/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.Interval;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.VsyncPanel;
import com.android.tools.profilers.cpu.VsyncPanelKt;
import com.intellij.ide.ui.UISettings;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0007J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/profilers/cpu/VsyncPanel;", "", "()V", "of", "Ljavax/swing/JComponent;", "content", "viewRange", "Lcom/android/tools/adtui/model/Range;", "vsyncValues", "", "Lcom/android/tools/adtui/model/SeriesData;", "", "vsyncEnabler", "Ljava/util/function/BooleanSupplier;", "series", "Lcom/android/tools/adtui/model/RangedSeries;", "intellij.android.profilers.ui"})
public final class VsyncPanel {
    @NotNull
    public static final VsyncPanel INSTANCE;

    @JvmStatic
    @NotNull
    public static final JComponent of(@NotNull JComponent content, @NotNull Range viewRange, @NotNull List<SeriesData<Long>> vsyncValues, @NotNull BooleanSupplier vsyncEnabler) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)viewRange, (String)"viewRange");
        Intrinsics.checkNotNullParameter(vsyncValues, (String)"vsyncValues");
        Intrinsics.checkNotNullParameter((Object)vsyncEnabler, (String)"vsyncEnabler");
        return VsyncPanel.of(content, (RangedSeries<Long>)new RangedSeries(viewRange, (DataSeries)new LazyDataSeries(new Supplier(vsyncValues){
            final /* synthetic */ List $vsyncValues;

            public final List<SeriesData<Long>> get() {
                return this.$vsyncValues;
            }
            {
                this.$vsyncValues = list;
            }
        }), null, 4, null), vsyncEnabler);
    }

    @JvmStatic
    @NotNull
    public static final JComponent of(@NotNull JComponent content, @NotNull RangedSeries<Long> series, @NotNull BooleanSupplier vsyncEnabler) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(series, (String)"series");
        Intrinsics.checkNotNullParameter((Object)vsyncEnabler, (String)"vsyncEnabler");
        JPanel $this$apply = jPanel = new JPanel(vsyncEnabler, series, new BorderLayout()){
            @NotNull
            private final StateChartModel<Long> model;
            @NotNull
            private final AspectObserver observer;
            private boolean intervalsInViewUpdated;
            @NotNull
            private final List<Interval> intervalsInView;
            final /* synthetic */ BooleanSupplier $vsyncEnabler;
            final /* synthetic */ RangedSeries $series;

            @NotNull
            public final StateChartModel<Long> getModel() {
                return this.model;
            }

            @NotNull
            public final AspectObserver getObserver() {
                return this.observer;
            }

            public final boolean getIntervalsInViewUpdated() {
                return this.intervalsInViewUpdated;
            }

            public final void setIntervalsInViewUpdated(boolean bl) {
                this.intervalsInViewUpdated = bl;
            }

            @NotNull
            public final List<Interval> getIntervalsInView() {
                return this.intervalsInView;
            }

            protected void paintComponent(@NotNull Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                super.paintComponent(g);
                if (this.$vsyncEnabler.getAsBoolean()) {
                    Graphics2D graphics2D;
                    Graphics graphics = g.create();
                    if (graphics == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
                    }
                    Graphics2D g2d = graphics2D = (Graphics2D)graphics;
                    boolean bl = false;
                    UISettings.Companion.setupAntialiasing((Graphics)g2d);
                    this.draw(g2d);
                    g2d.dispose();
                }
            }

            private final void updateIntervalsInView() {
                if (!this.intervalsInViewUpdated) {
                    this.intervalsInViewUpdated = true;
                    this.intervalsInView.clear();
                    RangedSeries data = (RangedSeries)this.model.getSeries().get(0);
                    double min = data.getXRange().getMin();
                    double max = data.getXRange().getMax();
                    double invRange = 1.0 / (max - min);
                    List dataList = data.getSeries();
                    var $fun$addInterval$1 = new Function3<Double, Double, Boolean, Boolean>(this, min, invRange){
                        final /* synthetic */ of.2 this$0;
                        final /* synthetic */ double $min;
                        final /* synthetic */ double $invRange;

                        public final boolean invoke(double previousX, double x, boolean on) {
                            return this.this$0.getIntervalsInView().add(new Interval((float)((previousX - this.$min) * this.$invRange), (float)((x - previousX) * this.$invRange), on));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$min = d;
                            this.$invRange = d2;
                            super(3);
                        }
                    };
                    Collection collection = dataList;
                    if (!collection.isEmpty()) {
                        double previousX = ((SeriesData)dataList.get((int)0)).x;
                        boolean previousVal = ((Number)((SeriesData)dataList.get((int)0)).value).longValue() > 0L;
                        for (SeriesData event : dataList.subList(1, dataList.size())) {
                            double x = event.x;
                            if (x >= min) {
                                $fun$addInterval$1.invoke(Math.max(min, previousX), Math.min(max, x), previousVal);
                            }
                            previousX = x;
                            boolean bl = previousVal = ((Number)event.value).longValue() > 0L;
                            if (!(previousX >= max)) continue;
                            break;
                        }
                        if (previousX < max) {
                            $fun$addInterval$1.invoke(Math.max(min, previousX), max, previousVal);
                        }
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void draw(Graphics2D g2d) {
                int endIndexExclusive;
                int n;
                int n2;
                int it;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                float scaleX = this.getWidth();
                float scaleY = this.getHeight();
                Rectangle clipRect = g2d.getClipBounds();
                var $fun$overlapIndex$1 = new Function2<Float, Float, Integer>(this){
                    final /* synthetic */ of.2 this$0;

                    public final int invoke(float x, float w) {
                        return CollectionsKt.binarySearch$default(this.this$0.getIntervalsInView(), (int)0, (int)0, (Function1)((Function1)new Function1<Interval, Integer>(x, w){
                            final /* synthetic */ float $x;
                            final /* synthetic */ float $w;

                            public final int invoke(@NotNull Interval value) {
                                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                                return value.getX() + value.getW() < this.$x ? -1 : (value.getX() > this.$x + this.$w ? 1 : 0);
                            }
                            {
                                this.$x = f;
                                this.$w = f2;
                                super(1);
                            }
                        }), (int)3, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                };
                this.updateIntervalsInView();
                if (clipRect != null && clipRect.x != 0) {
                    int n3;
                    it = n3 = $fun$overlapIndex$1.invoke((float)clipRect.x / scaleX, 0.0f);
                    boolean bl = false;
                    n2 = it < 0 ? -(it + 1) : it;
                } else {
                    n2 = 0;
                }
                int startIndexInclusive = n2;
                if (clipRect != null && clipRect.width != this.getWidth()) {
                    int it2 = it = $fun$overlapIndex$1.invoke((float)(clipRect.x + clipRect.width) / scaleX, 0.0f);
                    boolean bl = false;
                    n = it2 < 0 ? -(it2 + 1) : it2 + 1;
                } else {
                    n = endIndexExclusive = this.intervalsInView.size();
                }
                if ((float)(endIndexExclusive - startIndexInclusive) < scaleX) {
                    Iterable $this$forEach$iv = this.intervalsInView.subList(startIndexInclusive, endIndexExclusive);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        void w;
                        void x;
                        Interval $dstr$x$w$on = (Interval)element$iv;
                        boolean bl = false;
                        float f = $dstr$x$w$on.component1();
                        float f2 = $dstr$x$w$on.component2();
                        boolean on = $dstr$x$w$on.component3();
                        g2d.setColor(on ? ProfilerColors.VSYNC_BACKGROUND : ProfilerColors.DEFAULT_BACKGROUND);
                        g2d.fill(new Rectangle2D.Float((float)(x * scaleX), 0.0f, (float)(w * scaleX), scaleY));
                    }
                }
            }
            {
                void $this$apply;
                StateChartModel stateChartModel;
                this.$vsyncEnabler = $captured_local_variable$0;
                this.$series = $captured_local_variable$1;
                super($super_call_param$2);
                StateChartModel stateChartModel2 = stateChartModel = new StateChartModel();
                of.2 var7_6 = this;
                boolean bl = false;
                $this$apply.addSeries(this.$series);
                Unit unit = Unit.INSTANCE;
                var7_6.model = stateChartModel;
                this.observer = new AspectObserver();
                this.intervalsInView = new ArrayList<E>();
            }
        };
        boolean bl = false;
        $this$apply.add(content);
        var $fun$modelChanged$1 = new Function0<Unit>($this$apply){
            final /* synthetic */ of.2 $this_apply;

            public final void invoke() {
                this.$this_apply.setIntervalsInViewUpdated(false);
                VsyncPanelKt.access$getOpaqueContainer(this.$this_apply).repaint();
            }
            {
                this.$this_apply = var1_1;
                super(0);
            }
        };
        Function0 function0 = (Function0)new Function0<Unit>($fun$modelChanged$1){
            final /* synthetic */ of.3.1 $modelChanged$1;

            public final void invoke() {
                this.$modelChanged$1.invoke();
            }
            {
                this.$modelChanged$1 = var1_1;
                super(0, null, "modelChanged", "invoke()V", 0);
            }
        };
        $this$apply.getModel().addDependency($this$apply.getObserver()).onChange((Enum)StateChartModel.Aspect.MODEL_CHANGED, new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        });
        $fun$modelChanged$1.invoke();
        MouseListener handler = new MouseListener(content){
            final /* synthetic */ JComponent $content$inlined;
            {
                this.$content$inlined = jComponent;
            }

            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content$inlined.dispatchEvent(e);
            }

            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content$inlined.dispatchEvent(e);
            }

            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content$inlined.dispatchEvent(e);
            }

            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content$inlined.dispatchEvent(e);
            }

            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content$inlined.dispatchEvent(e);
            }

            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content$inlined.dispatchEvent(e);
            }

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content$inlined.dispatchEvent(e);
            }
        };
        $this$apply.addMouseListener(handler);
        $this$apply.addMouseMotionListener((MouseMotionListener)((Object)handler));
        return jPanel;
    }

    private VsyncPanel() {
    }

    static {
        VsyncPanel vsyncPanel;
        INSTANCE = vsyncPanel = new VsyncPanel();
    }
}

