/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.MultiSelectionModel;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import com.android.tools.adtui.trackgroup.TrackRenderer;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.FrameTimelineSelectionOverlayPanel;
import com.android.tools.profilers.cpu.JankyFrameTrackRendererKt;
import com.android.tools.profilers.cpu.VsyncPanel;
import com.android.tools.profilers.cpu.analysis.CpuAnalyzable;
import com.android.tools.profilers.cpu.analysis.JankAnalysisModel;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineEvent;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineModel;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\tH\u0016J\u0097\u0001\u0010\n\u001a\u007f\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0015\u0012\u0015\u0012\u0013\u0018\u00010\u0016\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00180\u000bj\n\u0012\u0006\u0012\u0004\u0018\u00010\u0016`\u00192\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/profilers/cpu/JankyFrameTrackRenderer;", "Lcom/android/tools/adtui/trackgroup/TrackRenderer;", "Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameTimelineModel;", "vsyncEnabler", "Ljava/util/function/BooleanSupplier;", "(Ljava/util/function/BooleanSupplier;)V", "render", "Ljavax/swing/JComponent;", "trackModel", "Lcom/android/tools/adtui/model/trackgroup/TrackModel;", "renderJankyFrame", "Lkotlin/Function5;", "Ljava/awt/Graphics2D;", "Lkotlin/ParameterName;", "name", "g", "Ljava/awt/geom/Rectangle2D$Float;", "boundary", "Ljava/awt/FontMetrics;", "defaultFontMetrics", "", "hoverred", "Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameTimelineEvent;", "value", "", "Lcom/android/tools/adtui/chart/statechart/Renderer;", "multiSelectionModel", "Lcom/android/tools/adtui/model/MultiSelectionModel;", "Lcom/android/tools/profilers/cpu/analysis/CpuAnalyzable;", "intellij.android.profilers.ui"})
public final class JankyFrameTrackRenderer
implements TrackRenderer<AndroidFrameTimelineModel> {
    private final BooleanSupplier vsyncEnabler;

    @NotNull
    public JComponent render(@NotNull TrackModel<AndroidFrameTimelineModel, ?> trackModel) {
        StateChart stateChart;
        Intrinsics.checkNotNullParameter(trackModel, (String)"trackModel");
        Object object = trackModel.getDataModel();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"trackModel.dataModel");
        StateChart $this$apply = stateChart = new StateChart((StateChartModel)object, this.renderJankyFrame(((AndroidFrameTimelineModel)((Object)trackModel.getDataModel())).getMultiSelectionModel()), null, 4, null);
        boolean bl = false;
        $this$apply.addRowIndexChangeListener(new IntConsumer(trackModel){
            final /* synthetic */ TrackModel $trackModel$inlined;
            {
                this.$trackModel$inlined = trackModel;
            }

            public final void accept(int it) {
                ((AndroidFrameTimelineModel)((Object)this.$trackModel$inlined.getDataModel())).setActiveSeriesIndex(it);
            }
        });
        $this$apply.addItemClickedListener(new Consumer(trackModel){
            final /* synthetic */ TrackModel $trackModel$inlined;
            {
                this.$trackModel$inlined = trackModel;
            }

            public final void accept(@Nullable AndroidFrameTimelineEvent it) {
                block0: {
                    AndroidFrameTimelineEvent androidFrameTimelineEvent;
                    AndroidFrameTimelineEvent androidFrameTimelineEvent2 = it;
                    if (androidFrameTimelineEvent2 == null) break block0;
                    AndroidFrameTimelineEvent it2 = androidFrameTimelineEvent = androidFrameTimelineEvent2;
                    boolean bl = false;
                    MultiSelectionModel<CpuAnalyzable<?>> multiSelectionModel = ((AndroidFrameTimelineModel)((Object)this.$trackModel$inlined.getDataModel())).getMultiSelectionModel();
                    AndroidFrameTimelineEvent androidFrameTimelineEvent3 = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)androidFrameTimelineEvent3, (String)"it");
                    multiSelectionModel.setSelection((Object)androidFrameTimelineEvent3, SetsKt.setOf((Object)new JankAnalysisModel(it2, ((AndroidFrameTimelineModel)((Object)this.$trackModel$inlined.getDataModel())).getCapture())));
                }
            }
        });
        StateChart it = stateChart;
        boolean bl2 = false;
        return VsyncPanel.of(FrameTimelineSelectionOverlayPanel.of$default((JComponent)it, ((AndroidFrameTimelineModel)((Object)trackModel.getDataModel())).getViewRange(), ((AndroidFrameTimelineModel)((Object)trackModel.getDataModel())).getMultiSelectionModel(), FrameTimelineSelectionOverlayPanel.GrayOutMode.None.INSTANCE, true, null, 32, null), ((AndroidFrameTimelineModel)((Object)trackModel.getDataModel())).getVsyncSeries(), this.vsyncEnabler);
    }

    private final Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, AndroidFrameTimelineEvent, Unit> renderJankyFrame(MultiSelectionModel<CpuAnalyzable<?>> multiSelectionModel) {
        return (Function5)new Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, AndroidFrameTimelineEvent, Unit>(multiSelectionModel){
            final /* synthetic */ MultiSelectionModel $multiSelectionModel;

            public final void invoke(@NotNull Graphics2D g, @NotNull Rectangle2D.Float rect, @NotNull FontMetrics fontMetrics, boolean hovered, @Nullable AndroidFrameTimelineEvent event) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
                Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
                if (event != null) {
                    String fullText;
                    String text;
                    CharSequence charSequence;
                    int borderY = 1;
                    int borderX = 1;
                    int textPadding = borderX + 1;
                    boolean active = hovered || this.$multiSelectionModel.getActiveSelectionKey() == event;
                    long duration = event.getActualDurationUs();
                    float f = (float)event.getExpectedDurationUs() / (float)duration;
                    float f2 = 1.0f;
                    float blankRectWidth = rect.width * Math.min(f, f2);
                    g.setColor(active ? (Color)JankyFrameTrackRendererKt.getActiveColor(event) : (Color)JankyFrameTrackRendererKt.getPassiveColor(event));
                    g.fill(rect);
                    g.setColor(ProfilerColors.CPU_STATECHART_DEFAULT_STATE);
                    g.fill(new Rectangle2D.Float(rect.x + (float)borderX, rect.y + (float)borderY, blankRectWidth - (float)(2 * borderX), rect.height - (float)(2 * borderY) - 1.0f));
                    float availableTextSpace = blankRectWidth - (float)(textPadding * 2);
                    if (availableTextSpace > 1.0f && (charSequence = (CharSequence)(text = AdtUiUtils.shrinkToFit((String)(fullText = event.getSurfaceFrameToken() + ": " + TimeFormatter.getSingleUnitDurationString((long)duration)), (FontMetrics)fontMetrics, (float)availableTextSpace))).length() > 0) {
                        g.setColor(active ? JBUI.CurrentTheme.Label.foreground() : JBUI.CurrentTheme.Label.disabledForeground());
                        float textOffset = rect.y + (rect.height - (float)fontMetrics.getHeight()) * 0.5f + (float)fontMetrics.getAscent();
                        g.drawString(text, rect.x + (float)textPadding, textOffset);
                    }
                }
            }
            {
                this.$multiSelectionModel = multiSelectionModel;
                super(5);
            }
        };
    }

    public JankyFrameTrackRenderer(@NotNull BooleanSupplier vsyncEnabler) {
        Intrinsics.checkNotNullParameter((Object)vsyncEnabler, (String)"vsyncEnabler");
        this.vsyncEnabler = vsyncEnabler;
    }
}

