/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.InMemoryDataSeries;
import com.android.tools.profilers.cpu.ThreadState;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ImportedTraceThreadDataSeries
extends InMemoryDataSeries<ThreadState> {
    private final int myThreadId;
    @NotNull
    private final List<SeriesData<ThreadState>> myStates;
    @NotNull
    private final CpuCapture myCapture;

    public ImportedTraceThreadDataSeries(@NotNull CpuCapture capture, int tid) {
        if (capture == null) {
            ImportedTraceThreadDataSeries.$$$reportNull$$$0(0);
        }
        this.myCapture = capture;
        this.myThreadId = tid;
        this.myStates = this.buildThreadStates();
    }

    private List<SeriesData<ThreadState>> buildThreadStates() {
        ArrayList<SeriesData<ThreadState>> states = new ArrayList<SeriesData<ThreadState>>();
        CaptureNode root = this.myCapture.getCaptureNode(this.myThreadId);
        if (root == null) {
            ImportedTraceThreadDataSeries.getLogger().warn("Thread root node is unexpectedly null and thread states could not be built.");
            return states;
        }
        List<CaptureNode> rootChildren = root.getChildren();
        for (CaptureNode rootChild : rootChildren) {
            states.add((SeriesData<ThreadState>)new SeriesData(rootChild.getStart(), (Object)ThreadState.HAS_ACTIVITY));
            states.add((SeriesData<ThreadState>)new SeriesData(rootChild.getEnd(), (Object)ThreadState.NO_ACTIVITY));
        }
        return states;
    }

    @Override
    @NotNull
    protected List<SeriesData<ThreadState>> inMemoryDataList() {
        List<SeriesData<ThreadState>> list = this.myStates;
        if (list == null) {
            ImportedTraceThreadDataSeries.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(ImportedTraceThreadDataSeries.class);
        if (logger == null) {
            ImportedTraceThreadDataSeries.$$$reportNull$$$0(2);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capture";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/ImportedTraceThreadDataSeries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/ImportedTraceThreadDataSeries";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "inMemoryDataList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

