/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.UnifiedEventDataSeries;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.LegacyCpuUsageDataSeries;
import com.android.tools.profilers.cpu.MergeCaptureDataSeries;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuUsage
extends LineChartModel {
    @NotNull
    private final Range myCpuRange;
    @NotNull
    private final RangedContinuousSeries myCpuSeries;

    public CpuUsage(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            CpuUsage.$$$reportNull$$$0(0);
        }
        this(profilers, profilers.getTimeline().getViewRange(), profilers.getTimeline().getDataRange(), null);
    }

    public CpuUsage(@NotNull StudioProfilers profilers, @NotNull Range viewRange, @NotNull Range dataRange, @Nullable CpuCapture cpuCapture) {
        Object series;
        if (profilers == null) {
            CpuUsage.$$$reportNull$$$0(1);
        }
        if (viewRange == null) {
            CpuUsage.$$$reportNull$$$0(2);
        }
        if (dataRange == null) {
            CpuUsage.$$$reportNull$$$0(3);
        }
        this.myCpuRange = new Range(0.0, 100.0);
        if (profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            series = new UnifiedEventDataSeries(profilers.getClient().getTransportClient(), profilers.getSession().getStreamId(), profilers.getSession().getPid(), Common.Event.Kind.CPU_USAGE, profilers.getSession().getPid(), events -> CpuUsage.extractData(events, false));
            if (cpuCapture != null && cpuCapture.getSystemTraceData() != null) {
                series = new MergeCaptureDataSeries<Long>(cpuCapture, (DataSeries<Long>)series, new LazyDataSeries(() -> cpuCapture.getSystemTraceData().getCpuUtilizationSeries()));
            }
        } else {
            series = new LegacyCpuUsageDataSeries(profilers.getClient().getCpuClient(), profilers.getSession(), false);
        }
        this.myCpuSeries = new RangedContinuousSeries(this.getCpuSeriesLabel(), viewRange, this.myCpuRange, (DataSeries)series, dataRange);
        this.add(this.myCpuSeries);
    }

    @NotNull
    public Range getCpuRange() {
        Range range = this.myCpuRange;
        if (range == null) {
            CpuUsage.$$$reportNull$$$0(4);
        }
        return range;
    }

    @NotNull
    public RangedContinuousSeries getCpuSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myCpuSeries;
        if (rangedContinuousSeries == null) {
            CpuUsage.$$$reportNull$$$0(5);
        }
        return rangedContinuousSeries;
    }

    protected String getCpuSeriesLabel() {
        return "";
    }

    protected static List<SeriesData<Long>> extractData(List<Common.Event> dataList, boolean isOtherProcess) {
        return IntStream.range(0, dataList.size() - 1).mapToObj(index -> CpuUsage.getCpuUsageData(((Common.Event)dataList.get(index)).getCpuUsage(), ((Common.Event)dataList.get(index + 1)).getCpuUsage(), isOtherProcess)).collect(Collectors.toList());
    }

    protected static SeriesData<Long> getCpuUsageData(Cpu.CpuUsageData prevData, Cpu.CpuUsageData data, boolean isOtherProcess) {
        long dataTimestamp = TimeUnit.NANOSECONDS.toMicros(data.getEndTimestamp());
        long elapsed = data.getElapsedTimeInMillisec() - prevData.getElapsedTimeInMillisec();
        double app = 100.0 * (double)(data.getAppCpuTimeInMillisec() - prevData.getAppCpuTimeInMillisec()) / (double)elapsed;
        double system = 100.0 * (double)(data.getSystemCpuTimeInMillisec() - prevData.getSystemCpuTimeInMillisec()) / (double)elapsed;
        system = Math.max(0.0, Math.min(system, 100.0));
        app = Math.max(0.0, Math.min(app, system));
        return new SeriesData(dataTimestamp, (Object)((long)(isOtherProcess ? system - app : app)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataRange";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuUsage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuUsage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuSeries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

