/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.common.EnumColors;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.MultiSelectionModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import com.android.tools.adtui.trackgroup.TrackRenderer;
import com.android.tools.adtui.util.SwingUtil;
import com.android.tools.idea.codenavigation.CodeNavigator;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.CpuThreadTrackModel;
import com.android.tools.profilers.cpu.FrameTimelineSelectionOverlayPanel;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.VsyncPanel;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalyzable;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.android.tools.profilers.cpu.capturedetails.CaptureNodeHRenderer;
import com.android.tools.profilers.cpu.capturedetails.CodeNavigationHandler;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineEvent;
import com.android.tools.profilers.cpu.systemtrace.CpuSystemTraceData;
import com.android.tools.profilers.cpu.systemtrace.RenderSequence;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceCpuCapture;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.function.BooleanSupplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuThreadTrackRenderer
implements TrackRenderer<CpuThreadTrackModel> {
    @NotNull
    private final AspectObserver myObserver;
    @NotNull
    private final StudioProfilersView myProfilersView;
    private final BooleanSupplier myVsyncEnabler;

    public CpuThreadTrackRenderer(@NotNull StudioProfilersView profilersView, BooleanSupplier vsyncEnabler) {
        if (profilersView == null) {
            CpuThreadTrackRenderer.$$$reportNull$$$0(0);
        }
        this.myObserver = new AspectObserver();
        this.myProfilersView = profilersView;
        this.myVsyncEnabler = vsyncEnabler;
    }

    @NotNull
    public JComponent render(final @NotNull TrackModel<CpuThreadTrackModel, ?> trackModel) {
        if (trackModel == null) {
            CpuThreadTrackRenderer.$$$reportNull$$$0(1);
        }
        final HTreeChart<CaptureNode> traceEventChart = this.createHChart(((CpuThreadTrackModel)trackModel.getDataModel()).getCallChartModel(), ((CpuThreadTrackModel)trackModel.getDataModel()).getCapture().getRange(), trackModel.isCollapsed());
        traceEventChart.setBackground(UIUtil.TRANSPARENT_COLOR);
        traceEventChart.setDrawDebugInfo(this.myProfilersView.getStudioProfilers().getIdeServices().getFeatureConfig().isPerformanceMonitoringEnabled());
        final MultiSelectionModel<CpuAnalyzable<?>> multiSelectionModel = ((CpuThreadTrackModel)trackModel.getDataModel()).getMultiSelectionModel();
        multiSelectionModel.addDependency(this.myObserver).onChange((Enum)MultiSelectionModel.Aspect.SELECTIONS_CHANGED, () -> {
            Object selection2 = multiSelectionModel.getActiveSelectionKey();
            if (selection2 == null) {
                traceEventChart.setSelectedNode(null);
            } else if (selection2 instanceof CaptureNode) {
                traceEventChart.setSelectedNode((HNode)((CaptureNode)selection2));
            }
        });
        final StateChart<ThreadState> threadStateChart = CpuThreadTrackRenderer.createStateChart(((CpuThreadTrackModel)trackModel.getDataModel()).getThreadStateChartModel());
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        if (trackModel.isCollapsed() || threadStateChart == null) {
            panel.setLayout((LayoutManager)new TabularLayout("*", "*"));
            panel.add((Component)traceEventChart, new TabularLayout.Constraint(0, 0));
        } else {
            panel.setLayout((LayoutManager)new TabularLayout("*", "8px,*"));
            panel.add((Component)threadStateChart, new TabularLayout.Constraint(0, 0));
            panel.add((Component)traceEventChart, new TabularLayout.Constraint(1, 0));
        }
        if (!trackModel.isCollapsed()) {
            panel.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (threadStateChart != null && threadStateChart.contains(e.getPoint())) {
                        trackModel.setActiveTooltipModel((TooltipModel)((CpuThreadTrackModel)trackModel.getDataModel()).getThreadStateTooltip());
                        threadStateChart.dispatchEvent((AWTEvent)e);
                    } else if (traceEventChart.contains(e.getPoint())) {
                        Point p = e.getPoint();
                        p.translate(-traceEventChart.getX(), -traceEventChart.getY());
                        CaptureNode node = (CaptureNode)traceEventChart.getNodeAt(p);
                        if (node == null) {
                            trackModel.setActiveTooltipModel(null);
                        } else {
                            trackModel.setActiveTooltipModel((TooltipModel)((CpuThreadTrackModel)trackModel.getDataModel()).getTraceEventTooltipBuilder().apply(node));
                        }
                        traceEventChart.dispatchEvent((AWTEvent)SwingUtil.convertMouseEventPoint((MouseEvent)e, (Point)p));
                    } else {
                        trackModel.setActiveTooltipModel(null);
                    }
                }
            });
            panel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (traceEventChart.contains(e.getPoint())) {
                        Point p = e.getPoint();
                        p.translate(-traceEventChart.getX(), -traceEventChart.getY());
                        CaptureNode node = (CaptureNode)traceEventChart.getNodeAt(p);
                        if (node != null) {
                            multiSelectionModel.setSelection((Object)node, Collections.singleton(new CaptureNodeAnalysisModel(node, ((CpuThreadTrackModel)trackModel.getDataModel()).getCapture())));
                        } else {
                            multiSelectionModel.deselect();
                        }
                        traceEventChart.dispatchEvent((AWTEvent)SwingUtil.convertMouseEventPoint((MouseEvent)e, (Point)p));
                    }
                }
            });
        }
        CpuSystemTraceData data = ((CpuThreadTrackModel)trackModel.getDataModel()).getCapture().getSystemTraceData();
        CpuThreadInfo info = ((CpuThreadTrackModel)trackModel.getDataModel()).getThreadInfo();
        Range viewRange = ((CpuThreadTrackModel)trackModel.getDataModel()).getTimeline().getViewRange();
        JComponent jComponent = data == null ? panel : VsyncPanel.of(FrameTimelineSelectionOverlayPanel.of(panel, viewRange, multiSelectionModel, CpuThreadTrackRenderer.grayOutModeForThread(info, data), true), viewRange, data.getVsyncCounterValues(), this.myVsyncEnabler);
        if (jComponent == null) {
            CpuThreadTrackRenderer.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    private static FrameTimelineSelectionOverlayPanel.GrayOutMode grayOutModeForThread(CpuThreadInfo thread2, CpuSystemTraceData data) {
        Function1<AndroidFrameTimelineEvent, RenderSequence> renderSequenceGetter;
        Function1<AndroidFrameTimelineEvent, RenderSequence> function1 = renderSequenceGetter = data instanceof SystemTraceCpuCapture ? ((SystemTraceCpuCapture)data).getFrameRenderSequence() : null;
        return renderSequenceGetter == null ? FrameTimelineSelectionOverlayPanel.GrayOutMode.None.INSTANCE : (thread2.isMainThread() ? new FrameTimelineSelectionOverlayPanel.GrayOutMode.Outside((Function1<? super AndroidFrameTimelineEvent, Range>)((Function1)e -> CpuThreadTrackRenderer.eventRange(((RenderSequence)renderSequenceGetter.invoke(e)).getMainEvent()))) : (thread2.isRenderThread() ? new FrameTimelineSelectionOverlayPanel.GrayOutMode.Outside((Function1<? super AndroidFrameTimelineEvent, Range>)((Function1)e -> CpuThreadTrackRenderer.eventRange(((RenderSequence)renderSequenceGetter.invoke(e)).getRenderEvent()))) : (thread2.isGpuThread() ? new FrameTimelineSelectionOverlayPanel.GrayOutMode.Outside((Function1<? super AndroidFrameTimelineEvent, Range>)((Function1)e -> CpuThreadTrackRenderer.eventRange(((RenderSequence)renderSequenceGetter.invoke(e)).getGpuEvent()))) : FrameTimelineSelectionOverlayPanel.GrayOutMode.All.INSTANCE)));
    }

    private static Range eventRange(@Nullable CaptureNode threadEvent) {
        return threadEvent == null ? new Range() : new Range((double)threadEvent.getStartGlobal(), (double)threadEvent.getEndGlobal());
    }

    @Nullable
    private static StateChart<ThreadState> createStateChart(@NotNull StateChartModel<ThreadState> model) {
        if (model == null) {
            CpuThreadTrackRenderer.$$$reportNull$$$0(3);
        }
        if (model.getSeries().isEmpty()) {
            return null;
        }
        StateChart threadStateChart = new StateChart(model, (StateChartColorProvider)new CpuThreadColorProvider());
        threadStateChart.setHeightGap(0.0f);
        return threadStateChart;
    }

    private HTreeChart<CaptureNode> createHChart(@NotNull CaptureDetails.CallChart callChartModel, @NotNull Range captureRange, boolean isCollapsed) {
        if (callChartModel == null) {
            CpuThreadTrackRenderer.$$$reportNull$$$0(4);
        }
        if (captureRange == null) {
            CpuThreadTrackRenderer.$$$reportNull$$$0(5);
        }
        CaptureNode node = callChartModel.getNode();
        Range selectionRange = callChartModel.getRange();
        HTreeChart.Builder builder = new HTreeChart.Builder((HNode)node, selectionRange, (HRenderer)new CaptureNodeHRenderer(CaptureDetails.Type.CALL_CHART)).setGlobalXRange(captureRange).setOrientation(HTreeChart.Orientation.TOP_DOWN).setRootVisible(false).setNodeSelectionEnabled(true);
        if (isCollapsed) {
            return builder.setCustomNodeHeightPx(1).setNodeYPaddingPx(0).build();
        }
        HTreeChart chart = builder.build();
        if (callChartModel.getCapture().getSystemTraceData() == null) {
            CodeNavigator navigator = this.myProfilersView.getStudioProfilers().getStage().getStudioProfilers().getIdeServices().getCodeNavigator();
            CodeNavigationHandler handler = new CodeNavigationHandler((HTreeChart<CaptureNode>)chart, navigator);
            chart.addMouseListener((MouseListener)handler);
            this.myProfilersView.getIdeProfilerComponents().createContextMenuInstaller().installNavigationContextMenu((JComponent)chart, navigator, handler::getCodeLocation);
        }
        if (node != null) {
            node.getAspectModel().addDependency(this.myObserver).onChange((Enum)CaptureNode.Aspect.FILTER_APPLIED, () -> chart.setHTree((HNode)node));
        }
        return chart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilersView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuThreadTrackRenderer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callChartModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuThreadTrackRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createStateChart";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createHChart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CpuThreadColorProvider
    extends StateChartColorProvider<ThreadState> {
        private final EnumColors<ThreadState> myEnumColors = ProfilerColors.THREAD_STATES.build();

        private CpuThreadColorProvider() {
        }

        @NotNull
        public Color getColor(boolean isMouseOver, @NotNull ThreadState value) {
            if (value == null) {
                CpuThreadColorProvider.$$$reportNull$$$0(0);
            }
            this.myEnumColors.setColorIndex(isMouseOver ? 1 : 0);
            Color color = this.myEnumColors.getColor((Enum)value);
            if (color == null) {
                CpuThreadColorProvider.$$$reportNull$$$0(1);
            }
            return color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuThreadTrackRenderer$CpuThreadColorProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuThreadTrackRenderer$CpuThreadColorProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getColor";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

