/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerNotifications;
import com.android.tools.profilers.cpu.MainProcessSelector;
import com.android.tools.profilers.cpu.ProcessSelectorDialogAbortedException;
import com.android.tools.profilers.cpu.TraceParser;
import com.android.tools.profilers.cpu.TracePreProcessor;
import com.android.tools.profilers.cpu.art.ArtTraceParser;
import com.android.tools.profilers.cpu.config.UnspecifiedConfiguration;
import com.android.tools.profilers.cpu.simpleperf.SimpleperfTraceParser;
import com.android.tools.profilers.cpu.systemtrace.AtraceParser;
import com.android.tools.profilers.cpu.systemtrace.AtraceProducer;
import com.android.tools.profilers.cpu.systemtrace.PerfettoProducer;
import com.android.tools.profilers.perfetto.PerfettoParser;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCaptureParser {
    @VisibleForTesting
    static final int MAX_SUPPORTED_TRACE_SIZE = 0x6400000;
    private final Map<Long, CompletableFuture<CpuCapture>> myCaptures;
    @NotNull
    private final IdeProfilerServices myServices;
    private final AspectModel<CpuProfilerAspect> myAspect;
    private boolean myIsParsing;
    private long myParsingStartTimeMs;
    private final Map<Long, CpuCaptureMetadata> myCaptureMetadataMap;
    private static final Set<String> myPreviouslyLoadedCaptures = new HashSet<String>();
    private static final Logger LOGGER = Logger.getInstance(CpuCaptureParser.class);

    public CpuCaptureParser(@NotNull IdeProfilerServices services) {
        if (services == null) {
            CpuCaptureParser.$$$reportNull$$$0(0);
        }
        this.myAspect = new AspectModel();
        this.myCaptureMetadataMap = new HashMap<Long, CpuCaptureMetadata>();
        this.myServices = services;
        this.myCaptures = new HashMap<Long, CompletableFuture<CpuCapture>>();
    }

    public AspectModel<CpuProfilerAspect> getAspect() {
        return this.myAspect;
    }

    @VisibleForTesting
    static void clearPreviouslyLoadedCaptures() {
        myPreviouslyLoadedCaptures.clear();
    }

    @Nullable
    public CompletableFuture<CpuCapture> getCapture(long traceId) {
        return this.myCaptures.get(traceId);
    }

    /*
     * WARNING - void declaration
     */
    void trackCaptureMetadata(long traceId, @NotNull CpuCaptureMetadata cpuCaptureMetadata) {
        void metadata;
        if (cpuCaptureMetadata == null) {
            CpuCaptureParser.$$$reportNull$$$0(1);
        }
        this.myCaptureMetadataMap.put(traceId, (CpuCaptureMetadata)metadata);
    }

    public void abortParsing() {
        this.myCaptures.forEach((id, capture) -> {
            boolean isCaptureCancelled = capture.cancel(true);
            if (!isCaptureCancelled) {
                LOGGER.warn(String.format("Parsing of capture %d was not properly cancelled.", id));
            }
        });
    }

    public boolean isParsing() {
        return this.myIsParsing;
    }

    public long getParsingElapsedTimeMs() {
        return System.currentTimeMillis() - this.myParsingStartTimeMs;
    }

    private void updateParsingStateWhenDone() {
        this.myIsParsing = false;
        this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_PARSING);
    }

    @VisibleForTesting
    public void updateParsingStateWhenStarting() {
        this.myParsingStartTimeMs = System.currentTimeMillis();
        this.myIsParsing = true;
        this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_PARSING);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompletableFuture<CpuCapture> parse(@NotNull File traceFile, long traceId, @NotNull Cpu.CpuTraceType preferredProfilerType, int processIdHint, String string) {
        void processNameHint;
        if (traceFile == null) {
            CpuCaptureParser.$$$reportNull$$$0(2);
        }
        if (preferredProfilerType == null) {
            CpuCaptureParser.$$$reportNull$$$0(3);
        }
        if (this.myCaptures.containsKey(traceId)) {
            CompletableFuture<CpuCapture> completableFuture = this.myCaptures.get(traceId);
            if (completableFuture == null) {
                CpuCaptureParser.$$$reportNull$$$0(4);
            }
            return completableFuture;
        }
        boolean isImportedTrace = processIdHint == 0;
        CompletionStage cpuCapture = ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(new TraceFileValidationAction(traceFile), this.myServices.getPoolExecutor()).thenRunAsync(new ParsingStartAction(traceFile), this.myServices.getMainExecutor())).thenApplyAsync((Function)new ProcessTraceAction(traceFile, traceId, preferredProfilerType, processIdHint, (String)processNameHint, this.myServices), this.myServices.getPoolExecutor())).whenCompleteAsync((BiConsumer)new TraceResultHandler(traceFile, traceId, isImportedTrace), this.myServices.getMainExecutor());
        this.myCaptures.put(traceId, (CompletableFuture<CpuCapture>)cpuCapture);
        CompletionStage completionStage = cpuCapture;
        if (completionStage == null) {
            CpuCaptureParser.$$$reportNull$$$0(5);
        }
        return completionStage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredProfilerType";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureParser";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "trackCaptureMetadata";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class TraceResultHandler
    implements BiConsumer<CpuCapture, Throwable> {
        @NotNull
        private final File traceFile;
        private final long traceId;
        private final boolean isImportedTrace;

        /*
         * WARNING - void declaration
         */
        private TraceResultHandler(File traceFile, long traceId, boolean bl) {
            void isImportedTrace;
            if (traceFile == null) {
                TraceResultHandler.$$$reportNull$$$0(0);
            }
            this.traceFile = traceFile;
            this.traceId = traceId;
            this.isImportedTrace = isImportedTrace;
        }

        @Override
        public void accept(CpuCapture capture, Throwable throwable) {
            CpuCaptureParser.this.updateParsingStateWhenDone();
            CpuCaptureMetadata metadata = CpuCaptureParser.this.myCaptureMetadataMap.computeIfAbsent(this.traceId, id -> new CpuCaptureMetadata(new UnspecifiedConfiguration("Unnamed")));
            metadata.setTraceFileSizeBytes((int)this.traceFile.length());
            if (capture != null) {
                metadata.setStatus(CpuCaptureMetadata.CaptureStatus.SUCCESS);
                metadata.setParsingTimeMs(Math.max(1L, System.currentTimeMillis() - CpuCaptureParser.this.myParsingStartTimeMs));
                metadata.setCaptureDurationMs(TimeUnit.MICROSECONDS.toMillis(capture.getDurationUs()));
                metadata.setRecordDurationMs(this.calculateRecordDurationMs(capture));
            } else if (throwable != null) {
                LOGGER.warn("Unable to parse capture: " + throwable.getMessage(), throwable.getCause());
                if (throwable.getCause() instanceof CancellationException) {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING);
                    CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PARSING_ABORTED);
                } else if (throwable.getCause() instanceof PreProcessorFailureException) {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PREPROCESS_FAILURE);
                    CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PREPROCESS_FAILURE);
                } else if (throwable.getCause() instanceof InvalidPathParsingFailureException) {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_PATH_INVALID);
                    CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PARSING_FAILURE);
                } else if (throwable.getCause() instanceof ReadErrorParsingFailureException) {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_READ_ERROR);
                    CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PARSING_FAILURE);
                } else if (throwable.getCause() instanceof UnknownParserParsingFailureException) {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_PARSER_UNKNOWN);
                    CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PARSING_FAILURE);
                } else if (throwable.getCause() instanceof FileHeaderParsingFailureException) {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_FILE_HEADER_ERROR);
                    CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PARSING_FAILURE);
                } else if (throwable.getCause() instanceof ParsingFailureException) {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_PARSER_ERROR);
                    CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PARSING_FAILURE);
                } else {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_CAUSE_UNKNOWN);
                    CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PARSING_FAILURE);
                }
            } else {
                LOGGER.warn("Unable to parse capture: no throwable.");
                metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_CAUSE_UNKNOWN);
                CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PARSING_FAILURE);
            }
            if (!myPreviouslyLoadedCaptures.contains(this.traceFile.getAbsolutePath())) {
                myPreviouslyLoadedCaptures.add(this.traceFile.getAbsolutePath());
                CpuCaptureParser.this.myServices.getFeatureTracker().trackCaptureTrace(metadata);
                if (this.isImportedTrace && capture != null) {
                    CpuCaptureParser.this.myServices.getFeatureTracker().trackImportTrace(capture.getType(), true);
                }
                CpuCaptureParser.this.myCaptureMetadataMap.remove(this.traceId);
            }
        }

        private long calculateRecordDurationMs(CpuCapture capture) {
            Range maxDataRange = new Range();
            for (CaptureNode node : capture.getCaptureNodes()) {
                maxDataRange.expand((double)node.getStartGlobal(), (double)node.getEndGlobal());
            }
            return TimeUnit.MICROSECONDS.toMillis((long)maxDataRange.getLength());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceFile", "com/android/tools/profilers/cpu/CpuCaptureParser$TraceResultHandler", "<init>"));
        }
    }

    private static final class ProcessTraceAction
    implements Function<Void, CpuCapture> {
        @NotNull
        private final File traceFile;
        private final long traceId;
        @NotNull
        private final Cpu.CpuTraceType preferredProfilerType;
        private final int processIdHint;
        @NotNull
        private final String processNameHint;
        @NotNull
        private final IdeProfilerServices services;
        private static final Supplier<TraceParser> ART_PARSER_SUPPLIER = () -> new ArtTraceParser();
        private static final Supplier<TraceParser> SIMPLEPERF_PARSER_SUPPLIER = () -> new SimpleperfTraceParser();
        private final Supplier<TraceParser> ATRACE_PARSER_SUPPLIER;
        private final Supplier<TraceParser> PERFETTO_PARSER_SUPPLIER;
        private static final Predicate<File> NO_OP_FILE_TESTER = null;
        private static final Predicate<File> ATRACE_FILE_TESTER = t -> AtraceProducer.verifyFileHasAtraceHeader(t);
        private static final Predicate<File> PERFETTO_FILE_TESTER = t -> PerfettoProducer.verifyFileHasPerfettoTraceHeader(t);

        /*
         * WARNING - void declaration
         */
        private ProcessTraceAction(@NotNull File traceFile, long traceId, @NotNull Cpu.CpuTraceType preferredProfilerType, int processIdHint, @Nullable String processNameHint, @NotNull IdeProfilerServices ideProfilerServices) {
            void services;
            if (traceFile == null) {
                ProcessTraceAction.$$$reportNull$$$0(0);
            }
            if (preferredProfilerType == null) {
                ProcessTraceAction.$$$reportNull$$$0(1);
            }
            if (ideProfilerServices == null) {
                ProcessTraceAction.$$$reportNull$$$0(2);
            }
            this.ATRACE_PARSER_SUPPLIER = () -> new AtraceParser(this.getMainProcessSelector());
            this.PERFETTO_PARSER_SUPPLIER = () -> new PerfettoParser(this.getMainProcessSelector(), this.getProfilerServices());
            this.traceFile = traceFile;
            this.traceId = traceId;
            this.preferredProfilerType = preferredProfilerType;
            this.processIdHint = processIdHint;
            this.processNameHint = processNameHint != null ? processNameHint : "";
            this.services = services;
        }

        @Override
        public CpuCapture apply(Void aVoid) {
            return this.parseToCapture(this.traceFile, this.traceId, this.preferredProfilerType);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        private CpuCapture parseToCapture(@NotNull File traceFile, long traceId, @NotNull Cpu.CpuTraceType cpuTraceType) {
            CpuCapture capture;
            void profilerType;
            boolean unknownType;
            if (traceFile == null) {
                ProcessTraceAction.$$$reportNull$$$0(3);
            }
            if (cpuTraceType == null) {
                ProcessTraceAction.$$$reportNull$$$0(4);
            }
            if (((unknownType = Cpu.CpuTraceType.UNSPECIFIED_TYPE.equals((Object)profilerType)) || profilerType == Cpu.CpuTraceType.ART) && (capture = ProcessTraceAction.tryToParseWith(Cpu.CpuTraceType.ART, traceFile, traceId, !unknownType, NO_OP_FILE_TESTER, ART_PARSER_SUPPLIER)) != null) {
                return capture;
            }
            if ((unknownType || profilerType == Cpu.CpuTraceType.SIMPLEPERF) && (capture = ProcessTraceAction.tryToParseWith(Cpu.CpuTraceType.SIMPLEPERF, traceFile, traceId, !unknownType, NO_OP_FILE_TESTER, SIMPLEPERF_PARSER_SUPPLIER)) != null) {
                return capture;
            }
            if ((unknownType || profilerType == Cpu.CpuTraceType.ATRACE) && (capture = ProcessTraceAction.tryToParseWith(Cpu.CpuTraceType.ATRACE, traceFile, traceId, !unknownType, ATRACE_FILE_TESTER, this.ATRACE_PARSER_SUPPLIER)) != null) {
                return capture;
            }
            if ((unknownType || profilerType == Cpu.CpuTraceType.PERFETTO) && (capture = ProcessTraceAction.tryToParseWith(Cpu.CpuTraceType.PERFETTO, traceFile, traceId, !unknownType, PERFETTO_FILE_TESTER, this.PERFETTO_PARSER_SUPPLIER)) != null) {
                return capture;
            }
            if (unknownType) {
                throw new UnknownParserParsingFailureException(traceFile.getAbsolutePath());
            }
            return null;
        }

        @NotNull
        private MainProcessSelector getMainProcessSelector() {
            return new MainProcessSelector(this.processNameHint, this.processIdHint, this.services);
        }

        @NotNull
        private IdeProfilerServices getProfilerServices() {
            IdeProfilerServices ideProfilerServices = this.services;
            if (ideProfilerServices == null) {
                ProcessTraceAction.$$$reportNull$$$0(5);
            }
            return ideProfilerServices;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        private static CpuCapture tryToParseWith(@NotNull Cpu.CpuTraceType type, @NotNull File traceFile, long traceId, boolean expectedToBeCorrectParser, @Nullable Predicate<File> traceInputVerification, @NotNull Supplier<TraceParser> supplier) {
            void parserSupplier;
            if (type == null) {
                ProcessTraceAction.$$$reportNull$$$0(6);
            }
            if (traceFile == null) {
                ProcessTraceAction.$$$reportNull$$$0(7);
            }
            if (supplier == null) {
                ProcessTraceAction.$$$reportNull$$$0(8);
            }
            if (traceInputVerification != null) {
                boolean inputVerification;
                try {
                    inputVerification = traceInputVerification.test(traceFile);
                }
                catch (Throwable t) {
                    throw new FileHeaderParsingFailureException(traceFile.getAbsolutePath(), type, t);
                }
                if (!inputVerification) {
                    if (expectedToBeCorrectParser) {
                        throw new FileHeaderParsingFailureException(traceFile.getAbsolutePath(), type);
                    }
                    return null;
                }
            }
            TraceParser parser = (TraceParser)parserSupplier.get();
            try {
                return parser.parse(traceFile, traceId);
            }
            catch (ProcessSelectorDialogAbortedException e) {
                throw new CancellationException("User aborted process choice dialog.");
            }
            catch (Throwable t) {
                if (expectedToBeCorrectParser || traceInputVerification != null) {
                    throw new ParsingFailureException(String.format("Trace file '%s' failed to be parsed as %s.", traceFile.getAbsolutePath(), type), t);
                }
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "traceFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preferredProfilerType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "services";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profilerType";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureParser$ProcessTraceAction";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parserSupplier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureParser$ProcessTraceAction";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProfilerServices";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "parseToCapture";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "tryToParseWith";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class ParsingStartAction
    implements Runnable {
        @NotNull
        private final File traceFile;

        private ParsingStartAction(File traceFile) {
            if (traceFile == null) {
                ParsingStartAction.$$$reportNull$$$0(0);
            }
            this.traceFile = traceFile;
        }

        @Override
        public void run() {
            CpuCaptureParser.this.updateParsingStateWhenStarting();
            long traceLengthBytes = this.traceFile.length();
            if (this.traceFile.length() > 0x6400000L) {
                Runnable yesCallback = () -> {};
                Runnable noCallback = () -> {
                    throw new CancellationException(String.format("Parsing of a long (%d bytes) trace file was aborted by the user.", traceLengthBytes));
                };
                this.openParseLargeTracesDialog(yesCallback, noCallback);
            }
        }

        private void openParseLargeTracesDialog(Runnable yesCallback, Runnable noCallback) {
            CpuCaptureParser.this.myServices.openYesNoDialog("The trace file generated is large, and " + ApplicationNamesInfo.getInstance().getFullProductName() + " may become unresponsive while it parses the data. Do you want to continue?\n\nWarning: If you select \"No\", " + ApplicationNamesInfo.getInstance().getFullProductName() + " discards the trace data and you will need to capture a new method trace.", "Trace File Too Large", yesCallback, noCallback);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceFile", "com/android/tools/profilers/cpu/CpuCaptureParser$ParsingStartAction", "<init>"));
        }
    }

    private static final class TraceFileValidationAction
    implements Runnable {
        @NotNull
        private final File traceFile;

        private TraceFileValidationAction(@NotNull File traceFile) {
            if (traceFile == null) {
                TraceFileValidationAction.$$$reportNull$$$0(0);
            }
            this.traceFile = traceFile;
        }

        @Override
        public void run() {
            if (!this.traceFile.exists() || this.traceFile.isDirectory()) {
                throw new InvalidPathParsingFailureException(this.traceFile.getAbsolutePath());
            }
            if (this.traceFile.length() == (long)TracePreProcessor.FAILURE.size()) {
                try (FileInputStream is = new FileInputStream(this.traceFile);){
                    ByteString fileContent = ByteString.readFrom((InputStream)is);
                    if (TracePreProcessor.FAILURE.equals((Object)fileContent)) {
                        throw new PreProcessorFailureException();
                    }
                }
                catch (IOException e) {
                    throw new ReadErrorParsingFailureException(this.traceFile.getAbsolutePath(), e);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceFile", "com/android/tools/profilers/cpu/CpuCaptureParser$TraceFileValidationAction", "<init>"));
        }
    }

    public static class FileHeaderParsingFailureException
    extends ParsingFailureException {
        private FileHeaderParsingFailureException(@NotNull String traceFilePath, @NotNull Cpu.CpuTraceType type) {
            if (traceFilePath == null) {
                FileHeaderParsingFailureException.$$$reportNull$$$0(0);
            }
            if (type == null) {
                FileHeaderParsingFailureException.$$$reportNull$$$0(1);
            }
            super(String.format("Trace file '%s' expected to be of type %s but failed header verification.", traceFilePath, type));
        }

        private FileHeaderParsingFailureException(@NotNull String traceFilePath, @NotNull Cpu.CpuTraceType type, @NotNull Throwable cause) {
            if (traceFilePath == null) {
                FileHeaderParsingFailureException.$$$reportNull$$$0(2);
            }
            if (type == null) {
                FileHeaderParsingFailureException.$$$reportNull$$$0(3);
            }
            if (cause == null) {
                FileHeaderParsingFailureException.$$$reportNull$$$0(4);
            }
            super(String.format("Trace file '%s' expected to be of type %s but failed header verification.", traceFilePath, type), cause);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "traceFilePath";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cause";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/profilers/cpu/CpuCaptureParser$FileHeaderParsingFailureException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UnknownParserParsingFailureException
    extends ParsingFailureException {
        private UnknownParserParsingFailureException(@NotNull String traceFilePath) {
            if (traceFilePath == null) {
                UnknownParserParsingFailureException.$$$reportNull$$$0(0);
            }
            super(String.format("Trace not parsed. Couldn't identify the correct parser for '%s'.", traceFilePath));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceFilePath", "com/android/tools/profilers/cpu/CpuCaptureParser$UnknownParserParsingFailureException", "<init>"));
        }
    }

    public static class ReadErrorParsingFailureException
    extends ParsingFailureException {
        private ReadErrorParsingFailureException(@NotNull String traceFilePath, @NotNull IOException readError) {
            if (traceFilePath == null) {
                ReadErrorParsingFailureException.$$$reportNull$$$0(0);
            }
            if (readError == null) {
                ReadErrorParsingFailureException.$$$reportNull$$$0(1);
            }
            super(String.format("Trace not parsed. Unable to read file: '%s'.", traceFilePath), readError);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "traceFilePath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "readError";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/profilers/cpu/CpuCaptureParser$ReadErrorParsingFailureException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class InvalidPathParsingFailureException
    extends ParsingFailureException {
        private InvalidPathParsingFailureException(@NotNull String traceFilePath) {
            if (traceFilePath == null) {
                InvalidPathParsingFailureException.$$$reportNull$$$0(0);
            }
            super(String.format("Trace not parsed. Path doesn't exist or points to a directory: '%s'.", traceFilePath));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceFilePath", "com/android/tools/profilers/cpu/CpuCaptureParser$InvalidPathParsingFailureException", "<init>"));
        }
    }

    public static class PreProcessorFailureException
    extends ParsingFailureException {
        private PreProcessorFailureException() {
        }
    }

    public static class ParsingFailureException
    extends RuntimeException {
        private ParsingFailureException() {
        }

        protected ParsingFailureException(@NotNull String string) {
            if (string == null) {
                ParsingFailureException.$$$reportNull$$$0(0);
            }
            super(string);
        }

        protected ParsingFailureException(@NotNull String string, @NotNull Throwable cause) {
            if (string == null) {
                ParsingFailureException.$$$reportNull$$$0(1);
            }
            if (cause == null) {
                ParsingFailureException.$$$reportNull$$$0(2);
            }
            super(string, cause);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "string";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cause";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/profilers/cpu/CpuCaptureParser$ParsingFailureException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

