/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.chart.statechart.StateChartTextConverter;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.MultiSelectionModel;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import com.android.tools.adtui.trackgroup.TrackRenderer;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.AndroidFrameEventColorProvider;
import com.android.tools.profilers.cpu.AndroidFrameEventTextProvider;
import com.android.tools.profilers.cpu.AndroidFrameEventTrackRenderer$WhenMappings;
import com.android.tools.profilers.cpu.FrameTimelineSelectionOverlayPanel;
import com.android.tools.profilers.cpu.JankyFrameTrackRendererKt;
import com.android.tools.profilers.cpu.VsyncPanel;
import com.android.tools.profilers.cpu.analysis.CpuAnalyzable;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameEvent;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameEventTrackModel;
import com.android.tools.profilers.cpu.systemtrace.AndroidFramePhase;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineEvent;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.IntConsumer;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\tH\u0016J\u00af\u0001\u0010\n\u001a{\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00180\u000bj\b\u0012\u0004\u0012\u00020\u0016`\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/profilers/cpu/AndroidFrameEventTrackRenderer;", "Lcom/android/tools/adtui/trackgroup/TrackRenderer;", "Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameEventTrackModel;", "vsyncEnabler", "Ljava/util/function/BooleanSupplier;", "(Ljava/util/function/BooleanSupplier;)V", "render", "Ljavax/swing/JComponent;", "trackModel", "Lcom/android/tools/adtui/model/trackgroup/TrackModel;", "rendererForSharedTimeline", "Lkotlin/Function5;", "Ljava/awt/Graphics2D;", "Lkotlin/ParameterName;", "name", "g", "Ljava/awt/geom/Rectangle2D$Float;", "boundary", "Ljava/awt/FontMetrics;", "defaultFontMetrics", "", "hoverred", "Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameEvent;", "value", "", "Lcom/android/tools/adtui/chart/statechart/Renderer;", "phase", "Lcom/android/tools/profilers/cpu/systemtrace/AndroidFramePhase;", "multiSelectionModel", "Lcom/android/tools/adtui/model/MultiSelectionModel;", "Lcom/android/tools/profilers/cpu/analysis/CpuAnalyzable;", "timelineEventIndex", "", "", "Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameTimelineEvent;", "intellij.android.profilers.ui"})
public final class AndroidFrameEventTrackRenderer
implements TrackRenderer<AndroidFrameEventTrackModel> {
    private final BooleanSupplier vsyncEnabler;

    @NotNull
    public JComponent render(@NotNull TrackModel<AndroidFrameEventTrackModel, ?> trackModel) {
        Intrinsics.checkNotNullParameter(trackModel, (String)"trackModel");
        Object object = trackModel.getDataModel();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"trackModel.dataModel");
        AndroidFrameEventTrackModel model = (AndroidFrameEventTrackModel)((Object)object);
        Map<Long, AndroidFrameTimelineEvent> map2 = model.getTimelineEventByFrameNumber();
        boolean isSharedTimeline = !map2.isEmpty();
        StateChart stateChart = isSharedTimeline ? new StateChart((StateChartModel)model, this.rendererForSharedTimeline(model.getAndroidFramePhase(), model.getMultiSelectionModel(), model.getTimelineEventByFrameNumber()), null, 4, null) : new StateChart((StateChartModel)model, (StateChartColorProvider)new AndroidFrameEventColorProvider(), (StateChartTextConverter)new AndroidFrameEventTextProvider(), null, 8, null);
        stateChart.addRowIndexChangeListener(new IntConsumer(model){
            final /* synthetic */ AndroidFrameEventTrackModel $model;

            public final void accept(int it) {
                this.$model.setActiveSeriesIndex(it);
            }
            {
                this.$model = androidFrameEventTrackModel;
            }
        });
        JComponent content = isSharedTimeline ? FrameTimelineSelectionOverlayPanel.of$default((JComponent)stateChart, model.getViewRange(), model.getMultiSelectionModel(), FrameTimelineSelectionOverlayPanel.GrayOutMode.None.INSTANCE, true, null, 32, null) : (JComponent)stateChart;
        return VsyncPanel.of(content, model.getVsyncSeries(), this.vsyncEnabler);
    }

    private final Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, AndroidFrameEvent, Unit> rendererForSharedTimeline(AndroidFramePhase phase, MultiSelectionModel<CpuAnalyzable<?>> multiSelectionModel, Map<Long, AndroidFrameTimelineEvent> timelineEventIndex) {
        return (Function5)new Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, AndroidFrameEvent, Unit>(timelineEventIndex, multiSelectionModel, phase){
            final /* synthetic */ Map $timelineEventIndex;
            final /* synthetic */ MultiSelectionModel $multiSelectionModel;
            final /* synthetic */ AndroidFramePhase $phase;

            public final void invoke(@NotNull Graphics2D g, @NotNull Rectangle2D.Float boundary, @NotNull FontMetrics fontMetrics, boolean hovered, @NotNull AndroidFrameEvent frame) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
                Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                if (frame instanceof AndroidFrameEvent.Data) {
                    String fullText;
                    String text;
                    CharSequence charSequence;
                    JBColor jBColor;
                    AndroidFrameTimelineEvent correspondingTimelineEvent = (AndroidFrameTimelineEvent)this.$timelineEventIndex.get(((AndroidFrameEvent.Data)frame).getFrameNumber());
                    boolean isActive = correspondingTimelineEvent == this.$multiSelectionModel.getActiveSelectionKey();
                    if (correspondingTimelineEvent == null) {
                        jBColor = StudioColorsKt.getFadedNeutralLifecycleEvent();
                    } else if (isActive) {
                        switch (AndroidFrameEventTrackRenderer$WhenMappings.$EnumSwitchMapping$0[this.$phase.ordinal()]) {
                            case 1: 
                            case 2: {
                                jBColor = StudioColorsKt.getNeutralLifecycleEvent();
                                break;
                            }
                            default: {
                                jBColor = JankyFrameTrackRendererKt.getActiveColor(correspondingTimelineEvent);
                                break;
                            }
                        }
                    } else {
                        switch (AndroidFrameEventTrackRenderer$WhenMappings.$EnumSwitchMapping$1[this.$phase.ordinal()]) {
                            case 1: 
                            case 2: {
                                jBColor = StudioColorsKt.getFadedNeutralLifecycleEvent();
                                break;
                            }
                            default: {
                                jBColor = JankyFrameTrackRendererKt.getPassiveColor(correspondingTimelineEvent);
                            }
                        }
                    }
                    JBColor borderColor = jBColor;
                    int borderX = 1;
                    int borderY = 1;
                    g.setColor((Color)borderColor);
                    g.fill(boundary);
                    g.setColor(ProfilerColors.CPU_STATECHART_DEFAULT_STATE);
                    g.fill(new Rectangle2D.Float(boundary.x + (float)borderX, boundary.y + (float)borderY, boundary.width - (float)(2 * borderX), boundary.height - (float)(2 * borderY) - 1.0f));
                    int textPadding = borderX + 1;
                    float availableTextSpace = boundary.width - (float)(2 * textPadding);
                    if (availableTextSpace > 1.0f && (charSequence = (CharSequence)(text = AdtUiUtils.shrinkToFit((String)(fullText = ((AndroidFrameEvent.Data)frame).getFrameNumber() + ": " + TimeFormatter.getSingleUnitDurationString((long)((AndroidFrameEvent.Data)frame).getDurationUs())), (FontMetrics)fontMetrics, (float)availableTextSpace))).length() > 0) {
                        g.setColor(hovered || isActive ? JBUI.CurrentTheme.Label.foreground() : JBUI.CurrentTheme.Label.disabledForeground());
                        float textOffset = boundary.y + (boundary.height - (float)fontMetrics.getHeight()) * 0.5f + (float)fontMetrics.getAscent();
                        g.drawString(text, boundary.x + (float)textPadding, textOffset);
                    }
                }
            }
            {
                this.$timelineEventIndex = map2;
                this.$multiSelectionModel = multiSelectionModel;
                this.$phase = androidFramePhase;
                super(5);
            }
        };
    }

    public AndroidFrameEventTrackRenderer(@NotNull BooleanSupplier vsyncEnabler) {
        Intrinsics.checkNotNullParameter((Object)vsyncEnabler, (String)"vsyncEnabler");
        this.vsyncEnabler = vsyncEnabler;
    }
}

