/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.profilers.DataVisualizationColors;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameEvent;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/profilers/cpu/AndroidFrameEventColorProvider;", "Lcom/android/tools/adtui/chart/statechart/StateChartColorProvider;", "Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameEvent;", "()V", "getColor", "Ljava/awt/Color;", "isMouseOver", "", "value", "getFontColor", "intellij.android.profilers.ui"})
final class AndroidFrameEventColorProvider
extends StateChartColorProvider<AndroidFrameEvent> {
    @NotNull
    public Color getColor(boolean isMouseOver, @NotNull AndroidFrameEvent value) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        AndroidFrameEvent androidFrameEvent = value;
        if (androidFrameEvent instanceof AndroidFrameEvent.Data) {
            color = (Color)DataVisualizationColors.getPaletteManager().getBackgroundColor(((AndroidFrameEvent.Data)value).getFrameNumber(), isMouseOver);
        } else if (androidFrameEvent instanceof AndroidFrameEvent.Padding) {
            Color color2 = UIUtil.TRANSPARENT_COLOR;
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"UIUtil.TRANSPARENT_COLOR");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return color;
    }

    @NotNull
    public Color getFontColor(boolean isMouseOver, @NotNull AndroidFrameEvent value) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        AndroidFrameEvent androidFrameEvent = value;
        if (androidFrameEvent instanceof AndroidFrameEvent.Data) {
            color = (Color)DataVisualizationColors.getPaletteManager().getForegroundColor(((AndroidFrameEvent.Data)value).getFrameNumber());
        } else if (androidFrameEvent instanceof AndroidFrameEvent.Padding) {
            Color color2 = UIUtil.TRANSPARENT_COLOR;
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"UIUtil.TRANSPARENT_COLOR");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return color;
    }
}

