/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.ViewBinder;
import com.android.tools.adtui.stdui.ContextMenuItem;
import com.android.tools.adtui.stdui.DefaultContextMenuItem;
import com.android.tools.adtui.stdui.StreamingScrollbar;
import com.android.tools.inspectors.common.ui.ContextMenuInstaller;
import com.android.tools.profilers.DismissibleMessage;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerContextMenu;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.ProfilerMonitorView;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.appinspection.AppInspectionMigrationKt;
import com.android.tools.profilers.appinspection.AppInspectionMigrationServices;
import com.android.tools.profilers.cpu.CpuMonitor;
import com.android.tools.profilers.cpu.CpuMonitorTooltip;
import com.android.tools.profilers.cpu.CpuMonitorTooltipView;
import com.android.tools.profilers.cpu.CpuMonitorView;
import com.android.tools.profilers.customevent.CustomEventMonitor;
import com.android.tools.profilers.customevent.CustomEventMonitorTooltip;
import com.android.tools.profilers.customevent.CustomEventMonitorTooltipView;
import com.android.tools.profilers.customevent.CustomEventMonitorView;
import com.android.tools.profilers.energy.EnergyMonitor;
import com.android.tools.profilers.energy.EnergyMonitorTooltip;
import com.android.tools.profilers.energy.EnergyMonitorTooltipView;
import com.android.tools.profilers.energy.EnergyMonitorView;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.event.EventMonitorView;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.LifecycleTooltipView;
import com.android.tools.profilers.event.UserEventTooltip;
import com.android.tools.profilers.event.UserEventTooltipView;
import com.android.tools.profilers.memory.MemoryMonitor;
import com.android.tools.profilers.memory.MemoryMonitorTooltip;
import com.android.tools.profilers.memory.MemoryMonitorTooltipView;
import com.android.tools.profilers.memory.MemoryMonitorView;
import com.android.tools.profilers.network.NetworkMonitor;
import com.android.tools.profilers.network.NetworkMonitorTooltip;
import com.android.tools.profilers.network.NetworkMonitorTooltipView;
import com.android.tools.profilers.network.NetworkMonitorView;
import com.intellij.ui.scale.JBUIScale;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;

public class StudioMonitorStageView
extends StageView<StudioMonitorStage> {
    private static final String SHOW_DEBUGGABLE_MESSAGE = "debuggable.monitor.message";
    private static final String SHOW_PROFILEABLE_MESSAGE = "profileable.monitor.message";
    @NotNull
    private final List<ProfilerMonitorView> myViews;
    private static final String NETWORK_INSPECTOR = "Network Inspector";

    public StudioMonitorStageView(@NotNull StudioProfilersView profilersView, @NotNull StudioMonitorStage stage) {
        boolean isCustomEventVisualizationEnabled;
        if (profilersView == null) {
            StudioMonitorStageView.$$$reportNull$$$0(0);
        }
        if (stage == null) {
            StudioMonitorStageView.$$$reportNull$$$0(1);
        }
        super(profilersView, stage);
        ViewBinder binder = new ViewBinder();
        binder.bind(NetworkMonitor.class, NetworkMonitorView::new);
        binder.bind(CpuMonitor.class, CpuMonitorView::new);
        binder.bind(MemoryMonitor.class, MemoryMonitorView::new);
        binder.bind(EventMonitor.class, EventMonitorView::new);
        boolean isEnergyProfilerEnabled = ((StudioMonitorStage)((Object)this.getStage())).getStudioProfilers().getIdeServices().getFeatureConfig().isEnergyProfilerEnabled();
        if (isEnergyProfilerEnabled) {
            binder.bind(EnergyMonitor.class, EnergyMonitorView::new);
        }
        if (isCustomEventVisualizationEnabled = ((StudioMonitorStage)((Object)this.getStage())).getStudioProfilers().getIdeServices().getFeatureConfig().isCustomEventVisualizationEnabled()) {
            binder.bind(CustomEventMonitor.class, CustomEventMonitorView::new);
        }
        StreamingScrollbar sb = new StreamingScrollbar(((StudioMonitorStage)((Object)this.getStage())).getTimeline(), this.getComponent());
        this.getComponent().add((Component)sb, "South");
        JPanel topPanel = new JPanel((LayoutManager)new TabularLayout("*", "*,Fit-"));
        topPanel.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        TabularLayout layout = new TabularLayout("*");
        JPanel monitors = new JPanel((LayoutManager)layout);
        this.getTooltipPanel().setLayout(new FlowLayout(0, 0, 0));
        RangeTooltipComponent tooltipComponent = new RangeTooltipComponent((Timeline)((StudioMonitorStage)((Object)this.getStage())).getTimeline(), (JComponent)this.getTooltipPanel(), this.getProfilersView().getComponent(), () -> true);
        this.getTooltipBinder().bind(NetworkMonitorTooltip.class, NetworkMonitorTooltipView::new);
        this.getTooltipBinder().bind(CpuMonitorTooltip.class, CpuMonitorTooltipView::new);
        this.getTooltipBinder().bind(MemoryMonitorTooltip.class, MemoryMonitorTooltipView::new);
        this.getTooltipBinder().bind(LifecycleTooltip.class, (stageView, tooltip2) -> new LifecycleTooltipView(stageView.getComponent(), (LifecycleTooltip)tooltip2));
        this.getTooltipBinder().bind(UserEventTooltip.class, (stageView, tooltip2) -> new UserEventTooltipView(stageView.getComponent(), (UserEventTooltip)tooltip2));
        if (isEnergyProfilerEnabled) {
            this.getTooltipBinder().bind(EnergyMonitorTooltip.class, EnergyMonitorTooltipView::new);
        }
        if (isCustomEventVisualizationEnabled) {
            this.getTooltipBinder().bind(CustomEventMonitorTooltip.class, CustomEventMonitorTooltipView::new);
        }
        AppInspectionMigrationServices migrationServices = stage.getStudioProfilers().getIdeServices().getAppInspectionMigrationServices();
        this.myViews = new ArrayList<ProfilerMonitorView>(stage.getMonitors().size());
        int rowIndex = 0;
        for (final ProfilerMonitor monitor : stage.getMonitors()) {
            if (monitor instanceof NetworkMonitor && migrationServices.isMigrationEnabled()) {
                if (!migrationServices.isNetworkProfilerMigrationDialogEnabled()) continue;
                JPanel panel = new JPanel(new BorderLayout());
                panel.setOpaque(true);
                panel.setBorder(ProfilerLayout.MONITOR_BORDER);
                panel.setMinimumSize(new Dimension(0, JBUIScale.scale((int)50)));
                panel.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
                layout.setRowSizing(rowIndex, "100*");
                monitors.add((Component)panel, new TabularLayout.Constraint(rowIndex, 0));
                ++rowIndex;
                AppInspectionMigrationKt.addMigrationPanel(panel, "Network Profiler has moved.", "network activity", NETWORK_INSPECTOR, () -> {
                    ((StudioMonitorStage)((Object)((Object)this.getStage()))).getStudioProfilers().getIdeServices().getFeatureTracker().trackNetworkMigrationDialogSelected();
                    migrationServices.openAppInspectionToolWindow(NETWORK_INSPECTOR);
                }, () -> {
                    migrationServices.setNetworkProfilerMigrationDialogEnabled(false);
                    this.relayoutMonitors(monitors);
                    this.getProfilersView().getComponent().setCursor(null);
                }, (Function2<? super Container, ? super Cursor, ? extends Container>)((Function2)(container, cursor) -> {
                    JLayeredPane cursorContainer = this.getProfilersView().getComponent();
                    cursorContainer.setCursor((Cursor)cursor);
                    return cursorContainer;
                }));
                continue;
            }
            ProfilerMonitorView view = (ProfilerMonitorView)((Object)binder.build((Object)profilersView, (Object)monitor));
            view.registerTooltip(tooltipComponent, stage);
            JComponent component = view.getComponent();
            component.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    StudioMonitorStageView.this.getProfilersView().getStageComponent().requestFocusInWindow();
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        StudioMonitorStageView.this.expandMonitor(monitor);
                    }
                }
            });
            component.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    int keyCode = KeyEvent.getExtendedKeyCodeForChar(e.getKeyChar());
                    if (keyCode == 10 && monitor.isFocused()) {
                        StudioMonitorStageView.this.expandMonitor(monitor);
                    }
                }
            });
            IdeProfilerComponents ideProfilerComponents = this.getIdeComponents();
            ContextMenuInstaller contextMenuInstaller = ideProfilerComponents.createContextMenuInstaller();
            DefaultContextMenuItem.Builder builder = new DefaultContextMenuItem.Builder("Open " + monitor.getName());
            DefaultContextMenuItem action = builder.setActionRunnable(() -> this.expandMonitor(monitor)).setKeyStrokes(new KeyStroke[]{KeyStroke.getKeyStroke(10, 0)}).setContainerComponent(component).build();
            ProfilerContextMenu.createIfAbsent(component).add(new ContextMenuItem[]{action});
            contextMenuInstaller.installGenericContextMenu(component, (ContextMenuItem)action);
            contextMenuInstaller.installGenericContextMenu(component, ContextMenuItem.SEPARATOR);
            profilersView.installCommonMenuItems(component);
            layout.setRowSizing(rowIndex, this.rowSizeString(view));
            monitors.add((Component)component, new TabularLayout.Constraint(rowIndex, 0));
            ++rowIndex;
            this.myViews.add(view);
        }
        StudioProfilers profilers = stage.getStudioProfilers();
        JComponent timeAxis = this.buildTimeAxis(profilers);
        topPanel.add((Component)tooltipComponent, new TabularLayout.Constraint(0, 0));
        topPanel.add((Component)monitors, new TabularLayout.Constraint(0, 0));
        topPanel.add((Component)timeAxis, new TabularLayout.Constraint(1, 0));
        this.getComponent().add((Component)topPanel, "Center");
    }

    private void relayoutMonitors(@NotNull JPanel monitors) {
        if (monitors == null) {
            StudioMonitorStageView.$$$reportNull$$$0(2);
        }
        TabularLayout layout = new TabularLayout("*");
        monitors.setLayout((LayoutManager)layout);
        monitors.removeAll();
        int index = 0;
        for (ProfilerMonitorView view : this.myViews) {
            layout.setRowSizing(index, this.rowSizeString(view));
            monitors.add((Component)view.getComponent(), new TabularLayout.Constraint(index, 0));
            ++index;
        }
        monitors.revalidate();
    }

    private String rowSizeString(@NotNull ProfilerMonitorView<ProfilerMonitor> view) {
        int weight;
        if (view == null) {
            StudioMonitorStageView.$$$reportNull$$$0(3);
        }
        return (weight = (int)(view.getVerticalWeight() * 100.0f)) > 0 ? weight + "*" : "Fit-";
    }

    private void expandMonitor(ProfilerMonitor monitor) {
        ((StudioMonitorStage)((Object)this.getStage())).getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectMonitor();
        monitor.expand();
    }

    @Override
    public JComponent getToolbar() {
        switch (((StudioMonitorStage)((Object)this.getStage())).getStudioProfilers().getSelectedSessionSupportLevel()) {
            case DEBUGGABLE: {
                return DismissibleMessage.of(((StudioMonitorStage)((Object)this.getStage())).getStudioProfilers(), SHOW_DEBUGGABLE_MESSAGE, "Timing data from debuggable processes will deviate significantly from real world performance. A profileable process may be more suitable.", "https://d.android.com/r/studio-ui/profiler/profileable", ProfilerColors.NOTIFICATION_BACKGROUND);
            }
            case PROFILEABLE: {
                return DismissibleMessage.of(((StudioMonitorStage)((Object)this.getStage())).getStudioProfilers(), SHOW_PROFILEABLE_MESSAGE, "Only CPU and Memory profilers are enabled for profileable processes.", "https://d.android.com/r/studio-ui/profiler/profileable");
            }
        }
        return new JPanel();
    }

    @Override
    public boolean needsProcessSelection() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilersView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "monitors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/StudioMonitorStageView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "relayoutMonitors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "rowSizeString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

