/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.trackgroup.TrackRenderer;
import com.android.tools.adtui.trackgroup.TrackRendererFactory;
import com.android.tools.profilers.ProfilerTrackRendererFactory$WhenMappings;
import com.android.tools.profilers.ProfilerTrackRendererType;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.AndroidFrameEventTrackRenderer;
import com.android.tools.profilers.cpu.BufferQueueTrackRenderer;
import com.android.tools.profilers.cpu.CpuCoreTrackRenderer;
import com.android.tools.profilers.cpu.CpuFrequencyTrackRenderer;
import com.android.tools.profilers.cpu.CpuThreadTrackRenderer;
import com.android.tools.profilers.cpu.DeadlineTextRenderer;
import com.android.tools.profilers.cpu.FramesTrackRenderer;
import com.android.tools.profilers.cpu.JankyFrameTrackRenderer;
import com.android.tools.profilers.cpu.RssMemoryTrackRenderer;
import com.android.tools.profilers.cpu.SurfaceflingerTrackRenderer;
import com.android.tools.profilers.cpu.VsyncTrackRenderer;
import com.android.tools.profilers.customevent.CustomEventTrackRenderer;
import com.android.tools.profilers.event.LifecycleTrackRenderer;
import com.android.tools.profilers.event.UserEventTrackRenderer;
import java.util.function.BooleanSupplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u0012\u0012\u000e\b\u0001\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/profilers/ProfilerTrackRendererFactory;", "Lcom/android/tools/adtui/trackgroup/TrackRendererFactory;", "Lcom/android/tools/profilers/ProfilerTrackRendererType;", "myProfilersView", "Lcom/android/tools/profilers/StudioProfilersView;", "vsyncEnabler", "Ljava/util/function/BooleanSupplier;", "(Lcom/android/tools/profilers/StudioProfilersView;Ljava/util/function/BooleanSupplier;)V", "createRenderer", "Lcom/android/tools/adtui/trackgroup/TrackRenderer;", "", "kotlin.jvm.PlatformType", "rendererType", "intellij.android.profilers.ui"})
public final class ProfilerTrackRendererFactory
implements TrackRendererFactory<ProfilerTrackRendererType> {
    private final StudioProfilersView myProfilersView;
    private final BooleanSupplier vsyncEnabler;

    @NotNull
    public TrackRenderer<? extends Object> createRenderer(@NotNull ProfilerTrackRendererType rendererType) {
        TrackRenderer trackRenderer;
        Intrinsics.checkNotNullParameter((Object)((Object)rendererType), (String)"rendererType");
        switch (ProfilerTrackRendererFactory$WhenMappings.$EnumSwitchMapping$0[rendererType.ordinal()]) {
            case 1: {
                trackRenderer = new LifecycleTrackRenderer();
                break;
            }
            case 2: {
                trackRenderer = new UserEventTrackRenderer();
                break;
            }
            case 3: {
                trackRenderer = new FramesTrackRenderer(this.vsyncEnabler);
                break;
            }
            case 4: {
                trackRenderer = new SurfaceflingerTrackRenderer(this.vsyncEnabler);
                break;
            }
            case 5: {
                trackRenderer = new VsyncTrackRenderer(this.vsyncEnabler);
                break;
            }
            case 6: {
                trackRenderer = new BufferQueueTrackRenderer(this.vsyncEnabler);
                break;
            }
            case 7: {
                trackRenderer = new CpuThreadTrackRenderer(this.myProfilersView, this.vsyncEnabler);
                break;
            }
            case 8: {
                trackRenderer = new CpuCoreTrackRenderer();
                break;
            }
            case 9: {
                trackRenderer = new CpuFrequencyTrackRenderer();
                break;
            }
            case 10: {
                trackRenderer = new RssMemoryTrackRenderer();
                break;
            }
            case 11: {
                trackRenderer = new AndroidFrameEventTrackRenderer(this.vsyncEnabler);
                break;
            }
            case 12: {
                trackRenderer = new JankyFrameTrackRenderer(this.vsyncEnabler);
                break;
            }
            case 13: {
                trackRenderer = new DeadlineTextRenderer(this.vsyncEnabler);
                break;
            }
            case 14: {
                trackRenderer = new CustomEventTrackRenderer();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return trackRenderer;
    }

    public ProfilerTrackRendererFactory(@NotNull StudioProfilersView myProfilersView, @NotNull BooleanSupplier vsyncEnabler) {
        Intrinsics.checkNotNullParameter((Object)((Object)myProfilersView), (String)"myProfilersView");
        Intrinsics.checkNotNullParameter((Object)vsyncEnabler, (String)"vsyncEnabler");
        this.myProfilersView = myProfilersView;
        this.vsyncEnabler = vsyncEnabler;
    }
}

