/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.LogService;
import com.android.tools.datastore.database.CpuTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import io.grpc.StatusRuntimeException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CpuDataPoller
extends PollRunner {
    private long myDataRequestStartTimestampNs;
    private long myTraceInfoRequestStartTimestampNs;
    @NotNull
    private final CpuServiceGrpc.CpuServiceBlockingStub myPollingService;
    @NotNull
    private final CpuTable myCpuTable;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final LogService myLogService;

    public CpuDataPoller(@NotNull Common.Session session, @NotNull CpuTable table2, @NotNull CpuServiceGrpc.CpuServiceBlockingStub pollingService, @NotNull LogService logService) {
        if (session == null) {
            CpuDataPoller.$$$reportNull$$$0(0);
        }
        if (table2 == null) {
            CpuDataPoller.$$$reportNull$$$0(1);
        }
        if (pollingService == null) {
            CpuDataPoller.$$$reportNull$$$0(2);
        }
        if (logService == null) {
            CpuDataPoller.$$$reportNull$$$0(3);
        }
        super(POLLING_DELAY_NS);
        this.myDataRequestStartTimestampNs = Long.MIN_VALUE;
        this.myTraceInfoRequestStartTimestampNs = Long.MIN_VALUE;
        this.myCpuTable = table2;
        this.myPollingService = pollingService;
        this.mySession = session;
        this.myLogService = logService;
    }

    @Override
    public void poll() throws StatusRuntimeException {
        long getDataStartNs = this.myDataRequestStartTimestampNs;
        CpuProfiler.CpuDataRequest.Builder request = CpuProfiler.CpuDataRequest.newBuilder().setSession(this.mySession).setStartTimestamp(getDataStartNs).setEndTimestamp(Long.MAX_VALUE);
        CpuProfiler.CpuDataResponse response = this.myPollingService.getData(request.build());
        for (Cpu.CpuUsageData data : response.getDataList()) {
            getDataStartNs = Math.max(getDataStartNs, data.getEndTimestamp());
            this.myCpuTable.insert(this.mySession, data);
        }
        long getThreadsStartNs = this.myDataRequestStartTimestampNs;
        CpuProfiler.GetThreadsRequest.Builder threadsRequest = CpuProfiler.GetThreadsRequest.newBuilder().setSession(this.mySession).setStartTimestamp(getThreadsStartNs).setEndTimestamp(Long.MAX_VALUE);
        CpuProfiler.GetThreadsResponse threadsResponse = this.myPollingService.getThreads(threadsRequest.build());
        if (this.myDataRequestStartTimestampNs == Long.MIN_VALUE) {
            CpuProfiler.GetThreadsResponse.ThreadSnapshot snapshot = threadsResponse.getInitialSnapshot();
            getThreadsStartNs = Math.max(getThreadsStartNs, snapshot.getTimestamp());
            this.myCpuTable.insertSnapshot(this.mySession, snapshot.getTimestamp(), snapshot.getThreadsList());
        }
        for (CpuProfiler.GetThreadsResponse.Thread thread2 : threadsResponse.getThreadsList()) {
            List activities = thread2.getActivitiesList();
            int count2 = thread2.getActivitiesCount();
            if (count2 > 0) {
                CpuProfiler.GetThreadsResponse.ThreadActivity last = (CpuProfiler.GetThreadsResponse.ThreadActivity)activities.get(count2 - 1);
                getThreadsStartNs = Math.max(getThreadsStartNs, last.getTimestamp());
            }
            this.myCpuTable.insertActivities(this.mySession, thread2.getTid(), thread2.getName(), activities);
        }
        CpuProfiler.GetTraceInfoRequest.Builder traceInfoRequest = CpuProfiler.GetTraceInfoRequest.newBuilder().setSession(this.mySession).setFromTimestamp(this.myTraceInfoRequestStartTimestampNs).setToTimestamp(Long.MAX_VALUE);
        CpuProfiler.GetTraceInfoResponse traceInfoResponse = this.myPollingService.getTraceInfo(traceInfoRequest.build());
        for (Cpu.CpuTraceInfo traceInfo : traceInfoResponse.getTraceInfoList()) {
            this.myCpuTable.insertTraceInfo(this.mySession, traceInfo);
            this.myTraceInfoRequestStartTimestampNs = Math.max(this.myTraceInfoRequestStartTimestampNs, Math.max(traceInfo.getFromTimestamp(), traceInfo.getToTimestamp()));
        }
        this.myDataRequestStartTimestampNs = Math.max(Math.max(this.myDataRequestStartTimestampNs + 1L, getDataStartNs), getThreadsStartNs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "table";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "pollingService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "logService";
                break;
            }
        }
        objectArray[1] = "com/android/tools/datastore/poller/CpuDataPoller";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

