/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.debugger;

import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.origin.Origin;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.AndroidDexer;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/android/debugger/AndroidDexerImpl;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/AndroidDexer;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "dex", "", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "DexConsumer", "intellij.android.kotlin.idea"})
public final class AndroidDexerImpl
implements AndroidDexer {
    @NotNull
    private final Project project;

    @Nullable
    public byte[] dex(@NotNull Collection<ClassToLoad> classes) {
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        try {
            D8Command.Builder builder = D8Command.builder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"D8Command.builder()");
            D8Command.Builder builder2 = builder;
            DexConsumer consumer = new DexConsumer();
            for (ClassToLoad classToLoad : classes) {
                byte[] bytes = classToLoad.component3();
                builder2.addClassProgramData(bytes, Origin.unknown());
            }
            builder2.setMode(CompilationMode.DEBUG);
            builder2.setProgramConsumer((ProgramConsumer)consumer);
            builder2.setMinApiLevel(13);
            builder2.setDisableDesugaring(true);
            D8.run((D8Command)((D8Command)builder2.build()));
            return consumer.getBytes();
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public AndroidDexerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/android/debugger/AndroidDexerImpl$DexConsumer;", "Lcom/android/tools/r8/DexIndexedConsumer;", "()V", "bytes", "", "getBytes", "()[B", "setBytes", "([B)V", "accept", "", "fileIndex", "", "data", "Lcom/android/tools/r8/ByteDataView;", "descriptors", "", "", "handler", "Lcom/android/tools/r8/DiagnosticsHandler;", "finished", "intellij.android.kotlin.idea"})
    private static final class DexConsumer
    implements DexIndexedConsumer {
        @Nullable
        private byte[] bytes;

        @Nullable
        public final byte[] getBytes() {
            return this.bytes;
        }

        public final void setBytes(@Nullable byte[] byArray) {
            this.bytes = byArray;
        }

        public synchronized void accept(int fileIndex, @NotNull ByteDataView data, @NotNull Set<String> descriptors, @NotNull DiagnosticsHandler handler) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            if (this.bytes != null) {
                throw (Throwable)new IllegalStateException("Multidex not supported");
            }
            this.bytes = data.copyByteData();
        }

        public void finished(@NotNull DiagnosticsHandler handler) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        }
    }
}

