/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.SdkConstants;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.repository.Revision;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.utils.ILogger;
import com.google.common.io.Files;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.execution.ParametersListUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import org.jetbrains.android.AndroidCommonBundle;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidExecutionUtil;
import org.jetbrains.android.util.SafeSignedJarBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidBuildCommonUtils {
    @NonNls
    public static final String PROGUARD_CFG_FILE_NAME = "proguard-project.txt";
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.util.AndroidCommonUtils");
    @NonNls
    public static final String MANIFEST_JAVA_FILE_NAME = "Manifest.java";
    @NonNls
    public static final String R_JAVA_FILENAME = "R.java";
    @NonNls
    public static final String CLASSES_JAR_FILE_NAME = "classes.jar";
    @NonNls
    public static final String AAR_DEPS_JAR_FILE_NAME = "aar_deps.jar";
    @NonNls
    public static final String CLASSES_FILE_NAME = "classes.dex";
    private static final Pattern WARNING_PATTERN = Pattern.compile(".*warning.*");
    private static final Pattern ERROR_PATTERN = Pattern.compile(".*error.*");
    private static final Pattern EXCEPTION_PATTERN = Pattern.compile(".*exception.*");
    public static final Pattern R_PATTERN = Pattern.compile("R(\\$.*)?\\.class");
    private static final Pattern MANIFEST_PATTERN = Pattern.compile("Manifest(\\$.*)?\\.class");
    private static final String BUILD_CONFIG_CLASS_NAME = "BuildConfig.class";
    public static final Pattern COMPILER_MESSAGE_PATTERN = Pattern.compile("(.+):(\\d+):.+");
    @NonNls
    public static final String PNG_EXTENSION = "png";
    private static final String[] DRAWABLE_EXTENSIONS = new String[]{"png", "jpg", "gif"};
    @NonNls
    public static final String RELEASE_BUILD_OPTION = "RELEASE_BUILD_KEY";
    @NonNls
    public static final String PROGUARD_CFG_PATHS_OPTION = "ANDROID_PROGUARD_CFG_PATHS";
    @NonNls
    public static final String PROGUARD_OUTPUT_JAR_NAME = "obfuscated_sources.jar";
    @NonNls
    public static final String SYSTEM_PROGUARD_CFG_FILE_NAME = "proguard-android.txt";
    @NonNls
    private static final String PROGUARD_HOME_ENV_VARIABLE = "PROGUARD_HOME";
    @NonNls
    public static final String ADDITIONAL_NATIVE_LIBS_ELEMENT = "additionalNativeLibs";
    private static final String[] TEST_CONFIGURATION_TYPE_IDS = new String[]{"AndroidJUnit", "JUnit", "TestNG", "ScalaTestRunConfiguration", "SpecsRunConfiguration", "Specs2RunConfiguration"};
    @NonNls
    public static final String ANNOTATIONS_JAR_RELATIVE_PATH = "/tools/support/annotations.jar";
    @NonNls
    public static final String PACKAGE_MANIFEST_ATTRIBUTE = "package";
    @NonNls
    public static final String ANDROID_FINAL_PACKAGE_FOR_ARTIFACT_SUFFIX = ".afp";
    @NonNls
    public static final String PROGUARD_CFG_OUTPUT_FILE_NAME = "proguard.txt";
    @NonNls
    public static final String MANIFEST_MERGING_BUILD_TARGET_TYPE_ID = "android-manifest-merging";
    @NonNls
    public static final String AAR_DEPS_BUILD_TARGET_TYPE_ID = "android-aar-deps";
    @NonNls
    public static final String DEX_BUILD_TARGET_TYPE_ID = "android-dex";
    @NonNls
    public static final String PRE_DEX_BUILD_TARGET_TYPE_ID = "android-pre-dex";
    @NonNls
    public static final String PACKAGING_BUILD_TARGET_TYPE_ID = "android-packaging";
    @NonNls
    public static final String RESOURCE_CACHING_BUILD_TARGET_ID = "android-resource-caching";
    @NonNls
    public static final String RESOURCE_PACKAGING_BUILD_TARGET_ID = "android-resource-packaging";
    @NonNls
    public static final String LIBRARY_PACKAGING_BUILD_TARGET_ID = "android-library-packaging";
    @NonNls
    public static final String AUTOGENERATED_JAVA_FILE_HEADER = "/*___Generated_by_IDEA___*/";
    @NonNls
    public static final String ANDROID_TEST_RUN_CONFIGURATION_TYPE = "AndroidTestRunConfigurationType";

    private AndroidBuildCommonUtils() {
    }

    public static boolean isTestConfiguration(@NotNull String typeId) {
        if (typeId == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(0);
        }
        return ArrayUtilRt.find((Object[])TEST_CONFIGURATION_TYPE_IDS, (Object)typeId) >= 0;
    }

    public static boolean isInstrumentationTestConfiguration(@NotNull String typeId) {
        if (typeId == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(1);
        }
        return ANDROID_TEST_RUN_CONFIGURATION_TYPE.equals(typeId);
    }

    public static String command2string(@NotNull Collection<String> command) {
        if (command == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(2);
        }
        StringBuilder builder = new StringBuilder();
        Iterator<String> it = command.iterator();
        while (it.hasNext()) {
            String s = it.next();
            builder.append('[');
            builder.append(s);
            builder.append(']');
            if (!it.hasNext()) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    public static void moveAllFiles(@NotNull File from, @NotNull File to, @NotNull Collection<File> newFiles) throws IOException {
        if (from == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(3);
        }
        if (to == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(4);
        }
        if (newFiles == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(5);
        }
        if (from.isFile()) {
            FileUtil.rename((File)from, (File)to);
            newFiles.add(to);
        } else {
            File[] children = from.listFiles();
            if (children != null) {
                for (File child : children) {
                    AndroidBuildCommonUtils.moveAllFiles(child, new File(to, child.getName()), newFiles);
                }
            }
        }
    }

    public static void handleDexCompilationResult(@NotNull Process process, @NotNull String commandLine, @NotNull String outputFilePath, final @NotNull Map<AndroidCompilerMessageKind, List<String>> messages, boolean multiDex) {
        if (process == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(6);
        }
        if (commandLine == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(7);
        }
        if (outputFilePath == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(8);
        }
        if (messages == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(9);
        }
        BaseOSProcessHandler handler = new BaseOSProcessHandler(process, commandLine, null);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private AndroidCompilerMessageKind myCategory = null;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String[] msgs;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (String msg : msgs = event.getText().split("\\n")) {
                    msg = msg.trim();
                    String msglc = msg.toLowerCase(Locale.US);
                    if (outputType == ProcessOutputTypes.STDERR) {
                        if (WARNING_PATTERN.matcher(msglc).matches()) {
                            this.myCategory = AndroidCompilerMessageKind.WARNING;
                        }
                        if (ERROR_PATTERN.matcher(msglc).matches() || EXCEPTION_PATTERN.matcher(msglc).matches() || this.myCategory == null) {
                            this.myCategory = AndroidCompilerMessageKind.ERROR;
                        }
                        ((List)messages.get((Object)this.myCategory)).add(msg);
                    } else if (outputType == ProcessOutputTypes.STDOUT && !msglc.startsWith("processing")) {
                        ((List)messages.get((Object)AndroidCompilerMessageKind.INFORMATION)).add(msg);
                    }
                    LOG.debug(msg);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/android/util/AndroidBuildCommonUtils$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        handler.startNotify();
        handler.waitFor();
        List<String> errors = messages.get((Object)AndroidCompilerMessageKind.ERROR);
        if (new File(outputFilePath).isFile()) {
            messages.get((Object)AndroidCompilerMessageKind.WARNING).addAll(errors);
            errors.clear();
        } else if (errors.isEmpty() && !multiDex) {
            errors.add("Cannot create classes.dex file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static List<String> packClassFilesIntoJar(@NotNull String[] firstPackageDirPaths, @NotNull String[] libFirstPackageDirPaths, @NotNull File jarFile) throws IOException {
        void var6_11;
        File firstPackageDir;
        String path;
        void var6_9;
        if (jarFile == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(10);
        }
        if (firstPackageDirPaths == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(11);
        }
        if (libFirstPackageDirPaths == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(12);
        }
        ArrayList<Pair<File, String>> files = new ArrayList<Pair<File, String>>();
        String[] stringArray = firstPackageDirPaths;
        int n = stringArray.length;
        boolean bl = false;
        while (var6_9 < n) {
            path = stringArray[var6_9];
            firstPackageDir = new File(path);
            if (firstPackageDir.exists()) {
                AndroidBuildCommonUtils.packClassFilesIntoJar(firstPackageDir, firstPackageDir.getParentFile(), true, files);
            }
            ++var6_9;
        }
        stringArray = libFirstPackageDirPaths;
        n = stringArray.length;
        boolean bl2 = false;
        while (var6_11 < n) {
            path = stringArray[var6_11];
            firstPackageDir = new File(path);
            if (firstPackageDir.exists()) {
                AndroidBuildCommonUtils.packClassFilesIntoJar(firstPackageDir, firstPackageDir.getParentFile(), false, files);
            }
            ++var6_11;
        }
        if (!files.isEmpty()) {
            try (JarOutputStream jos = new JarOutputStream(new FileOutputStream(jarFile));){
                for (Pair pair : files) {
                    AndroidBuildCommonUtils.packIntoJar(jos, (File)pair.getFirst(), (String)pair.getSecond());
                }
            }
        } else if (jarFile.isFile() && !jarFile.delete()) {
            throw new IOException("Cannot delete file " + FileUtilRt.toSystemDependentName((String)jarFile.getPath()));
        }
        ArrayList<String> srcFiles = new ArrayList<String>();
        for (Pair pair : files) {
            srcFiles.add(((File)pair.getFirst()).getPath());
        }
        ArrayList<String> arrayList = srcFiles;
        if (arrayList == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private static void packClassFilesIntoJar(@NotNull File file, @NotNull File rootDirectory, boolean packRAndManifestClasses, @NotNull List<Pair<File, String>> files) {
        if (file == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(14);
        }
        if (rootDirectory == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(15);
        }
        if (files == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(16);
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    AndroidBuildCommonUtils.packClassFilesIntoJar(child, rootDirectory, packRAndManifestClasses, files);
                }
            }
        } else if (file.isFile()) {
            if (!FileUtilRt.extensionEquals((String)file.getName(), (String)"class")) {
                return;
            }
            if (!packRAndManifestClasses && (R_PATTERN.matcher(file.getName()).matches() || MANIFEST_PATTERN.matcher(file.getName()).matches() || BUILD_CONFIG_CLASS_NAME.equals(file.getName()))) {
                return;
            }
            String rootPath = rootDirectory.getAbsolutePath();
            String path = file.getAbsolutePath();
            if ((path = FileUtil.toSystemIndependentName((String)path.substring(rootPath.length()))).charAt(0) == '/') {
                path = path.substring(1);
            }
            files.add((Pair<File, String>)Pair.create((Object)file, (Object)path));
        }
    }

    public static void packIntoJar(@NotNull JarOutputStream jar, @NotNull File file, @NotNull String path) throws IOException {
        if (jar == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(17);
        }
        if (file == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(18);
        }
        if (path == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(19);
        }
        JarEntry entry = new JarEntry(path);
        entry.setTime(file.lastModified());
        jar.putNextEntry(entry);
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            int count;
            byte[] buffer = new byte[1024];
            while ((count = bis.read(buffer)) != -1) {
                jar.write(buffer, 0, count);
            }
            jar.closeEntry();
        }
    }

    @NotNull
    public static Map<AndroidCompilerMessageKind, List<String>> launchProguard(@NotNull IAndroidTarget target, int sdkToolsRevision, @NotNull String sdkOsPath, @NotNull String javaExecutablePath, @NotNull String proguardVmOptions, @NotNull String[] proguardConfigFileOsPaths, @NotNull String inputJarOsPath, @NotNull String[] externalJarOsPaths, @NotNull String[] providedJarOsPaths, @NotNull String outputJarFileOsPath, @Nullable String logDirOutputOsPath) throws IOException {
        if (target == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(20);
        }
        if (sdkOsPath == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(21);
        }
        if (javaExecutablePath == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(22);
        }
        if (proguardVmOptions == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(23);
        }
        if (inputJarOsPath == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(24);
        }
        if (outputJarFileOsPath == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(25);
        }
        if (proguardConfigFileOsPaths == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(26);
        }
        if (externalJarOsPaths == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(27);
        }
        if (providedJarOsPaths == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(28);
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(javaExecutablePath);
        if (!proguardVmOptions.isEmpty()) {
            commands.addAll(ParametersListUtil.parse((String)proguardVmOptions));
        }
        commands.add("-jar");
        String proguardHome = AndroidBuildCommonUtils.getProguardHomeDirOsPath(sdkOsPath);
        String proguardJarOsPath = proguardHome + File.separator + "lib" + File.separator + "proguard.jar";
        commands.add(proguardJarOsPath);
        if (AndroidBuildCommonUtils.isIncludingInProguardSupported(sdkToolsRevision)) {
            for (String proguardConfigFileOsPath : proguardConfigFileOsPaths) {
                commands.add("-include");
                commands.add(AndroidBuildCommonUtils.quotePath(proguardConfigFileOsPath));
            }
        } else {
            commands.add("@" + AndroidBuildCommonUtils.quotePath(proguardConfigFileOsPaths[0]));
        }
        commands.add("-injars");
        StringBuilder builder = new StringBuilder(AndroidBuildCommonUtils.quotePath(inputJarOsPath));
        for (String jarFile : externalJarOsPaths) {
            builder.append(File.pathSeparatorChar);
            builder.append(AndroidBuildCommonUtils.quotePath(jarFile));
        }
        commands.add(builder.toString());
        commands.add("-outjars");
        commands.add(AndroidBuildCommonUtils.quotePath(outputJarFileOsPath));
        commands.add("-libraryjars");
        builder = new StringBuilder(AndroidBuildCommonUtils.quotePath(target.getPath(1).toString()));
        List libraries = target.getAdditionalLibraries();
        for (OptionalLibrary lib : libraries) {
            builder.append(File.pathSeparatorChar);
            builder.append(AndroidBuildCommonUtils.quotePath(lib.getJar().toAbsolutePath().toString()));
        }
        for (String path : providedJarOsPaths) {
            builder.append(File.pathSeparatorChar);
            builder.append(AndroidBuildCommonUtils.quotePath(path));
        }
        commands.add(builder.toString());
        if (logDirOutputOsPath != null) {
            commands.add("-dump");
            commands.add(AndroidBuildCommonUtils.quotePath(new File(logDirOutputOsPath, "dump.txt").getAbsolutePath()));
            commands.add("-printseeds");
            commands.add(AndroidBuildCommonUtils.quotePath(new File(logDirOutputOsPath, "seeds.txt").getAbsolutePath()));
            commands.add("-printusage");
            commands.add(AndroidBuildCommonUtils.quotePath(new File(logDirOutputOsPath, "usage.txt").getAbsolutePath()));
            commands.add("-printmapping");
            commands.add(AndroidBuildCommonUtils.quotePath(new File(logDirOutputOsPath, "mapping.txt").getAbsolutePath()));
        }
        LOG.info(AndroidBuildCommonUtils.command2string(commands));
        Map home = System.getenv().containsKey(PROGUARD_HOME_ENV_VARIABLE) ? Collections.emptyMap() : Collections.singletonMap(PROGUARD_HOME_ENV_VARIABLE, proguardHome);
        Map<AndroidCompilerMessageKind, List<String>> map = AndroidExecutionUtil.doExecute(ArrayUtilRt.toStringArray(commands), home);
        if (map == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(29);
        }
        return map;
    }

    @NotNull
    public static String getProguardHomeDirOsPath(@NotNull String sdkOsPath) {
        if (sdkOsPath == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(30);
        }
        String string = sdkOsPath + File.separator + "tools" + File.separator + "proguard";
        if (string == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(31);
        }
        return string;
    }

    private static String quotePath(String path) {
        if (((String)path).indexOf(32) >= 0) {
            path = "'" + (String)path + "'";
        }
        return path;
    }

    public static String buildTempInputJar(@NotNull String[] classFilesDirOsPaths, @NotNull String[] libClassFilesDirOsPaths) throws IOException {
        if (classFilesDirOsPaths == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(32);
        }
        if (libClassFilesDirOsPaths == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(33);
        }
        File inputJar = FileUtil.createTempFile((String)"proguard_input", (String)".jar");
        AndroidBuildCommonUtils.packClassFilesIntoJar(classFilesDirOsPaths, libClassFilesDirOsPaths, inputJar);
        return FileUtilRt.toSystemDependentName((String)inputJar.getPath());
    }

    public static String platformToolPath(@NotNull String toolFileName) {
        if (toolFileName == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(34);
        }
        return SdkConstants.OS_SDK_PLATFORM_TOOLS_FOLDER + toolFileName;
    }

    public static boolean isIncludingInProguardSupported(int sdkToolsRevision) {
        return sdkToolsRevision == -1 || sdkToolsRevision >= 17;
    }

    @Nullable
    public static Revision parsePackageRevision(@NotNull String sdkDirOsPath, @NotNull String packageDirName) {
        File propFile;
        if (sdkDirOsPath == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(35);
        }
        if (packageDirName == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(36);
        }
        if ((propFile = new File(sdkDirOsPath + File.separatorChar + packageDirName + File.separatorChar + "source.properties")).exists() && propFile.isFile()) {
            Map map = ProjectProperties.parsePropertyFile((IAbstractFile)new FileWrapper(propFile), (ILogger)new MessageBuildingSdkLog());
            if (map == null) {
                return null;
            }
            String revision = (String)map.get("Pkg.Revision");
            if (revision != null) {
                return Revision.parseRevision((String)revision);
            }
        }
        return null;
    }

    @NotNull
    public static String readFile(@NotNull File file) throws IOException {
        if (file == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(37);
        }
        String string = Files.toString((File)file, (Charset)StandardCharsets.UTF_8);
        if (string == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(38);
        }
        return string;
    }

    public static boolean contains2Identifiers(String packageName) {
        return packageName.split("\\.").length >= 2;
    }

    public static boolean directoriesContainSameContent(@NotNull File dir1, @NotNull File dir2, @Nullable FileFilter filter) throws IOException {
        if (dir1 == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(39);
        }
        if (dir2 == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(40);
        }
        if (dir1.exists() != dir2.exists()) {
            return false;
        }
        Object[] children1 = AndroidBuildCommonUtils.getFilteredChildren(dir1, filter);
        Object[] children2 = AndroidBuildCommonUtils.getFilteredChildren(dir2, filter);
        if (children1 == null || children2 == null) {
            return Arrays.equals(children1, children2);
        }
        if (children1.length != children2.length) {
            return false;
        }
        for (int i = 0; i < children1.length; ++i) {
            String content2;
            String content1;
            Object child1 = children1[i];
            Object child2 = children2[i];
            if (!Objects.equals(((File)child1).getName(), ((File)child2).getName())) {
                return false;
            }
            boolean childDir = ((File)child1).isDirectory();
            if (childDir != ((File)child2).isDirectory()) {
                return false;
            }
            if (!(childDir ? !AndroidBuildCommonUtils.directoriesContainSameContent((File)child1, (File)child2, filter) : !Objects.equals(content1 = AndroidBuildCommonUtils.readFile((File)child1), content2 = AndroidBuildCommonUtils.readFile((File)child2)))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static File[] getFilteredChildren(@NotNull File dir, @Nullable FileFilter filter) {
        File[] children;
        if (dir == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(41);
        }
        if ((children = dir.listFiles()) == null || children.length == 0 || filter == null) {
            return children;
        }
        ArrayList<File> result = new ArrayList<File>();
        for (File child : children) {
            if (!child.isDirectory() && !filter.accept(child)) continue;
            result.add(child);
        }
        return result.toArray(ArrayUtil.EMPTY_FILE_ARRAY);
    }

    @NotNull
    public static String addSuffixToFileName(@NotNull String path, @NotNull String suffix) {
        int dot;
        if (path == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(42);
        }
        if (suffix == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(43);
        }
        if ((dot = path.lastIndexOf(46)) < 0) {
            String string = path + suffix;
            if (string == null) {
                AndroidBuildCommonUtils.$$$reportNull$$$0(44);
            }
            return string;
        }
        String a = path.substring(0, dot);
        String b = path.substring(dot);
        String string = a + suffix + b;
        if (string == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(45);
        }
        return string;
    }

    public static void signApk(@NotNull File srcApk, @NotNull File destFile, @NotNull PrivateKey privateKey, @NotNull X509Certificate certificate) throws IOException {
        if (srcApk == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(46);
        }
        if (destFile == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(47);
        }
        if (privateKey == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(48);
        }
        if (certificate == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(49);
        }
        try (SafeSignedJarBuilder builder = new SafeSignedJarBuilder(privateKey, certificate, destFile.getPath());){
            builder.writeZip(srcApk, null);
        }
    }

    public static boolean hasXmxParam(@NotNull List<String> parameters) {
        if (parameters == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(50);
        }
        for (String param : parameters) {
            if (!param.startsWith("-Xmx")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String executeZipAlign(@NotNull String zipAlignPath, @NotNull File source, @NotNull File destination) {
        BaseOSProcessHandler handler;
        if (zipAlignPath == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(51);
        }
        if (source == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(52);
        }
        if (destination == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(53);
        }
        List<String> commandLine = Arrays.asList(zipAlignPath, "-f", "4", source.getAbsolutePath(), destination.getAbsolutePath());
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        try {
            handler = new BaseOSProcessHandler(processBuilder.start(), StringUtil.join(commandLine, (String)" "), null);
        }
        catch (IOException e) {
            return e.getMessage();
        }
        final StringBuilder builder = new StringBuilder();
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                builder.append(event.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/android/util/AndroidBuildCommonUtils$2";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        handler.startNotify();
        handler.waitFor();
        int exitCode = handler.getProcess().exitValue();
        return exitCode != 0 ? builder.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Map<AndroidCompilerMessageKind, List<String>> buildArtifact(@NotNull String artifactName, @NotNull String messagePrefix, @NotNull IAndroidTarget target, @Nullable String artifactFilePath, @NotNull String keyStorePath, @Nullable String keyAlias, @Nullable String keyStorePassword, @Nullable String keyPassword) throws GeneralSecurityException, IOException {
        if (artifactName == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(54);
        }
        if (messagePrefix == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(55);
        }
        if (target == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(56);
        }
        if (keyStorePath == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(57);
        }
        HashMap<AndroidCompilerMessageKind, List<String>> messages = new HashMap<AndroidCompilerMessageKind, List<String>>();
        messages.put(AndroidCompilerMessageKind.ERROR, new ArrayList());
        messages.put(AndroidCompilerMessageKind.WARNING, new ArrayList());
        messages.put(AndroidCompilerMessageKind.INFORMATION, new ArrayList());
        Pair<PrivateKey, X509Certificate> pair = AndroidBuildCommonUtils.getPrivateKeyAndCertificate(messagePrefix, messages, keyAlias, keyStorePath, keyStorePassword, keyPassword);
        if (pair == null) {
            HashMap<AndroidCompilerMessageKind, List<String>> hashMap = messages;
            if (hashMap == null) {
                AndroidBuildCommonUtils.$$$reportNull$$$0(58);
            }
            return hashMap;
        }
        String prefix = "Cannot sign artifact " + artifactName + ": ";
        if (artifactFilePath == null) {
            ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add(prefix + "output path is not specified");
            HashMap<AndroidCompilerMessageKind, List<String>> hashMap = messages;
            if (hashMap == null) {
                AndroidBuildCommonUtils.$$$reportNull$$$0(59);
            }
            return hashMap;
        }
        File artifactFile = new File(artifactFilePath);
        if (!artifactFile.exists()) {
            ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add(prefix + "file " + artifactFilePath + " hasn't been generated");
            HashMap<AndroidCompilerMessageKind, List<String>> hashMap = messages;
            if (hashMap == null) {
                AndroidBuildCommonUtils.$$$reportNull$$$0(60);
            }
            return hashMap;
        }
        String zipAlignPath = AndroidBuildCommonUtils.getZipAlign(target);
        File tmpDir = null;
        try {
            tmpDir = FileUtil.createTempDirectory((String)"android_artifact", (String)"tmp");
            File tmpArtifact = new File(tmpDir, "tmpArtifact.apk");
            AndroidBuildCommonUtils.signApk(artifactFile, tmpArtifact, (PrivateKey)pair.getFirst(), (X509Certificate)pair.getSecond());
            if (!FileUtil.delete((File)artifactFile)) {
                ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add("Cannot delete file " + artifactFile.getPath());
                HashMap<AndroidCompilerMessageKind, List<String>> hashMap = messages;
                HashMap<AndroidCompilerMessageKind, List<String>> hashMap2 = hashMap;
                if (hashMap2 == null) {
                    AndroidBuildCommonUtils.$$$reportNull$$$0(61);
                }
                return hashMap2;
            }
            if (zipAlignPath != null) {
                String errorMessage = AndroidBuildCommonUtils.executeZipAlign(zipAlignPath, tmpArtifact, artifactFile);
                if (errorMessage != null) {
                    ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add(messagePrefix + "zip-align: " + errorMessage);
                    HashMap<AndroidCompilerMessageKind, List<String>> hashMap = messages;
                    HashMap<AndroidCompilerMessageKind, List<String>> hashMap3 = hashMap;
                    if (hashMap3 == null) {
                        AndroidBuildCommonUtils.$$$reportNull$$$0(62);
                    }
                    return hashMap3;
                }
            } else {
                ((List)messages.get((Object)AndroidCompilerMessageKind.WARNING)).add(messagePrefix + AndroidCommonBundle.message("android.artifact.building.cannot.find.zip.align.error", new Object[0]));
                FileUtil.copy((File)tmpArtifact, (File)artifactFile);
            }
        }
        finally {
            if (tmpDir != null) {
                FileUtil.delete((File)tmpDir);
            }
        }
        HashMap<AndroidCompilerMessageKind, List<String>> hashMap = messages;
        if (hashMap == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(63);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Pair<PrivateKey, X509Certificate> getPrivateKeyAndCertificate(@NotNull String errorPrefix, @NotNull Map<AndroidCompilerMessageKind, List<String>> messages, @Nullable String keyAlias, @Nullable String keyStoreFilePath, @Nullable String keyStorePasswordStr, @Nullable String keyPasswordStr) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (errorPrefix == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(64);
        }
        if (messages == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(65);
        }
        if (keyStoreFilePath == null || keyStoreFilePath.isEmpty()) {
            messages.get((Object)AndroidCompilerMessageKind.ERROR).add(errorPrefix + "Key store file is not specified");
            return null;
        }
        if (keyStorePasswordStr == null) {
            messages.get((Object)AndroidCompilerMessageKind.ERROR).add(errorPrefix + "Key store password is not specified");
            return null;
        }
        if (keyAlias == null || keyAlias.isEmpty()) {
            messages.get((Object)AndroidCompilerMessageKind.ERROR).add(errorPrefix + "Key alias is not specified");
            return null;
        }
        if (keyPasswordStr == null) {
            messages.get((Object)AndroidCompilerMessageKind.ERROR).add(errorPrefix + "Key password is not specified");
            return null;
        }
        File keyStoreFile = new File(keyStoreFilePath);
        char[] keystorePassword = keyStorePasswordStr.toCharArray();
        char[] plainKeyPassword = keyPasswordStr.toCharArray();
        FileInputStream is = null;
        try {
            is = new FileInputStream(keyStoreFile);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(is, keystorePassword);
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyAlias, new KeyStore.PasswordProtection(plainKeyPassword));
            if (entry == null) {
                messages.get((Object)AndroidCompilerMessageKind.ERROR).add(errorPrefix + AndroidCommonBundle.message("android.artifact.building.cannot.find.key.error", keyAlias));
                Pair<PrivateKey, X509Certificate> pair = null;
                return pair;
            }
            PrivateKey privateKey = entry.getPrivateKey();
            Certificate certificate = entry.getCertificate();
            if (privateKey == null || certificate == null) {
                messages.get((Object)AndroidCompilerMessageKind.ERROR).add(errorPrefix + AndroidCommonBundle.message("android.artifact.building.cannot.find.key.error", keyAlias));
                Pair<PrivateKey, X509Certificate> pair = null;
                return pair;
            }
            Pair pair = Pair.create((Object)privateKey, (Object)((X509Certificate)certificate));
            return pair;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
    }

    @Nullable
    public static String getZipAlign(@NotNull IAndroidTarget target) {
        BuildToolInfo buildToolInfo;
        if (target == null) {
            AndroidBuildCommonUtils.$$$reportNull$$$0(66);
        }
        if ((buildToolInfo = target.getBuildToolInfo()) != null) {
            String path = null;
            try {
                path = buildToolInfo.getPath(BuildToolInfo.PathId.ZIP_ALIGN);
            }
            catch (Throwable ignored) {
                return null;
            }
            if (path != null && new File(path).exists()) {
                return path;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 29: 
            case 31: 
            case 38: 
            case 44: 
            case 45: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 29: 
            case 31: 
            case 38: 
            case 44: 
            case 45: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFiles";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFilePath";
                break;
            }
            case 9: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstPackageDirPaths";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFirstPackageDirPaths";
                break;
            }
            case 13: 
            case 29: 
            case 31: 
            case 38: 
            case 44: 
            case 45: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/util/AndroidBuildCommonUtils";
                break;
            }
            case 14: 
            case 18: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDirectory";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jar";
                break;
            }
            case 19: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: 
            case 56: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkOsPath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaExecutablePath";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proguardVmOptions";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputJarOsPath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputJarFileOsPath";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proguardConfigFileOsPaths";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalJarOsPaths";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providedJarOsPaths";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFilesDirOsPaths";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libClassFilesDirOsPaths";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolFileName";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkDirOsPath";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDirName";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir1";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir2";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcApk";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destFile";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "privateKey";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificate";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipAlignPath";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagePrefix";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStorePath";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/util/AndroidBuildCommonUtils";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "packClassFilesIntoJar";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "launchProguard";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getProguardHomeDirOsPath";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "readFile";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "addSuffixToFileName";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "buildArtifact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTestConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInstrumentationTestConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "command2string";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "moveAllFiles";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleDexCompilationResult";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "packClassFilesIntoJar";
                break;
            }
            case 13: 
            case 29: 
            case 31: 
            case 38: 
            case 44: 
            case 45: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "packIntoJar";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "launchProguard";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getProguardHomeDirOsPath";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "buildTempInputJar";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "platformToolPath";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageRevision";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "readFile";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "directoriesContainSameContent";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredChildren";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addSuffixToFileName";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "signApk";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "hasXmxParam";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "executeZipAlign";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "buildArtifact";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getPrivateKeyAndCertificate";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getZipAlign";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 29: 
            case 31: 
            case 38: 
            case 44: 
            case 45: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

