/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser.androidPlugin;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.ide.common.blame.parser.util.ParserUtil;
import com.android.utils.ILogger;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class DexExceptionParser
implements PatternAwareOutputParser {
    private static final Pattern ERROR = Pattern.compile("UNEXPECTED TOP-LEVEL EXCEPTION:");
    private static final Pattern ALREADY_ADDED_EXCEPTION = Pattern.compile("already added: L(.+);");

    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<Message> messages, @NotNull ILogger logger) throws ParsingFailedException {
        Matcher m1;
        if (line == null) {
            DexExceptionParser.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            DexExceptionParser.$$$reportNull$$$0(1);
        }
        if (messages == null) {
            DexExceptionParser.$$$reportNull$$$0(2);
        }
        if (logger == null) {
            DexExceptionParser.$$$reportNull$$$0(3);
        }
        if (!(m1 = ERROR.matcher(line)).matches()) {
            return false;
        }
        String stackTrace = ParserUtil.digestStackTrace((OutputLineReader)reader);
        if (stackTrace == null) {
            return false;
        }
        Matcher m2 = ALREADY_ADDED_EXCEPTION.matcher(stackTrace);
        if (!m2.matches()) {
            return false;
        }
        String message = String.format("Class %1s has already been added to output. Please remove duplicate copies.", m2.group(1).replace('/', '.').replace('$', '.'));
        messages.add(new Message(Message.Kind.ERROR, message, new SourceFilePosition(SourceFile.UNKNOWN, SourcePosition.UNKNOWN), new SourceFilePosition[0]));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "line";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "reader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "messages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "logger";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/gradle/output/parser/androidPlugin/DexExceptionParser";
        objectArray[2] = "parse";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

