/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.segments;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.annotations.NonNls;

public final class PushReader {
    private final Reader mySource;
    private final IntList myReadAhead = new IntArrayList();
    @NonNls
    private static final String INTERNAL_ERROR_UNEXPECTED_END_OF_PIPE = "Unexpected end of pipe";

    public PushReader(Reader source) {
        this.mySource = source;
    }

    public int next() throws IOException {
        return this.myReadAhead.isEmpty() ? this.mySource.read() : this.myReadAhead.removeInt(this.myReadAhead.size() - 1);
    }

    public void pushBack(char[] chars) {
        for (int i = chars.length - 1; i >= 0; --i) {
            char aChar = chars[i];
            this.myReadAhead.add((int)aChar);
        }
    }

    public void close() throws IOException {
        this.mySource.close();
    }

    public boolean ready() throws IOException {
        return !this.myReadAhead.isEmpty() || this.mySource.ready();
    }

    public void pushBack(int aChar) {
        this.myReadAhead.add(aChar);
    }

    public char[] next(int charCount) throws IOException {
        int offset;
        char[] chars = new char[charCount];
        for (offset = 0; offset < chars.length && offset < this.myReadAhead.size(); ++offset) {
            chars[offset] = (char)this.myReadAhead.removeInt(this.myReadAhead.size() - 1);
        }
        while (offset < chars.length) {
            int bytesRead = this.mySource.read(chars, offset, chars.length - offset);
            if (bytesRead == -1) {
                throw new IOException(INTERNAL_ERROR_UNEXPECTED_END_OF_PIPE);
            }
            offset += bytesRead;
        }
        return chars;
    }
}

