/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant;

import com.intellij.lang.ant.ForcedAntFileAttribute;
import com.intellij.lang.ant.dom.AntDomAntlib;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import org.jetbrains.annotations.Nullable;

public final class AntSupport {
    public static void markFileAsAntFile(VirtualFile file, Project project, boolean value) {
        if (file.isValid() && ForcedAntFileAttribute.isAntFile(file) != value) {
            ForcedAntFileAttribute.forceAntFile(file, value);
            TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), (Condition)project.getDisposed(), () -> PsiManager.getInstance((Project)project).dropPsiCaches());
        }
    }

    @Nullable
    public static AntDomProject getAntDomProject(PsiFile psiFile) {
        if (psiFile instanceof XmlFile) {
            DomManager domManager = DomManager.getDomManager((Project)psiFile.getProject());
            DomFileElement fileElement = domManager.getFileElement((XmlFile)psiFile, AntDomProject.class);
            return fileElement != null ? (AntDomProject)fileElement.getRootElement() : null;
        }
        return null;
    }

    @Nullable
    public static AntDomProject getAntDomProjectForceAntFile(PsiFile psiFile) {
        if (psiFile instanceof XmlFile) {
            DomManager domManager = DomManager.getDomManager((Project)psiFile.getProject());
            DomFileElement fileElement = domManager.getFileElement((XmlFile)psiFile, AntDomProject.class);
            if (fileElement == null) {
                ForcedAntFileAttribute.forceAntFile(psiFile.getVirtualFile(), true);
                fileElement = domManager.getFileElement((XmlFile)psiFile, AntDomProject.class);
            }
            return fileElement != null ? (AntDomProject)fileElement.getRootElement() : null;
        }
        return null;
    }

    @Nullable
    public static AntDomAntlib getAntLib(PsiFile psiFile) {
        if (psiFile instanceof XmlFile) {
            DomManager domManager = DomManager.getDomManager((Project)psiFile.getProject());
            DomFileElement fileElement = domManager.getFileElement((XmlFile)psiFile, AntDomAntlib.class);
            return fileElement != null ? (AntDomAntlib)fileElement.getRootElement() : null;
        }
        return null;
    }

    @Nullable
    public static AntDomElement getAntDomElement(XmlTag xmlTag) {
        DomElement domElement = DomManager.getDomManager((Project)xmlTag.getProject()).getDomElement(xmlTag);
        return domElement instanceof AntDomElement ? (AntDomElement)domElement : null;
    }

    @Nullable
    public static AntDomElement getInvocationAntDomElement(ConvertContext context) {
        return (AntDomElement)context.getInvocationElement().getParentOfType(AntDomElement.class, false);
    }
}

