/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.BytesSource;
import com.android.zipflinger.LargeFileSource;
import com.android.zipflinger.Source;
import com.android.zipflinger.StreamSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;

public class Sources {
    public static final int LARGE_LIMIT = 100000000;

    public static Source from(File file, String name, int compressionLevel) throws IOException {
        return Sources.from(file.toPath(), name, compressionLevel);
    }

    public static Source from(Path path2, String name, int compressionLevel) throws IOException {
        if (Files.size(path2) > 100000000L) {
            return new LargeFileSource(path2, name, compressionLevel);
        }
        return new BytesSource(path2, name, compressionLevel);
    }

    public static Source from(InputStream in, String name, int compressionLevel) throws IOException {
        return Sources.from(in, name, compressionLevel, 100000000);
    }

    public static Source from(InputStream in, String name, int compressionLevel, int largeLimit) throws IOException {
        return new StreamSource(in, name, compressionLevel, largeLimit);
    }
}

