/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.vmtrace.viz;

import com.android.tools.perflib.vmtrace.Call;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.perflib.vmtrace.MethodInfo;
import com.android.tools.perflib.vmtrace.ThreadInfo;
import com.android.tools.perflib.vmtrace.VmTraceData;
import com.android.tools.perflib.vmtrace.viz.RenderContext;
import com.android.tools.perflib.vmtrace.viz.TimeUtils;
import com.android.utils.HtmlBuilder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class CallHierarchyRenderer {
    private static final int PER_LEVEL_HEIGHT_PX = 10;
    private static final int PADDING = 1;
    private static final int TEXT_HEIGHT = 6;
    private static final int TEXT_LEFT_PADDING = 5;
    private final VmTraceData mTraceData;
    private final ThreadInfo mThread;
    private final Call mTopCall;
    private final int mYOffset;
    private final TimeUnit mLayoutTimeUnits;
    private final RenderContext mRenderContext;
    private final Rectangle2D mLayout = new Rectangle2D.Double();
    private final Point2D mTmpPoint1 = new Point2D.Double();
    private final Point2D mTmpPoint2 = new Point2D.Double();
    private Font mFont;
    private static final DecimalFormat PERCENTAGE_FORMATTER = new DecimalFormat("#.##");

    public CallHierarchyRenderer(VmTraceData vmTraceData, ThreadInfo thread, int yOffset, TimeUnit defaultTimeUnits, RenderContext renderContext) {
        this.mTraceData = vmTraceData;
        this.mThread = thread;
        this.mTopCall = thread.getTopLevelCall();
        this.mYOffset = yOffset;
        this.mLayoutTimeUnits = defaultTimeUnits;
        this.mRenderContext = renderContext;
    }

    public void render(Graphics2D g, AffineTransform viewPortTransform) {
        Rectangle clip = g.getClipBounds();
        Iterator<Call> it = this.mTopCall.getCallHierarchyIterator();
        while (it.hasNext()) {
            Call c = it.next();
            this.fillLayoutBounds(c, this.mLayout);
            this.transformRect(viewPortTransform, this.mLayout);
            if (!clip.intersects(this.mLayout) || this.mLayout.getWidth() < 1.0) continue;
            Color fillColor = this.mRenderContext.getFillColor(c, this.mThread);
            g.setColor(fillColor);
            g.fill(this.mLayout);
            String name = this.getName(c);
            this.drawString(g, name, this.mLayout, this.mRenderContext.getFontColor(c, this.mThread));
        }
    }

    private Rectangle2D transformRect(AffineTransform viewPortTransform, Rectangle2D rect) {
        this.mTmpPoint1.setLocation(rect.getX(), rect.getY());
        this.mTmpPoint2.setLocation(rect.getWidth(), rect.getHeight());
        viewPortTransform.transform(this.mTmpPoint1, this.mTmpPoint1);
        viewPortTransform.deltaTransform(this.mTmpPoint2, this.mTmpPoint2);
        rect.setRect(this.mTmpPoint1.getX(), this.mTmpPoint1.getY(), this.mTmpPoint2.getX(), this.mTmpPoint2.getY());
        return rect;
    }

    private void drawString(Graphics2D g, String name, Rectangle2D bounds, Color fontColor) {
        if (this.mFont == null) {
            this.mFont = g.getFont().deriveFont(8.0f);
        }
        g.setFont(this.mFont);
        g.setColor(fontColor);
        AffineTransform origTx = g.getTransform();
        this.mTmpPoint1.setLocation(bounds.getX() + 5.0, bounds.getY() + 6.0);
        double availableWidth = g.getTransform().getScaleX() * bounds.getWidth();
        origTx.transform(this.mTmpPoint1, this.mTmpPoint1);
        g.setTransform(new AffineTransform());
        double stringWidth = g.getFontMetrics().stringWidth(name);
        if (availableWidth > stringWidth) {
            g.drawString(name, (float)this.mTmpPoint1.getX(), (float)this.mTmpPoint1.getY());
        }
        g.setTransform(origTx);
    }

    private void fillLayoutBounds(Call c, Rectangle2D layoutBounds) {
        ClockType renderClock = this.mRenderContext.getRenderClock();
        double x = c.getEntryTime(renderClock, this.mLayoutTimeUnits) - this.mTopCall.getEntryTime(renderClock, this.mLayoutTimeUnits) + 1L;
        double y = c.getDepth() * 10 + this.mYOffset + 1;
        double width = c.getInclusiveTime(renderClock, this.mLayoutTimeUnits) - 2L;
        double height = 8.0;
        layoutBounds.setRect(x, y, width, height);
    }

    public String getToolTipFor(double x, double y) {
        Iterator<Call> it = this.mTopCall.getCallHierarchyIterator();
        while (it.hasNext()) {
            Call c = it.next();
            this.fillLayoutBounds(c, this.mLayout);
            if (!this.mLayout.contains(x, y)) continue;
            return this.formatToolTip(c);
        }
        return null;
    }

    private String formatToolTip(Call c) {
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        htmlBuilder.openHtmlBody();
        htmlBuilder.addHeading(this.getMethodInfo(c).getFullName(), "black");
        long span = c.getExitTime(ClockType.GLOBAL, TimeUnit.NANOSECONDS) - c.getEntryTime(ClockType.GLOBAL, TimeUnit.NANOSECONDS);
        TimeUnit unit = TimeUnit.NANOSECONDS;
        String entryGlobal = TimeUtils.makeHumanReadable(c.getEntryTime(ClockType.GLOBAL, unit), span, unit);
        String entryThread = TimeUtils.makeHumanReadable(c.getEntryTime(ClockType.THREAD, unit), span, unit);
        String exitGlobal = TimeUtils.makeHumanReadable(c.getExitTime(ClockType.GLOBAL, unit), span, unit);
        String exitThread = TimeUtils.makeHumanReadable(c.getExitTime(ClockType.THREAD, unit), span, unit);
        String durationGlobal = TimeUtils.makeHumanReadable(c.getExitTime(ClockType.GLOBAL, unit) - c.getEntryTime(ClockType.GLOBAL, unit), span, unit);
        String durationThread = TimeUtils.makeHumanReadable(c.getExitTime(ClockType.THREAD, unit) - c.getEntryTime(ClockType.THREAD, unit), span, unit);
        htmlBuilder.beginTable();
        htmlBuilder.addTableRow(new String[]{"Wallclock Time:", durationGlobal, String.format("(from %s to %s)", entryGlobal, exitGlobal)});
        htmlBuilder.addTableRow(new String[]{"CPU Time:", durationThread, String.format("(from %s to %s)", entryThread, exitThread)});
        htmlBuilder.endTable();
        htmlBuilder.newline();
        htmlBuilder.add("Inclusive Time: ");
        htmlBuilder.beginBold();
        double inclusivePercentage = this.mTraceData.getDurationPercentage(c, this.mThread, this.mRenderContext.getRenderClock(), true);
        htmlBuilder.add(PERCENTAGE_FORMATTER.format(inclusivePercentage));
        htmlBuilder.add("%");
        htmlBuilder.endBold();
        htmlBuilder.newline();
        htmlBuilder.add("Exclusive Time: ");
        htmlBuilder.beginBold();
        double exclusivePercentage = this.mTraceData.getDurationPercentage(c, this.mThread, this.mRenderContext.getRenderClock(), false);
        htmlBuilder.add(PERCENTAGE_FORMATTER.format(exclusivePercentage));
        htmlBuilder.add("%");
        htmlBuilder.endBold();
        htmlBuilder.closeHtmlBody();
        return htmlBuilder.getHtml();
    }

    private String getName(Call c) {
        return this.getMethodInfo(c).getShortName();
    }

    private MethodInfo getMethodInfo(Call c) {
        long methodId = c.getMethodId();
        return this.mTraceData.getMethod(methodId);
    }
}

