/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.memoryanalyzer;

import com.android.ddmlib.BitmapDecoder;
import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Type;
import java.awt.Dimension;

public class HprofBitmapProvider
implements BitmapDecoder.BitmapDataProvider {
    private ArrayInstance mBuffer = null;
    private boolean mMutable = false;
    private int mWidth = -1;
    private int mHeight = -1;

    public HprofBitmapProvider(Instance instance) {
        ClassInstance resolvedInstance = HprofBitmapProvider.getBitmapClassInstance(instance);
        if (resolvedInstance == null) {
            throw new RuntimeException("Can not resolve Bitmap instance");
        }
        Integer width = null;
        Integer height = null;
        Boolean mutable = null;
        for (ClassInstance.FieldValue field : resolvedInstance.getValues()) {
            Object bitmapValue = field.getValue();
            String bitmapFieldName = field.getField().getName();
            if ("mBuffer".equals(bitmapFieldName) && bitmapValue instanceof ArrayInstance) {
                ArrayInstance arrayInstance = (ArrayInstance)bitmapValue;
                if (arrayInstance.getArrayType() != Type.BYTE) continue;
                this.mBuffer = arrayInstance;
                continue;
            }
            if ("mIsMutable".equals(bitmapFieldName) && bitmapValue instanceof Boolean) {
                mutable = (Boolean)bitmapValue;
                continue;
            }
            if ("mWidth".equals(bitmapFieldName) && bitmapValue instanceof Integer) {
                width = (Integer)bitmapValue;
                continue;
            }
            if (!"mHeight".equals(bitmapFieldName) || !(bitmapValue instanceof Integer)) continue;
            height = (Integer)bitmapValue;
        }
        if (this.mBuffer == null || this.mBuffer.getArrayType() != Type.BYTE || mutable == null || width == null || height == null) {
            throw new RuntimeException("Unable to resolve bitmap instance member variables");
        }
        this.mMutable = mutable;
        this.mWidth = width;
        this.mHeight = height;
    }

    public static boolean canGetBitmapFromInstance(Instance value) {
        if (!(value instanceof ClassInstance)) {
            return false;
        }
        String className = value.getClassObj().getClassName();
        return "android.graphics.Bitmap".equals(className) || "android.graphics.drawable.BitmapDrawable".equals(className);
    }

    @Override
    public String getBitmapConfigName() throws Exception {
        int area = this.mWidth * this.mHeight;
        int pixelSize = this.mBuffer.getLength() / area;
        if (!this.mMutable && this.mBuffer.getLength() % area != 0 || this.mMutable && area > this.mBuffer.getLength()) {
            return null;
        }
        switch (pixelSize) {
            case 4: {
                return "\"ARGB_8888\"";
            }
            case 2: {
                return "\"RGB_565\"";
            }
        }
        return "\"ALPHA_8\"";
    }

    @Override
    public Dimension getDimension() throws Exception {
        return this.mWidth < 0 || this.mHeight < 0 ? null : new Dimension(this.mWidth, this.mHeight);
    }

    @Override
    public boolean downsizeBitmap(Dimension newSize) throws Exception {
        return true;
    }

    @Override
    public byte[] getPixelBytes(Dimension size) throws Exception {
        return this.mBuffer.asRawByteArray(0, this.mBuffer.getLength());
    }

    private static ClassInstance getBitmapClassInstance(Instance instance) {
        if (!(instance instanceof ClassInstance)) {
            return null;
        }
        ClassInstance selectedObject = (ClassInstance)instance;
        String className = instance.getClassObj().getClassName();
        if ("android.graphics.Bitmap".equals(className)) {
            return selectedObject;
        }
        if ("android.graphics.drawable.BitmapDrawable".equals(className)) {
            return HprofBitmapProvider.getBitmapFromDrawable(selectedObject);
        }
        return null;
    }

    private static ClassInstance getBitmapFromDrawable(ClassInstance instance) {
        ClassInstance bitmapState = HprofBitmapProvider.getBitmapStateFromBitmapDrawable(instance);
        if (bitmapState == null) {
            return null;
        }
        for (ClassInstance.FieldValue fieldValue : bitmapState.getValues()) {
            ClassInstance result;
            String className;
            Field field = fieldValue.getField();
            Object value = fieldValue.getValue();
            if (!"mBitmap".equals(field.getName()) || !(value instanceof ClassInstance) || !"android.graphics.Bitmap".equals(className = (result = (ClassInstance)value).getClassObj().getClassName())) continue;
            return (ClassInstance)value;
        }
        return null;
    }

    private static ClassInstance getBitmapStateFromBitmapDrawable(ClassInstance bitmapDrawable) {
        for (ClassInstance.FieldValue field : bitmapDrawable.getValues()) {
            ClassInstance result;
            String className;
            String fieldName = field.getField().getName();
            Object fieldValue = field.getValue();
            if (!"mBitmapState".equals(fieldName) || !(fieldValue instanceof ClassInstance) || !"android.graphics.drawable.BitmapDrawable$BitmapState".equals(className = (result = (ClassInstance)fieldValue).getClassObj().getClassName())) continue;
            return result;
        }
        return null;
    }
}

