/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.analysis;

import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.analysis.ComputationProgress;
import com.google.common.collect.Lists;
import gnu.trove.TObjectProcedure;
import java.util.List;

public abstract class DominatorsBase {
    protected volatile ComputationProgress mCurrentProgress = new ComputationProgress("Starting dominator computation", 0.0);
    protected Snapshot mSnapshot;
    protected List<Instance> mTopSort;

    protected DominatorsBase(Snapshot snapshot) {
        this.mSnapshot = snapshot;
        assert (this.mSnapshot.getTopologicalOrdering() != null);
        this.mTopSort = this.mSnapshot.getTopologicalOrdering();
        for (Heap heap : this.mSnapshot.getHeaps()) {
            for (Instance instance : heap.getClasses()) {
                instance.resetRetainedSize();
            }
            heap.forEachInstance(new TObjectProcedure<Instance>(){

                public boolean execute(Instance instance) {
                    instance.resetRetainedSize();
                    return true;
                }
            });
        }
    }

    public void dispose() {
        this.mSnapshot = null;
    }

    public abstract ComputationProgress getComputationProgress();

    public abstract void computeDominators();

    public void computeRetainedSizes() {
        for (Instance node : Lists.reverse(this.mSnapshot.getReachableInstances())) {
            Instance dom = node.getImmediateDominator();
            if (dom == Snapshot.SENTINEL_ROOT) continue;
            dom.addRetainedSizes(node);
        }
    }
}

