/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.Visitor;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ClassInstance
extends Instance {
    private final long mValuesOffset;

    public ClassInstance(long id, StackTrace stack, long valuesOffset) {
        super(id, stack);
        this.mValuesOffset = valuesOffset;
    }

    List<FieldValue> getFields(String name) {
        ArrayList<FieldValue> result = new ArrayList<FieldValue>();
        for (FieldValue value : this.getValues()) {
            if (!value.getField().getName().equals(name)) continue;
            result.add(value);
        }
        return result;
    }

    public List<FieldValue> getValues() {
        ArrayList<FieldValue> result = new ArrayList<FieldValue>();
        this.getBuffer().setPosition(this.mValuesOffset);
        for (ClassObj clazz = this.getClassObj(); clazz != null; clazz = clazz.getSuperClassObj()) {
            for (Field field : clazz.getFields()) {
                result.add(new FieldValue(field, this.readValue(field.getType())));
            }
        }
        return result;
    }

    @Override
    public final void resolveReferences() {
        for (FieldValue fieldValue : this.getValues()) {
            if (!(fieldValue.getValue() instanceof Instance)) continue;
            Instance referencedInstance = (Instance)fieldValue.getValue();
            referencedInstance.addReverseReference(fieldValue.getField(), this);
            if (this.getIsSoftReference() && fieldValue.getField().getName().equals("referent")) {
                this.mSoftForwardReference = referencedInstance;
                continue;
            }
            this.mHardForwardReferences.add(referencedInstance);
        }
        this.mHardForwardReferences.trimToSize();
    }

    @Override
    public final void accept(Visitor visitor2) {
        visitor2.visitClassInstance(this);
        for (Instance instance : this.mHardForwardReferences) {
            visitor2.visitLater(this, instance);
        }
    }

    @Override
    public boolean getIsSoftReference() {
        return this.getClassObj().getIsSoftReference();
    }

    public final String toString() {
        return String.format("%s@%d (0x%x)", this.getClassObj().getClassName(), this.getUniqueId(), this.getUniqueId());
    }

    public boolean isStringInstance() {
        return this.getClassObj() != null && "java.lang.String".equals(this.getClassObj().getClassName());
    }

    public final String getAsString() {
        return this.getAsString(Integer.MAX_VALUE);
    }

    public final String getAsString(int maxDecodeStringLength) {
        int count = -1;
        int offset = 0;
        ArrayInstance charBufferArray = null;
        ArrayInstance byteBufferArray = null;
        for (FieldValue entry : this.getValues()) {
            if (charBufferArray == null && "value".equals(entry.getField().getName())) {
                if (!(entry.getValue() instanceof ArrayInstance)) continue;
                if (((ArrayInstance)entry.getValue()).getArrayType() == Type.CHAR) {
                    charBufferArray = (ArrayInstance)entry.getValue();
                    continue;
                }
                if (((ArrayInstance)entry.getValue()).getArrayType() != Type.BYTE) continue;
                byteBufferArray = (ArrayInstance)entry.getValue();
                continue;
            }
            if ("count".equals(entry.getField().getName())) {
                if (!(entry.getValue() instanceof Integer)) continue;
                count = (Integer)entry.getValue();
                continue;
            }
            if (!"offset".equals(entry.getField().getName()) || !(entry.getValue() instanceof Integer)) continue;
            offset = (Integer)entry.getValue();
        }
        if (byteBufferArray != null) {
            try {
                return new String(byteBufferArray.asRawByteArray(offset >= 0 ? offset : 0, Math.max(Math.min(count, maxDecodeStringLength), 0)), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return charBufferArray == null ? null : new String(charBufferArray.asCharArray(offset >= 0 ? offset : 0, Math.max(Math.min(count, maxDecodeStringLength), 0)));
    }

    public static class FieldValue {
        private Field mField;
        private Object mValue;

        public FieldValue(Field field, Object value) {
            this.mField = field;
            this.mValue = value;
        }

        public Field getField() {
            return this.mField;
        }

        public Object getValue() {
            return this.mValue;
        }
    }
}

