/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.mlkit;

import com.android.tools.mlkit.DataInputOutputUtils;
import com.android.tools.mlkit.MlNames;
import com.google.common.base.Strings;
import com.google.flatbuffers.Table;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.tensorflow.lite.support.metadata.MetadataExtractor;
import org.tensorflow.lite.support.metadata.schema.AssociatedFile;
import org.tensorflow.lite.support.metadata.schema.Content;
import org.tensorflow.lite.support.metadata.schema.ModelMetadata;
import org.tensorflow.lite.support.metadata.schema.NormalizationOptions;
import org.tensorflow.lite.support.metadata.schema.ProcessUnit;
import org.tensorflow.lite.support.metadata.schema.Stats;
import org.tensorflow.lite.support.metadata.schema.TensorMetadata;

public class TensorInfo {
    private static final String DEFAULT_INPUT_NAME = "inputFeature";
    private static final String DEFAULT_OUTPUT_NAME = "outputFeature";
    private final Source source;
    private final int index;
    private final DataType dataType;
    private final int[] shape;
    private final QuantizationParams quantizationParams;
    private final boolean metadataExisted;
    private final String name;
    private final String identifierName;
    private final String description;
    private final ContentType contentType;
    private final ContentRange contentRange;
    private final String fileName;
    private final FileType fileType;
    private final NormalizationParams normalizationParams;
    private final ImageProperties imageProperties;
    private final BoundingBoxProperties boundingBoxProperties;

    public TensorInfo(Source source, int index, DataType dataType, int[] shape, QuantizationParams quantizationParams, boolean metadataExisted, String name, String description, ContentType contentType, ContentRange contentRange, String fileName, FileType fileType, NormalizationParams normalizationParams, ImageProperties imageProperties, BoundingBoxProperties boundingBoxProperties) {
        this.source = source;
        this.index = index;
        this.dataType = dataType;
        this.shape = shape;
        this.quantizationParams = quantizationParams;
        this.metadataExisted = metadataExisted;
        this.name = name;
        this.description = description;
        this.contentType = contentType;
        this.contentRange = contentRange;
        this.fileName = fileName;
        this.fileType = fileType;
        this.normalizationParams = normalizationParams;
        this.imageProperties = imageProperties;
        this.boundingBoxProperties = boundingBoxProperties;
        this.identifierName = MlNames.computeIdentifierName(name, TensorInfo.getDefaultName(source, index));
    }

    public TensorInfo(DataInput in) throws IOException {
        this.source = Source.fromByte(in.readByte());
        this.index = in.readInt();
        this.dataType = DataType.fromByte(in.readByte());
        this.shape = DataInputOutputUtils.readIntArray(in);
        this.quantizationParams = new QuantizationParams(in);
        this.metadataExisted = in.readBoolean();
        this.name = in.readUTF();
        this.description = in.readUTF();
        this.contentType = ContentType.fromByte(in.readByte());
        this.contentRange = new ContentRange(in);
        this.fileName = in.readUTF();
        this.fileType = FileType.fromByte(in.readByte());
        this.normalizationParams = new NormalizationParams(in);
        this.imageProperties = in.readBoolean() ? new ImageProperties(in) : null;
        this.boundingBoxProperties = in.readBoolean() ? new BoundingBoxProperties(in) : null;
        this.identifierName = MlNames.computeIdentifierName(this.name, TensorInfo.getDefaultName(this.source, this.index));
    }

    public void save(DataOutput out) throws IOException {
        out.write(this.source.id);
        out.writeInt(this.index);
        out.write(this.dataType.id);
        DataInputOutputUtils.writeIntArray(out, this.shape);
        this.quantizationParams.save(out);
        out.writeBoolean(this.metadataExisted);
        out.writeUTF(this.name);
        out.writeUTF(this.description);
        out.write(this.contentType.id);
        this.contentRange.save(out);
        out.writeUTF(this.fileName);
        out.write(this.fileType.id);
        this.normalizationParams.save(out);
        out.writeBoolean(this.imageProperties != null);
        if (this.imageProperties != null) {
            this.imageProperties.save(out);
        }
        out.writeBoolean(this.boundingBoxProperties != null);
        if (this.boundingBoxProperties != null) {
            this.boundingBoxProperties.save(out);
        }
    }

    public Source getSource() {
        return this.source;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int[] getShape() {
        return this.shape;
    }

    public QuantizationParams getQuantizationParams() {
        return this.quantizationParams;
    }

    public boolean isMetadataExisted() {
        return this.metadataExisted;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifierName() {
        return this.identifierName;
    }

    public String getDescription() {
        return this.description;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public ContentRange getContentRange() {
        return this.contentRange;
    }

    public String getFileName() {
        return this.fileName;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public NormalizationParams getNormalizationParams() {
        return this.normalizationParams;
    }

    public ImageProperties getImageProperties() {
        return this.imageProperties;
    }

    public BoundingBoxProperties getBoundingBoxProperties() {
        return this.boundingBoxProperties;
    }

    public boolean isRGBImage() {
        return this.imageProperties != null && this.imageProperties.colorSpaceType == ImageProperties.ColorSpaceType.RGB;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TensorInfo that = (TensorInfo)o;
        return this.index == that.index && this.source == that.source && this.dataType == that.dataType && Arrays.equals(this.shape, that.shape) && Objects.equals(this.quantizationParams, that.quantizationParams) && this.metadataExisted == that.metadataExisted && this.name.equals(that.name) && this.description.equals(that.description) && this.contentType == that.contentType && Objects.equals(this.contentRange, that.contentRange) && this.fileName.equals(that.fileName) && this.fileType == that.fileType && Objects.equals(this.normalizationParams, that.normalizationParams) && Objects.equals(this.imageProperties, that.imageProperties) && Objects.equals(this.boundingBoxProperties, that.boundingBoxProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.index, this.dataType, this.metadataExisted, this.name, this.description});
    }

    public static TensorInfo parseFrom(MetadataExtractor extractor, Source source, int index) {
        ModelMetadata metadata;
        MetadataExtractor.QuantizationParams params;
        Builder builder = new Builder();
        builder.setSource(source).setIndex(index);
        if (source == Source.INPUT) {
            params = extractor.getInputTensorQuantizationParams(index);
            builder.setDataType(DataType.fromByte(extractor.getInputTensorType(index))).setShape(extractor.getInputTensorShape(index)).setQuantizationParams(new QuantizationParams(params.getScale(), params.getZeroPoint()));
        } else {
            params = extractor.getOutputTensorQuantizationParams(index);
            builder.setDataType(DataType.fromByte(extractor.getOutputTensorType(index))).setShape(extractor.getOutputTensorShape(index)).setQuantizationParams(new QuantizationParams(params.getScale(), params.getZeroPoint()));
        }
        ModelMetadata modelMetadata = metadata = extractor.hasMetadata() ? extractor.getModelMetadata() : null;
        if (metadata == null) {
            builder.setMetadataExisted(false);
        } else if (!extractor.isMinimumParserVersionSatisfied()) {
            builder.setMetadataExisted(true);
            TensorMetadata tensorMetadata = source == Source.INPUT ? metadata.subgraphMetadata(0).inputTensorMetadata(index) : metadata.subgraphMetadata(0).outputTensorMetadata(index);
            builder.setName(Strings.nullToEmpty((String)tensorMetadata.name()));
            builder.setNormalizationParams(TensorInfo.extractNormalizationParams(tensorMetadata));
        } else {
            AssociatedFile file;
            builder.setMetadataExisted(true);
            TensorMetadata tensorMetadata = source == Source.INPUT ? metadata.subgraphMetadata(0).inputTensorMetadata(index) : metadata.subgraphMetadata(0).outputTensorMetadata(index);
            builder.setName(Strings.nullToEmpty((String)tensorMetadata.name())).setDescription(Strings.nullToEmpty((String)tensorMetadata.description())).setContentType(TensorInfo.extractContentType(tensorMetadata));
            Content content = tensorMetadata.content();
            if (content != null && content.range() != null) {
                builder.setContentRange(new ContentRange(content.range().min(), content.range().max()));
            }
            if ((file = TensorInfo.getPreferredAssociatedFile(tensorMetadata)) != null) {
                builder.setFileName(Strings.nullToEmpty((String)file.name())).setFileType(FileType.fromByte(file.type()));
            }
            if (builder.contentType == ContentType.IMAGE) {
                org.tensorflow.lite.support.metadata.schema.ImageProperties properties = (org.tensorflow.lite.support.metadata.schema.ImageProperties)tensorMetadata.content().contentProperties((Table)new org.tensorflow.lite.support.metadata.schema.ImageProperties());
                builder.setImageProperties(new ImageProperties(ImageProperties.ColorSpaceType.fromByte(properties.colorSpace())));
            } else if (builder.contentType == ContentType.BOUNDING_BOX) {
                org.tensorflow.lite.support.metadata.schema.BoundingBoxProperties properties = (org.tensorflow.lite.support.metadata.schema.BoundingBoxProperties)tensorMetadata.content().contentProperties((Table)new org.tensorflow.lite.support.metadata.schema.BoundingBoxProperties());
                builder.setBoundingBoxProperties(new BoundingBoxProperties(BoundingBoxProperties.Type.fromByte(properties.type()), BoundingBoxProperties.CoordinateType.fromByte(properties.coordinateType()), properties.indexAsByteBuffer().asIntBuffer()));
            }
            builder.setNormalizationParams(TensorInfo.extractNormalizationParams(tensorMetadata));
        }
        return builder.build();
    }

    private static FloatBuffer toFloatBuffer(float value) {
        return FloatBuffer.wrap(new float[]{value});
    }

    private static String getDefaultName(Source source, int index) {
        return (source == Source.INPUT ? DEFAULT_INPUT_NAME : DEFAULT_OUTPUT_NAME) + index;
    }

    private static AssociatedFile getPreferredAssociatedFile(TensorMetadata tensorMetadata) {
        AssociatedFile defaultFile = tensorMetadata.associatedFiles(0);
        int length = tensorMetadata.associatedFilesLength();
        for (int i = 0; i < length; ++i) {
            AssociatedFile associatedFile = tensorMetadata.associatedFiles(i);
            String localeTag = associatedFile.locale();
            if (localeTag == null) continue;
            if (Locale.ENGLISH.equals(Locale.forLanguageTag(localeTag))) {
                return associatedFile;
            }
            defaultFile = associatedFile;
        }
        return defaultFile;
    }

    public static ContentType extractContentType(TensorMetadata tensorMetadata) {
        Content content = tensorMetadata.content();
        if (content == null) {
            return ContentType.UNKNOWN;
        }
        byte type = content.contentPropertiesType();
        if (type == 2) {
            return ContentType.IMAGE;
        }
        if (type == 1) {
            return ContentType.FEATURE;
        }
        if (type == 3) {
            return ContentType.BOUNDING_BOX;
        }
        return ContentType.UNKNOWN;
    }

    private static NormalizationOptions extractNormalizationOptions(TensorMetadata tensorMetadata) {
        for (int i = 0; i < tensorMetadata.processUnitsLength(); ++i) {
            ProcessUnit unit = tensorMetadata.processUnits(i);
            if (unit.optionsType() != 1) continue;
            return (NormalizationOptions)unit.options((Table)new NormalizationOptions());
        }
        return null;
    }

    private static NormalizationParams extractNormalizationParams(TensorMetadata tensorMetadata) {
        NormalizationOptions normalizationOptions = TensorInfo.extractNormalizationOptions(tensorMetadata);
        FloatBuffer mean = normalizationOptions != null && normalizationOptions.meanAsByteBuffer() != null ? normalizationOptions.meanAsByteBuffer().asFloatBuffer() : TensorInfo.toFloatBuffer(0.0f);
        FloatBuffer std = normalizationOptions != null && normalizationOptions.stdAsByteBuffer() != null ? normalizationOptions.stdAsByteBuffer().asFloatBuffer() : TensorInfo.toFloatBuffer(1.0f);
        Stats stats = tensorMetadata.stats();
        FloatBuffer min = stats != null && stats.minAsByteBuffer() != null ? tensorMetadata.stats().minAsByteBuffer().asFloatBuffer() : TensorInfo.toFloatBuffer(Float.MIN_VALUE);
        FloatBuffer max = stats != null && stats.maxAsByteBuffer() != null ? tensorMetadata.stats().maxAsByteBuffer().asFloatBuffer() : TensorInfo.toFloatBuffer(Float.MAX_VALUE);
        return new NormalizationParams(mean, std, min, max);
    }

    public static class QuantizationParams {
        private final float scale;
        private final long zeroPoint;

        public QuantizationParams(float scale, long zeroPoint) {
            this.scale = scale;
            this.zeroPoint = zeroPoint;
        }

        public QuantizationParams(DataInput in) throws IOException {
            this.scale = in.readFloat();
            this.zeroPoint = in.readLong();
        }

        public void save(DataOutput out) throws IOException {
            out.writeFloat(this.scale);
            out.writeLong(this.zeroPoint);
        }

        public float getScale() {
            return this.scale;
        }

        public long getZeroPoint() {
            return this.zeroPoint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QuantizationParams that = (QuantizationParams)o;
            return Float.compare(this.scale, that.scale) == 0 && this.zeroPoint == that.zeroPoint;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.scale), this.zeroPoint);
        }
    }

    public static class NormalizationParams {
        private final float[] mean;
        private final float[] std;
        private final float[] min;
        private final float[] max;

        public NormalizationParams(FloatBuffer meanBuffer, FloatBuffer stdBuffer, FloatBuffer minBuffer, FloatBuffer maxBuffer) {
            this.mean = new float[meanBuffer.limit()];
            meanBuffer.get(this.mean);
            this.std = new float[stdBuffer.limit()];
            stdBuffer.get(this.std);
            this.min = new float[minBuffer.limit()];
            minBuffer.get(this.min);
            this.max = new float[maxBuffer.limit()];
            maxBuffer.get(this.max);
        }

        public NormalizationParams(DataInput in) throws IOException {
            this.mean = DataInputOutputUtils.readFloatArray(in);
            this.std = DataInputOutputUtils.readFloatArray(in);
            this.min = DataInputOutputUtils.readFloatArray(in);
            this.max = DataInputOutputUtils.readFloatArray(in);
        }

        public void save(DataOutput out) throws IOException {
            DataInputOutputUtils.writeFloatArray(out, this.mean);
            DataInputOutputUtils.writeFloatArray(out, this.std);
            DataInputOutputUtils.writeFloatArray(out, this.min);
            DataInputOutputUtils.writeFloatArray(out, this.max);
        }

        public float[] getMean() {
            return this.mean;
        }

        public float[] getStd() {
            return this.std;
        }

        public float[] getMin() {
            return this.min;
        }

        public float[] getMax() {
            return this.max;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NormalizationParams that = (NormalizationParams)o;
            return Arrays.equals(this.mean, that.mean) && Arrays.equals(this.std, that.std) && Arrays.equals(this.min, that.min) && Arrays.equals(this.max, that.max);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.mean);
            result = 31 * result + Arrays.hashCode(this.std);
            result = 31 * result + Arrays.hashCode(this.min);
            result = 31 * result + Arrays.hashCode(this.max);
            return result;
        }
    }

    public static class ContentRange {
        public final int min;
        public final int max;

        public ContentRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public ContentRange(DataInput in) throws IOException {
            this.min = in.readInt();
            this.max = in.readInt();
        }

        public void save(DataOutput out) throws IOException {
            out.writeInt(this.min);
            out.writeInt(this.max);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContentRange that = (ContentRange)o;
            return this.min == that.min && this.max == that.max;
        }

        public int hashCode() {
            return Objects.hash(this.min, this.max);
        }
    }

    public static class BoundingBoxProperties {
        public final Type type;
        public final CoordinateType coordinateType;
        public final int[] index;

        public BoundingBoxProperties(Type type, CoordinateType coordinateType, IntBuffer indexBuffer) {
            this.type = type;
            this.coordinateType = coordinateType;
            this.index = new int[indexBuffer.remaining()];
            indexBuffer.get(this.index);
        }

        public BoundingBoxProperties(DataInput in) throws IOException {
            this.type = Type.fromByte(in.readByte());
            this.coordinateType = CoordinateType.fromByte(in.readByte());
            this.index = DataInputOutputUtils.readIntArray(in);
        }

        public void save(DataOutput out) throws IOException {
            out.write(this.type.id);
            out.write(this.coordinateType.id);
            DataInputOutputUtils.writeIntArray(out, this.index);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoundingBoxProperties that = (BoundingBoxProperties)o;
            return this.type == that.type && this.coordinateType == that.coordinateType && Arrays.equals(this.index, that.index);
        }

        public int hashCode() {
            int result = Objects.hash(new Object[]{this.type, this.coordinateType});
            result = 31 * result + Arrays.hashCode(this.index);
            return result;
        }

        public static enum CoordinateType {
            UNKNOWN(-1),
            RATIO(0),
            PIXEL(1);

            private final int id;

            private CoordinateType(int id) {
                this.id = id;
            }

            public static CoordinateType fromByte(byte id) {
                for (CoordinateType type : CoordinateType.values()) {
                    if (type.id != id) continue;
                    return type;
                }
                return UNKNOWN;
            }
        }

        public static enum Type {
            UNKNOWN(0),
            BOUNDARIES(1),
            UPPER_LEFT(2),
            CENTER(3);

            private final int id;

            private Type(int id) {
                this.id = id;
            }

            public static Type fromByte(byte id) {
                for (Type type : Type.values()) {
                    if (type.id != id) continue;
                    return type;
                }
                return UNKNOWN;
            }
        }
    }

    public static class ImageProperties {
        public final ColorSpaceType colorSpaceType;

        public ImageProperties(ColorSpaceType colorSpaceType) {
            this.colorSpaceType = colorSpaceType;
        }

        public ImageProperties(DataInput in) throws IOException {
            this.colorSpaceType = ColorSpaceType.fromByte(in.readByte());
        }

        public void save(DataOutput out) throws IOException {
            out.write(this.colorSpaceType.id);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageProperties that = (ImageProperties)o;
            return this.colorSpaceType == that.colorSpaceType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.colorSpaceType});
        }

        public static enum ColorSpaceType {
            UNKNOWN(0),
            RGB(1),
            GRAYSCALE(2);

            private final int id;

            private ColorSpaceType(int id) {
                this.id = id;
            }

            public static ColorSpaceType fromByte(byte id) {
                for (ColorSpaceType type : ColorSpaceType.values()) {
                    if (type.id != id) continue;
                    return type;
                }
                return UNKNOWN;
            }
        }
    }

    private static class Builder {
        private Source source = Source.UNKNOWN;
        private int index;
        private DataType dataType = DataType.UNKNOWN;
        private int[] shape;
        private QuantizationParams quantizationParams;
        private boolean metadataExisted;
        private String name = "";
        private String description = "";
        private ContentType contentType = ContentType.UNKNOWN;
        private ContentRange contentRange = new ContentRange(-1, -1);
        private String fileName = "";
        private FileType fileType = FileType.UNKNOWN;
        private NormalizationParams normalizationParams;
        private ImageProperties imageProperties;
        private BoundingBoxProperties boundingBoxProperties;

        private Builder() {
        }

        private Builder setSource(Source source) {
            this.source = source;
            return this;
        }

        private Builder setIndex(int index) {
            this.index = index;
            return this;
        }

        private Builder setDataType(DataType dataType) {
            this.dataType = dataType;
            return this;
        }

        private Builder setShape(int[] shape) {
            this.shape = shape;
            return this;
        }

        private Builder setQuantizationParams(QuantizationParams quantizationParams) {
            this.quantizationParams = quantizationParams;
            return this;
        }

        private Builder setMetadataExisted(boolean metadataExisted) {
            this.metadataExisted = metadataExisted;
            return this;
        }

        private Builder setName(String name) {
            this.name = name;
            return this;
        }

        private Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        private Builder setContentType(ContentType contentType) {
            this.contentType = contentType;
            return this;
        }

        private Builder setContentRange(ContentRange contentRange) {
            this.contentRange = contentRange;
            return this;
        }

        private Builder setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        private Builder setFileType(FileType fileType) {
            this.fileType = fileType;
            return this;
        }

        private Builder setNormalizationParams(NormalizationParams normalizationParams) {
            this.normalizationParams = normalizationParams;
            return this;
        }

        public Builder setImageProperties(ImageProperties imageProperties) {
            this.imageProperties = imageProperties;
            return this;
        }

        public Builder setBoundingBoxProperties(BoundingBoxProperties boundingBoxProperties) {
            this.boundingBoxProperties = boundingBoxProperties;
            return this;
        }

        private TensorInfo build() {
            return new TensorInfo(this.source, this.index, this.dataType, this.shape, this.quantizationParams, this.metadataExisted, this.name, this.description, this.contentType, this.contentRange, this.fileName, this.fileType, this.normalizationParams != null ? this.normalizationParams : new NormalizationParams(TensorInfo.toFloatBuffer(0.0f), TensorInfo.toFloatBuffer(1.0f), TensorInfo.toFloatBuffer(Float.MIN_VALUE), TensorInfo.toFloatBuffer(Float.MAX_VALUE)), this.imageProperties, this.boundingBoxProperties);
        }
    }

    public static enum ContentType {
        UNKNOWN(0),
        FEATURE(1),
        IMAGE(2),
        BOUNDING_BOX(3);

        private final byte id;

        private ContentType(byte id) {
            this.id = id;
        }

        public static ContentType fromByte(byte id) {
            for (ContentType type : ContentType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return UNKNOWN;
        }
    }

    public static enum FileType {
        UNKNOWN(0),
        DESCRIPTIONS(1),
        TENSOR_AXIS_LABELS(2),
        TENSOR_VALUE_LABELS(3),
        TENSOR_AXIS_SCORE_CALIBRATION(4);

        private final byte id;

        private FileType(byte id) {
            this.id = id;
        }

        public static FileType fromByte(byte id) {
            for (FileType type : FileType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return UNKNOWN;
        }
    }

    public static enum Source {
        UNKNOWN(0),
        INPUT(1),
        OUTPUT(2);

        private final byte id;

        private Source(byte id) {
            this.id = id;
        }

        public static Source fromByte(byte id) {
            for (Source source : Source.values()) {
                if (source.id != id) continue;
                return source;
            }
            return UNKNOWN;
        }
    }

    public static enum DataType {
        UNKNOWN(-1),
        FLOAT32(0),
        INT32(2),
        UINT8(3),
        INT64(4);

        private final byte id;

        private DataType(byte id) {
            this.id = id;
        }

        public static DataType fromByte(byte id) {
            for (DataType type : DataType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

