/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0001\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0000J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004j\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/detector/api/TextFormat;", "", "(Ljava/lang/String;I)V", "convertTo", "", "message", "to", "fromHtml", "html", "fromRaw", "text", "toHtml", "toText", "RAW", "TEXT", "HTML", "HTML_WITH_UNICODE", "Companion", "android.sdktools.lint-api"})
public final class TextFormat
extends Enum<TextFormat> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    public static final String HTTP_PREFIX = "http://";
    @NotNull
    public static final String HTTPS_PREFIX = "https://";
    public static final /* enum */ TextFormat RAW;
    public static final /* enum */ TextFormat TEXT;
    public static final /* enum */ TextFormat HTML;
    public static final /* enum */ TextFormat HTML_WITH_UNICODE;
    private static final /* synthetic */ TextFormat[] $VALUES;

    @NotNull
    public final String toHtml(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.convertTo(text, HTML);
    }

    @NotNull
    public final String toText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.convertTo(text, TEXT);
    }

    @NotNull
    public final String convertTo(@NotNull String message2, @NotNull TextFormat to) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
        if (this == to) {
            return message2;
        }
        TextFormat textFormat = this;
        int n = WhenMappings.$EnumSwitchMapping$0[textFormat.ordinal()];
        switch (n) {
            case 1: {
                String string;
                TextFormat textFormat2 = to;
                int n2 = WhenMappings.$EnumSwitchMapping$0[textFormat2.ordinal()];
                switch (n2) {
                    case 1: {
                        string = message2;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        string = to.fromRaw(message2);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }
            case 2: {
                String string;
                TextFormat textFormat3 = to;
                int n3 = WhenMappings.$EnumSwitchMapping$0[textFormat3.ordinal()];
                switch (n3) {
                    case 1: {
                        string = TextFormat.Companion.textToRaw(message2);
                        break;
                    }
                    case 2: {
                        string = message2;
                        break;
                    }
                    case 3: 
                    case 4: {
                        String string2 = XmlUtils.toXmlTextValue((String)message2);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toXmlTextValue(message)");
                        string = string2;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }
            case 3: {
                String string;
                TextFormat textFormat4 = to;
                int n4 = WhenMappings.$EnumSwitchMapping$0[textFormat4.ordinal()];
                switch (n4) {
                    case 3: {
                        string = message2;
                        break;
                    }
                    case 4: {
                        string = TextFormat.Companion.removeNumericEntities(message2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = to.fromHtml(message2);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }
            case 4: {
                String string;
                TextFormat textFormat5 = to;
                int n5 = WhenMappings.$EnumSwitchMapping$0[textFormat5.ordinal()];
                switch (n5) {
                    case 3: 
                    case 4: {
                        string = message2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = to.fromHtml(message2);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    private final String fromHtml(String html) {
        boolean bl = this == RAW || this == TEXT;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-TextFormat$fromHtml$22 = false;
            TextFormat $i$a$-assert-TextFormat$fromHtml$22 = this;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-TextFormat$fromHtml$22));
        }
        StringBuilder sb = new StringBuilder(html.length());
        boolean inPre = false;
        int i = 0;
        int n = html.length();
        while (i < n) {
            int n2;
            int n3;
            int end2;
            char c = html.charAt(i);
            if (c == '<') {
                String tag22;
                void $this$trim$iv;
                if (StringsKt.startsWith$default((String)html, (String)"<!--", (int)i, (boolean)false, (int)4, null)) {
                    end2 = StringsKt.indexOf$default((CharSequence)html, (String)"-->", (int)i, (boolean)false, (int)4, null);
                    if (end2 == -1) break;
                    n3 = i = end2 + 2;
                    i = n3 + 1;
                    continue;
                }
                int begin = 0;
                boolean isEndTag = false;
                if (StringsKt.startsWith$default((String)html, (String)"</", (int)i, (boolean)false, (int)4, null)) {
                    begin = i + 2;
                    isEndTag = true;
                } else {
                    begin = i + 1;
                }
                i = StringsKt.indexOf$default((CharSequence)html, (char)'>', (int)i, (boolean)false, (int)4, null);
                if (i == -1) break;
                int end3 = i;
                if (html.charAt(i - 1) == '/') {
                    int n4 = end3;
                    end3 = n4 + -1;
                    isEndTag = true;
                }
                CharSequence charSequence = html;
                n2 = 0;
                String string = charSequence;
                if (string == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = string.substring(begin, end3);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                charSequence = string2;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl3 = false;
                    boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (StringsKt.equals((String)(tag22 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"br", (boolean)true)) {
                    sb.append('\n');
                } else if (StringsKt.equals((String)tag22, (String)"p", (boolean)true) || StringsKt.equals((String)tag22, (String)"div", (boolean)true) || StringsKt.equals((String)tag22, (String)"pre", (boolean)true) || StringsKt.equals((String)tag22, (String)"blockquote", (boolean)true) || StringsKt.equals((String)tag22, (String)"dl", (boolean)true) || StringsKt.equals((String)tag22, (String)"dd", (boolean)true) || StringsKt.equals((String)tag22, (String)"dt", (boolean)true) || StringsKt.equals((String)tag22, (String)"ol", (boolean)true) || StringsKt.equals((String)tag22, (String)"ul", (boolean)true) || StringsKt.equals((String)tag22, (String)"li", (boolean)true) || tag22.length() == 2 && StringsKt.startsWith$default((String)tag22, (String)"h", (boolean)false, (int)2, null) && Character.isDigit(tag22.charAt(1))) {
                    charSequence = sb;
                    n2 = 0;
                    if (charSequence.length() > 0 && sb.charAt(sb.length() - 1) != '\n') {
                        sb.append('\n');
                    }
                    if (Intrinsics.areEqual((Object)tag22, (Object)"li") && !isEndTag) {
                        sb.append("* ");
                    }
                    if (StringsKt.equals((String)tag22, (String)"pre", (boolean)true)) {
                        inPre = !isEndTag;
                    }
                }
            } else if (c == '&') {
                end2 = StringsKt.indexOf$default((CharSequence)html, (char)';', (int)i, (boolean)false, (int)4, null);
                if (end2 > i) {
                    String entity;
                    String s;
                    String end3 = html;
                    int tag22 = end2 + 1;
                    boolean bl5 = false;
                    String string = end3;
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string.substring(i, tag22), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String tag22 = s = XmlUtils.fromXmlAttributeValue((String)entity);
                    Intrinsics.checkNotNullExpressionValue((Object)tag22, (String)"s");
                    if (StringsKt.startsWith$default((String)tag22, (String)"&", (boolean)false, (int)2, null)) {
                        if (StringsKt.equals((String)entity, (String)"&nbsp;", (boolean)true)) {
                            s = " ";
                        } else if (StringsKt.startsWith$default((String)entity, (String)"&#", (boolean)false, (int)2, null)) {
                            try {
                                String string3 = entity;
                                n2 = 2;
                                boolean bl6 = false;
                                String string4 = string3;
                                if (string4 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                }
                                String string5 = string4.substring(n2);
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                                int value = Integer.parseInt(string5);
                                s = Character.toString((char)value);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    sb.append(s);
                    i = end2;
                } else {
                    sb.append(c);
                }
            } else if (Character.isWhitespace(c)) {
                if (inPre) {
                    sb.append(c);
                } else {
                    CharSequence charSequence = sb;
                    n3 = 0;
                    if (charSequence.length() == 0 || !Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                        sb.append(' ');
                    }
                }
            } else {
                sb.append(c);
            }
            int n5 = i;
            i = n5 + 1;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        String s = string;
        string = SdkUtils.wrap((String)s, (int)60, null);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrap(s, 60, null)");
        s = string;
        return s;
    }

    private final String fromRaw(String text) {
        boolean bl = this == HTML || this == HTML_WITH_UNICODE || this == TEXT;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-TextFormat$fromRaw$22 = false;
            TextFormat $i$a$-assert-TextFormat$fromRaw$22 = this;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-TextFormat$fromRaw$22));
        }
        StringBuilder sb = new StringBuilder(3 * text.length() / 2);
        boolean html = this == HTML || this == HTML_WITH_UNICODE;
        boolean escapeUnicode = this == HTML;
        char prev = '\u0000';
        int flushIndex = 0;
        int n = text.length();
        boolean escaped = false;
        int i = 0;
        while (i < n) {
            int n2;
            char c = text.charAt(i);
            if (c == '\\' && !escaped) {
                escaped = true;
                if (i > flushIndex) {
                    com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, html, flushIndex, i, escapeUnicode, false, 64, null);
                }
                flushIndex = i + 1;
                n2 = i;
                i = n2 + 1;
                continue;
            }
            if (!(escaped || c != '*' && c != '`' || i >= n - 1)) {
                int end2;
                if ((i == 0 || text.charAt(i - 1) == '\n') && StringsKt.regionMatches((String)text, (int)i, (String)"```", (int)0, (int)3, (boolean)false) && (end2 = StringsKt.indexOf$default((CharSequence)text, (String)"\n```", (int)(i + 3), (boolean)false, (int)4, null)) != -1) {
                    int nextLineStart = StringsKt.indexOf$default((CharSequence)text, (char)'\n', (int)i, (boolean)false, (int)4, null) + 1;
                    if (i > flushIndex) {
                        com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, html, flushIndex, i - 1, escapeUnicode, false, 64, null);
                    }
                    sb.append("\n");
                    if (html) {
                        sb.append("<pre>\n");
                    }
                    TextFormat.Companion.appendEscapedText(sb, text, html, nextLineStart, end2 + 1, escapeUnicode, false);
                    if (html) {
                        sb.append("</pre>\n");
                    }
                    flushIndex = i = end2 + 4 < n && text.charAt(end2 + 4) == '\n' ? end2 + 5 : end2 + 4;
                    continue;
                }
                if (!Character.isLetterOrDigit(prev) && !Character.isWhitespace(text.charAt(i + 1))) {
                    int end22;
                    end2 = StringsKt.indexOf$default((CharSequence)text, (char)c, (int)(i + 1), (boolean)false, (int)4, null);
                    boolean bold = false;
                    if (end2 == i + 1 && c == '*') {
                        end22 = StringsKt.indexOf$default((CharSequence)text, (char)'*', (int)(end2 + 1), (boolean)false, (int)4, null);
                        if (end22 == end2 + 1) {
                            if ((end22 = StringsKt.indexOf$default((CharSequence)text, (String)"***", (int)(end22 + 1), (boolean)false, (int)4, null)) != -1) {
                                if (i > flushIndex) {
                                    com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, html, flushIndex, i, escapeUnicode, false, 64, null);
                                }
                                if (html) {
                                    sb.append("<b><i>");
                                    com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, true, i + 3, end22, escapeUnicode, false, 64, null);
                                    sb.append("</i></b>");
                                } else {
                                    com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, false, i + 3, end22, escapeUnicode, false, 64, null);
                                }
                                flushIndex = end22 + 3;
                                i = flushIndex - 1;
                            }
                            int n3 = i;
                            i = n3 + 1;
                            continue;
                        }
                        if (end22 != -1 && end22 > end2 + 1 && end22 < n - 1 && text.charAt(end22 + 1) == '*') {
                            end2 = end22;
                            bold = true;
                        }
                    }
                    if (!(end2 == -1 || end2 != n - 1 && Character.isLetter(text.charAt(end2 + 1)))) {
                        if (i > flushIndex) {
                            com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, html, flushIndex, i, escapeUnicode, false, 64, null);
                        }
                        if (bold) {
                            end22 = i;
                            i = end22 + 1;
                        }
                        if (html) {
                            String tag = bold ? "b" : (c == '*' ? "i" : "code");
                            sb.append('<').append(tag).append('>');
                            com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, true, i + 1, end2, escapeUnicode, false, 64, null);
                            sb.append('<').append('/').append(tag).append('>');
                        } else {
                            com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, false, i + 1, end2, escapeUnicode, false, 64, null);
                        }
                        flushIndex = end2 + 1;
                        if (bold) {
                            int tag = flushIndex;
                            flushIndex = tag + 1;
                        }
                        i = flushIndex - 1;
                    }
                }
            } else if (html && c == 'h' && i < n - 1 && text.charAt(i + 1) == 't' && (StringsKt.startsWith$default((String)text, (String)HTTP_PREFIX, (int)i, (boolean)false, (int)4, null) || StringsKt.startsWith$default((String)text, (String)HTTPS_PREFIX, (int)i, (boolean)false, (int)4, null)) && !Character.isLetterOrDigit(prev)) {
                int length = StringsKt.startsWith$default((String)text, (String)HTTP_PREFIX, (int)i, (boolean)false, (int)4, null) ? HTTP_PREFIX.length() : HTTPS_PREFIX.length();
                int end3 = Companion.findUrlEnd(text, i);
                if (end3 > i + length) {
                    String url;
                    if (i > flushIndex) {
                        com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, true, flushIndex, i, escapeUnicode, false, 64, null);
                    }
                    String string = text;
                    boolean bl3 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string2.substring(i, end3), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    sb.append("<a href=\"");
                    sb.append(url);
                    sb.append('\"').append('>');
                    sb.append(url);
                    sb.append("</a>");
                    flushIndex = end3;
                    i = flushIndex - 1;
                }
            } else if (c == '\n' && escaped) {
                n2 = flushIndex;
                flushIndex = n2 + 1;
            }
            prev = c;
            escaped = false;
            n2 = i;
            i = n2 + 1;
        }
        if (flushIndex < n) {
            com.android.tools.lint.detector.api.TextFormat$Companion.appendEscapedText$default(Companion, sb, text, html, flushIndex, n, escapeUnicode, false, 64, null);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public static TextFormat[] values() {
        return (TextFormat[])$VALUES.clone();
    }

    public static TextFormat valueOf(String value) {
        return Enum.valueOf(TextFormat.class, value);
    }

    static {
        RAW = new TextFormat();
        TEXT = new TextFormat();
        HTML = new TextFormat();
        HTML_WITH_UNICODE = new TextFormat();
        $VALUES = textFormatArray = new TextFormat[]{TextFormat.RAW, TextFormat.TEXT, TextFormat.HTML, TextFormat.HTML_WITH_UNICODE};
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\r2\b\b\u0002\u0010\u0012\u001a\u00020\rH\u0002J\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/detector/api/TextFormat$Companion;", "", "()V", "HTTPS_PREFIX", "", "HTTP_PREFIX", "appendEscapedText", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "text", "html", "", "start", "", "end", "escapeUnicode", "newlinesAsBr", "findUrlEnd", "removeNumericEntities", "terminatesUrl", "c", "", "textToRaw", "message", "android.sdktools.lint-api"})
    public static final class Companion {
        private Companion() {
        }

        public final int findUrlEnd(@NotNull String text, int start2) {
            int n;
            char d;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int length = StringsKt.startsWith$default((String)text, (String)TextFormat.HTTP_PREFIX, (int)start2, (boolean)false, (int)4, null) ? TextFormat.HTTP_PREFIX.length() : TextFormat.HTTPS_PREFIX.length();
            int end2 = start2 + length;
            int n2 = text.length();
            while (!(end2 >= n2 || this.terminatesUrl(d = text.charAt(end2)) || d == ')' && start2 > 0 && text.charAt(start2 - 1) == '(')) {
                n = end2;
                end2 = n + 1;
            }
            char last = text.charAt(end2 - 1);
            if (last == '.' || last == ')' || last == '!' || last == ',') {
                n = end2;
                end2 = n + -1;
            }
            return end2;
        }

        private final boolean terminatesUrl(char c) {
            boolean bl;
            block1: {
                char c2;
                block0: {
                    c2 = c;
                    boolean bl2 = 'a' <= c2 ? c2 <= 'z' : false;
                    if (!bl2) break block0;
                    bl = false;
                    break block1;
                }
                bl = ('A' <= c2 ? c2 <= 'Z' : false) ? false : (('0' <= c2 ? c2 <= '9' : false) ? false : !((((((((((((((((((((((c2 == '-' ? true : c2 == '_') ? true : c2 == '.') ? true : c2 == '*') ? true : c2 == '+') ? true : c2 == '%') ? true : c2 == '/') ? true : c2 == '#') ? true : c2 == ':') ? true : c2 == '@') ? true : c2 == '!') ? true : c2 == '$') ? true : c2 == '&') ? true : c2 == '\'') ? true : c2 == '~') ? true : c2 == '[') ? true : c2 == ']') ? true : c2 == '(') ? true : c2 == ')') ? true : c2 == ';') ? true : c2 == '?') ? true : c2 == '=') ? true : c2 == ','));
            }
            return bl;
        }

        private final String textToRaw(String message2) {
            boolean mustEscape = false;
            int n = 0;
            int n2 = message2.length();
            if (n < n2) {
                do {
                    int i;
                    char c;
                    if ((c = message2.charAt(i = n++)) != '\\' && c != '*' && c != '`') continue;
                    mustEscape = true;
                    break;
                } while (n < n2);
            }
            if (!mustEscape) {
                return message2;
            }
            StringBuilder sb = new StringBuilder(message2.length() * 2);
            int n3 = 0;
            if (n3 < n2) {
                do {
                    int i;
                    char c;
                    if ((c = message2.charAt(i = n3++)) == '\\' || c == '*' || c == '`') {
                        sb.append('\\');
                    }
                    sb.append(c);
                } while (n3 < n2);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        private final String removeNumericEntities(String html) {
            if (!StringsKt.contains$default((CharSequence)html, (CharSequence)"&#", (boolean)false, (int)2, null)) {
                return html;
            }
            StringBuilder sb = new StringBuilder(html.length());
            int i = 0;
            int n = html.length();
            while (i < n) {
                int end2;
                char c = html.charAt(i);
                if (c == '&' && i < n - 1 && html.charAt(i + 1) == '#' && (end2 = StringsKt.indexOf$default((CharSequence)html, (char)';', (int)(i + 2), (boolean)false, (int)4, null)) != -1) {
                    String string = html;
                    int n2 = i + 2;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n2, end2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    try {
                        String decimal;
                        c = (char)Integer.parseInt(decimal);
                        sb.append(c);
                        int n3 = i = end2;
                        i = n3 + 1;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                sb.append(c);
                int n4 = i;
                i = n4 + 1;
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        private final void appendEscapedText(StringBuilder sb, String text, boolean html, int start2, int end2, boolean escapeUnicode, boolean newlinesAsBr) {
            if (html) {
                int n = start2;
                if (n < end2) {
                    do {
                        int i;
                        char c;
                        if ((c = text.charAt(i = n++)) == '<') {
                            sb.append("&lt;");
                            continue;
                        }
                        if (c == '&') {
                            sb.append("&amp;");
                            continue;
                        }
                        if (c == '\n') {
                            if (newlinesAsBr) {
                                sb.append("<br/>\n");
                                continue;
                            }
                            sb.append("\n");
                            continue;
                        }
                        if (c > '\u00ff' && escapeUnicode) {
                            if (c == '\u200b') continue;
                            sb.append("&#");
                            sb.append(Integer.toString(c));
                            sb.append(';');
                            continue;
                        }
                        if (c == '\u00a0') {
                            sb.append("&nbsp;");
                            continue;
                        }
                        sb.append(c);
                    } while (n < end2);
                }
            } else {
                int n = start2;
                if (n < end2) {
                    do {
                        int i;
                        char c;
                        if ((c = text.charAt(i = n++)) == '\u200b') continue;
                        sb.append(c);
                    } while (n < end2);
                }
            }
        }

        static /* synthetic */ void appendEscapedText$default(Companion companion, StringBuilder stringBuilder, String string, boolean bl, int n, int n2, boolean bl2, boolean bl3, int n3, Object object) {
            if ((n3 & 0x40) != 0) {
                bl3 = true;
            }
            companion.appendEscapedText(stringBuilder, string, bl, n, n2, bl2, bl3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextFormat.values().length];
            nArray[TextFormat.RAW.ordinal()] = 1;
            nArray[TextFormat.TEXT.ordinal()] = 2;
            nArray[TextFormat.HTML.ordinal()] = 3;
            nArray[TextFormat.HTML_WITH_UNICODE.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

