/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.OtherFileScanner;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\n\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\r\u001a\u00020\tH\u0002J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/client/api/OtherFileVisitor;", "", "detectors", "", "Lcom/android/tools/lint/detector/api/Detector;", "(Ljava/util/List;)V", "files", "Ljava/util/EnumMap;", "Lcom/android/tools/lint/detector/api/Scope;", "Ljava/io/File;", "collectFiles", "", "", "file", "scan", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "main", "android.sdktools.lint-api"})
public final class OtherFileVisitor {
    @NotNull
    private final List<Detector> detectors;
    @NotNull
    private final EnumMap<Scope, List<File>> files;

    public OtherFileVisitor(@NotNull List<? extends Detector> detectors) {
        Intrinsics.checkNotNullParameter(detectors, (String)"detectors");
        this.detectors = detectors;
        this.files = new EnumMap(Scope.class);
    }

    public final void scan(@NotNull LintDriver driver, @NotNull Project project, @Nullable Project main) {
        List<File> manifestFiles;
        boolean bl;
        boolean bl2;
        ArrayList<File> files;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File file2 = project.getDir();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.dir");
        File projectFolder = file2;
        EnumSet<Scope> scopes = EnumSet.noneOf(Scope.class);
        for (Detector detector : this.detectors) {
            OtherFileScanner object2 = (OtherFileScanner)((Object)detector);
            EnumSet<Scope> enumSet = object2.getApplicableFiles();
            if (enumSet.contains((Object)Scope.OTHER)) {
                scopes = Scope.ALL;
                break;
            }
            scopes.addAll((Collection<Scope>)enumSet);
        }
        List<File> subset = project.getSubset();
        if (scopes.contains((Object)Scope.RESOURCE_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList<File>(subset.size());
                for (File file : subset) {
                    if (!SdkUtils.endsWith((CharSequence)file.getPath(), (CharSequence)".xml") || Intrinsics.areEqual((Object)file.getName(), (Object)"AndroidManifest.xml")) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    Scope scope = Scope.RESOURCE_FILE;
                    bl2 = false;
                    map.put(scope, files);
                }
            } else {
                files = Lists.newArrayListWithExpectedSize((int)100);
                for (File file : project.getResourceFolders()) {
                    Intrinsics.checkNotNullExpressionValue(files, (String)"files");
                    List list2 = files;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"res");
                    this.collectFiles(list2, file);
                }
                File file = new File(projectFolder, "assets");
                if (file.exists()) {
                    Intrinsics.checkNotNullExpressionValue(files, (String)"files");
                    this.collectFiles((List<File>)files, file);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    Scope scope = Scope.RESOURCE_FILE;
                    bl = false;
                    map.put(scope, files);
                }
            }
        }
        if (scopes.contains((Object)Scope.JAVA_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList<File>(subset.size());
                for (File file : subset) {
                    String string = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
                    if (!StringsKt.endsWith$default((String)string, (String)".java", (boolean)false, (int)2, null)) {
                        string = file.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
                        if (!StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null)) continue;
                    }
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    Scope scope = Scope.JAVA_FILE;
                    bl2 = false;
                    map.put(scope, files);
                }
            } else {
                files = Lists.newArrayListWithExpectedSize((int)100);
                for (File file : project.getJavaSourceFolders()) {
                    Intrinsics.checkNotNullExpressionValue(files, (String)"files");
                    List list3 = files;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"srcFolder");
                    this.collectFiles(list3, file);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    Scope scope = Scope.JAVA_FILE;
                    bl2 = false;
                    map.put(scope, files);
                }
            }
        }
        if (scopes.contains((Object)Scope.CLASS_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                for (File file : subset) {
                    String string = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
                    if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    Scope scope = Scope.CLASS_FILE;
                    bl2 = false;
                    map.put(scope, files);
                }
            } else {
                files = Lists.newArrayListWithExpectedSize((int)100);
                for (File file : project.getJavaClassFolders()) {
                    Intrinsics.checkNotNullExpressionValue(files, (String)"files");
                    List list4 = files;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"classFolder");
                    this.collectFiles(list4, file);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    Scope scope = Scope.CLASS_FILE;
                    bl2 = false;
                    map.put(scope, files);
                }
            }
        }
        if (scopes.contains((Object)Scope.MANIFEST)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                for (File file : subset) {
                    if (!Intrinsics.areEqual((Object)file.getName(), (Object)"AndroidManifest.xml")) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    Scope scope = Scope.MANIFEST;
                    bl2 = false;
                    map.put(scope, files);
                }
            } else {
                List<File> list5 = project.getManifestFiles();
                Intrinsics.checkNotNullExpressionValue(list5, (String)"project.manifestFiles");
                manifestFiles = list5;
                Map map = this.files;
                Scope scope = Scope.MANIFEST;
                bl2 = false;
                map.put(scope, manifestFiles);
            }
        }
        if (scopes.contains((Object)Scope.GRADLE_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                for (File file : subset) {
                    String string = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                    if (!StringsKt.endsWith$default((String)string, (String)".gradle", (boolean)false, (int)2, null)) {
                        string = file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                        if (!StringsKt.endsWith$default((String)string, (String)".kts", (boolean)false, (int)2, null)) continue;
                    }
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    Scope scope = Scope.GRADLE_FILE;
                    bl2 = false;
                    map.put(scope, files);
                }
            } else {
                List<File> list6 = project.getGradleBuildScripts();
                Intrinsics.checkNotNullExpressionValue(list6, (String)"project.gradleBuildScripts");
                manifestFiles = list6;
                Map map = this.files;
                Scope scope = Scope.GRADLE_FILE;
                bl2 = false;
                map.put(scope, manifestFiles);
            }
        }
        if (scopes.contains((Object)Scope.PROGUARD_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                for (File file : subset) {
                    String string = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                    if (!StringsKt.startsWith$default((String)string, (String)"proguard", (boolean)false, (int)2, null)) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    Scope scope = Scope.PROPERTY_FILE;
                    bl2 = false;
                    map.put(scope, files);
                }
            } else {
                List<File> list7 = project.getProguardFiles();
                Intrinsics.checkNotNullExpressionValue(list7, (String)"project.proguardFiles");
                manifestFiles = list7;
                Map map = this.files;
                Scope scope = Scope.PROGUARD_FILE;
                bl2 = false;
                map.put(scope, manifestFiles);
            }
        }
        if (scopes.contains((Object)Scope.PROPERTY_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                for (File file : subset) {
                    String string = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                    if (!StringsKt.endsWith$default((String)string, (String)".properties", (boolean)false, (int)2, null)) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    Map map = this.files;
                    Scope scope = Scope.PROPERTY_FILE;
                    bl2 = false;
                    map.put(scope, files);
                }
            } else {
                List<File> list8 = project.getPropertyFiles();
                Intrinsics.checkNotNullExpressionValue(list8, (String)"project.propertyFiles");
                List<File> propertyFiles = list8;
                Map map = this.files;
                Scope scope = Scope.PROPERTY_FILE;
                bl2 = false;
                map.put(scope, propertyFiles);
            }
        }
        Map map = this.files;
        boolean bl3 = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            bl = false;
            Scope scope = (Scope)((Object)entry2.getKey());
            Map.Entry entry3 = entry;
            boolean bl4 = false;
            List files2 = (List)entry3.getValue();
            ArrayList<Detector> applicable = new ArrayList<Detector>(this.detectors.size());
            for (Detector detector : this.detectors) {
                OtherFileScanner fileScanner2 = (OtherFileScanner)((Object)detector);
                EnumSet<Scope> appliesTo = fileScanner2.getApplicableFiles();
                if (!appliesTo.contains((Object)Scope.OTHER) && !appliesTo.contains((Object)scope)) continue;
                applicable.add(detector);
            }
            if (applicable.isEmpty()) continue;
            for (File file5 : files2) {
                Context context2 = new Context(driver, project, main, file5, null, 16, null);
                for (Detector detector : applicable) {
                    detector.beforeCheckFile(context2);
                    detector.run(context2);
                    detector.afterCheckFile(context2);
                    LintDriver lintDriver = driver;
                    int n = lintDriver.getFileCount();
                    lintDriver.setFileCount(n + 1);
                }
            }
        }
    }

    private final void collectFiles(List<File> files, File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                    this.collectFiles(files, child);
                }
            }
        } else {
            files.add(file);
        }
    }
}

