/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/WorkManagerDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "android.sdktools.lint-checks"})
public final class WorkManagerDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(WorkManagerDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String CLASS_WORK_MANAGER = "androidx.work.WorkManager";
    @NotNull
    private static final String CLASS_WORK_CONTINUATION = "androidx.work.WorkContinuation";
    @NotNull
    private static final String METHOD_BEGIN_WITH = "beginWith";
    @NotNull
    private static final String METHOD_BEGIN_UNIQUE_WORK = "beginUniqueWork";
    @NotNull
    private static final String METHOD_ENQUEUE = "enqueue";
    @NotNull
    private static final String METHOD_ENQUEUE_SYNC = "enqueueSync";
    @NotNull
    private static final String METHOD_ENQUEUE_UNIQUE = "enqueueUniquePeriodicWork";
    @NotNull
    private static final String METHOD_THEN = "then";
    @NotNull
    private static final String METHOD_COMBINE = "combine";

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{METHOD_BEGIN_WITH, METHOD_BEGIN_UNIQUE_WORK, METHOD_THEN, METHOD_COMBINE};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!context2.getEvaluator().isMemberInClass((PsiMember)method, CLASS_WORK_MANAGER) && !context2.getEvaluator().isMemberInClass((PsiMember)method, CLASS_WORK_CONTINUATION)) {
            return;
        }
        UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)((UElement)node), UMethod.class, (boolean)true);
        if (uMethod == null) {
            return;
        }
        UMethod surrounding = uMethod;
        if (Intrinsics.areEqual((Object)((uMethod = surrounding.getReturnType()) == null ? null : uMethod.getCanonicalText()), (Object)CLASS_WORK_CONTINUATION)) {
            return;
        }
        Ref.BooleanRef enqueued = new Ref.BooleanRef();
        List list2 = CollectionsKt.listOf((Object)node);
        surrounding.accept((UastVisitor)new DataFlowAnalyzer(enqueued, list2){
            final /* synthetic */ Ref.BooleanRef $enqueued;
            {
                this.$enqueued = $enqueued;
                super($super_call_param$1, null, 2, null);
            }

            public void receiver(@NotNull UCallExpression call) {
                block16: {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    String methodName = Lint.getMethodName(call);
                    if (methodName == null) break block16;
                    int n = -1;
                    switch (methodName.hashCode()) {
                        case -1594257912: {
                            if (methodName.equals("enqueue")) {
                                n = 1;
                            }
                            break;
                        }
                        case 1310382275: {
                            if (methodName.equals("enqueueSync")) {
                                n = 1;
                            }
                            break;
                        }
                        case 1078858469: {
                            if (methodName.equals("enqueueUniquePeriodicWork")) {
                                n = 1;
                            }
                            break;
                        }
                        case 3558941: {
                            if (methodName.equals("then")) {
                                n = 2;
                            }
                            break;
                        }
                        case 950074687: {
                            if (methodName.equals("combine")) {
                                n = 2;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            this.$enqueued.element = true;
                            break;
                        }
                        case 2: {
                            this.$enqueued.element = true;
                        }
                    }
                }
            }

            public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                String methodName = Lint.getMethodName(call);
                if (Intrinsics.areEqual((Object)methodName, (Object)"combine")) {
                    this.$enqueued.element = true;
                } else {
                    UElement parent = UastUtils.skipParenthesizedExprUp((UElement)call.getUastParent());
                    if (parent instanceof UQualifiedReferenceExpression) {
                        PsiElement listVariable;
                        UExpression uExpression = UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)parent).getReceiver());
                        PsiElement psiElement = listVariable = uExpression == null ? null : UastUtils.tryResolve((UElement)((UElement)uExpression));
                        if (listVariable instanceof PsiLocalVariable) {
                            this.getReferences().add(listVariable);
                        } else {
                            UElement parentParent = UastUtils.skipParenthesizedExprUp((UElement)((UQualifiedReferenceExpression)parent).getUastParent());
                            if (parentParent instanceof ULocalVariable) {
                                this.addVariableReference((UVariable)parentParent);
                            }
                        }
                    } else if (parent instanceof ULocalVariable) {
                        this.addVariableReference((UVariable)parent);
                    }
                }
            }

            public boolean returnsSelf(@NotNull UCallExpression call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                String methodName = Lint.getMethodName(call);
                if (Intrinsics.areEqual((Object)methodName, (Object)"synchronous")) {
                    return true;
                }
                return super.returnsSelf(call);
            }
        });
        if (!enqueued.element) {
            UElement uElement = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
            UElement uElement2 = UastUtils.skipParenthesizedExprUp((UElement)(uElement == null ? null : uElement.getUastParent()));
            ULocalVariable uLocalVariable = uElement2 instanceof ULocalVariable ? (ULocalVariable)uElement2 : null;
            String name = uLocalVariable == null ? null : uLocalVariable.getName();
            String nameString = name != null ? '`' + name + "` " : "";
            JavaContext.report$default(context2, ISSUE, (UElement)node, context2.getLocation((UElement)node), "WorkContinuation " + nameString + "not enqueued: did you forget to call `enqueue()`?", null, 16, null);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default(companion, "EnqueueWork", "WorkManager Enqueue", "\n                `WorkContinuations` cannot be enqueued automatically.  You must call `enqueue()` \\\n                on a `WorkContinuation` to have it and its parent continuations enqueued inside \\\n                `WorkManager`.\n            ", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/WorkManagerDetector$Companion;", "", "()V", "CLASS_WORK_CONTINUATION", "", "CLASS_WORK_MANAGER", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "METHOD_BEGIN_UNIQUE_WORK", "METHOD_BEGIN_WITH", "METHOD_COMBINE", "METHOD_ENQUEUE", "METHOD_ENQUEUE_SYNC", "METHOD_ENQUEUE_UNIQUE", "METHOD_THEN", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

