/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.checks.VersionChecks;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/WebViewApiAvailabilityDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Companion", "Handler", "android.sdktools.lint-checks"})
public final class WebViewApiAvailabilityDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String WEBVIEW_CLASS_NAME = "android.webkit.WebView";
    private static final int INVALID = -1;
    @NotNull
    private static final Set<String> BLOCKED_METHODS;
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UCallExpression.class);
    }

    @Override
    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Handler(context2);
    }

    static {
        Object object = new String[]{"getAccessibilityClassName", "onProvideVirtualStructure", "autofill", "getRendererPriorityWaivedWhenNotVisible", "getRendererRequestedPriority", "onProvideAutofillVirtualStructure", "setRendererPriorityPolicy", "getTextClassifier", "setTextClassifier", "getWebViewClassLoader", "disableWebView", "setDataDirectorySuffix", "getWebViewLooper", "isVisibleToUserForAutofill"};
        BLOCKED_METHODS = SetsKt.setOf((Object[])object);
        object = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(WebViewApiAvailabilityDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)object, "WebViewApiAvailability", "WebView API Availability", "The `androidx.webkit` library is a static library you can add to your Android application allowing you to use new APIs on older platform versions, targeting more devices.", implementation, "https://developer.android.com/reference/androidx/webkit/package-summary", category, 7, severity, false, true, null, null, 3328, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/WebViewApiAvailabilityDetector$Companion;", "", "()V", "BLOCKED_METHODS", "", "", "INVALID", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "WEBVIEW_CLASS_NAME", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/WebViewApiAvailabilityDetector$Handler;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "visitCallExpression", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "android.sdktools.lint-checks"})
    private static final class Handler
    extends UElementHandler {
        @NotNull
        private final JavaContext context;

        public Handler(@NotNull JavaContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.context = context2;
        }

        @Override
        public void visitCallExpression(@NotNull UCallExpression node) {
            ApiLookup apiLookup;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiMethod psiMethod = node.resolve();
            if (psiMethod == null) {
                return;
            }
            PsiMethod method = psiMethod;
            if (BLOCKED_METHODS.contains(method.getName())) {
                return;
            }
            JavaEvaluator evaluator = this.context.getEvaluator();
            if (!evaluator.isMemberInClass((PsiMember)method, WebViewApiAvailabilityDetector.WEBVIEW_CLASS_NAME)) {
                return;
            }
            LintClient client = this.context.getClient();
            ApiLookup apiLookup2 = ApiLookup.get(client, this.context.getProject().getBuildTarget());
            if (apiLookup2 == null) {
                return;
            }
            ApiLookup apiLookup3 = apiLookup = apiLookup2;
            String string = method.getName();
            String string2 = evaluator.getMethodDescription(method, false, false);
            Intrinsics.checkNotNull((Object)string2);
            int api = apiLookup3.getMethodVersion(WebViewApiAvailabilityDetector.WEBVIEW_CLASS_NAME, string, string2);
            if (api == -1 || api <= 21 || api > 28) {
                return;
            }
            if (!VersionChecks.Companion.isWithinVersionCheckConditional$default(VersionChecks.Companion, client, evaluator, (UElement)node, api, false, 16, null)) {
                return;
            }
            Incident incident = new Incident(ISSUE, node, this.context.getLocation((UElement)node), "Consider using `WebViewCompat." + method.getName() + "` instead which will support more devices.");
            this.context.report(incident);
        }
    }
}

