/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.utils.DomExtensions;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/WearableConfigurationActionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "foundAction", "Lorg/w3c/dom/Element;", "foundCategory", "foundMetaData", "afterScanningManifest", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "beforeScanningManifest", "checkMergedProject", "visitIntentFilterTag", "intentFilter", "visitManifestElement", "", "element", "visitMetaData", "metaData", "Issues", "android.sdktools.lint-checks"})
public final class WearableConfigurationActionDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @Nullable
    private Element foundAction;
    @Nullable
    private Element foundCategory;
    @Nullable
    private Element foundMetaData;
    @NotNull
    public static final String WEARABLE_CONFIGURATION_ACTION = "com.google.android.wearable.watchface.wearableConfigurationAction";
    @NotNull
    public static final String CATEGORY_WEARABLE_CONFIGURATION = "com.google.android.wearable.watchface.category.WEARABLE_CONFIGURATION";
    @NotNull
    public static final String WATCH_FACE_EDITOR_ACTION = "androidx.wear.watchface.editor.action.WATCH_FACE_EDITOR";
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    public void checkMergedProject(@NotNull Context context2) {
        Object object;
        LintModelLibrary lintModelLibrary;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object2 = context2.getProject().getBuildVariant();
        LintModelLibrary lintModelLibrary2 = object2 == null ? null : (lintModelLibrary = (object = object2.getMainArtifact()) == null ? null : object.findCompileDependency("androidx.wear.watchface:watchface"));
        if (lintModelLibrary == null) {
            return;
        }
        this.beforeScanningManifest();
        object = context2.getMainProject().getMergedManifest();
        Object object3 = object2 = object == null ? null : object.getDocumentElement();
        if (object2 == null) {
            return;
        }
        Object document = object2;
        DomExtensions.visitElements((Element)document, (Function1)((Function1)new Function1<Element, Boolean>(this){
            final /* synthetic */ WearableConfigurationActionDetector this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return WearableConfigurationActionDetector.access$visitManifestElement(this.this$0, it);
            }
        }));
        this.afterScanningManifest(context2);
    }

    private final void beforeScanningManifest() {
        this.foundAction = null;
        this.foundCategory = null;
        this.foundMetaData = null;
    }

    private final void afterScanningManifest(Context context2) {
        Element foundMetaData = this.foundMetaData;
        Element foundCategory = this.foundCategory;
        Element foundAction = this.foundAction;
        if (foundMetaData != null && foundAction == null) {
            context2.report(new Incident(ISSUE, foundMetaData, Context.getLocation$default(context2, foundMetaData.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name"), null, 2, null), "Watch face configuration activity is missing"));
        } else if (foundMetaData != null && foundAction != null && foundCategory == null) {
            context2.report(new Incident(ISSUE, foundAction, Context.getLocation$default(context2, foundAction, null, 2, null), "Watch face configuration tag is required"), Constraints.minSdkLessThan(30));
        } else if (foundAction != null && foundMetaData == null) {
            context2.report(new Incident(ISSUE, foundAction, Context.getLocation$default(context2, foundAction.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name"), null, 2, null), "`wearableConfigurationAction` metadata is missing"), Constraints.minSdkLessThan(30));
        }
    }

    private final boolean visitManifestElement(Element element) {
        String string = element.getTagName();
        if (Intrinsics.areEqual((Object)string, (Object)"meta-data")) {
            this.visitMetaData(element);
        } else if (Intrinsics.areEqual((Object)string, (Object)"intent-filter")) {
            this.visitIntentFilterTag(element);
        }
        return false;
    }

    private final void visitMetaData(Element metaData) {
        if (Intrinsics.areEqual((Object)metaData.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)WEARABLE_CONFIGURATION_ACTION) && Intrinsics.areEqual((Object)metaData.getAttributeNS("http://schemas.android.com/apk/res/android", "value"), (Object)WATCH_FACE_EDITOR_ACTION)) {
            this.foundMetaData = metaData;
        }
    }

    private final void visitIntentFilterTag(Element intentFilter) {
        Element tmpCategory = null;
        Element tmpAction = null;
        Iterator iterator = DomExtensions.childrenIterator((Node)intentFilter);
        boolean bl = false;
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Node child = (Node)iterator2.next();
            Object object = child instanceof Element ? (Element)child : null;
            if (object == null) continue;
            object = ((Element)child).getTagName();
            if (Intrinsics.areEqual((Object)object, (Object)"action")) {
                if (!Intrinsics.areEqual((Object)((Element)child).getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)WATCH_FACE_EDITOR_ACTION)) continue;
                tmpAction = (Element)child;
                continue;
            }
            if (!Intrinsics.areEqual((Object)object, (Object)"category") || !Intrinsics.areEqual((Object)((Element)child).getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)CATEGORY_WEARABLE_CONFIGURATION)) continue;
            tmpCategory = (Element)child;
        }
        if (tmpAction != null) {
            this.foundAction = tmpAction;
            this.foundCategory = tmpCategory;
        }
    }

    public static final /* synthetic */ boolean access$visitManifestElement(WearableConfigurationActionDetector $this, Element element) {
        return $this.visitManifestElement(element);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(WearableConfigurationActionDetector.class, Scope.MANIFEST_SCOPE);
        ISSUE = Issue.Companion.create$default(companion, "WearableConfigurationAction", "Wear configuration action metadata must match an activity", "\n                If and only if a watch face service defines `wearableConfigurationAction` metadata, with the value `WATCH_FACE_EDITOR`, \\\n                there should be an activity in the same package, which has an intent filter for `WATCH_FACE_EDITOR` \\\n                (with com.google.android.wearable.watchface.category.WEARABLE_CONFIGURATION if minSdkVersion is less than 30).\n            ", implementation, "https://developer.android.com/training/wearables/watch-faces/configuration", category, 5, severity, false, true, null, null, 3328, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/WearableConfigurationActionDetector$Issues;", "", "()V", "CATEGORY_WEARABLE_CONFIGURATION", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "WATCH_FACE_EDITOR_ACTION", "WEARABLE_CONFIGURATION_ACTION", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

