/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.CharSequences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;

public class Utf8Detector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create("EnforceUTF8", "Encoding used in resource files is not UTF-8", "XML supports encoding in a wide variety of character sets. However, not all tools handle the XML encoding attribute correctly, and nearly all Android apps use UTF-8, so by using UTF-8 you can protect yourself against subtle bugs when using non-ASCII characters.\n\nIn particular, the Android Gradle build system will merge resource XML files assuming the resource files are using UTF-8 encoding.\n", Category.I18N, 5, Severity.FATAL, new Implementation(Utf8Detector.class, Scope.RESOURCE_FILE_SCOPE));
    private static final Pattern ENCODING_PATTERN = Pattern.compile("encoding=['\"](\\S*)['\"]");

    @Override
    public void visitDocument(XmlContext context2, Document document) {
        Matcher matcher;
        char c;
        int lineEnd;
        if (context2.getResourceFolderType() == ResourceFolderType.RAW) {
            return;
        }
        CharSequence xml = context2.getContents();
        if (xml == null) {
            return;
        }
        int max = xml.length();
        for (lineEnd = 0; lineEnd < max && (c = xml.charAt(lineEnd)) != '\n' && c != '\r'; ++lineEnd) {
        }
        for (int i = 16; i < lineEnd - 5; ++i) {
            if (xml.charAt(i) != 'u' && xml.charAt(i) != 'U' || xml.charAt(i + 1) != 't' && xml.charAt(i + 1) != 'T' || xml.charAt(i + 2) != 'f' && xml.charAt(i + 2) != 'F' || xml.charAt(i + 3) != '-' && xml.charAt(i + 3) != '_' || xml.charAt(i + 4) != '8') continue;
            return;
        }
        int encodingIndex = CharSequences.lastIndexOf((CharSequence)xml, (String)"encoding", (int)lineEnd);
        if (encodingIndex != -1 && (matcher = ENCODING_PATTERN.matcher(xml)).find(encodingIndex)) {
            String encoding = matcher.group(1);
            Location location2 = Location.create(context2.file, xml, matcher.start(1), matcher.end(1));
            LintFix fix = this.fix().replace().all().with("utf-8").build();
            context2.report(ISSUE, null, location2, String.format("%1$s: Not using UTF-8 as the file encoding. This can lead to subtle bugs with non-ascii characters", encoding), fix);
        }
    }
}

