/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.DomExtensions;
import com.android.utils.SdkUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.CharDirectionality;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/checks/TypographyDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "checkDashes", "", "checkEllipsis", "checkFractions", "checkMisc", "checkQuotes", "appliesTo", "folderType", "Lcom/android/resources/ResourceFolderType;", "beforeCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "checkText", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "textNode", "Lorg/w3c/dom/Node;", "text", "", "getApplicableElements", "", "visitElement", "Companion", "android.sdktools.lint-checks"})
public final class TypographyDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean checkDashes;
    private boolean checkQuotes;
    private boolean checkFractions;
    private boolean checkEllipsis;
    private boolean checkMisc;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(TypographyDetector.class, Scope.RESOURCE_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue DASHES;
    @JvmField
    @NotNull
    public static final Issue QUOTES;
    @JvmField
    @NotNull
    public static final Issue FRACTIONS;
    @JvmField
    @NotNull
    public static final Issue ELLIPSIS;
    @JvmField
    @NotNull
    public static final Issue OTHER;
    @NotNull
    private static final String GRAVE_QUOTE_MESSAGE = "Avoid quoting with grave accents; use apostrophes or better yet directional quotes instead";
    @NotNull
    private static final String ELLIPSIS_MESSAGE = "Replace \"...\" with ellipsis character (\u2026, &#8230;) ?";
    @NotNull
    private static final String EN_DASH_MESSAGE = "Replace \"-\" with an \"en dash\" character (\u2013, &#8211;) ?";
    @NotNull
    private static final String EM_DASH_MESSAGE = "Replace \"--\" with an \"em dash\" character (\u2014, &#8212;) ?";
    @NotNull
    private static final String TYPOGRAPHIC_APOSTROPHE_MESSAGE = "Replace apostrophe (') with typographic apostrophe (\u2019, &#8217;) ?";
    @NotNull
    private static final String SINGLE_QUOTE_MESSAGE = "Replace straight quotes ('') with directional quotes (\u2018\u2019, &#8216; and &#8217;) ?";
    @NotNull
    private static final String DBL_QUOTES_MESSAGE = "Replace straight quotes (\") with directional quotes (\u201c\u201d, &#8220; and &#8221;) ?";
    @NotNull
    private static final String COPYRIGHT_MESSAGE = "Replace (c) with copyright symbol \u00a9 (&#169;) ?";
    @NotNull
    private static final Pattern HYPHEN_RANGE_PATTERN;
    @NotNull
    private static final Pattern GRAVE_QUOTATION;
    @NotNull
    private static final Pattern FRACTION_PATTERN;
    @NotNull
    private static final Pattern SINGLE_QUOTE;
    @NotNull
    private static final String FRACTION_MESSAGE = "Use fraction character %1$c (%2$s) instead of %3$s?";

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES;
    }

    @NotNull
    public List<String> getApplicableElements() {
        Object[] objectArray = new String[]{"string", "string-array", "plurals"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void beforeCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.checkDashes = context2.isEnabled(DASHES);
        this.checkQuotes = context2.isEnabled(QUOTES);
        this.checkFractions = context2.isEnabled(FRACTIONS);
        this.checkEllipsis = context2.isEnabled(ELLIPSIS);
        this.checkMisc = context2.isEnabled(OTHER);
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (SdkUtils.isServiceKey((String)element.getAttribute("name"))) {
            return;
        }
        Attr translatable = element.getAttributeNode("translatable");
        if (translatable != null && !Intrinsics.areEqual((Object)translatable.getValue(), (Object)"true")) {
            return;
        }
        Iterator iterator = DomExtensions.childrenIterator((Node)element);
        boolean bl = false;
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Node child = (Node)iterator2.next();
            if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                String text = child.getNodeValue();
                Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                this.checkText(context2, element, child, text);
                continue;
            }
            if (child.getNodeType() != 1 || !Intrinsics.areEqual((Object)child.getParentNode().getNodeName(), (Object)"string-array") && !Intrinsics.areEqual((Object)child.getParentNode().getNodeName(), (Object)"plurals")) continue;
            Iterator iterator3 = DomExtensions.childrenIterator((Node)child);
            boolean bl2 = false;
            Iterator iterator4 = iterator3;
            while (iterator4.hasNext()) {
                Node item = (Node)iterator4.next();
                if (item.getNodeType() != 3 && item.getNodeType() != 4) continue;
                String text = item.getNodeValue();
                Element element2 = (Element)child;
                Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                this.checkText(context2, element2, item, text);
            }
        }
    }

    private final void checkText(XmlContext context2, Element element, Node textNode, String text) {
        Matcher matcher;
        int hyphen;
        int ellipsis;
        if (this.checkEllipsis && (ellipsis = StringsKt.indexOf$default((CharSequence)text, (String)"...", (int)0, (boolean)false, (int)6, null)) != -1 && !StringsKt.startsWith$default((String)text, (String)".", (int)(ellipsis + 3), (boolean)false, (int)4, null)) {
            context2.report(ELLIPSIS, element, context2.getLocation(textNode), ELLIPSIS_MESSAGE, this.fix().replace().text("...").with("\u2026").build());
        }
        if (this.checkDashes && (hyphen = StringsKt.indexOf$default((CharSequence)text, (char)'-', (int)0, (boolean)false, (int)6, null)) != -1) {
            int emDash;
            Matcher matcher2 = HYPHEN_RANGE_PATTERN.matcher(text);
            if (matcher2.matches()) {
                boolean isNegativeNumber;
                boolean bl = isNegativeNumber = !Character.isWhitespace(matcher2.group(2).charAt(0)) && Character.isWhitespace(matcher2.group(1).charAt(matcher2.group(1).length() - 1));
                if (!isNegativeNumber && !TypographyDetector.Companion.isAnalyticsTrackingId(element)) {
                    context2.report(DASHES, element, context2.getLocation(textNode), EN_DASH_MESSAGE, TypographyDetector.Companion.isRtl(text) ? null : this.fix().replace().text("-").with("\u2013").build());
                }
            }
            if ((emDash = StringsKt.indexOf$default((CharSequence)text, (String)"--", (int)0, (boolean)false, (int)6, null)) > 1 && !StringsKt.startsWith$default((String)text, (String)"-", (int)(emDash + 2), (boolean)false, (int)4, null)) {
                context2.report(DASHES, element, context2.getLocation(textNode), EM_DASH_MESSAGE, TypographyDetector.Companion.isRtl(text) ? null : this.fix().replace().text("--").with("\u2014").build());
            }
        }
        if (this.checkQuotes) {
            int quoteEnd;
            int quoteStart = StringsKt.indexOf$default((CharSequence)text, (char)'\'', (int)0, (boolean)false, (int)6, null);
            if (quoteStart != -1) {
                int quoteEnd2 = StringsKt.indexOf$default((CharSequence)text, (char)'\'', (int)(quoteStart + 1), (boolean)false, (int)4, null);
                if (quoteEnd2 != -1 && quoteEnd2 > quoteStart + 1 && (quoteEnd2 < text.length() - 1 || quoteStart > 0) && SINGLE_QUOTE.matcher(text).matches()) {
                    Node node = element;
                    Location location2 = context2.getLocation(textNode);
                    LintFix.ReplaceStringBuilder replaceStringBuilder = this.fix().replace();
                    String emDash = text;
                    int n = quoteEnd2 + 1;
                    boolean bl = false;
                    String string = emDash;
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = string.substring(quoteStart, n);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    LintFix.ReplaceStringBuilder replaceStringBuilder2 = replaceStringBuilder.text(string2);
                    StringBuilder stringBuilder = new StringBuilder().append('\u2018');
                    emDash = text;
                    n = quoteStart + 1;
                    bl = false;
                    String string3 = emDash;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n, quoteEnd2);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    context2.report(QUOTES, node, location2, SINGLE_QUOTE_MESSAGE, replaceStringBuilder2.with(stringBuilder.append(string4).append('\u2019').toString()).build());
                    return;
                }
                if (quoteEnd2 == -1 && quoteStart > 0 && Character.isLetterOrDigit(text.charAt(quoteStart - 1))) {
                    context2.report(QUOTES, element, context2.getLocation(textNode), TYPOGRAPHIC_APOSTROPHE_MESSAGE, this.fix().replace().text("'").with("\u2019").build());
                    return;
                }
            }
            if ((quoteStart = StringsKt.indexOf$default((CharSequence)text, (char)'\"', (int)0, (boolean)false, (int)6, null)) != -1 && (quoteEnd = StringsKt.indexOf$default((CharSequence)text, (char)'\"', (int)(quoteStart + 1), (boolean)false, (int)4, null)) != -1 && quoteEnd > quoteStart + 1 && (quoteEnd < text.length() - 1 || quoteStart > 0)) {
                Node node = element;
                Location location3 = context2.getLocation(textNode);
                LintFix.ReplaceStringBuilder replaceStringBuilder = this.fix().replace();
                String emDash = text;
                int n = quoteEnd + 1;
                boolean bl = false;
                String string = emDash;
                if (string == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string.substring(quoteStart, n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                LintFix.ReplaceStringBuilder replaceStringBuilder3 = replaceStringBuilder.text(string5);
                StringBuilder stringBuilder = new StringBuilder().append('\u201c');
                emDash = text;
                n = quoteStart + 1;
                bl = false;
                String string6 = emDash;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n, quoteEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                context2.report(QUOTES, node, location3, DBL_QUOTES_MESSAGE, replaceStringBuilder3.with(stringBuilder.append(string7).append('\u201d').toString()).build());
                return;
            }
            int graveStart = StringsKt.indexOf$default((CharSequence)text, (char)'`', (int)0, (boolean)false, (int)6, null);
            if (graveStart != -1 && GRAVE_QUOTATION.matcher(text).matches()) {
                LintFix lintFix;
                boolean bl;
                int n;
                String string;
                int quoteEnd3 = StringsKt.indexOf$default((CharSequence)text, (String)"'", (int)0, (boolean)false, (int)6, null);
                if (text.charAt(graveStart + 1) == '`') {
                    LintFix.ReplaceStringBuilder replaceStringBuilder = this.fix().replace();
                    string = text;
                    n = quoteEnd3 + 2;
                    bl = false;
                    String string8 = string;
                    if (string8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string9 = string8.substring(graveStart, n);
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    LintFix.ReplaceStringBuilder replaceStringBuilder4 = replaceStringBuilder.text(string9);
                    StringBuilder stringBuilder = new StringBuilder().append('\u201c');
                    string = text;
                    n = graveStart + 2;
                    bl = false;
                    String string10 = string;
                    if (string10 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string11 = string10.substring(n, quoteEnd3);
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    lintFix = replaceStringBuilder4.with(stringBuilder.append(string11).append('\u201d').toString()).build();
                } else {
                    LintFix.ReplaceStringBuilder replaceStringBuilder = this.fix().replace();
                    string = text;
                    n = quoteEnd3 + 1;
                    bl = false;
                    String string12 = string;
                    if (string12 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string13 = string12.substring(graveStart, n);
                    Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    LintFix.ReplaceStringBuilder replaceStringBuilder5 = replaceStringBuilder.text(string13);
                    StringBuilder stringBuilder = new StringBuilder().append('\u2018');
                    string = text;
                    n = graveStart + 1;
                    bl = false;
                    String string14 = string;
                    if (string14 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string15 = string14.substring(n, quoteEnd3);
                    Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    lintFix = replaceStringBuilder5.with(stringBuilder.append(string15).append('\u2019').toString()).build();
                }
                LintFix quickfix = lintFix;
                context2.report(QUOTES, element, context2.getLocation(textNode), GRAVE_QUOTE_MESSAGE, quickfix);
                return;
            }
        }
        if (this.checkFractions && StringsKt.indexOf$default((CharSequence)text, (char)'/', (int)0, (boolean)false, (int)6, null) != -1 && (matcher = FRACTION_PATTERN.matcher(text)).matches()) {
            String top = matcher.group(1);
            String bottom = matcher.group(2);
            if (Intrinsics.areEqual((Object)top, (Object)"1") && Intrinsics.areEqual((Object)bottom, (Object)"2")) {
                Node node = element;
                Location location4 = context2.getLocation(textNode);
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = FRACTION_MESSAGE;
                Object[] objectArray = new Object[]{Character.valueOf('\u00bd'), "&#189;", "1/2"};
                boolean bl = false;
                String string16 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"java.lang.String.format(format, *args)");
                context2.report(FRACTIONS, node, location4, string16, this.fix().replace().text("1/2").with("\u00bd").build());
            } else if (Intrinsics.areEqual((Object)top, (Object)"1") && Intrinsics.areEqual((Object)bottom, (Object)"4")) {
                Node node = element;
                Location location5 = context2.getLocation(textNode);
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = FRACTION_MESSAGE;
                Object[] objectArray = new Object[]{Character.valueOf('\u00bc'), "&#188;", "1/4"};
                boolean bl = false;
                String string17 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"java.lang.String.format(format, *args)");
                context2.report(FRACTIONS, node, location5, string17, this.fix().replace().text("1/4").with("\u00bc").build());
            } else if (Intrinsics.areEqual((Object)top, (Object)"3") && Intrinsics.areEqual((Object)bottom, (Object)"4")) {
                Node node = element;
                Location location6 = context2.getLocation(textNode);
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = FRACTION_MESSAGE;
                Object[] objectArray = new Object[]{Character.valueOf('\u00be'), "&#190;", "3/4"};
                boolean bl = false;
                String string18 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"java.lang.String.format(format, *args)");
                context2.report(FRACTIONS, node, location6, string18, this.fix().replace().text("3/4").with("\u00be").build());
            } else if (Intrinsics.areEqual((Object)top, (Object)"1") && Intrinsics.areEqual((Object)bottom, (Object)"3")) {
                Node node = element;
                Location location7 = context2.getLocation(textNode);
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = FRACTION_MESSAGE;
                Object[] objectArray = new Object[]{Character.valueOf('\u2153'), "&#8531;", "1/3"};
                boolean bl = false;
                String string19 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"java.lang.String.format(format, *args)");
                context2.report(FRACTIONS, node, location7, string19, this.fix().replace().text("1/3").with("\u2153").build());
            } else if (Intrinsics.areEqual((Object)top, (Object)"2") && Intrinsics.areEqual((Object)bottom, (Object)"3")) {
                Node node = element;
                Location location8 = context2.getLocation(textNode);
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = FRACTION_MESSAGE;
                Object[] objectArray = new Object[]{Character.valueOf('\u2154'), "&#8532;", "2/3"};
                boolean bl = false;
                String string20 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string20, (String)"java.lang.String.format(format, *args)");
                context2.report(FRACTIONS, node, location8, string20, this.fix().replace().text("2/3").with("\u2154").build());
            }
        }
        if (this.checkMisc && StringsKt.indexOf$default((CharSequence)text, (char)'(', (int)0, (boolean)false, (int)6, null) != -1 && (StringsKt.contains$default((CharSequence)text, (CharSequence)"(c)", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)text, (CharSequence)"(C)", (boolean)false, (int)2, null))) {
            context2.report(OTHER, element, context2.getLocation(textNode), COPYRIGHT_MESSAGE, this.fix().replace().text(StringsKt.contains$default((CharSequence)text, (CharSequence)"(c)", (boolean)false, (int)2, null) ? "(c)" : "(C)").with("\u00a9").build());
        }
    }

    static {
        Object object = Issue.Companion;
        Category category = Category.TYPOGRAPHY;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        DASHES = Issue.Companion.create$default((Issue.Companion)object, "TypographyDashes", "Hyphen can be replaced with dash", "\n                        The \"n dash\" (\\u2013, &#8211;) and the \"m dash\" (\\u2014, &#8212;) \\\n                        characters are used for ranges (n dash) and breaks (m dash). Using these \\\n                        instead of plain hyphens can make text easier to read and your application \\\n                        will look more polished.\n                        ", implementation, "https://en.wikipedia.org/wiki/Dash", category, 5, severity, false, null, null, null, 3840, null);
        object = Issue.Companion;
        category = Category.TYPOGRAPHY;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        QUOTES = Issue.Companion.create$default((Issue.Companion)object, "TypographyQuotes", "Straight quotes can be replaced with curvy quotes", "\n                        Straight single quotes and double quotes, when used as a pair, can be replaced by \\\n                        \"curvy quotes\" (or directional quotes). This can make the text more readable. Note that you \\\n                        should never use grave accents and apostrophes to quote, `like this'. (Also note that you \\\n                        should not use curvy quotes for code fragments.)\n                        ", implementation, "https://en.wikipedia.org/wiki/Quotation_mark", category, 5, severity, false, null, null, null, 3584, null);
        object = Issue.Companion;
        category = Category.TYPOGRAPHY;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        FRACTIONS = Issue.Companion.create$default((Issue.Companion)object, "TypographyFractions", "Fraction string can be replaced with fraction character", "\n                        You can replace certain strings, such as 1/2, and 1/4, with dedicated \\\n                        characters for these, such as \u00bd (&#189;) and \u00bc (&#188;). \\\n                        This can help make the text more readable.\n                        ", implementation, "https://en.wikipedia.org/wiki/Number_Forms", category, 5, severity, false, null, null, null, 3840, null);
        object = Issue.Companion;
        category = Category.TYPOGRAPHY;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        ELLIPSIS = Issue.Companion.create$default((Issue.Companion)object, "TypographyEllipsis", "Ellipsis string can be replaced with ellipsis character", "\n                    You can replace the string \"...\" with a dedicated ellipsis character, \\\n                    ellipsis character (\\u2026, &#8230;). This can help make the text more readable.\n                    ", implementation, "https://en.wikipedia.org/wiki/Ellipsis", category, 5, severity, false, null, null, null, 3840, null);
        OTHER = Issue.Companion.create("TypographyOther", "Other typographical problems", "This check looks for miscellaneous typographical problems and offers replacement \\\n                    sequences that will make the text easier to read and your application more \\\n                    polished.\n                    ", Category.TYPOGRAPHY, 3, Severity.WARNING, IMPLEMENTATION);
        object = Pattern.compile(".*(\\d+\\s*)-(\\s*\\d+).*");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compile(\".*(\\\\d+\\\\s*)-(\\\\s*\\\\d+).*\")");
        HYPHEN_RANGE_PATTERN = object;
        object = Pattern.compile("(^[^`]*`[^'`]+'[^']*$)|(^[^`]*``[^'`]+''[^']*$)");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compile(\"(^[^`]*`[^'`]+'\u2026^[^`]*``[^'`]+''[^']*$)\")");
        GRAVE_QUOTATION = object;
        object = Pattern.compile(".*\\b([13])\\s*/\\s*([234])\\b.*");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compile(\".*\\\\b([13])\\\\s*/\\\\s*([234])\\\\b.*\")");
        FRACTION_PATTERN = object;
        object = Pattern.compile(".*\\W*'[^']+'(\\W.*)?", 256);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compile(\".*\\\\W*'[^']+'(\\\u2026.UNICODE_CHARACTER_CLASS)");
        SINGLE_QUOTE = object;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/checks/TypographyDetector$Companion;", "", "()V", "COPYRIGHT_MESSAGE", "", "DASHES", "Lcom/android/tools/lint/detector/api/Issue;", "DBL_QUOTES_MESSAGE", "ELLIPSIS", "ELLIPSIS_MESSAGE", "EM_DASH_MESSAGE", "EN_DASH_MESSAGE", "FRACTIONS", "FRACTION_MESSAGE", "FRACTION_PATTERN", "Ljava/util/regex/Pattern;", "GRAVE_QUOTATION", "GRAVE_QUOTE_MESSAGE", "HYPHEN_RANGE_PATTERN", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "OTHER", "QUOTES", "SINGLE_QUOTE", "SINGLE_QUOTE_MESSAGE", "TYPOGRAPHIC_APOSTROPHE_MESSAGE", "isAnalyticsTrackingId", "", "element", "Lorg/w3c/dom/Element;", "isRtl", "string", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isAnalyticsTrackingId(Element element) {
            String name = element.getAttribute("name");
            return Intrinsics.areEqual((Object)"ga_trackingId", (Object)name);
        }

        private final boolean isRtl(String string) {
            boolean bl;
            block1: {
                CharSequence $this$any$iv = string;
                boolean $i$f$any = false;
                CharSequence charSequence = $this$any$iv;
                for (int i = 0; i < charSequence.length(); ++i) {
                    char element$iv;
                    char c = element$iv = charSequence.charAt(i);
                    boolean bl2 = false;
                    CharDirectionality directionality = CharsKt.getDirectionality((char)c);
                    boolean bl3 = directionality == CharDirectionality.RIGHT_TO_LEFT || directionality == CharDirectionality.RIGHT_TO_LEFT_ARABIC || directionality == CharDirectionality.RIGHT_TO_LEFT_EMBEDDING || directionality == CharDirectionality.RIGHT_TO_LEFT_OVERRIDE;
                    if (!bl3) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

