/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.FloatRangeConstraint;
import com.android.tools.lint.checks.IntRangeConstraint;
import com.android.tools.lint.checks.RangeConstraint;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.annotations.VisibleForTesting;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B'\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0010\u001a\u00020\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0004J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\u0001H\u0016\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006J;\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u001b\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010\u001cJ \u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0016H\u0016J\u000e\u0010!\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0006J\b\u0010\"\u001a\u00020\u0016H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/checks/SizeConstraint;", "Lcom/android/tools/lint/checks/RangeConstraint;", "range", "Lcom/android/tools/lint/checks/IntRangeConstraint;", "(Lcom/android/tools/lint/checks/IntRangeConstraint;)V", "exact", "", "min", "max", "multiple", "(JJJJ)V", "getExact", "()J", "getMax", "getMin", "getMultiple", "and", "other", "contains", "", "(Lcom/android/tools/lint/checks/RangeConstraint;)Ljava/lang/Boolean;", "describe", "", "argument", "Lorg/jetbrains/uast/UExpression;", "unit", "actualValue", "skipPrefix", "(Lorg/jetbrains/uast/UExpression;Ljava/lang/String;Ljava/lang/Long;Z)Ljava/lang/String;", "describeDelta", "actual", "actualLabel", "allowedLabel", "isValid", "toString", "Companion", "android.sdktools.lint-checks"})
public final class SizeConstraint
extends RangeConstraint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long exact;
    private final long min;
    private final long max;
    private final long multiple;

    private SizeConstraint(long exact, long min, long max, long multiple) {
        this.exact = exact;
        this.min = min;
        this.max = max;
        this.multiple = multiple;
    }

    public final long getExact() {
        return this.exact;
    }

    public final long getMin() {
        return this.min;
    }

    public final long getMax() {
        return this.max;
    }

    public final long getMultiple() {
        return this.multiple;
    }

    public SizeConstraint(@NotNull IntRangeConstraint range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(range.getFrom() == range.getTo() ? range.getFrom() : -1L, range.getFrom(), range.getTo(), 1L);
    }

    @NotNull
    public String toString() {
        return SizeConstraint.describe$default(this, null, null, null, false, 8, null);
    }

    public final boolean isValid(long actual) {
        return !(this.exact != -1L ? this.exact != actual : actual < this.min || actual > this.max || actual % this.multiple != 0L);
    }

    @NotNull
    public final String describe(long argument) {
        return SizeConstraint.describe$default(this, null, null, argument, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final String describe(@Nullable UExpression argument, @Nullable String unit, @Nullable Long actualValue, boolean skipPrefix) {
        String actualUnit;
        Object object;
        String string = unit;
        String string2 = string == null ? (((object = argument) == null ? null : object.getExpressionType()) != null && Intrinsics.areEqual((Object)((object = argument.getExpressionType()) == null ? null : object.getCanonicalText()), (Object)"java.lang.String") ? "Length" : "Size") : (actualUnit = string);
        if (actualValue != null && !this.isValid(actualValue)) {
            long actual = actualValue;
            if (this.exact != -1L) {
                if (this.exact != actual) {
                    return "Expected " + actualUnit + ' ' + this.exact + " (was " + actual + ')';
                }
            } else {
                if (actual < this.min || actual > this.max) {
                    StringBuilder sb = new StringBuilder(20);
                    if (actual < this.min) {
                        sb.append("Expected ").append(actualUnit).append(" \u2265 ");
                        sb.append(String.valueOf(this.min));
                    } else {
                        boolean bl = actual > this.max;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        if (_Assertions.ENABLED && !bl) {
                            boolean bl4 = false;
                            String string3 = "Assertion failed";
                            throw (Throwable)((Object)new AssertionError((Object)string3));
                        }
                        sb.append("Expected ").append(actualUnit).append(" \u2264 ");
                        sb.append(String.valueOf(this.max));
                    }
                    sb.append(" (was ").append(actual).append(')');
                    String string4 = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"sb.toString()");
                    return string4;
                }
                if (actual % this.multiple != 0L) {
                    return "Expected " + actualUnit + " to be a multiple of " + this.multiple + " (was " + actual + " and should be either " + actual / this.multiple * this.multiple + " or " + (actual / this.multiple + 1L) * this.multiple + ')';
                }
            }
        }
        StringBuilder sb = new StringBuilder(20);
        if (!skipPrefix) {
            sb.append(actualUnit);
            sb.append(" must be ");
        }
        if (this.exact != -1L) {
            sb.append("exactly ");
            sb.append(String.valueOf(this.exact));
            object = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sb.toString()");
            return object;
        }
        boolean continued = true;
        if (this.min != Long.MIN_VALUE && this.max != Long.MAX_VALUE) {
            sb.append("at least ");
            sb.append(String.valueOf(this.min));
            sb.append(" and at most ");
            sb.append(String.valueOf(this.max));
        } else if (this.min != Long.MIN_VALUE) {
            sb.append("at least ");
            sb.append(String.valueOf(this.min));
        } else if (this.max != Long.MAX_VALUE) {
            sb.append("at most ");
            sb.append(String.valueOf(this.max));
        } else {
            continued = false;
        }
        if (this.multiple != 1L) {
            if (continued) {
                sb.append(" and ");
            }
            sb.append("a multiple of ");
            sb.append(String.valueOf(this.multiple));
        }
        if (actualValue != null) {
            sb.append(" (was ").append(actualValue).append(')');
        }
        String string5 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"sb.toString()");
        return string5;
    }

    public static /* synthetic */ String describe$default(SizeConstraint sizeConstraint, UExpression uExpression, String string, Long l, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            uExpression = null;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            l = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return sizeConstraint.describe(uExpression, string, l, bl);
    }

    @Override
    @NotNull
    public String describeDelta(@NotNull RangeConstraint actual, @NotNull String actualLabel, @NotNull String allowedLabel) {
        long other;
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)actualLabel, (String)"actualLabel");
        Intrinsics.checkNotNullParameter((Object)allowedLabel, (String)"allowedLabel");
        if (!(actual instanceof SizeConstraint)) {
            return SizeConstraint.describe$default(this, null, null, null, false, 15, null);
        }
        if (((SizeConstraint)actual).exact != -1L) {
            return this.describe(((SizeConstraint)actual).exact);
        }
        if (this.multiple != 1L && (other = ((SizeConstraint)actual).multiple) % this.multiple != 0L) {
            StringBuilder sb = new StringBuilder(SizeConstraint.describe$default(this, null, null, null, false, 15, null)).append(", but ");
            CharSequence charSequence = actualLabel;
            boolean bl = false;
            if (charSequence.length() > 0) {
                sb.append(actualLabel).append(" ");
            }
            if (((SizeConstraint)actual).multiple == 1L) {
                sb.append(Intrinsics.stringPlus((String)"is not a multiple of ", (Object)this.multiple));
            } else {
                sb.append(Intrinsics.stringPlus((String)"can be a multiple of ", (Object)((SizeConstraint)actual).multiple));
            }
            charSequence = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
            return charSequence;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(SizeConstraint.describe$default(this, null, null, null, false, 14, null));
        sb.append(", but ");
        CharSequence charSequence = actualLabel;
        boolean bl = false;
        if (charSequence.length() > 0) {
            sb.append(actualLabel).append(" ");
        }
        sb.append("can be ");
        if (this.max < ((SizeConstraint)actual).min && ((SizeConstraint)actual).max != Long.MAX_VALUE || this.min > ((SizeConstraint)actual).max && ((SizeConstraint)actual).min != Long.MIN_VALUE) {
            sb.append(((SizeConstraint)actual).describe(null, null, null, true));
            charSequence = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
            return charSequence;
        }
        if (((SizeConstraint)actual).min < this.min) {
            if (((SizeConstraint)actual).min == Long.MIN_VALUE) {
                sb.append(Intrinsics.stringPlus((String)"less than ", (Object)this.min));
            } else {
                sb.append(String.valueOf(((SizeConstraint)actual).min));
            }
        } else if (((SizeConstraint)actual).max > this.max) {
            if (((SizeConstraint)actual).max == Long.MAX_VALUE) {
                sb.append(Intrinsics.stringPlus((String)"greater than ", (Object)this.max));
            } else {
                sb.append(String.valueOf(((SizeConstraint)actual).max));
            }
        } else {
            charSequence = "There's no delta";
            bl = false;
            throw (Throwable)new IllegalStateException(((Object)charSequence).toString());
        }
        charSequence = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    @Override
    @NotNull
    public RangeConstraint and(@Nullable RangeConstraint other) {
        SizeConstraint sizeConstraint;
        RangeConstraint rangeConstraint = other;
        if (rangeConstraint == null) {
            return this;
        }
        RangeConstraint rangeConstraint2 = other;
        if (rangeConstraint2 instanceof SizeConstraint) {
            sizeConstraint = (SizeConstraint)other;
        } else if (rangeConstraint2 instanceof IntRangeConstraint) {
            sizeConstraint = new SizeConstraint((IntRangeConstraint)other);
        } else if (rangeConstraint2 instanceof FloatRangeConstraint) {
            sizeConstraint = new SizeConstraint(new IntRangeConstraint((FloatRangeConstraint)other));
        } else {
            String string = other.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"other.javaClass.name");
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        SizeConstraint range = sizeConstraint;
        long l = this.exact != -1L ? this.exact : this.min;
        long l2 = range.exact != -1L ? range.exact : range.min;
        boolean bl = false;
        long start2 = Math.max(l, l2);
        l2 = this.exact != -1L ? this.exact : this.max;
        long l3 = range.exact != -1L ? range.exact : range.max;
        boolean bl2 = false;
        long end2 = Math.min(l2, l3);
        return new SizeConstraint(start2 == end2 ? start2 : -1L, start2, end2, this.multiple);
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull RangeConstraint other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other instanceof SizeConstraint) {
            Boolean bl;
            if (this.exact != -1L && ((SizeConstraint)other).exact != -1L) {
                return this.exact == ((SizeConstraint)other).exact;
            }
            if (this.multiple != 1L && (((SizeConstraint)other).exact != -1L ? ((SizeConstraint)other).exact % this.multiple != 0L : ((SizeConstraint)other).multiple % this.multiple != 0L)) {
                return false;
            }
            if (((SizeConstraint)other).exact != -1L) {
                long l = this.min;
                long l2 = this.max;
                long l3 = ((SizeConstraint)other).exact;
                bl = l <= l3 ? l3 <= l2 : false;
            } else {
                bl = ((SizeConstraint)other).min >= this.min && ((SizeConstraint)other).max <= this.max;
            }
            return bl;
        }
        return null;
    }

    @JvmOverloads
    @NotNull
    public final String describe(@Nullable UExpression argument, @Nullable String unit, @Nullable Long actualValue) {
        return SizeConstraint.describe$default(this, argument, unit, actualValue, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final String describe(@Nullable UExpression argument, @Nullable String unit) {
        return SizeConstraint.describe$default(this, argument, unit, null, false, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final String describe(@Nullable UExpression argument) {
        return SizeConstraint.describe$default(this, argument, null, null, false, 14, null);
    }

    @JvmOverloads
    @NotNull
    public final String describe() {
        return SizeConstraint.describe$default(this, null, null, null, false, 15, null);
    }

    @JvmStatic
    @NotNull
    public static final SizeConstraint create(@NotNull UAnnotation annotation) {
        return Companion.create(annotation);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final SizeConstraint exactly(long value) {
        return Companion.exactly(value);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final SizeConstraint atLeast(long value) {
        return Companion.atLeast(value);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final SizeConstraint atMost(long value) {
        return Companion.atMost(value);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final SizeConstraint range(long from, long to) {
        return Companion.range(from, to);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final SizeConstraint multiple(int multiple) {
        return Companion.multiple(multiple);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final SizeConstraint rangeWithMultiple(long from, long to, int multiple) {
        return Companion.rangeWithMultiple(from, to, multiple);
    }

    public /* synthetic */ SizeConstraint(long exact, long min, long max, long multiple, DefaultConstructorMarker $constructor_marker) {
        this(exact, min, max, multiple);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0007J \u0010\u0012\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/SizeConstraint$Companion;", "", "()V", "atLeast", "Lcom/android/tools/lint/checks/SizeConstraint;", "value", "", "atMost", "create", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "exactly", "minWithMultiple", "from", "multiple", "", "range", "to", "rangeWithMultiple", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SizeConstraint create(@NotNull UAnnotation annotation) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            boolean bl = AnnotationDetectorKt.SIZE_ANNOTATION.isEquals(annotation.getQualifiedName());
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            long exact = UastLintUtils.Companion.getAnnotationLongValue(annotation, "value", -1L);
            long min = UastLintUtils.Companion.getAnnotationLongValue(annotation, "min", Long.MIN_VALUE);
            long max = UastLintUtils.Companion.getAnnotationLongValue(annotation, "max", Long.MAX_VALUE);
            long multiple = UastLintUtils.Companion.getAnnotationLongValue(annotation, "multiple", 1L);
            return new SizeConstraint(exact, min, max, multiple, null);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final SizeConstraint exactly(long value) {
            return new SizeConstraint(value, Long.MIN_VALUE, Long.MAX_VALUE, 1L, null);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final SizeConstraint atLeast(long value) {
            return new SizeConstraint(-1L, value, Long.MAX_VALUE, 1L, null);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final SizeConstraint atMost(long value) {
            return new SizeConstraint(-1L, Long.MIN_VALUE, value, 1L, null);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final SizeConstraint range(long from, long to) {
            return new SizeConstraint(-1L, from, to, 1L, null);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final SizeConstraint multiple(int multiple) {
            return new SizeConstraint(-1L, Long.MIN_VALUE, Long.MAX_VALUE, multiple, null);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final SizeConstraint rangeWithMultiple(long from, long to, int multiple) {
            return new SizeConstraint(-1L, from, to, multiple, null);
        }

        @VisibleForTesting
        @NotNull
        public final SizeConstraint minWithMultiple(long from, int multiple) {
            return new SizeConstraint(-1L, from, Long.MAX_VALUE, multiple, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

