/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RtlDetector
extends LayoutDetector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(RtlDetector.class, EnumSet.of(Scope.RESOURCE_FILE, Scope.JAVA_FILE, Scope.MANIFEST), Scope.RESOURCE_FILE_SCOPE, Scope.JAVA_FILE_SCOPE, Scope.MANIFEST_SCOPE);
    public static final Issue USE_START = Issue.create("RtlHardcoded", "Using left/right instead of start/end attributes", "Using `Gravity#LEFT` and `Gravity#RIGHT` can lead to problems when a layout is rendered in locales where text flows from right to left. Use `Gravity#START` and `Gravity#END` instead. Similarly, in XML `gravity` and `layout_gravity` attributes, use `start` rather than `left`.\n\nFor XML attributes such as paddingLeft and `layout_marginLeft`, use `paddingStart` and `layout_marginStart`. **NOTE**: If your `minSdkVersion` is less than 17, you should add **both** the older left/right attributes **as well as** the new start/end attributes. On older platforms, where RTL is not supported and the start/end attributes are unknown and therefore ignored, you need the older left/right attributes. There is a separate lint check which catches that type of error.\n\n(Note: For `Gravity#LEFT` and `Gravity#START`, you can use these constants even when targeting older platforms, because the `start` bitmask is a superset of the `left` bitmask. Therefore, you can use `gravity=\"start\"` rather than `gravity=\"left|start\"`.)", Category.RTL, 5, Severity.WARNING, IMPLEMENTATION);
    public static final Issue COMPAT = Issue.create("RtlCompat", "Right-to-left text compatibility issues", "API 17 adds a `textAlignment` attribute to specify text alignment. However, if you are supporting older versions than API 17, you must **also** specify a gravity or layout_gravity attribute, since older platforms will ignore the `textAlignment` attribute.", Category.RTL, 6, Severity.ERROR, IMPLEMENTATION);
    public static final Issue SYMMETRY = Issue.create("RtlSymmetry", "Padding and margin symmetry", "If you specify padding or margin on the left side of a layout, you should probably also specify padding on the right side (and vice versa) for right-to-left layout symmetry.", Category.RTL, 6, Severity.WARNING, IMPLEMENTATION);
    public static final Issue ENABLED = Issue.create("RtlEnabled", "Using RTL attributes without enabling RTL support", "To enable right-to-left support, when running on API 17 and higher, you must set the `android:supportsRtl` attribute in the manifest `<application>` element.\n\nIf you have started adding RTL attributes, but have not yet finished the migration, you can set the attribute to false to satisfy this lint check.", Category.RTL, 3, Severity.WARNING, IMPLEMENTATION);
    private static final String RIGHT_FIELD = "RIGHT";
    private static final String LEFT_FIELD = "LEFT";
    private static final String FQCN_GRAVITY = "android.view.Gravity";
    static final String ATTR_SUPPORTS_RTL = "supportsRtl";
    private static final int RTL_API = 17;
    private static final String LEFT = "Left";
    private static final String START = "Start";
    private static final String RIGHT = "Right";
    private static final String END = "End";
    private Boolean mEnabledRtlSupport;
    private boolean mUsesRtlAttributes;
    private boolean mSpecifiesRtlMode;
    @VisibleForTesting
    static final String[] ATTRIBUTES = new String[]{"layout_alignParentLeft", "layout_alignParentStart", "layout_alignParentRight", "layout_alignParentEnd", "layout_marginLeft", "layout_marginStart", "layout_marginRight", "layout_marginEnd", "paddingLeft", "paddingStart", "paddingRight", "paddingEnd", "drawableLeft", "drawableStart", "drawableRight", "drawableEnd", "listPreferredItemPaddingLeft", "listPreferredItemPaddingStart", "listPreferredItemPaddingRight", "listPreferredItemPaddingEnd", "layout_toLeftOf", "layout_toStartOf", "layout_toRightOf", "layout_toEndOf", "layout_alignLeft", "layout_alignStart", "layout_alignRight", "layout_alignEnd"};
    private static final int APPLIES_TARGET_PRE_17 = 1;
    private static final int APPLIES_REQUIRES_RTL = 2;
    private static final int APPLIES_MIN_PRE_17 = 4;
    private static final int APPLIES_MIN_17 = 8;
    private static final int APPLIES_FOLDER_OR_MIN_17 = 16;
    private static final String KEY_APPLIES = "applies";

    private boolean rtlApplies(Context context2) {
        Project project = context2.getMainProject();
        if (project.getTargetSdk() < 17) {
            return false;
        }
        if (this.mEnabledRtlSupport != null && !this.mEnabledRtlSupport.booleanValue()) {
            return false;
        }
        if (this.mEnabledRtlSupport == null) {
            this.mEnabledRtlSupport = RtlDetector.getMergedManifestRtlSetting(context2);
            if (this.mEnabledRtlSupport == null) {
                this.mEnabledRtlSupport = false;
            }
            return this.mEnabledRtlSupport;
        }
        return true;
    }

    private static Boolean getMergedManifestRtlSetting(Context context2) {
        Project mainProject = context2.getMainProject();
        Document mergedManifest = mainProject.getMergedManifest();
        if (mergedManifest == null) {
            return null;
        }
        Element root = mergedManifest.getDocumentElement();
        if (root == null) {
            return null;
        }
        Element application = XmlUtils.getFirstSubTagByName((Node)root, (String)"application");
        if (application == null) {
            return null;
        }
        String rtlSupported = application.getAttributeNS("http://schemas.android.com/apk/res/android", ATTR_SUPPORTS_RTL);
        return !"false".equals(rtlSupported);
    }

    @Override
    public boolean filterIncident(Context context2, Incident incident, LintMap map) {
        int flags = map.getInt(KEY_APPLIES, 0);
        if (this.applies(context2, flags, incident.getLocation().getFile())) {
            String message2 = incident.getMessage();
            if (message2.contains("%s")) {
                String minApi = context2.getMainProject().getMinSdkVersion().getApiString();
                incident.setMessage(String.format(message2, minApi));
            }
            return true;
        }
        return false;
    }

    private boolean applies(Context context2, int flags, File location2) {
        if ((flags & 2) != 0 && !this.rtlApplies(context2)) {
            return false;
        }
        if ((flags & 1) != 0 && context2.getMainProject().getTargetSdk() >= 17) {
            return false;
        }
        if ((flags & 0x10) != 0) {
            return context2.getProject().getMinSdk() >= 17 || RtlDetector.getFolderVersion(location2) >= 17;
        }
        if ((flags & 8) != 0) {
            return context2.getMainProject().getMinSdk() >= 17;
        }
        if ((flags & 4) != 0) {
            return context2.getMainProject().getMinSdk() < 17;
        }
        return true;
    }

    static int getFolderVersion(File resourceFile) {
        return RtlDetector.getFolderVersion(resourceFile.getPath());
    }

    static int getFolderVersion(String path2) {
        int i;
        for (i = path2.length() - 1; i >= 0; --i) {
            char c = path2.charAt(i);
            if (c != '/' && c != '\\') continue;
            --i;
            break;
        }
        if (i != 0) {
            VersionQualifier qualifier;
            String folderName;
            FolderConfiguration config;
            int j;
            boolean haveDash = false;
            for (j = i; j >= 0; --j) {
                char c = path2.charAt(j);
                if (c == '/' || c == '\\') {
                    ++j;
                    break;
                }
                if (c != '-') continue;
                haveDash = true;
            }
            if (haveDash && (config = FolderConfiguration.getConfigForFolder((String)(folderName = path2.substring(Math.max(j, 0), i + 1)))) != null && (qualifier = config.getVersionQualifier()) != null) {
                return qualifier.getVersion();
            }
        }
        return -1;
    }

    @Override
    public void afterCheckRootProject(Context context2) {
        List<File> manifestFile;
        if (this.mUsesRtlAttributes && !this.mSpecifiesRtlMode && !(manifestFile = context2.getProject().getManifestFiles()).isEmpty()) {
            Location location2 = Location.create(manifestFile.get(0));
            context2.report(new Incident(ENABLED, location2, "The project references RTL attributes, but does not explicitly enable or disable RTL support with `android:supportsRtl` in the manifest"), this.map().put(KEY_APPLIES, 2));
        }
    }

    public static boolean isRtlAttributeName(String attribute) {
        for (int i = 1; i < ATTRIBUTES.length; i += 2) {
            if (!attribute.equals(ATTRIBUTES[i])) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static String convertOldToNew(String attribute) {
        if (attribute.contains(LEFT)) {
            return attribute.replace(LEFT, START);
        }
        return attribute.replace(RIGHT, END);
    }

    static String convertNewToOld(String attribute) {
        if (attribute.contains(START)) {
            return attribute.replace(START, LEFT);
        }
        return attribute.replace(END, RIGHT);
    }

    @VisibleForTesting
    static String convertToOppositeDirection(String attribute) {
        if (attribute.contains(LEFT)) {
            return attribute.replace(LEFT, RIGHT);
        }
        if (attribute.contains(RIGHT)) {
            return attribute.replace(RIGHT, LEFT);
        }
        if (attribute.contains(START)) {
            return attribute.replace(START, END);
        }
        return attribute.replace(END, START);
    }

    static String getTextAlignmentToGravity(String attribute) {
        if (attribute.equals("center")) {
            return "center_horizontal";
        }
        if (attribute.endsWith(START)) {
            return "start";
        }
        if (attribute.endsWith(END)) {
            return "end";
        }
        return null;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        int size = ATTRIBUTES.length + 4;
        ArrayList<String> attributes = new ArrayList<String>(size);
        attributes.add(ATTR_SUPPORTS_RTL);
        attributes.add("gravity");
        attributes.add("layout_gravity");
        attributes.add("textAlignment");
        Collections.addAll(attributes, ATTRIBUTES);
        assert (attributes.size() == size) : attributes.size();
        return attributes;
    }

    @Override
    public void visitAttribute(XmlContext context2, Attr attribute) {
        boolean isOld;
        Element element;
        String value = attribute.getValue();
        if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
            return;
        }
        String name = attribute.getLocalName();
        assert (name != null) : attribute.getName();
        if (name.equals(ATTR_SUPPORTS_RTL)) {
            this.mSpecifiesRtlMode = true;
            this.mEnabledRtlSupport = Boolean.valueOf(value);
            if (!attribute.getOwnerElement().getTagName().equals("application")) {
                context2.report(new Incident(ENABLED, attribute, context2.getLocation(attribute), String.format("Wrong declaration: `%1$s` should be defined on the `<application>` element", attribute.getName())));
            }
            if (this.mEnabledRtlSupport.booleanValue() && context2.getProject().getMinSdk() < 17) {
                String message2 = String.format(Locale.getDefault(), "You must set `android:targetSdkVersion` to at least %1$d when enabling RTL support", 17);
                this.reportRtl(context2, ENABLED, attribute, context2.getValueLocation(attribute), message2, null, 1);
            }
            return;
        }
        if (name.equals("textAlignment")) {
            String gravitySpec;
            Attr gravityNode;
            if (context2.getProject().getReportIssues()) {
                this.mUsesRtlAttributes = true;
            }
            if ((element = attribute.getOwnerElement()).hasAttributeNS("http://schemas.android.com/apk/res/android", "gravity")) {
                gravityNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "gravity");
                gravitySpec = gravityNode.getValue();
            } else if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_gravity")) {
                gravityNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_gravity");
                gravitySpec = gravityNode.getValue();
            } else {
                if (context2.getProject().getMinSdk() < 17) {
                    String expectedGravity;
                    int folderVersion = context2.getFolderVersion();
                    if (folderVersion < 17 && context2.isEnabled(COMPAT) && (expectedGravity = RtlDetector.getTextAlignmentToGravity(value)) != null) {
                        String string = String.format(Locale.getDefault(), "To support older versions than API 17 (project specifies %%s) you must **also** specify `gravity` or `layout_gravity=\"%1$s\"`", expectedGravity);
                        LintFix fix1 = this.fix().set("http://schemas.android.com/apk/res/android", "gravity", expectedGravity).build();
                        LintFix fix2 = this.fix().set("http://schemas.android.com/apk/res/android", "layout_gravity", expectedGravity).build();
                        LintFix fix = this.fix().alternatives(fix1, fix2);
                        this.reportRtl(context2, COMPAT, attribute, context2.getNameLocation(attribute), string, fix, 6);
                    }
                    return;
                }
                return;
            }
            String expectedGravity = RtlDetector.getTextAlignmentToGravity(value);
            if (expectedGravity != null && context2.isEnabled(COMPAT)) {
                ArrayList<String> gravities = new ArrayList<String>();
                for (String g2 : gravitySpec.split("\\|")) {
                    g2 = g2.trim();
                    gravities.add(g2);
                    if (g2.equals("center")) {
                        gravities.add("center_horizontal");
                        gravities.add("center_vertical");
                    }
                    if (!g2.equals("fill")) continue;
                    gravities.add("fill_horizontal");
                    gravities.add("fill_vertical");
                }
                if (gravities.stream().noneMatch(g -> g.equals(expectedGravity))) {
                    String string = String.format("Inconsistent alignment specification between `textAlignment` and `gravity` attributes: was `%1$s`, expected `%2$s`", gravitySpec, expectedGravity);
                    Location location2 = context2.getValueLocation(attribute);
                    Location secondary = context2.getValueLocation(gravityNode);
                    secondary.setMessage("Incompatible direction here");
                    location2.setSecondary(secondary);
                    this.reportRtl(context2, COMPAT, attribute, location2, string, null, 2);
                }
            }
        }
        if (name.equals("gravity") || name.equals("layout_gravity")) {
            boolean isLeft = value.contains("left");
            boolean isRight = value.contains("right");
            if (!isLeft && !isRight) {
                if ((value.contains("start") || value.contains("end")) && context2.getProject().getReportIssues()) {
                    this.mUsesRtlAttributes = true;
                }
                return;
            }
            String message4 = String.format("Use \"`%1$s`\" instead of \"`%2$s`\" to ensure correct behavior in right-to-left locales", isLeft ? "start" : "end", isLeft ? "left" : "right");
            if (context2.isEnabled(USE_START)) {
                this.reportRtl(context2, USE_START, attribute, context2.getValueLocation(attribute), message4, null, 2);
            }
            return;
        }
        element = attribute.getOwnerElement();
        boolean isPaddingAttribute = RtlDetector.isPaddingAttribute(name);
        if (isPaddingAttribute || RtlDetector.isMarginAttribute(name)) {
            String opposite = RtlDetector.convertToOppositeDirection(name);
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", opposite)) {
                String oldValue = element.getAttributeNS("http://schemas.android.com/apk/res/android", opposite);
                if (value.equals(oldValue)) {
                    return;
                }
            } else if (isPaddingAttribute && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", RtlDetector.isOldAttribute(opposite) ? RtlDetector.convertOldToNew(opposite) : RtlDetector.convertNewToOld(opposite)) && context2.isEnabled(SYMMETRY)) {
                String message5 = String.format("When you define `%1$s` you should probably also define `%2$s` for right-to-left symmetry", name, opposite);
                this.reportRtl(context2, SYMMETRY, attribute, context2.getNameLocation(attribute), message5, null, 2);
            }
        }
        if (isOld = RtlDetector.isOldAttribute(name)) {
            if (!context2.isEnabled(USE_START)) {
                return;
            }
            String rtl = RtlDetector.convertOldToNew(name);
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", rtl)) {
                String message6 = String.format("Redundant attribute `%1$s`; already defining `%2$s` with `targetSdkVersion` %3$s", name, rtl, context2.getProject().getTargetSdk());
                LintFix lintFix = this.fix().unset("http://schemas.android.com/apk/res/android", name).autoFix().build();
                this.reportRtl(context2, USE_START, attribute, context2.getNameLocation(attribute), message6, lintFix, 18);
            } else {
                String message2;
                if (context2.getProject().getMinSdk() < 17 && context2.getFolderVersion() < 17) {
                    message2 = String.format("Consider adding `%1$s:%2$s=\"%3$s\"` to better support right-to-left layouts", attribute.getPrefix(), rtl, value);
                    LintFix lintFix = this.fix().name(String.format("Add %1$s:%2$s=\"%3$s\"", attribute.getPrefix(), rtl, value)).set(attribute.getNamespaceURI(), rtl, attribute.getValue()).build();
                    this.reportRtl(context2, USE_START, attribute, context2.getNameLocation(attribute), message2, lintFix, 4);
                }
                message2 = String.format("Consider replacing `%1$s` with `%2$s:%3$s=\"%4$s\"` to better support right-to-left layouts", attribute.getName(), attribute.getPrefix(), rtl, value);
                LintFix lintFix = this.fix().replace().name(String.format("Replace with %1$s:%2$s=\"%3$s\"", attribute.getPrefix(), rtl, value)).text(name).with(rtl).build();
                this.reportRtl(context2, USE_START, attribute, context2.getNameLocation(attribute), message2, lintFix, 10);
            }
        } else {
            if (context2.getProject().getMinSdk() >= 17 || !context2.isEnabled(COMPAT)) {
                return;
            }
            int folderVersion = context2.getFolderVersion();
            if (folderVersion >= 17) {
                return;
            }
            String old = RtlDetector.convertNewToOld(name);
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", old)) {
                return;
            }
            String string = RtlDetector.convertNewToOld(value);
            String message7 = String.format(Locale.getDefault(), "To support older versions than API 17 (project specifies %%s) you should **also** add `%1$s:%2$s=\"%3$s\"`", attribute.getPrefix(), old, string);
            LintFix fix = this.fix().set(attribute.getNamespaceURI(), old, string).build();
            this.reportRtl(context2, COMPAT, attribute, context2.getNameLocation(attribute), message7, fix, 6);
        }
    }

    private void reportRtl(XmlContext context2, Issue issue, Node scope, Location nameLocation, String message2, LintFix fix, int constraint2) {
        Incident incident = new Incident(issue, scope, nameLocation, message2, fix);
        context2.report(incident, this.map().put(KEY_APPLIES, constraint2));
    }

    private static boolean isOldAttribute(String name) {
        return name.contains(LEFT) || name.contains(RIGHT);
    }

    private static boolean isMarginAttribute(String name) {
        return name.startsWith("layout_margin");
    }

    private static boolean isPaddingAttribute(String name) {
        return name.startsWith("padding");
    }

    @Override
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(USimpleNameReferenceExpression.class);
    }

    @Override
    public UElementHandler createUastHandler(JavaContext context2) {
        return new IdentifierChecker(context2);
    }

    static {
        if (Lint.assertionsEnabled()) {
            for (int i = 0; i < ATTRIBUTES.length; i += 2) {
                String replace = ATTRIBUTES[i];
                String with = ATTRIBUTES[i + 1];
                assert (with.equals(RtlDetector.convertOldToNew(replace)));
                assert (replace.equals(RtlDetector.convertNewToOld(with)));
            }
        }
    }

    private static class IdentifierChecker
    extends UElementHandler {
        private final JavaContext context;

        public IdentifierChecker(JavaContext context2) {
            this.context = context2;
        }

        @Override
        public void visitSimpleNameReferenceExpression(USimpleNameReferenceExpression element) {
            String identifier = element.getIdentifier();
            boolean isLeft = RtlDetector.LEFT_FIELD.equals(identifier);
            boolean isRight = RtlDetector.RIGHT_FIELD.equals(identifier);
            if (!isLeft && !isRight) {
                return;
            }
            PsiElement resolved = element.resolve();
            if (!(resolved instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)resolved;
            if (!this.context.getEvaluator().isMemberInClass((PsiMember)field, RtlDetector.FQCN_GRAVITY)) {
                return;
            }
            String message2 = String.format("Use \"`Gravity.%1$s`\" instead of \"`Gravity.%2$s`\" to ensure correct behavior in right-to-left locales", (isLeft ? "start" : "end").toUpperCase(Locale.US), (isLeft ? "left" : "right").toUpperCase(Locale.US));
            Location location2 = this.context.getLocation((UElement)element);
            Incident incident = new Incident(USE_START, element, location2, message2);
            this.context.report(incident, new LintMap().put(RtlDetector.KEY_APPLIES, 2));
        }
    }
}

