/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.detector.api.BinaryResourceScanner;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelModule;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResourcePrefixDetector
extends Detector
implements BinaryResourceScanner,
XmlScanner {
    public static final Issue ISSUE = Issue.create("ResourceName", "Resource with Wrong Prefix", "In Gradle projects you can specify a resource prefix that all resources in the project must conform to. This makes it easier to ensure that you don't accidentally combine resources from different libraries, since they all end up in the same shared app namespace.", Category.CORRECTNESS, 8, Severity.FATAL, new Implementation(ResourcePrefixDetector.class, EnumSet.of(Scope.RESOURCE_FILE, Scope.BINARY_RESOURCE_FILE), Scope.RESOURCE_FILE_SCOPE, Scope.BINARY_RESOURCE_FILE_SCOPE));
    private String mPrefix;
    private String mUnderlinePrefix;
    private String mCamelPrefix;

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("resources", "declare-styleable");
    }

    private static String computeResourcePrefix(Project project) {
        LintModelModule model = project.getBuildModule();
        if (model != null) {
            return model.getResourcePrefix();
        }
        return null;
    }

    private void updatePrefix(Context context2) {
        if (context2 == null) {
            this.mCamelPrefix = null;
            this.mUnderlinePrefix = null;
            this.mPrefix = null;
        } else {
            this.mPrefix = ResourcePrefixDetector.computeResourcePrefix(context2.getProject());
            if (this.mPrefix == null) {
                this.mCamelPrefix = null;
                this.mUnderlinePrefix = null;
            } else if (this.mPrefix.indexOf(95) != -1) {
                this.mUnderlinePrefix = this.mPrefix;
                this.mCamelPrefix = SdkVersionInfo.underlinesToCamelCase((String)this.mPrefix);
            } else {
                this.mCamelPrefix = this.mPrefix;
                this.mUnderlinePrefix = SdkVersionInfo.camelCaseToUnderlines((String)this.mPrefix);
            }
        }
    }

    @Override
    public void beforeCheckEachProject(Context context2) {
        this.updatePrefix(context2);
    }

    @Override
    public void afterCheckEachProject(Context context2) {
        this.updatePrefix(null);
    }

    @Override
    public void beforeCheckFile(Context context2) {
        String name;
        XmlContext xmlContext;
        ResourceFolderType folderType;
        if (this.mPrefix != null && context2 instanceof XmlContext && (folderType = (xmlContext = (XmlContext)context2).getResourceFolderType()) != null && folderType != ResourceFolderType.VALUES && !ResourcePrefixDetector.libraryPrefixMatches(this.mUnderlinePrefix, name = Lint.getBaseName(context2.file.getName()))) {
            Element root;
            if (xmlContext.document != null && (root = xmlContext.document.getDocumentElement()) != null) {
                xmlContext.report(ISSUE, root, xmlContext.getElementLocation(root), this.getErrorMessage(name, folderType));
                return;
            }
            context2.report(ISSUE, Location.create(context2.file), this.getErrorMessage(name, folderType));
        }
    }

    private String getErrorMessage(String name, ResourceFolderType folderType) {
        assert (this.mPrefix != null && !name.startsWith(this.mPrefix));
        return String.format("Resource named '`%1$s`' does not start with the project's resource prefix '`%2$s`'; rename to '`%3$s`' ?", name, this.mPrefix, Lint.computeResourceName(this.mPrefix, name, folderType));
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        if (this.mPrefix == null || context2.getResourceFolderType() != ResourceFolderType.VALUES) {
            return;
        }
        for (Element item : XmlUtils.getSubTags((Node)element)) {
            String name;
            Attr nameAttribute = item.getAttributeNode("name");
            if (nameAttribute == null || (name = nameAttribute.getValue()).indexOf(58) != -1 || ResourcePrefixDetector.libraryPrefixMatches(this.mUnderlinePrefix, name) || ResourcePrefixDetector.libraryPrefixMatches(this.mCamelPrefix, name)) continue;
            String message2 = this.getErrorMessage(name, ResourceFolderType.VALUES);
            context2.report(ISSUE, nameAttribute, context2.getLocation(nameAttribute), message2);
        }
    }

    @VisibleForTesting
    static boolean libraryPrefixMatches(String prefix, String name) {
        if (name.startsWith(prefix)) {
            return true;
        }
        if (SdkUtils.startsWithIgnoreCase((String)name, (String)prefix)) {
            return true;
        }
        return prefix.endsWith("_") && name.regionMatches(true, 0, prefix, 0, prefix.length() - 1);
    }

    @Override
    public void checkBinaryResource(ResourceContext context2) {
        String name;
        ResourceFolderType folderType;
        if (this.mUnderlinePrefix != null && (folderType = context2.getResourceFolderType()) != null && folderType != ResourceFolderType.VALUES && !(name = Lint.getBaseName(context2.file.getName())).startsWith(this.mUnderlinePrefix)) {
            String path2 = context2.file.getPath();
            if (path2.endsWith(".bc") && folderType == ResourceFolderType.RAW) {
                return;
            }
            Location location2 = Location.create(context2.file);
            context2.report(ISSUE, location2, this.getErrorMessage(name, folderType));
        }
    }
}

