/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PxUsageDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(PxUsageDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue PX_ISSUE = Issue.create("PxUsage", "Using 'px' dimension", "For performance reasons and to keep the code simpler, the Android system uses pixels as the standard unit for expressing dimension or coordinate values. That means that the dimensions of a view are always expressed in the code using pixels, but always based on the current screen density. For instance, if `myView.getWidth()` returns 10, the view is 10 pixels wide on the current screen, but on a device with a higher density screen, the value returned might be 15. If you use pixel values in your application code to work with bitmaps that are not pre-scaled for the current screen density, you might need to scale the pixel values that you use in your code to match the un-scaled bitmap source.", Category.CORRECTNESS, 2, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://developer.android.com/guide/practices/screens_support.html#screen-independence");
    public static final Issue IN_MM_ISSUE = Issue.create("InOrMmUsage", "Using `mm` or `in` dimensions", "Avoid using `mm` (millimeters) or `in` (inches) as the unit for dimensions.\n\nWhile it should work in principle, unfortunately many devices do not report the correct true physical density, which means that the dimension calculations won't work correctly. You are better off using `dp` (and for font sizes, `sp`).", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
    public static final Issue DP_ISSUE = Issue.create("SpUsage", "Using `dp` instead of `sp` for text sizes", "When setting text sizes, you should normally use `sp`, or \"scale-independent pixels\". This is like the `dp` unit, but it is also scaled by the user's font size preference. It is recommend you use this unit when specifying font sizes, so they will be adjusted for both the screen density and the user's preference.\n\nThere **are** cases where you might need to use `dp`; typically this happens when the text is in a container with a specific dp-size. This will prevent the text from spilling outside the container. Note however that this means that the user's font size settings are not respected, so consider adjusting the layout itself to be more flexible.", Category.CORRECTNESS, 3, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://developer.android.com/training/multiscreen/screendensities.html");
    public static final Issue SMALL_SP_ISSUE = Issue.create("SmallSp", "Text size is too small", "Avoid using sizes smaller than 11sp.", Category.USABILITY, 4, Severity.WARNING, IMPLEMENTATION);

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.VALUES;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("style", "dimen", "item");
    }

    @Override
    public void visitAttribute(XmlContext context2, Attr attribute) {
        block8: {
            String value;
            block11: {
                block10: {
                    block9: {
                        block7: {
                            value = attribute.getValue();
                            if (!value.endsWith("px") || !value.matches("\\d+(\\.\\d+)?px")) break block7;
                            if (PxUsageDetector.isZero(value) || value.equals("1px")) {
                                return;
                            }
                            if (!context2.isEnabled(PX_ISSUE)) break block8;
                            context2.report(PX_ISSUE, attribute, context2.getLocation(attribute), "Avoid using \"`px`\" as units; use \"`dp`\" instead");
                            break block8;
                        }
                        if ((!value.endsWith("mm") || !value.matches("\\d+(\\.\\d+)?mm")) && (!value.endsWith("in") || !value.matches("\\d+(\\.\\d+)?in"))) break block9;
                        if (PxUsageDetector.isZero(value)) {
                            return;
                        }
                        if (!context2.isEnabled(IN_MM_ISSUE)) break block8;
                        String unit = value.substring(value.length() - 2);
                        context2.report(IN_MM_ISSUE, attribute, context2.getLocation(attribute), String.format("Avoid using \"`%1$s`\" as units (it does not work accurately on all devices); use \"`dp`\" instead", unit));
                        break block8;
                    }
                    if (!value.endsWith("sp") || !"textSize".equals(attribute.getLocalName()) && !"layout_height".equals(attribute.getLocalName()) || !value.matches("\\d+(\\.\\d+)?sp")) break block10;
                    int size = PxUsageDetector.getTruncatedSize(value);
                    if (size <= 0 || size >= 11) break block8;
                    context2.report(SMALL_SP_ISSUE, attribute, context2.getLocation(attribute), String.format("Avoid using sizes smaller than `11sp`: `%1$s`", value));
                    break block8;
                }
                if (!"textSize".equals(attribute.getLocalName())) break block8;
                if (!PxUsageDetector.isDpUnit(value)) break block11;
                if (!context2.isEnabled(DP_ISSUE)) break block8;
                context2.report(DP_ISSUE, attribute, context2.getLocation(attribute), "Should use \"`sp`\" instead of \"`dp`\" for text sizes", PxUsageDetector.createDpToSpFix());
                break block8;
            }
            if (value.startsWith("@dimen/")) {
                LintClient client = context2.getClient();
                Project project = context2.getProject();
                ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
                ResourceUrl url = ResourceUrl.parse((String)value);
                if (url != null) {
                    List items = resources.getResources(ResourceNamespace.TODO(), url.type, url.name);
                    for (ResourceItem item : items) {
                        Location secondary;
                        String dimenValue;
                        ResourceValue resourceValue = item.getResourceValue();
                        if (resourceValue == null || (dimenValue = resourceValue.getValue()) == null || !PxUsageDetector.isDpUnit(dimenValue) || !context2.isEnabled(DP_ISSUE)) continue;
                        PathString sourceFile = item.getSource();
                        assert (sourceFile != null);
                        String message2 = String.format("Should use \"`sp`\" instead of \"`dp`\" for text sizes (`%1$s` is defined as `%2$s` in `%3$s`", value, dimenValue, Lint.getFileNameWithParent(client, sourceFile));
                        Location location2 = context2.getLocation(attribute);
                        if (!context2.getDriver().isIsolated() && (secondary = client.getXmlParser().getValueLocation(client, item)) != null) {
                            secondary.setMessage("This dp dimension is used as a text size");
                            location2.setSecondary(secondary);
                        }
                        context2.report(DP_ISSUE, attribute, location2, message2);
                        break;
                    }
                }
            }
        }
    }

    static boolean isZero(String numberWithUnit) {
        if (numberWithUnit.startsWith("0")) {
            for (int i = 1; i < numberWithUnit.length(); ++i) {
                char c = numberWithUnit.charAt(i);
                if (c == '0' || c == '.') continue;
                return !Character.isDigit(c);
            }
            return true;
        }
        return false;
    }

    private static LintFix createDpToSpFix() {
        return LintFix.create().replace().pattern(".*(di?p)").with("sp").build();
    }

    private static boolean isDpUnit(String value) {
        return (value.endsWith("dp") || value.endsWith("dip")) && value.matches("\\d+(\\.\\d+)?di?p");
    }

    private static int getTruncatedSize(String text) {
        assert (text.matches("\\d+(\\.\\d+)?sp")) : text;
        int dot = text.indexOf(46);
        return Integer.parseInt(text.substring(0, dot != -1 ? dot : text.length() - 2));
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        block7: {
            String tagName;
            block6: {
                if (context2.getResourceFolderType() != ResourceFolderType.VALUES) {
                    return;
                }
                tagName = element.getTagName();
                if (!tagName.equals("style")) break block6;
                NodeList itemNodes = element.getChildNodes();
                int nodeCount = itemNodes.getLength();
                for (int j = 0; j < nodeCount; ++j) {
                    Node item = itemNodes.item(j);
                    if (item.getNodeType() != 1 || !"item".equals(item.getNodeName())) continue;
                    Element itemElement = (Element)item;
                    NodeList childNodes = item.getChildNodes();
                    int n = childNodes.getLength();
                    for (int i = 0; i < n; ++i) {
                        Node child = childNodes.item(i);
                        if (child.getNodeType() != 3) {
                            return;
                        }
                        PxUsageDetector.checkItem(context2, itemElement, child);
                    }
                }
                break block7;
            }
            if (!tagName.equals("dimen") && !"dimen".equals(element.getAttribute("type"))) break block7;
            NodeList childNodes = element.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() != 3) {
                    return;
                }
                PxUsageDetector.checkItem(context2, element, child);
            }
        }
    }

    private static void checkItem(XmlContext context2, Element item, Node textNode) {
        String text = textNode.getNodeValue();
        for (int j = text.length() - 1; j > 0; --j) {
            int size;
            String name;
            char c = text.charAt(j);
            if (Character.isWhitespace(c)) continue;
            if (c == 'x' && text.charAt(j - 1) == 'p') {
                if (!(text = text.trim()).matches("\\d+(\\.\\d+)?px") || PxUsageDetector.isZero(text) || text.equals("1px") || !context2.isEnabled(PX_ISSUE)) break;
                context2.report(PX_ISSUE, item, context2.getLocation(textNode), "Avoid using `\"px\"` as units; use `\"dp\"` instead");
                break;
            }
            if (c == 'm' && text.charAt(j - 1) == 'm' || c == 'n' && text.charAt(j - 1) == 'i') {
                text = text.trim();
                String unit = text.substring(text.length() - 2);
                if (!text.matches("\\d+(\\.\\d+)?" + unit) || PxUsageDetector.isZero(text) || !context2.isEnabled(IN_MM_ISSUE)) break;
                context2.report(IN_MM_ISSUE, item, context2.getLocation(textNode), String.format("Avoid using \"`%1$s`\" as units (it does not work accurately on all devices); use \"`dp`\" instead", unit));
                break;
            }
            if (c == 'p' && (text.charAt(j - 1) == 'd' || text.charAt(j - 1) == 'i')) {
                text = text.trim();
                String name2 = item.getAttribute("name");
                if (!name2.equals("textSize") && !name2.equals("android:textSize") || !text.matches("\\d+(\\.\\d+)?di?p") || !context2.isEnabled(DP_ISSUE)) break;
                context2.report(DP_ISSUE, item, context2.getLocation(textNode), "Should use \"`sp`\" instead of \"`dp`\" for text sizes", PxUsageDetector.createDpToSpFix());
                break;
            }
            if (c != 'p' || text.charAt(j - 1) != 's' || !"textSize".equals(name = item.getAttribute("name")) && !"layout_height".equals(name)) break;
            text = text.trim();
            String unit = text.substring(text.length() - 2);
            if (!text.matches("\\d+(\\.\\d+)?" + unit) || !context2.isEnabled(SMALL_SP_ISSUE) || (size = PxUsageDetector.getTruncatedSize(text)) <= 0 || size >= 11) break;
            context2.report(SMALL_SP_ISSUE, item, context2.getLocation(textNode), String.format("Avoid using sizes smaller than `11sp`: `%1$s`", text));
            break;
        }
    }
}

