/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.PermissionDetector;
import com.android.tools.lint.checks.PermissionFinder;
import com.android.tools.lint.checks.PermissionHolder;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Constraint;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.utils.XmlUtils;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 =2\u00020\u00012\u00020\u0002:\u0002<=B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J4\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u001eH\u0002J\"\u0010\u001f\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u001eH\u0002J \u0010&\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001b0\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\bH\u0002J\u001a\u0010/\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u001e2\b\b\u0002\u00100\u001a\u00020\u0005H\u0002J\u0010\u00101\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u00102\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u001eH\u0002J\"\u00103\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001e\u00104\u001a\u00020\b2\u0006\u0010.\u001a\u00020\b2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001b0\nH\u0002J(\u00106\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\u00172\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/android/tools/lint/checks/PermissionDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "mIsAndroidThingsProject", "", "Ljava/lang/Boolean;", "mPermissions", "Lcom/android/tools/lint/checks/PermissionHolder;", "applicableAnnotations", "", "", "checkParameterPermission", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "signature", "method", "Lcom/intellij/psi/PsiMethod;", "argument", "Lorg/jetbrains/uast/UExpression;", "checkPermission", "node", "Lorg/jetbrains/uast/UElement;", "result", "Lcom/android/tools/lint/checks/PermissionFinder$Result;", "requirement", "Lcom/android/tools/lint/checks/PermissionRequirement;", "conditionMet", "createLocalPermissionHolder", "Lcom/android/tools/lint/detector/api/Context;", "createManifestPermissionHolder", "manifest", "Lorg/w3c/dom/Document;", "minSdkVersion", "Lcom/android/sdklib/AndroidVersion;", "targetSdkVersion", "createMergedManifestPermissionHolder", "filterIncident", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getLocalPermissions", "getMissingMessage", "messageFormat", "permissions", "getPermissions", "accessMergedManifest", "handlesSecurityException", "isAndroidThingsProject", "isExactAlarmRequirement", "mergePermissions", "requirements", "visitAnnotationUsage", "element", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "CheckPermissionVisitor", "Companion", "android.sdktools.lint-checks"})
public final class PermissionDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private PermissionHolder mPermissions;
    @Nullable
    private Boolean mIsAndroidThingsProject;
    @NotNull
    public static final String KEY_MISSING_PERMISSIONS = "missing";
    @NotNull
    public static final String KEY_LAST_API = "lastApi";
    @NotNull
    public static final String KEY_REQUIREMENT = "requirement";
    @NotNull
    public static final String KEY_LOCAL_PERMISSION = "local";
    @NotNull
    private static final String KEY_MESSAGE = "message";
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(PermissionDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    private static final String THINGS_LIBRARY = "com.google.android.things";
    @NotNull
    public static final String AOSP_PERMISSION_ANNOTATION = "android.annotation.RequiresPermission";
    @JvmField
    @NotNull
    public static final Issue MISSING_PERMISSION;

    @Override
    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{AnnotationDetectorKt.PERMISSION_ANNOTATION.oldName(), AnnotationDetectorKt.PERMISSION_ANNOTATION.newName(), AnnotationDetectorKt.PERMISSION_ANNOTATION_READ.oldName(), AnnotationDetectorKt.PERMISSION_ANNOTATION_READ.newName(), AnnotationDetectorKt.PERMISSION_ANNOTATION_WRITE.oldName(), AnnotationDetectorKt.PERMISSION_ANNOTATION_WRITE.newName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitAnnotationUsage(@NotNull JavaContext context2, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        PsiMethod method;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        AnnotationUsageType type = usageInfo.getType();
        PsiElement psiElement = usageInfo.getReferenced();
        PsiMethod psiMethod = method = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
        if (type == AnnotationUsageType.METHOD_CALL) {
            PermissionRequirement permissionRequirement = PermissionRequirement.create(annotationInfo.getAnnotation());
            Intrinsics.checkNotNullExpressionValue((Object)permissionRequirement, (String)"create(annotationInfo.annotation)");
            PermissionRequirement requirement = permissionRequirement;
            this.checkPermission(context2, element, method, null, requirement);
        } else if (element instanceof UExpression && method != null) {
            this.checkParameterPermission(context2, annotationInfo.getQualifiedName(), method, (UExpression)element);
        }
    }

    private final void checkParameterPermission(JavaContext context2, String signature, PsiMethod method, UExpression argument) {
        PermissionFinder.Operation operation = null;
        if (AnnotationDetectorKt.PERMISSION_ANNOTATION_READ.isEquals(signature)) {
            operation = PermissionFinder.Operation.READ;
        } else if (AnnotationDetectorKt.PERMISSION_ANNOTATION_WRITE.isEquals(signature)) {
            operation = PermissionFinder.Operation.WRITE;
        } else {
            PsiType type = argument.getExpressionType();
            if (type != null && Intrinsics.areEqual((Object)"android.content.Intent", (Object)type.getCanonicalText())) {
                operation = PermissionFinder.Operation.ACTION;
            }
        }
        if (operation == null) {
            return;
        }
        PermissionFinder.Result result = PermissionFinder.findRequiredPermissions(context2, operation, (UElement)argument);
        if (result != null) {
            UElement uElement = (UElement)argument;
            PermissionRequirement permissionRequirement = result.requirement;
            Intrinsics.checkNotNullExpressionValue((Object)permissionRequirement, (String)"result.requirement");
            this.checkPermission(context2, uElement, method, result, permissionRequirement);
        }
    }

    private final boolean conditionMet(JavaContext context2, PermissionRequirement requirement, PsiMethod method) {
        PsiMethod psiMethod = method;
        if (psiMethod == null) {
            return false;
        }
        return this.isExactAlarmRequirement(requirement, context2, method);
    }

    private final boolean isExactAlarmRequirement(PermissionRequirement requirement, JavaContext context2, PsiMethod method) {
        return requirement.isSingle() && Intrinsics.areEqual((Object)requirement.toString(), (Object)"android.permission.SCHEDULE_EXACT_ALARM") && context2.getEvaluator().isMemberInClass((PsiMember)method, "android.app.AlarmManager");
    }

    private final void checkPermission(JavaContext context2, UElement node, PsiMethod method, PermissionFinder.Result result, PermissionRequirement requirement) {
        List<PermissionRequirement> localPermissionRequirements;
        if (requirement.isConditional() && !this.conditionMet(context2, requirement, method)) {
            return;
        }
        PermissionHolder permissions = PermissionDetector.getPermissions$default(this, context2, false, 2, null);
        if (!requirement.isSatisfied(permissions) && !requirement.isSatisfied(permissions = this.mergePermissions(permissions, localPermissionRequirements = this.getLocalPermissions(node)))) {
            Object where;
            String string;
            Object object;
            UIdentifier callIdentifier;
            Object operation = null;
            String name = null;
            if (result != null) {
                Object object2 = result.name;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"result.name");
                name = object2;
                object2 = result.operation;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"result.operation");
                operation = object2;
            } else {
                String string2;
                boolean bl = method != null;
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string3 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string3));
                }
                PsiMethod psiMethod = method;
                Intrinsics.checkNotNull((Object)psiMethod);
                PsiClass containingClass = psiMethod.getContainingClass();
                if (containingClass != null) {
                    string2 = containingClass.getName() + '.' + method.getName();
                } else {
                    String string4 = method.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n                      \u2026ame\n                    }");
                    string2 = name = string4;
                }
                if (Intrinsics.areEqual((Object)name, (Object)"Builder.setPersisted") && node instanceof UCallExpression && ((UCallExpression)node).getValueArguments().size() == 1 && Intrinsics.areEqual((Object)ConstantEvaluator.evaluate(context2, (UElement)((UCallExpression)node).getValueArguments().get(0)), (Object)false)) {
                    return;
                }
                operation = PermissionFinder.Operation.CALL;
            }
            Location location2 = context2.getLocation(node);
            UCallExpression expressionNode = (UCallExpression)UastUtils.getParentOfType((UElement)node, UCallExpression.class, (boolean)true);
            if (expressionNode != null && (callIdentifier = expressionNode.getMethodIdentifier()) != null && !Intrinsics.areEqual((Object)callIdentifier, (Object)node)) {
                location2 = context2.getRangeLocation((UElement)callIdentifier, 0, node, 0);
            }
            Set<String> missingPermissions = requirement.getMissingPermissions(permissions);
            Constraint constraint2 = null;
            PsiMethod psiMethod = method;
            if (Intrinsics.areEqual((Object)(psiMethod == null ? null : psiMethod.getName()), (Object)"getAllCellInfo") && missingPermissions.size() == 1) {
                Intrinsics.checkNotNullExpressionValue(missingPermissions, (String)"missingPermissions");
                if (Intrinsics.areEqual((Object)CollectionsKt.first((Iterable)missingPermissions), (Object)"android.permission.ACCESS_COARSE_LOCATION") && permissions.hasPermission("android.permission.ACCESS_FINE_LOCATION")) {
                    return;
                }
            }
            String messageFormat = "Missing permissions required " + ((PermissionFinder.Operation)((Object)operation)).prefix() + ' ' + name + ": %1$s";
            LintFix.Builder builder = this.fix();
            Object[] objectArray = new Object[6];
            objectArray[0] = KEY_MESSAGE;
            objectArray[1] = messageFormat;
            objectArray[2] = KEY_MISSING_PERMISSIONS;
            Intrinsics.checkNotNullExpressionValue(missingPermissions, (String)"missingPermissions");
            objectArray[3] = CollectionsKt.toList((Iterable)missingPermissions);
            objectArray[4] = KEY_LAST_API;
            objectArray[5] = requirement.getLastApplicableApi();
            Incident incident = new Incident(MISSING_PERMISSION, node, location2, "", builder.data(objectArray));
            if (this.isExactAlarmRequirement(requirement, context2, method)) {
                String string5;
                constraint2 = Constraints.targetSdkAtLeast(31);
                incident.overrideSeverity(Severity.WARNING);
                object = method;
                if (object == null) {
                    string5 = "";
                } else {
                    string = object.getName();
                    if (string == null) {
                        string5 = "";
                    } else {
                        String string6 = string;
                        boolean bl = false;
                        boolean bl5 = false;
                        String it = string6;
                        boolean bl6 = false;
                        String string7 = " with `" + it + '`';
                        string5 = string7 == null ? "" : string7;
                    }
                }
                where = string5;
                messageFormat = "Setting Exact alarms" + (String)where + " requires the `SCHEDULE_EXACT_ALARM` permission or power exemption from user; it is intended for applications where the user knowingly schedules actions to happen at a precise time such as alarms, clocks, calendars, etc. Check out the javadoc on this permission to make sure your use case is valid.";
            }
            if (context2.isGlobalAnalysis()) {
                where = constraint2;
                if (where == null ? false : !((Constraint)where).accept(context2, incident)) {
                    return;
                }
                incident.setMessage(this.getMissingMessage(messageFormat, requirement, permissions));
                context2.report(incident);
            } else {
                LintMap map = this.map();
                object = requirement.serialize();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"requirement.serialize()");
                map.put(KEY_REQUIREMENT, (String)object);
                map.put(KEY_MESSAGE, messageFormat);
                object = constraint2;
                if (object != null) {
                    string = object;
                    boolean bl = false;
                    boolean bl7 = false;
                    String it = string;
                    boolean bl8 = false;
                    map.put("_condition_", (Constraint)((Object)it));
                }
                object = localPermissionRequirements;
                boolean bl = false;
                if (!object.isEmpty()) {
                    map.put(KEY_LOCAL_PERMISSION, CollectionsKt.joinToString$default((Iterable)localPermissionRequirements, (CharSequence)";", null, null, (int)0, null, (Function1)checkPermission.2.INSTANCE, (int)30, null));
                }
                context2.report(incident, map);
            }
            return;
        }
        if (requirement.isRevocable(permissions) && context2.getProject().getTargetSdkVersion().getFeatureLevel() >= 23 && requirement.getLastApplicableApi() >= 23) {
            boolean handlesMissingPermission = this.handlesSecurityException(node);
            if (!handlesMissingPermission) {
                List<PermissionRequirement> localPermissionRequirements2 = this.getLocalPermissions(node);
                boolean location2 = false;
                location2 = false;
                PermissionHolder localRequirements = this.mergePermissions(new PermissionHolder.SetPermissionLookup(new LinkedHashSet(), new LinkedHashSet(), permissions.getMinSdkVersion(), permissions.getTargetSdkVersion()), localPermissionRequirements2);
                if (requirement.isSatisfied(localRequirements)) {
                    return;
                }
                UMethod methodNode = (UMethod)UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)true);
                if (methodNode != null) {
                    CheckPermissionVisitor visitor2 = new CheckPermissionVisitor(node);
                    methodNode.accept((UastVisitor)visitor2);
                    handlesMissingPermission = visitor2.checksPermission();
                }
            }
            if (!handlesMissingPermission) {
                String message2 = "Call requires permission which may be rejected by user: code should explicitly check to see if permission is available (with `checkPermission`) or explicitly handle a potential `SecurityException`";
                Location location3 = context2.getLocation(node);
                LintFix.Builder builder = this.fix();
                Object[] objectArray = new Object[4];
                objectArray[0] = KEY_MISSING_PERMISSIONS;
                Object object = requirement.getRevocablePermissions(permissions);
                Intrinsics.checkNotNullExpressionValue(object, (String)"requirement.getRevocablePermissions(permissions)");
                objectArray[1] = CollectionsKt.toList((Iterable)((Iterable)object));
                objectArray[2] = KEY_REQUIREMENT;
                object = requirement.serialize();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"requirement.serialize()");
                objectArray[3] = object;
                Incident incident = new Incident(MISSING_PERMISSION, node, location3, message2, builder.data(objectArray));
                context2.report(incident, this.map());
            }
        }
    }

    private final String getMissingMessage(String messageFormat, PermissionRequirement requirement, PermissionHolder permissions) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object[] objectArray = new Object[]{requirement.describeMissingPermissions(permissions)};
        boolean bl = false;
        String string = String.format(messageFormat, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
        return StringsKt.replace$default((String)string, (String)"carrier privileges", (String)"carrier privileges (see TelephonyManager#hasCarrierPrivileges)", (boolean)false, (int)4, null);
    }

    @Override
    public boolean filterIncident(@NotNull Context context2, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        String requirementString = map.getString(KEY_REQUIREMENT, null);
        if (requirementString == null) {
            return !this.isAndroidThingsProject(context2);
        }
        PermissionRequirement permissionRequirement = PermissionRequirement.deserialize(requirementString);
        Intrinsics.checkNotNullExpressionValue((Object)permissionRequirement, (String)"deserialize(requirementString)");
        PermissionRequirement requirement = permissionRequirement;
        PermissionHolder permissions = null;
        permissions = this.getPermissions(context2, true);
        if (requirement.isSatisfied(permissions)) {
            return false;
        }
        Object object = map.getString(KEY_LOCAL_PERMISSION, null);
        if (object != null) {
            String string = object;
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            char[] cArray = new char[]{';'};
            Sequence $this$forEach$iv = StringsKt.splitToSequence$default((CharSequence)it, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String serialized = (String)element$iv;
                boolean bl4 = false;
                PermissionRequirement permissionRequirement2 = PermissionRequirement.deserialize(serialized);
                Intrinsics.checkNotNullExpressionValue((Object)permissionRequirement2, (String)"deserialize(serialized)");
                PermissionRequirement r = permissionRequirement2;
                permissions = this.mergePermissions(permissions, CollectionsKt.listOf((Object)r));
            }
            if (requirement.isSatisfied(permissions)) {
                return false;
            }
        }
        object = map.getConstraint("_condition_");
        if (object == null ? false : !((Constraint)object).accept(context2, incident)) {
            return false;
        }
        String string = map.getString(KEY_MESSAGE, "");
        Intrinsics.checkNotNull((Object)string);
        String messageFormat = string;
        incident.setMessage(this.getMissingMessage(messageFormat, requirement, permissions));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PermissionRequirement> getLocalPermissions(UElement node) {
        void $this$mapTo$iv$iv;
        Object object;
        Object object2;
        UAnnotation uAnnotation;
        UClass containingClass;
        Object object3;
        UClass uClass;
        UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)true);
        if (uMethod == null) {
            return CollectionsKt.emptyList();
        }
        UMethod method = uMethod;
        String string = AnnotationDetectorKt.PERMISSION_ANNOTATION.oldName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PERMISSION_ANNOTATION.oldName()");
        UAnnotation uAnnotation2 = method.findAnnotation(string);
        if (uAnnotation2 == null) {
            uClass = AnnotationDetectorKt.PERMISSION_ANNOTATION.newName();
            Intrinsics.checkNotNullExpressionValue((Object)uClass, (String)"PERMISSION_ANNOTATION.newName()");
            string = method.findAnnotation((String)uClass);
            object3 = string == null ? method.findAnnotation(AOSP_PERMISSION_ANNOTATION) : string;
        } else {
            object3 = uAnnotation2;
        }
        UAnnotation methodAnnotation = object3;
        UClass uClass2 = containingClass = UastUtils.getContainingUClass((UElement)((UElement)method));
        if (uClass2 == null) {
            uAnnotation = null;
        } else {
            object2 = AnnotationDetectorKt.PERMISSION_ANNOTATION.oldName();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"PERMISSION_ANNOTATION.oldName()");
            uAnnotation = uClass = uClass2.findAnnotation((String)object2);
        }
        if (uClass == null) {
            UAnnotation uAnnotation3;
            object2 = containingClass;
            if (object2 == null) {
                uAnnotation3 = null;
            } else {
                String string2 = AnnotationDetectorKt.PERMISSION_ANNOTATION.newName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PERMISSION_ANNOTATION.newName()");
                uAnnotation3 = uClass2 = object2.findAnnotation(string2);
            }
            object = uClass2 == null ? ((object2 = containingClass) == null ? null : object2.findAnnotation(AOSP_PERMISSION_ANNOTATION)) : uClass2;
        } else {
            object = uClass;
        }
        UClass classAnnotation = object;
        uClass = new UClass[]{methodAnnotation, classAnnotation};
        Iterable $this$map$iv = CollectionsKt.listOfNotNull((Object[])uClass);
        boolean $i$f$map = false;
        object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UAnnotation uAnnotation4 = (UAnnotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PermissionRequirement permissionRequirement = PermissionRequirement.create((UAnnotation)it);
            collection.add(permissionRequirement);
        }
        return (List)destination$iv$iv;
    }

    private final PermissionHolder mergePermissions(PermissionHolder permissions, List<? extends PermissionRequirement> requirements) {
        PermissionHolder merged = permissions;
        for (PermissionRequirement permissionRequirement : requirements) {
            PermissionHolder permissionHolder = PermissionHolder.SetPermissionLookup.join(merged, permissionRequirement);
            Intrinsics.checkNotNullExpressionValue((Object)permissionHolder, (String)"join(merged, requirement)");
            merged = permissionHolder;
        }
        return merged;
    }

    private final boolean handlesSecurityException(UElement node) {
        return Companion.handlesException(node, null, false, "java.lang.SecurityException");
    }

    private final PermissionHolder getPermissions(Context context2, boolean accessMergedManifest) {
        PermissionHolder permissionHolder;
        PermissionHolder permissionHolder2 = this.mPermissions;
        if (permissionHolder2 == null) {
            if (accessMergedManifest || context2.isGlobalAnalysis()) {
                PermissionHolder permissionHolder3 = this.createMergedManifestPermissionHolder(context2);
                boolean bl = false;
                boolean bl2 = false;
                PermissionHolder it = permissionHolder3;
                boolean bl3 = false;
                this.mPermissions = it;
                permissionHolder = permissionHolder3;
            } else {
                PermissionHolder permissionHolder4 = this.createLocalPermissionHolder(context2);
                boolean bl = false;
                boolean bl4 = false;
                PermissionHolder it = permissionHolder4;
                boolean bl5 = false;
                this.mPermissions = it;
                permissionHolder = permissionHolder4;
            }
        } else {
            permissionHolder = permissionHolder2;
        }
        return permissionHolder;
    }

    static /* synthetic */ PermissionHolder getPermissions$default(PermissionDetector permissionDetector, Context context2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return permissionDetector.getPermissions(context2, bl);
    }

    private final PermissionHolder createLocalPermissionHolder(Context context2) {
        PermissionHolder permissionHolder;
        Project project = context2.getProject();
        AndroidVersion minSdkVersion = project.getMinSdkVersion();
        AndroidVersion targetSdkVersion = project.getTargetSdkVersion();
        Document dom = project.getManifestDom();
        if (dom != null) {
            Intrinsics.checkNotNullExpressionValue((Object)minSdkVersion, (String)"minSdkVersion");
            Intrinsics.checkNotNullExpressionValue((Object)targetSdkVersion, (String)"targetSdkVersion");
            permissionHolder = this.createManifestPermissionHolder(dom, minSdkVersion, targetSdkVersion);
        } else {
            permissionHolder = new PermissionHolder.SetPermissionLookup(SetsKt.emptySet(), SetsKt.emptySet(), minSdkVersion, targetSdkVersion);
        }
        return permissionHolder;
    }

    private final PermissionHolder createMergedManifestPermissionHolder(Context context2) {
        Project mainProject = context2.getMainProject();
        Document mergedManifest = mainProject.getMergedManifest();
        AndroidVersion minSdkVersion = mainProject.getMinSdkVersion();
        AndroidVersion targetSdkVersion = mainProject.getTargetSdkVersion();
        Intrinsics.checkNotNullExpressionValue((Object)minSdkVersion, (String)"minSdkVersion");
        Intrinsics.checkNotNullExpressionValue((Object)targetSdkVersion, (String)"targetSdkVersion");
        return this.createManifestPermissionHolder(mergedManifest, minSdkVersion, targetSdkVersion);
    }

    private final PermissionHolder createManifestPermissionHolder(Document manifest, AndroidVersion minSdkVersion, AndroidVersion targetSdkVersion) {
        HashSet permissions = Sets.newHashSetWithExpectedSize((int)30);
        HashSet revocable = Sets.newHashSetWithExpectedSize((int)4);
        if (manifest != null) {
            for (Element element : XmlUtils.getSubTags((Node)manifest.getDocumentElement())) {
                String protectionLevel;
                String nodeName = element.getNodeName();
                if (Intrinsics.areEqual((Object)"uses-permission", (Object)nodeName) || Intrinsics.areEqual((Object)"uses-permission-sdk-23", (Object)nodeName) || Intrinsics.areEqual((Object)"uses-permission-sdk-m", (Object)nodeName)) {
                    String name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                    CharSequence charSequence = name;
                    boolean bl = false;
                    if (!(charSequence.length() > 0)) continue;
                    permissions.add(name);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)nodeName, (Object)"permission") || !Intrinsics.areEqual((Object)"dangerous", (Object)(protectionLevel = element.getAttributeNS("http://schemas.android.com/apk/res/android", "protectionLevel")))) continue;
                String name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                CharSequence charSequence = name;
                boolean bl = false;
                if (!(charSequence.length() > 0)) continue;
                revocable.add(name);
            }
        }
        return new PermissionHolder.SetPermissionLookup(permissions, revocable, minSdkVersion, targetSdkVersion);
    }

    private final boolean isAndroidThingsProject(Context context2) {
        if (this.mIsAndroidThingsProject == null) {
            Project project = context2.getMainProject();
            Document document = project.getMergedManifest();
            if (document == null) {
                return false;
            }
            Document mergedManifest = document;
            Element element = mergedManifest.getDocumentElement();
            if (element == null) {
                return false;
            }
            Element manifest = element;
            Element element2 = XmlUtils.getFirstSubTagByName((Node)manifest, (String)"application");
            if (element2 == null) {
                return false;
            }
            Element application = element2;
            Element usesLibrary = XmlUtils.getFirstSubTagByName((Node)application, (String)"uses-library");
            while (usesLibrary != null && this.mIsAndroidThingsProject == null) {
                String name = usesLibrary.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                boolean isThingsLibraryRequired = true;
                String required = usesLibrary.getAttributeNS("http://schemas.android.com/apk/res/android", "required");
                if (Intrinsics.areEqual((Object)"false", (Object)required)) {
                    isThingsLibraryRequired = false;
                }
                if (Intrinsics.areEqual((Object)THINGS_LIBRARY, (Object)name) && isThingsLibraryRequired) {
                    this.mIsAndroidThingsProject = true;
                }
                usesLibrary = XmlUtils.getNextTagByName((Node)usesLibrary, (String)"uses-library");
            }
            if (this.mIsAndroidThingsProject == null) {
                this.mIsAndroidThingsProject = false;
            }
        }
        Boolean bl = this.mIsAndroidThingsProject;
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        MISSING_PERMISSION = Issue.Companion.create$default(companion, "MissingPermission", "Missing Permissions", "\n                This check scans through your code and libraries and looks at the APIs being \\\n                used, and checks this against the set of permissions required to access \\\n                those APIs. If the code using those APIs is called at runtime, then the \\\n                program will crash.\n\n                Furthermore, for permissions that are revocable (with `targetSdkVersion` 23), \\\n                client code must also be prepared to handle the calls throwing an exception \\\n                if the user rejects the request for permission at runtime.", implementation, null, category, 9, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\u0006J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/PermissionDetector$CheckPermissionVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "mTarget", "Lorg/jetbrains/uast/UElement;", "(Lorg/jetbrains/uast/UElement;)V", "mChecksPermission", "", "mDone", "checksPermission", "visitCallExpression", "node", "Lorg/jetbrains/uast/UCallExpression;", "visitElement", "visitMethodCallExpression", "", "android.sdktools.lint-checks"})
    private static final class CheckPermissionVisitor
    extends AbstractUastVisitor {
        @NotNull
        private final UElement mTarget;
        private boolean mChecksPermission;
        private boolean mDone;

        public CheckPermissionVisitor(@NotNull UElement mTarget) {
            Intrinsics.checkNotNullParameter((Object)mTarget, (String)"mTarget");
            this.mTarget = mTarget;
        }

        public boolean visitElement(@NotNull UElement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return this.mDone || super.visitElement(node);
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (UastExpressionUtils.isMethodCall((UElement)((UElement)node))) {
                this.visitMethodCallExpression(node);
            }
            return super.visitCallExpression(node);
        }

        private final void visitMethodCallExpression(UCallExpression node) {
            String name;
            if (node == this.mTarget) {
                this.mDone = true;
            }
            if ((name = node.getMethodName()) != null && (StringsKt.startsWith$default((String)name, (String)"check", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"enforce", (boolean)false, (int)2, null)) && StringsKt.endsWith$default((String)name, (String)"Permission", (boolean)false, (int)2, null)) {
                this.mChecksPermission = true;
                this.mDone = true;
            }
        }

        public final boolean checksPermission() {
            return this.mChecksPermission;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0002J(\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/checks/PermissionDetector$Companion;", "", "()V", "AOSP_PERMISSION_ANNOTATION", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "KEY_LAST_API", "KEY_LOCAL_PERMISSION", "KEY_MESSAGE", "KEY_MISSING_PERMISSIONS", "KEY_REQUIREMENT", "MISSING_PERMISSION", "Lcom/android/tools/lint/detector/api/Issue;", "THINGS_LIBRARY", "containsException", "", "types", "", "Lcom/intellij/psi/PsiType;", "exceptionClass", "Lcom/intellij/psi/PsiClass;", "allowSuperClass", "exceptionClassName", "handlesException", "node", "Lorg/jetbrains/uast/UElement;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean handlesException(@NotNull UElement node, @Nullable PsiClass exceptionClass, boolean allowSuperClass, @NotNull String exceptionClassName) {
            UTryExpression tryCatch;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)exceptionClassName, (String)"exceptionClassName");
            UElement parent = node;
            while ((tryCatch = (UTryExpression)UastUtils.getParentOfType((UElement)parent, UTryExpression.class, (boolean)true)) != null) {
                for (UCatchClause catchClause : tryCatch.getCatchClauses()) {
                    if (!this.containsException(catchClause.getTypes(), exceptionClass, allowSuperClass, exceptionClassName)) continue;
                    return true;
                }
                parent = (UElement)tryCatch;
            }
            UMethod declaration = (UMethod)UastUtils.getParentOfType((UElement)parent, UMethod.class, (boolean)false);
            if (declaration != null) {
                PsiClassType[] thrownTypes = declaration.getThrowsList().getReferencedTypes();
                Intrinsics.checkNotNullExpressionValue((Object)thrownTypes, (String)"thrownTypes");
                PsiClassType[] psiClassTypeArray = thrownTypes;
                if (this.containsException(CollectionsKt.listOf((Object[])Arrays.copyOf(psiClassTypeArray, psiClassTypeArray.length)), exceptionClass, allowSuperClass, exceptionClassName)) {
                    return true;
                }
            }
            return false;
        }

        private final boolean containsException(List<? extends PsiType> types, PsiClass exceptionClass, boolean allowSuperClass, String exceptionClassName) {
            for (PsiType psiType : types) {
                String string;
                String string2;
                if (!(psiType instanceof PsiClassType)) continue;
                PsiClass psiClass = ((PsiClassType)psiType).resolve();
                String string3 = string2 = psiClass == null ? null : psiClass.getQualifiedName();
                if (string2 == null) {
                    return true;
                }
                String cls = string = string2;
                if (allowSuperClass && exceptionClass != null) {
                    return InheritanceUtil.isInheritor((PsiClass)exceptionClass, (boolean)false, (String)cls);
                }
                if (!Intrinsics.areEqual((Object)exceptionClassName, (Object)cls)) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

