/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceFolderScanner;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class LocaleFolderDetector
extends Detector
implements ResourceFolderScanner,
SourceCodeScanner,
ClassScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(LocaleFolderDetector.class, Scope.RESOURCE_FOLDER_SCOPE);
    public static final Issue DEPRECATED_CODE = Issue.create("LocaleFolder", "Wrong locale name", "From the `java.util.Locale` documentation:\n\"Note that Java uses several deprecated two-letter codes. The Hebrew (\"he\") language code is rewritten as \"iw\", Indonesian (\"id\") as \"in\", and Yiddish (\"yi\") as \"ji\". This rewriting happens even if you construct your own Locale object, not just for instances returned by the various lookup methods.\n\nBecause of this, if you add your localized resources in for example `values-he` they will not be used, since the system will look for `values-iw` instead.\n\nTo work around this, place your resources in a `values` folder using the deprecated language code instead.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://developer.android.com/reference/java/util/Locale.html").setAndroidSpecific(true);
    public static final Issue WRONG_REGION = Issue.create("WrongRegion", "Suspicious Language/Region Combination", "Android uses the letter codes ISO 639-1 for languages, and the letter codes ISO 3166-1 for the region codes. In many cases, the language code and the country where the language is spoken is the same, but it is also often not the case. For example, while 'se' refers to Sweden, where Swedish is spoken, the language code for Swedish is **not** `se` (which refers to the Northern Sami language), the language code is `sv`. And similarly the region code for `sv` is El Salvador.\n\nThis lint check looks for suspicious language and region combinations, to help catch cases where you've accidentally used the wrong language or region code. Lint knows about the most common regions where a language is spoken, and if a folder combination is not one of these, it is flagged as suspicious.\n\nNote however that it may not be an error: you can theoretically have speakers of any language in any region and want to target that with your resources, so this check is aimed at tracking down likely mistakes, not to enforce a specific set of region and language combinations.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION).setAndroidSpecific(true);
    public static final Issue USE_ALPHA_2 = Issue.create("UseAlpha2", "Using 3-letter Codes", "For compatibility with earlier devices, you should only use 3-letter language and region codes when there is no corresponding 2 letter code.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION).addMoreInfo("https://tools.ietf.org/html/bcp47").setAndroidSpecific(true);
    public static final Issue INVALID_FOLDER = Issue.create("InvalidResourceFolder", "Invalid Resource Folder", "This lint check looks for a folder name that is not a valid resource folder name; these will be ignored and not packaged by the Android Gradle build plugin.\n\nNote that the order of resources is very important; for example, you can't specify a language before a network code.\n\nSimilarly, note that to use 3 letter region codes, you have to use a special BCP 47 syntax: the prefix b+ followed by the BCP 47 language tag but with `+` as the individual separators instead of `-`. Therefore, for the BCP 47 language tag `nl-ABW` you have to use `b+nl+ABW`.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION).addMoreInfo("https://developer.android.com/guide/topics/resources/providing-resources.html").addMoreInfo("https://tools.ietf.org/html/bcp47").setAndroidSpecific(true);
    public static final Issue GET_LOCALES = Issue.create("GetLocales", "Locale crash", "This check looks for usage of Lollipop-style locale folders (e.g. 3 letter language codes, or BCP 47 qualifiers) combined with an `AssetManager#getLocales()` call. This leads to crashes", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(LocaleFolderDetector.class, EnumSet.of(Scope.RESOURCE_FOLDER, Scope.JAVA_FILE, Scope.JAVA_LIBRARIES), EnumSet.of(Scope.RESOURCE_FOLDER, Scope.JAVA_FILE))).setAndroidSpecific(true);
    private static final String KEY_MESSAGE = "message";
    private Map<String, File> mBcp47Folders;
    private List<File> threeLetterLocales;
    private boolean foundGetLocaleCall;

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return true;
    }

    @Override
    public void checkFolder(ResourceContext context2, String folderName) {
        LocaleQualifier locale;
        LocaleQualifier localeQualifier = locale = context2.getFolderConfiguration() != null ? context2.getFolderConfiguration().getLocaleQualifier() : null;
        if (locale != null && locale.hasLanguage()) {
            List relevantRegions;
            String regionAlpha2;
            String region;
            String languageAlpha2;
            String language = locale.getLanguage();
            assert (language != null);
            String replace = null;
            switch (language) {
                case "he": {
                    replace = "iw";
                    break;
                }
                case "id": {
                    replace = "in";
                    break;
                }
                case "yi": {
                    replace = "ji";
                }
            }
            if (language.length() >= 3) {
                if (this.threeLetterLocales == null) {
                    this.threeLetterLocales = Lists.newArrayList();
                }
                this.threeLetterLocales.add(context2.file);
            }
            if (replace != null) {
                String message2 = String.format("The locale folder \"`%1$s`\" should be called \"`%2$s`\" instead; see the `java.util.Locale` documentation", language, replace);
                context2.report(new Incident(DEPRECATED_CODE, Location.create(context2.file), message2));
            }
            if (language.length() == 3 && (languageAlpha2 = LocaleManager.getLanguageAlpha2((String)language.toLowerCase(Locale.US))) != null) {
                String message3 = String.format("For compatibility, should use 2-letter language codes when available; use `%1$s` instead of `%2$s`", languageAlpha2, language);
                context2.report(new Incident(USE_ALPHA_2, Location.create(context2.file), message3));
            }
            if ((region = locale.getRegion()) != null && locale.hasRegion() && region.length() == 3 && (regionAlpha2 = LocaleManager.getRegionAlpha2((String)region.toUpperCase(Locale.UK))) != null) {
                String message4 = String.format("For compatibility, should use 2-letter region codes when available; use `%1$s` instead of `%2$s`", regionAlpha2, region);
                context2.report(new Incident(USE_ALPHA_2, Location.create(context2.file), message4));
            }
            if (region != null && region.length() == 2 && !(relevantRegions = LocaleManager.getRelevantRegions((String)language)).isEmpty() && !relevantRegions.contains(region) && LocaleManager.isValidRegionCode((String)region)) {
                List<String> sortedRegions = LocaleFolderDetector.sortRegions(language, relevantRegions);
                ArrayList suggestions = Lists.newArrayList();
                for (String code : sortedRegions) {
                    suggestions.add(code + " (" + LocaleManager.getRegionName((String)code) + ")");
                }
                String message5 = String.format("Suspicious language and region combination %1$s (%2$s) with %3$s (%4$s): language %5$s is usually paired with: %6$s", language, LocaleManager.getLanguageName((String)language), region, LocaleManager.getRegionName((String)region), language, Joiner.on((String)", ").join((Iterable)suggestions));
                context2.report(new Incident(WRONG_REGION, Location.create(context2.file), message5));
            }
        }
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)folderName);
        if (ResourceFolderType.getFolderType((String)folderName) != null && config == null) {
            String message6 = "Invalid resource folder: make sure qualifiers appear in the correct order, are spelled correctly, etc.";
            String bcpSuggestion = LocaleFolderDetector.suggestBcp47Correction(folderName);
            if (bcpSuggestion != null) {
                message6 = String.format("Invalid resource folder; did you mean `%1$s` ?", bcpSuggestion);
            }
            context2.report(new Incident(INVALID_FOLDER, Location.create(context2.file), message6));
        } else if (locale != null && folderName.contains("b+") && config != null && config.getLocaleQualifier() != null) {
            if (this.mBcp47Folders == null) {
                this.mBcp47Folders = Maps.newHashMap();
            }
            if (!this.mBcp47Folders.containsKey(folderName)) {
                this.mBcp47Folders.put(folderName, context2.file);
            }
        }
    }

    @VisibleForTesting
    static String suggestBcp47Correction(String folderName) {
        String language = null;
        String region = null;
        Iterator iterator = FolderConfiguration.QUALIFIER_SPLITTER.split((CharSequence)folderName).iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        iterator.next();
        while (iterator.hasNext()) {
            String segment;
            String original = segment = (String)iterator.next();
            int length = segment.length();
            if (language != null) {
                segment = segment.toUpperCase(Locale.US);
                if (length == 3) {
                    if (original.charAt(0) == 'r' && Character.isUpperCase(original.charAt(1)) && LocaleManager.isValidRegionCode((String)segment.substring(1))) {
                        region = segment.substring(1);
                        break;
                    }
                    if (Character.isDigit(original.charAt(0))) {
                        region = segment;
                        continue;
                    }
                    if (!LocaleManager.isValidRegionCode((String)segment)) continue;
                    region = segment;
                    continue;
                }
                if (length != 4 || original.charAt(0) != 'r' || !Character.isUpperCase(original.charAt(1)) || !LocaleManager.isValidRegionCode((String)segment.substring(1))) continue;
                region = segment.substring(1);
                break;
            }
            if ("car".equals(segment = segment.toLowerCase(Locale.US))) {
                return null;
            }
            if (!LocaleManager.isValidLanguageCode((String)segment)) continue;
            language = segment;
        }
        if (language != null) {
            String better;
            if (language.length() == 3 && (better = LocaleManager.getLanguageAlpha2((String)language)) != null) {
                language = better;
            }
            if (region != null) {
                if (region.length() == 3 && !Character.isDigit(region.charAt(0)) && (better = LocaleManager.getRegionAlpha2((String)region)) != null) {
                    region = better;
                }
                return "b+" + language + '+' + region;
            }
            return "b+" + language;
        }
        return null;
    }

    @Override
    public void afterCheckRootProject(Context context2) {
        if (this.mBcp47Folders != null && !context2.getProject().getMinSdkVersion().isGreaterOrEqualThan(21)) {
            HashMap configToFile = Maps.newHashMap();
            ArrayListMultimap languageToConfigs = ArrayListMultimap.create();
            for (String folderName : this.mBcp47Folders.keySet()) {
                FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)folderName);
                assert (config != null) : folderName;
                LocaleQualifier locale = config.getLocaleQualifier();
                assert (locale != null) : folderName;
                configToFile.put(config, this.mBcp47Folders.get(folderName));
                Object key = locale.getLanguage();
                assert (key != null);
                if (locale.hasRegion()) {
                    key = (String)key + '_' + locale.getRegion();
                }
                languageToConfigs.put(key, (Object)config);
            }
            for (String language : languageToConfigs.keySet()) {
                Collection configs = languageToConfigs.get((Object)language);
                if (configs.size() <= 1) continue;
                ArrayList candidates = Lists.newArrayListWithExpectedSize((int)configs.size());
                for (FolderConfiguration config : configs) {
                    if (config.getVersionQualifier() != null && config.getVersionQualifier().getVersion() >= 21) continue;
                    boolean localeOnly = true;
                    int n = FolderConfiguration.getQualifierCount();
                    for (int i = 0; i < n; ++i) {
                        ResourceQualifier qualifier = config.getQualifier(i);
                        if (!ResourceQualifier.isValid((ResourceQualifier)qualifier) || qualifier instanceof LocaleQualifier) continue;
                        localeOnly = false;
                        break;
                    }
                    if (!localeOnly) continue;
                    candidates.add(config);
                }
                if (candidates.size() <= 1) continue;
                Collections.sort(candidates);
                Location location2 = null;
                ArrayList folderNames = Lists.newArrayList();
                for (int i = candidates.size() - 1; i >= 0; --i) {
                    FolderConfiguration config = (FolderConfiguration)candidates.get(i);
                    File dir = (File)configToFile.get(config);
                    assert (dir != null) : config;
                    Location secondary = location2;
                    location2 = Location.create(dir);
                    location2.setSecondary(secondary);
                    folderNames.add(dir.getName());
                }
                String message2 = String.format("Multiple locale folders for language `%1$s` map to a single folder in versions < API 21: %2$s", language, Joiner.on((String)", ").join((Iterable)folderNames));
                assert (location2 != null);
                Incident incident = new Incident(INVALID_FOLDER, location2, message2);
                context2.report(incident, Constraints.minSdkLessThan(21));
            }
        }
    }

    private static List<String> sortRegions(String language, List<String> regions) {
        ArrayList sortedRegions = Lists.newArrayList(regions);
        String primary = LocaleManager.getLanguageRegion((String)language);
        String secondary = LocaleManager.getDefaultLanguageRegion((String)language);
        sortedRegions.sort((r1, r2) -> {
            int rank1;
            int n = r1.equals(primary) ? 1 : (r1.equals(secondary) ? 2 : (rank1 = r1.equalsIgnoreCase(language) ? 3 : 4));
            int rank2 = r2.equals(primary) ? 1 : (r2.equals(secondary) ? 2 : (r2.equalsIgnoreCase(language) ? 3 : 4));
            int delta = rank1 - rank2;
            if (delta == 0) {
                delta = r1.compareTo((String)r2);
            }
            return delta;
        });
        return sortedRegions;
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("getLocales");
    }

    @Override
    public void visitMethodCall(JavaContext context2, UCallExpression call, PsiMethod method) {
        Location location2;
        if (this.threeLetterLocales == null || context2.getProject().getMinSdk() >= 21) {
            return;
        }
        if (!context2.getEvaluator().isMemberInSubClassOf((PsiMember)method, "android.content.res.AssetManager", false)) {
            return;
        }
        Location prev = location2 = context2.getLocation((UElement)call);
        ArrayList folderNames = Lists.newArrayListWithCapacity((int)this.threeLetterLocales.size());
        Collections.sort(this.threeLetterLocales);
        for (File file : this.threeLetterLocales) {
            prev = Location.create(file).withSecondary(prev, "Locale folder here", false);
            folderNames.add(file.getName());
        }
        Incident incident = new Incident(GET_LOCALES, call, location2, "");
        String formatString = "The app will crash on platforms older than v21 (minSdkVersion is %1$d) because `AssetManager#getLocales` is called and it contains one or more v21-style (3-letter or BCP47 locale) folders: " + Joiner.on((String)", ").join((Iterable)folderNames);
        context2.report(incident, this.map().put(KEY_MESSAGE, formatString));
    }

    @Override
    public void checkClass(ClassContext context2, ClassNode classNode) {
        if (this.threeLetterLocales == null || context2.getProject().getMinSdk() >= 21 || this.foundGetLocaleCall) {
            return;
        }
        List methodList = classNode.methods;
        for (Object m : methodList) {
            MethodNode method = (MethodNode)m;
            InsnList nodes = method.instructions;
            int n = nodes.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode instruction = nodes.get(i);
                int type = instruction.getType();
                if (type != 5) continue;
                MethodInsnNode node = (MethodInsnNode)instruction;
                if (!node.owner.equals("android/content/res/AssetManager") || !node.name.equals("getLocales") || !node.desc.equals("()[Ljava/lang/String;")) continue;
                this.foundGetLocaleCall = true;
                Collections.sort(this.threeLetterLocales);
                File jarFile = context2.getJarFile();
                LintClient client = context2.getClient();
                for (File file : this.threeLetterLocales) {
                    String jarPath = jarFile != null ? Lint.getFileNameWithParent(client, jarFile) : "?";
                    Location location2 = Location.create(file);
                    Incident incident = new Incident(GET_LOCALES, location2, "");
                    String formatString = "The app will crash on platforms older than v21 (minSdkVersion is %1$d) because `AssetManager#getLocales()` is called (from the library jar file " + jarPath + ") and this folder resource name only works on v21 or later with that call present in the app";
                    context2.report(incident, this.map().put(KEY_MESSAGE, formatString));
                }
            }
        }
    }

    @Override
    public boolean filterIncident(Context context2, Incident incident, LintMap map) {
        assert (incident.getIssue() == GET_LOCALES);
        if (context2.getMainProject().getMinSdk() < 21) {
            int minSdk = context2.getMainProject().getMinSdk();
            assert (minSdk < 21);
            String formatString = map.getString(KEY_MESSAGE, "");
            String message2 = String.format(Locale.getDefault(), formatString, minSdk);
            incident.setMessage(message2);
            return true;
        }
        return false;
    }
}

