/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000bH\u0002J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/LocaleDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkFormat", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "method", "Lcom/intellij/psi/PsiMethod;", "call", "Lorg/jetbrains/uast/UCallExpression;", "checkJavaToUpperLowerCase", "node", "checkLocaleGetDefault", "checkStringsKt", "getApplicableMethodNames", "", "", "isLoggingParameter", "", "visitMethodCall", "Companion", "android.sdktools.lint-checks"})
public final class LocaleDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(LocaleDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    public static final String TO_UPPER_CASE = "toUpperCase";
    @NotNull
    public static final String TO_LOWER_CASE = "toLowerCase";
    @NotNull
    public static final String GET_DEFAULT = "getDefault";
    @NotNull
    public static final String KOTLIN_STRINGS_JVM_KT = "kotlin.text.StringsKt__StringsJVMKt";
    @NotNull
    public static final String CAPITALIZE = "capitalize";
    @NotNull
    public static final String DECAPITALIZE = "decapitalize";
    @JvmField
    @NotNull
    public static final Issue STRING_LOCALE;
    @JvmField
    @NotNull
    public static final Issue FINAL_LOCALE;

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{TO_LOWER_CASE, TO_UPPER_CASE, "format", GET_DEFAULT, CAPITALIZE, DECAPITALIZE};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        block30: {
            block28: {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                if (Intrinsics.areEqual((Object)method.getName(), (Object)GET_DEFAULT)) {
                    if (context2.getEvaluator().isMemberInClass((PsiMember)method, "java.util.Locale")) {
                        this.checkLocaleGetDefault(context2, method, node);
                    }
                    return;
                }
                if (!context2.getEvaluator().isMemberInClass((PsiMember)method, "java.lang.String")) break block28;
                switch (method.getName()) {
                    case "format": {
                        this.checkFormat(context2, method, node);
                        break;
                    }
                    case "toLowerCase": 
                    case "toUpperCase": {
                        this.checkJavaToUpperLowerCase(context2, method, node);
                    }
                }
            }
            if (!context2.getEvaluator().isMemberInClass((PsiMember)method, KOTLIN_STRINGS_JVM_KT)) break block30;
            switch (method.getName()) {
                case "decapitalize": 
                case "capitalize": {
                    this.checkStringsKt(context2, method, node);
                    break;
                }
                case "toLowerCase": 
                case "toUpperCase": {
                    this.checkStringsKt(context2, method, node);
                }
            }
        }
    }

    private final void checkJavaToUpperLowerCase(JavaContext context2, PsiMethod method, UCallExpression node) {
        if (LintClient.Companion.isStudio()) {
            return;
        }
        if (method.getParameterList().getParametersCount() != 0) {
            return;
        }
        Location location2 = context2.getNameLocation((UElement)node);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "Implicitly using the default locale is a common source of bugs: Use `%1$s(Locale)` instead. For strings meant to be internal use `Locale.ROOT`, otherwise `Locale.getDefault()`.";
        Object[] objectArray = new Object[]{method.getName()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String message2 = string2;
        JavaContext.report$default(context2, STRING_LOCALE, (UElement)node, location2, message2, null, 16, null);
    }

    private final void checkStringsKt(JavaContext context2, PsiMethod method, UCallExpression node) {
        if (method.getParameterList().getParametersCount() > 1) {
            return;
        }
        Location location2 = context2.getNameLocation((UElement)node);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "Implicitly using the default locale is a common source of bugs: Use `%1$s(Locale)` instead. For strings meant to be internal use `Locale.ROOT`, otherwise `Locale.getDefault()`.";
        Object object = new Object[]{method.getName()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String message2 = string2;
        Location range = context2.getCallLocation(node, false, true);
        object = this.fix().group();
        bl = false;
        boolean bl2 = false;
        Object groupBuilder = object;
        boolean bl3 = false;
        Object[] objectArray = new String[]{"ROOT", "getDefault()"};
        for (String localeName : CollectionsKt.listOf((Object[])objectArray)) {
            ((LintFix.GroupBuilder)groupBuilder).add(this.fix().name("Replace with `" + method.getName() + "(Locale." + localeName + ")`").sharedName("Use explicit locale").replace().range(range).with(method.getName() + "(java.util.Locale." + localeName + ')').shortenNames().build());
        }
        LintFix quickfixData = ((LintFix.GroupBuilder)object).build();
        context2.report(STRING_LOCALE, (UElement)node, location2, message2, quickfixData);
    }

    private final void checkFormat(JavaContext context2, PsiMethod method, UCallExpression call) {
        String string;
        if (method.getParameterList().getParametersCount() == 0 || !context2.getEvaluator().parameterHasType(method, 0, "java.lang.String")) {
            return;
        }
        List expressions = call.getValueArguments();
        if (expressions.isEmpty()) {
            return;
        }
        UExpression first = (UExpression)expressions.get(0);
        Object object = ConstantEvaluator.evaluate(context2, (UElement)first);
        String string2 = string = object instanceof String ? (String)object : null;
        if (string == null) {
            return;
        }
        String value = string;
        if (StringFormatDetector.isLocaleSpecific(value)) {
            if (this.isLoggingParameter(context2, call)) {
                return;
            }
            if (UastUtils.getParentOfType((UElement)((UElement)call), UThrowExpression.class, (boolean)true) != null) {
                return;
            }
            Location location2 = Intrinsics.areEqual((Object)"format", (Object)Lint.getMethodName(call)) ? context2.getCallLocation(call, true, true) : context2.getCallLocation(call, false, true);
            String message2 = "Implicitly using the default locale is a common source of bugs: Use `String.format(Locale, ...)` instead";
            JavaContext.report$default(context2, STRING_LOCALE, (UElement)call, location2, message2, null, 16, null);
        }
    }

    private final void checkLocaleGetDefault(JavaContext context2, PsiMethod method, UCallExpression node) {
        Class[] classArray = new Class[]{UMethod.class, ULambdaExpression.class};
        UField uField = (UField)UastUtils.getParentOfType((UElement)((UElement)node), UField.class, (boolean)true, (Class[])classArray);
        if (uField == null) {
            return;
        }
        UField field = uField;
        JavaEvaluator evaluator = context2.getEvaluator();
        if (evaluator.isStatic((PsiModifierListOwner)field) && evaluator.isFinal((PsiModifierListOwner)field)) {
            JavaContext.report$default(context2, FINAL_LOCALE, (UElement)node, context2.getLocation((UElement)node), "Assigning `Locale.getDefault()` to a final static field is suspicious; this code will not work correctly if the user changes locale while the app is running", null, 16, null);
        }
    }

    private final boolean isLoggingParameter(JavaContext context2, UCallExpression node) {
        String name;
        UCallExpression parentCall = (UCallExpression)UastUtils.getParentOfType((UElement)((UElement)node), UCallExpression.class, (boolean)true);
        if (parentCall != null && (name = Lint.getMethodName(parentCall)) != null && name.length() == 1) {
            PsiMethod method = parentCall.resolve();
            return context2.getEvaluator().isMemberInClass((PsiMember)method, "android.util.Log");
        }
        return false;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        STRING_LOCALE = Issue.Companion.create$default(companion, "DefaultLocale", "Implied default locale in case conversion", "\n                Calling `String#toLowerCase()` or `#toUpperCase()` **without specifying an \\\n                explicit locale** is a common source of bugs. The reason for that is that \\\n                those methods will use the current locale on the user's device, and even \\\n                though the code appears to work correctly when you are developing the app, \\\n                it will fail in some locales. For example, in the Turkish locale, the \\\n                uppercase replacement for `i` is **not** `I`.\n\n                If you want the methods to just perform ASCII replacement, for example to \\\n                convert an enum name, call `String#toUpperCase(Locale.US)` instead. If you \\\n                really want to use the current locale, call \\\n                `String#toUpperCase(Locale.getDefault())` instead.\n                ", implementation, "https://developer.android.com/reference/java/util/Locale.html#default_locale", category, 6, severity, false, null, null, null, 3840, null);
        companion = Issue.Companion;
        category = Category.I18N;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        FINAL_LOCALE = Issue.Companion.create$default(companion, "ConstantLocale", "Constant Locale", "\n                Assigning `Locale.getDefault()` to a constant is suspicious, because \\\n                the locale can change while the app is running.", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/LocaleDetector$Companion;", "", "()V", "CAPITALIZE", "", "DECAPITALIZE", "FINAL_LOCALE", "Lcom/android/tools/lint/detector/api/Issue;", "GET_DEFAULT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "KOTLIN_STRINGS_JVM_KT", "STRING_LOCALE", "TO_LOWER_CASE", "TO_UPPER_CASE", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

