/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.elements.KtLightFieldForSourceDeclarationSupport;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0002\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00100\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/LeakDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "checkInstanceField", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "field", "Lorg/jetbrains/uast/UField;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "visitClass", "declaration", "Lorg/jetbrains/uast/UClass;", "Companion", "FieldChecker", "android.sdktools.lint-checks"})
public final class LeakDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final List<String> SUPER_CLASSES;
    @NotNull
    private static final String CLASS_LIFECYCLE = "androidx.lifecycle.Lifecycle";
    @NotNull
    private static final String CLASS_LIFECYCLE_OLD = "android.arch.lifecycle.Lifecycle";

    @Override
    @NotNull
    public List<String> applicableSuperClasses() {
        return SUPER_CLASSES;
    }

    @Override
    public void visitClass(@NotNull JavaContext context2, @NotNull UClass declaration) {
        Class[] classArray;
        UMethod method;
        boolean isStatic;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        UClass containingClass = UastUtils.getContainingUClass((UElement)((UElement)declaration));
        boolean isAnonymous = declaration instanceof UAnonymousClass;
        JavaEvaluator evaluator = context2.getEvaluator();
        boolean bl = isStatic = evaluator.isStatic((PsiModifierListOwner)declaration) || containingClass == null;
        if (isStatic || isAnonymous) {
            for (UField uField : declaration.getFields()) {
                this.checkInstanceField(context2, uField);
            }
            if (!isAnonymous) {
                return;
            }
        }
        String superClass = null;
        Iterator<String> iterator = SUPER_CLASSES.iterator();
        while (iterator.hasNext()) {
            String cls = iterator.next();
            if (!evaluator.inheritsFrom((PsiClass)declaration, cls, false)) continue;
            superClass = cls;
            break;
        }
        if ((iterator = superClass) == null) {
            return;
        }
        UElement uastParent = declaration.getUastParent();
        if (uastParent != null && (method = (UMethod)UastUtils.getParentOfType((UElement)uastParent, UMethod.class, (boolean)true, (Class[])(classArray = new Class[]{UClass.class, UObjectLiteralExpression.class}))) != null && evaluator.isStatic((PsiModifierListOwner)method)) {
            return;
        }
        Class[] classArray2 = new Class[]{UMethod.class};
        UCallExpression invocation = (UCallExpression)UastUtils.getParentOfType((UElement)((UElement)declaration), UObjectLiteralExpression.class, (boolean)true, (Class[])classArray2);
        Object var10_18 = null;
        Location location2 = isAnonymous && invocation != null ? context2.getCallLocation(invocation, false, false) : context2.getNameLocation(declaration);
        String name = null;
        if (isAnonymous) {
            name = Intrinsics.stringPlus((String)"anonymous ", (Object)((UAnonymousClass)declaration).getBaseClassReference().getQualifiedName());
        } else {
            name = declaration.getQualifiedName();
            if (name == null) {
                name = declaration.getName();
            }
        }
        String string = superClass;
        int n = StringsKt.lastIndexOf$default((CharSequence)superClass, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
        boolean bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String superClassName = string3;
        context2.report(ISSUE, declaration, location2, "This `" + superClassName + "` class should be static or leaks might occur (" + name + ')');
    }

    @Override
    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UField.class);
    }

    @Override
    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new FieldChecker(context2);
    }

    private final void checkInstanceField(JavaContext context2, UField field) {
        PsiClassType psiClassType;
        Object object = field.getType();
        PsiClassType psiClassType2 = psiClassType = object instanceof PsiClassType ? (PsiClassType)object : null;
        if (psiClassType == null) {
            return;
        }
        PsiClassType type = psiClassType;
        object = type.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"type.canonicalText");
        Object fqn = object;
        if (StringsKt.startsWith$default((String)fqn, (String)"java.", (boolean)false, (int)2, null)) {
            return;
        }
        PsiClass psiClass = type.resolve();
        if (psiClass == null) {
            return;
        }
        PsiClass psiClass2 = psiClass;
        PsiClass cls = psiClass2;
        if (LeakDetector.Companion.isLeakCandidate(cls, context2.getEvaluator())) {
            context2.report(ISSUE, field, context2.getLocation(field), "This field leaks a context object");
        }
    }

    static {
        Object[] objectArray = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(LeakDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)objectArray, "StaticFieldLeak", "Static Field Leaks", "\n                A static field will leak contexts.\n\n                Non-static inner classes have an implicit reference to their outer class. \\\n                If that outer class is for example a `Fragment` or `Activity`, then this \\\n                reference means that the long-running handler/loader/task will hold a \\\n                reference to the activity which prevents it from getting garbage collected.\n\n                Similarly, direct field references to activities and fragments from these \\\n                longer running instances can cause leaks.\n\n                ViewModel classes should never point to Views or non-application Contexts.\n                ", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
        objectArray = new String[]{"android.content.Loader", "android.support.v4.content.Loader", "android.os.AsyncTask", "android.arch.lifecycle.ViewModel", "androidx.lifecycle.ViewModel"};
        SUPER_CLASSES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/LeakDetector$FieldChecker;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "isInitializedToAppContext", "", "field", "Lcom/intellij/psi/PsiField;", "typeClass", "Lcom/intellij/psi/PsiClass;", "Lorg/jetbrains/uast/UField;", "report", "", "modifierList", "Lcom/intellij/psi/PsiModifierList;", "message", "", "visitField", "node", "android.sdktools.lint-checks"})
    private static final class FieldChecker
    extends UElementHandler {
        @NotNull
        private final JavaContext context;

        public FieldChecker(@NotNull JavaContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.context = context2;
        }

        @Override
        public void visitField(@NotNull UField node) {
            block6: {
                PsiField[] cls;
                PsiField[] psiFieldArray;
                PsiField[] psiFieldArray2;
                PsiModifierList modifierList;
                block5: {
                    PsiClassType psiClassType;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    modifierList = node.getModifierList();
                    if (modifierList == null || !modifierList.hasModifierProperty("static") || node.getUastParent() instanceof UAnonymousClass) {
                        return;
                    }
                    Object object = node.getType();
                    PsiClassType psiClassType2 = psiClassType = object instanceof PsiClassType ? (PsiClassType)object : null;
                    if (psiClassType == null) {
                        return;
                    }
                    PsiClassType type = psiClassType;
                    object = type.getCanonicalText();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"type.canonicalText");
                    Object fqn = object;
                    if (StringsKt.startsWith$default((String)fqn, (String)"java.", (boolean)false, (int)2, null)) {
                        return;
                    }
                    psiFieldArray2 = type.resolve();
                    if (psiFieldArray2 == null) {
                        return;
                    }
                    cls = psiFieldArray = psiFieldArray2;
                    if (!StringsKt.startsWith$default((String)fqn, (String)"android.", (boolean)false, (int)2, null)) break block5;
                    if (!Companion.isLeakCandidate((PsiClass)cls, this.context.getEvaluator()) || Companion.isAppContext((PsiClass)cls, (PsiField)node) || this.isInitializedToAppContext(node, (PsiClass)cls)) break block6;
                    String message2 = "Do not place Android context classes in static fields; this is a memory leak";
                    this.report((PsiField)node, modifierList, message2);
                    break block6;
                }
                psiFieldArray2 = cls.getAllFields();
                Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray2, (String)"cls.allFields");
                psiFieldArray = psiFieldArray2;
                int n = psiFieldArray.length;
                for (int i = 0; i < n; ++i) {
                    PsiClass psiClass;
                    PsiClass psiClass2;
                    PsiClassType psiClassType;
                    int count = i;
                    PsiField referenced = psiFieldArray[i];
                    if (count == 20) break;
                    Object object = referenced.getType();
                    PsiClassType psiClassType3 = psiClassType = object instanceof PsiClassType ? (PsiClassType)object : null;
                    if (psiClassType == null) continue;
                    PsiClassType innerType = psiClassType;
                    object = innerType.getCanonicalText();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"innerType.canonicalText");
                    Object canonical = object;
                    if (StringsKt.startsWith$default((String)canonical, (String)"java.", (boolean)false, (int)2, null) || (psiClass2 = innerType.resolve()) == null) continue;
                    PsiClass innerCls = psiClass = psiClass2;
                    if (!StringsKt.startsWith$default((String)canonical, (String)"android.", (boolean)false, (int)2, null) || !Companion.isLeakCandidate(innerCls, this.context.getEvaluator())) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)referenced, (String)"referenced");
                    if (Companion.isAppContext(innerCls, referenced) || this.isInitializedToAppContext(this.context, referenced, innerCls)) continue;
                    String message3 = "Do not place Android context classes in static fields (static reference to `" + cls.getName() + "` which has field `" + referenced.getName() + "` pointing to `" + innerCls.getName() + "`); this is a memory leak";
                    this.report((PsiField)node, modifierList, message3);
                    break;
                }
            }
        }

        private final boolean isInitializedToAppContext(JavaContext context2, PsiField field, PsiClass typeClass) {
            if (!context2.getEvaluator().extendsClass(typeClass, "android.content.Context", false)) {
                return false;
            }
            UField uField = (UField)UastContextKt.toUElement((PsiElement)((PsiElement)field), UField.class);
            if (uField == null) {
                return true;
            }
            UField uField2 = uField;
            return this.isInitializedToAppContext(uField2, typeClass);
        }

        private final boolean isInitializedToAppContext(UField field, PsiClass typeClass) {
            UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)field));
            if (uClass == null) {
                return false;
            }
            UClass containingClass = uClass;
            if (!this.context.getEvaluator().extendsClass(typeClass, "android.content.Context", false)) {
                return false;
            }
            for (UDeclaration method : containingClass.getUastDeclarations()) {
                UExpression uExpression;
                if (!(method instanceof UMethod) || !((UMethod)method).isConstructor() || (uExpression = ((UMethod)method).getUastBody()) == null) continue;
                UExpression methodBody = uExpression;
                Ref assignedToAppContext = new Ref((Object)false);
                methodBody.accept((UastVisitor)new AbstractUastVisitor(field, (Ref<Boolean>)assignedToAppContext){
                    final /* synthetic */ UField $field;
                    final /* synthetic */ Ref<Boolean> $assignedToAppContext;
                    {
                        this.$field = $field;
                        this.$assignedToAppContext = $assignedToAppContext;
                    }

                    public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (UastExpressionUtils.isAssignment((UElement)((UElement)node)) && node.getLeftOperand() instanceof UResolvable && Intrinsics.areEqual((Object)this.$field.getSourcePsi(), (Object)((UResolvable)node.getLeftOperand()).resolve())) {
                            UElement rhs = (UElement)node.getRightOperand();
                            while (rhs instanceof UQualifiedReferenceExpression) {
                                rhs = (UElement)((UQualifiedReferenceExpression)rhs).getSelector();
                            }
                            if (rhs instanceof UCallExpression && Intrinsics.areEqual((Object)"getApplicationContext", (Object)Lint.getMethodName((UCallExpression)rhs))) {
                                this.$assignedToAppContext.set((Object)true);
                            }
                        }
                        return super.visitBinaryExpression(node);
                    }
                });
                Object object = assignedToAppContext.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assignedToAppContext.get()");
                if (!((Boolean)object).booleanValue()) continue;
                return true;
            }
            return false;
        }

        private final void report(PsiField field, PsiModifierList modifierList, String message2) {
            PsiElement locationNode = (PsiElement)field;
            if (modifierList.hasExplicitModifier("static")) {
                for (PsiElement child = modifierList.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!(child instanceof PsiKeyword) || !Intrinsics.areEqual((Object)"static", (Object)((PsiKeyword)child).getText())) continue;
                    locationNode = child;
                    break;
                }
            }
            Location location2 = this.context.getLocation(locationNode);
            JavaContext.report$default(this.context, ISSUE, (PsiElement)field, location2, message2, null, 16, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/LeakDetector$Companion;", "", "()V", "CLASS_LIFECYCLE", "", "CLASS_LIFECYCLE_OLD", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "SUPER_CLASSES", "", "isAppContext", "", "cls", "Lcom/intellij/psi/PsiClass;", "field", "Lcom/intellij/psi/PsiField;", "isLeakCandidate", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isAppContext(PsiClass cls, PsiField field) {
            String name;
            Object object;
            Object $this$any$iv;
            KtDeclaration origin;
            if (field.getAnnotation("dagger.hilt.android.qualifiers.ApplicationContext") != null) {
                return true;
            }
            if (field instanceof KtLightFieldForSourceDeclarationSupport && (origin = ((KtLightFieldForSourceDeclarationSupport)field).getKotlinOrigin()) != null) {
                boolean bl;
                block6: {
                    List list2 = origin.getAnnotationEntries();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"origin.annotationEntries");
                    $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        object = $this$any$iv.iterator();
                        while (object.hasNext()) {
                            Object element$iv = object.next();
                            KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                            boolean bl2 = false;
                            Name name2 = it.getShortName();
                            if (!Intrinsics.areEqual((Object)(name2 == null ? null : name2.getIdentifier()), (Object)"ApplicationContext")) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return true;
                }
            }
            $this$any$iv = field.getName();
            Intrinsics.checkNotNullExpressionValue((Object)$this$any$iv, (String)"field.name");
            String string = name = $this$any$iv;
            object = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"US");
            boolean bl = false;
            String string2 = string;
            boolean bl3 = false;
            String string3 = string2.toLowerCase((Locale)object);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
            String lower = string3;
            return (StringsKt.contains$default((CharSequence)lower, (CharSequence)"appcontext", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)lower, (CharSequence)"application", (boolean)false, (int)2, null)) && Intrinsics.areEqual((Object)"android.content.Context", (Object)cls.getQualifiedName());
        }

        private final boolean isLeakCandidate(PsiClass cls, JavaEvaluator evaluator) {
            return evaluator.extendsClass(cls, "android.content.Context", false) && !evaluator.extendsClass(cls, "android.app.Application", false) || evaluator.extendsClass(cls, "android.view.View", false) || evaluator.extendsClass(cls, "android.app.Fragment", false) || evaluator.extendsClass(cls, LeakDetector.CLASS_LIFECYCLE, false) || evaluator.extendsClass(cls, LeakDetector.CLASS_LIFECYCLE_OLD, false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

