/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.helpers.DefaultJavaEvaluator;
import com.android.tools.lint.model.LintModelMavenName;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class InvalidPackageDetector
extends Detector
implements ClassScanner {
    public static final Issue ISSUE = Issue.create("InvalidPackage", "Package not included in Android", "This check scans through libraries looking for calls to APIs that are not included in Android.\n\nWhen you create Android projects, the classpath is set up such that you can only access classes in the API packages that are included in Android. However, if you add other projects to your libs/ folder, there is no guarantee that those .jar files were built with an Android specific classpath, and in particular, they could be accessing unsupported APIs such as java.applet.\n\nThis check scans through library jars and looks for references to API packages that are not included in Android and flags these. This is only an error if your code calls one of the library classes which wind up referencing the unsupported package.", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(InvalidPackageDetector.class, Scope.JAVA_LIBRARY_SCOPE)).setEnabledByDefault(false).setAndroidSpecific(true);
    private static final String JAVA_PKG_PREFIX = "java/";
    private static final String JAVAX_PKG_PREFIX = "javax/";
    private ApiLookup mApiDatabase;
    private List<Candidate> mCandidates;
    private final Set<String> mJavaxLibraryClasses = Sets.newHashSetWithExpectedSize((int)64);

    @Override
    public void beforeCheckRootProject(Context context2) {
        this.mApiDatabase = ApiLookup.get(context2.getClient(), context2.getProject().getBuildTarget());
    }

    @Override
    public void checkClass(ClassContext context2, ClassNode classNode) {
        if (!context2.isFromClassLibrary() || InvalidPackageDetector.shouldSkip(context2.file)) {
            return;
        }
        if (this.mApiDatabase == null) {
            return;
        }
        if ((classNode.access & 0x2000) != 0 || classNode.superName != null && classNode.superName.startsWith("javax/annotation/")) {
            return;
        }
        if (classNode.name.startsWith(JAVAX_PKG_PREFIX)) {
            this.mJavaxLibraryClasses.add(classNode.name);
        }
        List methodList = classNode.methods;
        for (Object m : methodList) {
            String type;
            int args;
            MethodNode method = (MethodNode)m;
            InsnList nodes = method.instructions;
            String signature = method.desc;
            if (signature != null && (args = signature.indexOf(41)) != -1 && signature.charAt(args + 1) == 'L' && this.isInvalidPackage(type = signature.substring(args + 2, signature.length() - 1))) {
                AbstractInsnNode first = nodes.size() > 0 ? nodes.get(0) : null;
                this.record(context2, method, first, type);
            }
            int n = nodes.size();
            for (int i = 0; i < n; ++i) {
                Type t;
                String className;
                String owner;
                MethodInsnNode node;
                AbstractInsnNode instruction = nodes.get(i);
                int type2 = instruction.getType();
                if (type2 == 5) {
                    node = (MethodInsnNode)instruction;
                    owner = node.owner;
                    if (node.getOpcode() == 182 && owner.equals(classNode.name)) {
                        owner = classNode.superName;
                    }
                    if (!this.isInvalidPackage(owner)) continue;
                    this.record(context2, method, instruction, owner);
                    continue;
                }
                if (type2 == 4) {
                    node = (FieldInsnNode)instruction;
                    owner = node.owner;
                    if (!this.isInvalidPackage(owner)) continue;
                    this.record(context2, method, instruction, owner);
                    continue;
                }
                if (type2 != 9) continue;
                node = (LdcInsnNode)instruction;
                if (!(node.cst instanceof Type) || !this.isInvalidPackage(className = (t = (Type)node.cst).getInternalName())) continue;
                this.record(context2, method, instruction, className);
            }
        }
    }

    private boolean isInvalidPackage(String className) {
        if (className.startsWith(JAVA_PKG_PREFIX)) {
            return !this.mApiDatabase.isValidJavaPackage(className, InvalidPackageDetector.getPackageNameLength(className));
        }
        if (className.startsWith(JAVAX_PKG_PREFIX)) {
            if (className.startsWith("javax/annotation/") || className.startsWith("javax/lang/model")) {
                return false;
            }
            return !this.mApiDatabase.isValidJavaPackage(className, InvalidPackageDetector.getPackageNameLength(className));
        }
        return false;
    }

    private static int getPackageNameLength(String className) {
        int packageLength = className.lastIndexOf(47);
        if (packageLength < 0) {
            packageLength = className.length();
        }
        return packageLength;
    }

    private void record(ClassContext context2, MethodNode method, AbstractInsnNode instruction, String owner) {
        if (owner.indexOf(36) != -1) {
            return;
        }
        if (this.mCandidates == null) {
            this.mCandidates = new ArrayList<Candidate>();
        }
        this.mCandidates.add(new Candidate(owner, context2.getClassNode().name, context2.getJarFile()));
    }

    @Override
    public void afterCheckRootProject(Context context2) {
        if (this.mCandidates == null) {
            return;
        }
        HashSet<String> seen = new HashSet<String>();
        for (Candidate candidate : this.mCandidates) {
            String name;
            String type = candidate.mClass;
            if (this.mJavaxLibraryClasses.contains(type)) continue;
            File jarFile = candidate.mJarFile;
            String referencedIn = candidate.mReferencedIn;
            Location location2 = Location.create(jarFile);
            String pkg = InvalidPackageDetector.getPackageName(type);
            if (seen.contains(pkg)) continue;
            seen.add(pkg);
            if (pkg.equals("javax.inject") && ((name = jarFile.getName()).startsWith("dagger-") || name.startsWith("guice-")) || jarFile.getName().startsWith("junit-")) continue;
            Project project = context2.getProject();
            DefaultJavaEvaluator evaluator = new DefaultJavaEvaluator(null, project);
            LintModelMavenName library2 = evaluator.getLibrary(jarFile);
            String libraryString = library2 != null && !"__local_aars__".equals(library2.getGroupId()) ? library2.getGroupId() + ':' + library2.getArtifactId() : "library";
            String message2 = String.format("Invalid package reference in %1$s; not included in Android: `%2$s`. Referenced from `%3$s`.", libraryString, pkg, ClassContext.getFqcn(referencedIn));
            context2.report(ISSUE, location2, message2);
        }
    }

    private static String getPackageName(String owner) {
        String pkg = owner;
        int index = pkg.lastIndexOf(47);
        if (index != -1) {
            pkg = pkg.substring(0, index);
        }
        return ClassContext.getFqcn(pkg);
    }

    private static boolean shouldSkip(File file) {
        return file.getPath().endsWith("android-support-v4.jar");
    }

    private static class Candidate {
        private final String mReferencedIn;
        private final File mJarFile;
        private final String mClass;

        public Candidate(String className, String referencedIn, File jarFile) {
            this.mClass = className;
            this.mReferencedIn = referencedIn;
            this.mJarFile = jarFile;
        }
    }
}

