/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.SdkUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Element;

public class IconDetector
extends Detector
implements XmlScanner,
SourceCodeScanner {
    private static final boolean INCLUDE_LDPI;
    private static final String KEY_MIN_API = "minSdk";
    private static final Pattern DENSITY_PATTERN;
    private static final Pattern DP_NAME_PATTERN;
    private List<String> cachedRequiredDensities;
    private Project cachedDensitiesForProject;
    private static final String[] DENSITY_QUALIFIERS;
    private static final EnumSet<Scope> ICON_TYPE_SCOPE;
    private static final Implementation IMPLEMENTATION_JAVA;
    private static final Implementation IMPLEMENTATION_RES_ONLY;
    public static final Issue ICON_EXPECTED_SIZE;
    public static final Issue ICON_DIP_SIZE;
    public static final Issue ICON_LOCATION;
    public static final Issue ICON_DENSITIES;
    public static final Issue ICON_MISSING_FOLDER;
    public static final Issue GIF_USAGE;
    public static final Issue DUPLICATES_NAMES;
    public static final Issue DUPLICATES_CONFIGURATIONS;
    public static final Issue ICON_NODPI;
    public static final Issue ICON_MIX_9PNG;
    public static final Issue ICON_XML_AND_PNG;
    public static final Issue ICON_EXTENSION;
    public static final Issue ICON_COLORS;
    public static final Issue ICON_LAUNCHER_SHAPE;
    public static final Issue NOTIFICATION_ICON_COMPATIBILITY;
    public static final Issue WEBP_ELIGIBLE;
    public static final Issue WEBP_UNSUPPORTED;
    private Map<File, BufferedImage> imageCache;
    private Map<String, UElement> notificationIcons;
    private Set<String> actionBarIcons;
    private Set<String> launcherIcons;
    private Multimap<String, String> menuToIcons;
    private Set<Object> roundIcons;
    private static final String NOTIFICATION_CLASS = "android.app.Notification";
    private static final String NOTIFICATION_BUILDER_CLASS = "android.app.Notification.Builder";
    private static final String NOTIFICATION_COMPAT_BUILDER_CLASS = "android.support.v4.app.NotificationCompat.Builder";
    private static final String SET_SMALL_ICON = "setSmallIcon";
    private static final String ON_CREATE_OPTIONS_MENU = "onCreateOptionsMenu";

    @Override
    public void beforeCheckRootProject(Context context2) {
        this.launcherIcons = null;
        this.actionBarIcons = null;
        this.notificationIcons = null;
        this.roundIcons = null;
    }

    @Override
    public void afterCheckEachProject(Context context2) {
        if (!context2.getProject().getReportIssues()) {
            return;
        }
        this.checkResourceFolder(context2, context2.getProject());
    }

    private void checkResourceFolder(Context context2, Project project) {
        HashMap<String, File> notificationIconFiles = null;
        List<File> resourceFolders = project.getResourceFolders();
        for (File file : resourceFolders) {
            File[] folders = file.listFiles();
            if (folders == null) continue;
            boolean checkFolders = context2.isEnabled(ICON_DENSITIES) || context2.isEnabled(ICON_MISSING_FOLDER) || context2.isEnabled(ICON_NODPI) || context2.isEnabled(ICON_MIX_9PNG) || context2.isEnabled(ICON_XML_AND_PNG);
            boolean checkDipSizes = context2.isEnabled(ICON_DIP_SIZE);
            boolean checkDuplicates = context2.isEnabled(DUPLICATES_NAMES) || context2.isEnabled(DUPLICATES_CONFIGURATIONS);
            boolean checkWebp = context2.isEnabled(WEBP_ELIGIBLE);
            HashMap<File, Dimension> pixelSizes = null;
            HashMap<File, Long> fileSizes = null;
            if (checkDipSizes || checkDuplicates || checkWebp) {
                pixelSizes = new HashMap<File, Dimension>();
                fileSizes = new HashMap<File, Long>();
            }
            if (context2.isEnabled(NOTIFICATION_ICON_COMPATIBILITY) && context2.getProject().getMinSdk() < 21) {
                notificationIconFiles = new HashMap<String, File>();
            }
            HashMap<File, Set<String>> folderToNames = new HashMap<File, Set<String>>();
            HashMap<File, Set<String>> nonDpiFolderNames = new HashMap<File, Set<String>>();
            for (File file2 : folders) {
                String name;
                HashSet<String> names;
                File[] files;
                String folderName = file2.getName();
                if (!folderName.startsWith("drawable") && !folderName.startsWith("mipmap") || (files = file2.listFiles()) == null) continue;
                this.checkDrawableDir(context2, file2, files, pixelSizes, fileSizes, notificationIconFiles);
                if (checkFolders && DENSITY_PATTERN.matcher(folderName).matches()) {
                    names = new HashSet(files.length);
                    for (File f : files) {
                        name = f.getName();
                        if (!IconDetector.isDrawableFile(name)) continue;
                        names.add(name);
                    }
                    folderToNames.put(file2, names);
                    continue;
                }
                if (!checkFolders) continue;
                names = new HashSet<String>(files.length);
                for (File f : files) {
                    name = f.getName();
                    if (!IconDetector.isDrawableFile(name)) continue;
                    names.add(name);
                }
                nonDpiFolderNames.put(file2, names);
            }
            if (checkDipSizes) {
                IconDetector.checkDipSizes(context2, pixelSizes);
            }
            if (checkDuplicates) {
                IconDetector.checkDuplicates(context2, pixelSizes, fileSizes);
            }
            if (checkFolders && !folderToNames.isEmpty()) {
                this.checkDensities(context2, file, folderToNames, nonDpiFolderNames);
            }
            if (!checkWebp) continue;
            File largest = null;
            long size = 0L;
            for (Map.Entry entry : fileSizes.entrySet()) {
                Long sizeLong;
                String baseName;
                File f = (File)entry.getKey();
                String name = f.getName();
                if ((!SdkUtils.endsWithIgnoreCase((String)name, (String)".png") || SdkUtils.endsWithIgnoreCase((String)name, (String)".9.png")) && !SdkUtils.endsWithIgnoreCase((String)name, (String)".jpg") && !SdkUtils.endsWithIgnoreCase((String)name, (String)".jpeg") || IconDetector.isAdaptiveIconLayer(baseName = IconDetector.getBaseName(name)) || (sizeLong = (Long)entry.getValue()) == null || sizeLong <= size) continue;
                size = sizeLong;
                largest = f;
            }
            if (largest == null) continue;
            Location location2 = Location.create(largest);
            String message2 = "One or more images in this project can be converted to the WebP format which typically results in smaller file sizes, even for lossless conversion";
            Incident incident = new Incident(WEBP_ELIGIBLE, location2, message2);
            context2.report(incident, Constraints.minSdkAtLeast(18));
        }
        if (notificationIconFiles != null) {
            for (Map.Entry entry : notificationIconFiles.entrySet()) {
                File file = (File)entry.getValue();
                if (SdkUtils.isBitmapFile((File)file)) continue;
                String message3 = String.format("Notification icon %1$s has to have a raster image to support Android versions below 5.0 (API 21)", entry.getKey());
                Location location3 = Location.create(file);
                Incident incident = new Incident(NOTIFICATION_ICON_COMPATIBILITY, location3, message3);
                context2.report(incident, Constraints.minSdkLessThan(21));
            }
        }
    }

    public static boolean isDrawableFile(String name) {
        return Lint.endsWith(name, ".png") || Lint.endsWith(name, ".jpg") || Lint.endsWith(name, ".gif") || Lint.endsWith(name, ".xml") || Lint.endsWith(name, ".jpeg") || Lint.endsWith(name, ".webp");
    }

    private static void checkDuplicates(Context context2, Map<File, Dimension> pixelSizes, Map<File, Long> fileSizes) {
        HashMap<Long, HashSet<File>> sameSizes = new HashMap<Long, HashSet<File>>();
        HashMap<Long, File> seenSizes = new HashMap<Long, File>(fileSizes.size());
        for (Map.Entry<File, Long> entry : fileSizes.entrySet()) {
            File file = entry.getKey();
            Long size = entry.getValue();
            if (seenSizes.containsKey(size)) {
                HashSet<File> set = (HashSet<File>)sameSizes.get(size);
                if (set == null) {
                    set = new HashSet<File>();
                    set.add((File)seenSizes.get(size));
                    sameSizes.put(size, set);
                }
                set.add(file);
                continue;
            }
            seenSizes.put(size, file);
        }
        if (sameSizes.isEmpty()) {
            return;
        }
        Collection candidateLists = sameSizes.values();
        for (Set candidates : candidateLists) {
            HashMap<Dimension, HashSet<Object>> sameDimensions = new HashMap<Dimension, HashSet<Object>>(candidates.size());
            ArrayList<Object> noSize = new ArrayList<Object>();
            for (Object file : candidates) {
                Dimension dimension = pixelSizes.get(file);
                if (dimension != null) {
                    Set<Object> set = (HashSet<Object>)sameDimensions.get(dimension);
                    if (set == null) {
                        set = new HashSet<Object>();
                        sameDimensions.put(dimension, (HashSet<Object>)set);
                    }
                    set.add(file);
                    continue;
                }
                noSize.add(file);
            }
            Collection sets = sameDimensions.values();
            if (!noSize.isEmpty()) {
                if (!sets.isEmpty()) {
                    Object file;
                    file = sets.iterator();
                    while (file.hasNext()) {
                        Set set = (Set)file.next();
                        set.addAll(noSize);
                    }
                } else {
                    HashSet noSizeSet = new HashSet(noSize);
                    sets = Collections.singletonList(noSizeSet);
                }
            }
            HashMap<File, byte[]> fileContents = new HashMap<File, byte[]>();
            for (Set<Object> set : sets) {
                if (set.size() < 2) continue;
                for (File file : set) {
                    byte[] bits = (byte[])fileContents.get(file);
                    if (bits != null) continue;
                    try {
                        bits = context2.getClient().readBytes(file);
                        fileContents.put(file, bits);
                    }
                    catch (IOException e) {
                        context2.log(e, null, new Object[0]);
                    }
                }
                HashMap<Object, File> equal = new HashMap<Object, File>();
                ArrayList arrayList = new ArrayList(set);
                Collections.sort(arrayList);
                for (int i = 0; i < arrayList.size() - 1; ++i) {
                    for (int j = i + 1; j < arrayList.size(); ++j) {
                        File file1 = (File)arrayList.get(i);
                        File file = (File)arrayList.get(j);
                        byte[] contents1 = (byte[])fileContents.get(file1);
                        byte[] byArray = (byte[])fileContents.get(file);
                        if (contents1 == null || byArray == null || contents1.length != byArray.length) continue;
                        boolean same = true;
                        for (int k = 0; k < contents1.length; ++k) {
                            if (contents1[k] == byArray[k]) continue;
                            same = false;
                            break;
                        }
                        if (!same) continue;
                        equal.put(file1, file);
                    }
                }
                if (equal.isEmpty()) continue;
                HashMap<File, HashSet<Object>> partitions = new HashMap<File, HashSet<Object>>();
                ArrayList<HashSet<Object>> sameSets = new ArrayList<HashSet<Object>>();
                for (Map.Entry entry : equal.entrySet()) {
                    File file1 = (File)entry.getKey();
                    File file = (File)entry.getValue();
                    Set set1 = (Set)partitions.get(file1);
                    Set set2 = (Set)partitions.get(file);
                    if (set1 != null) {
                        set1.add(file);
                        continue;
                    }
                    if (set2 != null) {
                        set2.add(file1);
                        continue;
                    }
                    set = new HashSet();
                    sameSets.add((HashSet<Object>)set);
                    set.add(file1);
                    set.add(file);
                    partitions.put(file1, (HashSet<Object>)set);
                    partitions.put(file, (HashSet<Object>)set);
                }
                ArrayList lists = new ArrayList();
                for (Set same : sameSets) {
                    assert (!same.isEmpty());
                    ArrayList arrayList2 = new ArrayList(same);
                    Collections.sort(arrayList2);
                    lists.add(arrayList2);
                }
                lists.sort((list1, list2) -> ((File)list1.get(0)).compareTo((File)list2.get(0)));
                ListIterator listIterator = lists.listIterator();
                while (listIterator.hasNext()) {
                    List list3 = (List)listIterator.next();
                    boolean bl = true;
                    for (File file : list3) {
                        String name = file.getName();
                        if (DP_NAME_PATTERN.matcher(name).matches()) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    listIterator.remove();
                }
                for (List list3 : lists) {
                    Location curr;
                    StringBuilder sb;
                    Location location2 = null;
                    boolean sameNames = true;
                    String lastName = null;
                    for (Object file : list3) {
                        if (lastName != null && !lastName.equals(((File)file).getName())) {
                            sameNames = false;
                        }
                        lastName = ((File)file).getName();
                        Location linkedLocation = location2;
                        location2 = Location.create((File)file);
                        location2.setSecondary(linkedLocation);
                    }
                    if (sameNames) {
                        Object file;
                        sb = new StringBuilder(list3.size() * 16);
                        file = list3.iterator();
                        while (file.hasNext()) {
                            File file2 = (File)file.next();
                            if (sb.length() > 0) {
                                sb.append(", ");
                            }
                            sb.append(file2.getParentFile().getName());
                        }
                        String message2 = String.format("The `%1$s` icon has identical contents in the following configuration folders: %2$s", lastName, sb.toString());
                        if (location2 == null) continue;
                        for (curr = location2; curr != null; curr = curr.getSecondary()) {
                            if (!context2.getConfiguration().isIgnored(context2, DUPLICATES_CONFIGURATIONS, curr, message2)) continue;
                            return;
                        }
                        context2.report(DUPLICATES_CONFIGURATIONS, location2, message2);
                        continue;
                    }
                    sb = new StringBuilder(list3.size() * 16);
                    for (File file : list3) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(file.getName());
                    }
                    String message2 = String.format("The following unrelated icon files have identical contents: %1$s", sb.toString());
                    for (curr = location2; curr != null; curr = curr.getSecondary()) {
                        if (!context2.getConfiguration().isIgnored(context2, DUPLICATES_NAMES, curr, message2)) continue;
                        return;
                    }
                    context2.report(DUPLICATES_NAMES, location2, message2);
                }
            }
        }
    }

    private static void checkDipSizes(Context context2, Map<File, Dimension> pixelSizes) {
        HashMap<String, ArrayList<File>> nameToFiles = new HashMap<String, ArrayList<File>>();
        for (File file : pixelSizes.keySet()) {
            String name = file.getName();
            ArrayList<File> list2 = (ArrayList<File>)nameToFiles.get(name);
            if (list2 == null) {
                list2 = new ArrayList<File>();
                nameToFiles.put(name, list2);
            }
            list2.add(file);
        }
        ArrayList names = new ArrayList(nameToFiles.keySet());
        Collections.sort(names);
        HashMap configMap = new HashMap();
        for (Map.Entry entry : nameToFiles.entrySet()) {
            String name = (String)entry.getKey();
            List files = (List)entry.getValue();
            for (File file : files) {
                ArrayList<File> list3;
                String parentName = file.getParentFile().getName();
                int index = -1;
                for (String qualifier : DENSITY_QUALIFIERS) {
                    index = parentName.indexOf(qualifier);
                    if (index == -1) continue;
                    parentName = parentName.substring(0, index) + parentName.substring(index + qualifier.length());
                    break;
                }
                if (index == -1) continue;
                HashMap<String, ArrayList<File>> folderMap = (HashMap<String, ArrayList<File>>)configMap.get(name);
                if (folderMap == null) {
                    folderMap = new HashMap<String, ArrayList<File>>();
                    configMap.put(name, folderMap);
                }
                if ((list3 = (ArrayList<File>)folderMap.get(parentName)) == null) {
                    list3 = new ArrayList<File>();
                    folderMap.put(parentName, list3);
                }
                list3.add(file);
            }
        }
        for (String name : names) {
            Map configurations = (Map)configMap.get(name);
            if (configurations == null) continue;
            for (Map.Entry entry : configurations.entrySet()) {
                Object size;
                List files = (List)entry.getValue();
                HashMap<File, Dimension> dipSizes = new HashMap<File, Dimension>();
                int dipWidthSum = 0;
                int dipHeightSum = 0;
                int count = 0;
                for (File file : files) {
                    String dpString;
                    int dp;
                    String folderName = file.getParentFile().getName();
                    float factor = IconDetector.getMdpiScalingFactor(folderName);
                    if (!(factor > 0.0f) || (size = pixelSizes.get(file)) == null) continue;
                    Dimension dip = new Dimension(Math.round((float)((Dimension)size).width / factor), Math.round((float)((Dimension)size).height / factor));
                    dipWidthSum += dip.width;
                    dipHeightSum += dip.height;
                    dipSizes.put(file, dip);
                    ++count;
                    String fileName = file.getName();
                    Matcher matcher = DP_NAME_PATTERN.matcher(fileName);
                    if (!matcher.matches() || Math.abs(dip.width - (dp = Integer.parseInt(dpString = matcher.group(1)))) <= 2 && Math.abs(dip.height - dp) <= 2) continue;
                    String message2 = String.format("Suspicious file name `%1$s`: The implied %2$s `dp` size does not match the actual `dp` size (pixel size %3$d\u00d7%4$d in a `%5$s` folder computes to %6$d\u00d7%7$d `dp`)", fileName, dpString, ((Dimension)size).width, ((Dimension)size).height, folderName, dip.width, dip.height);
                    context2.report(ICON_DIP_SIZE, Location.create(file), message2);
                }
                if (count == 0) continue;
                int meanWidth = dipWidthSum / count;
                int meanHeight = dipHeightSum / count;
                int squareWidthSum = 0;
                int squareHeightSum = 0;
                size = dipSizes.values().iterator();
                while (size.hasNext()) {
                    Dimension size2 = (Dimension)size.next();
                    squareWidthSum += (size2.width - meanWidth) * (size2.width - meanWidth);
                    squareHeightSum += (size2.height - meanHeight) * (size2.height - meanHeight);
                }
                double widthStdDev = Math.sqrt((double)squareWidthSum / (double)count);
                double heightStdDev = Math.sqrt((double)squareHeightSum / (double)count);
                if (!(widthStdDev > (double)(meanWidth / 10)) && !(heightStdDev > (double)meanHeight)) continue;
                StringBuilder sb = new StringBuilder(100);
                sb.append("The image `").append(name).append("` varies significantly in its density-independent (dip) size across the various density versions: ");
                Location location2 = null;
                ArrayList entries = new ArrayList();
                for (Map.Entry entry2 : dipSizes.entrySet()) {
                    entries.add(entry2);
                }
                entries.sort((e1, e2) -> {
                    Dimension d1 = (Dimension)e1.getValue();
                    Dimension d2 = (Dimension)e2.getValue();
                    if (d1.width != d2.width) {
                        return d2.width - d1.width;
                    }
                    return d2.height - d1.height;
                });
                ArrayList examples = Lists.newArrayList();
                for (Map.Entry entry2 : entries) {
                    File file = (File)entry2.getKey();
                    Location linkedLocation = location2;
                    location2 = Location.create(file);
                    location2.setSecondary(linkedLocation);
                    Dimension dip = (Dimension)entry2.getValue();
                    Dimension px = pixelSizes.get(file);
                    String example = Lint.getFileNameWithParent(context2.getClient(), file) + ": " + String.format("%1$dx%2$d dp (%3$dx%4$d px)", dip.width, dip.height, px.width, px.height);
                    examples.add(example);
                }
                if (location2 == null) continue;
                Collections.sort(examples);
                sb.append(Joiner.on((String)", ").join((Iterable)examples));
                context2.report(ICON_DIP_SIZE, location2, sb.toString());
            }
        }
    }

    private void checkDensities(Context context2, File res, Map<File, Set<String>> folderToNames, Map<File, Set<String>> nonDpiFolderNames) {
        Iterator folderName;
        HashSet<String> definedDensities = new HashSet<String>();
        for (File f : folderToNames.keySet()) {
            definedDensities.add(f.getName());
        }
        if (context2.isEnabled(ICON_MISSING_FOLDER)) {
            boolean bl;
            ArrayList<String> missing = new ArrayList<String>();
            List<String> requiredDensityFolders = this.getRequiredDensityFolders(context2);
            boolean bl2 = false;
            Iterator<Object> iterator = requiredDensityFolders.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (!definedDensities.contains(string)) {
                    missing.add(string);
                    continue;
                }
                bl = true;
            }
            if (!missing.isEmpty() && bl) {
                Collections.sort(missing);
                context2.report(ICON_MISSING_FOLDER, Location.create(res), String.format("Missing density variation folders in `%1$s`: %2$s", context2.getProject().getDisplayPath(res), Lint.formatList(missing, -1)));
            }
        }
        if (context2.isEnabled(ICON_NODPI)) {
            HashSet<String> noDpiNames = new HashSet<String>();
            for (Map.Entry entry : folderToNames.entrySet()) {
                if (!IconDetector.isNoDpiFolder((File)entry.getKey())) continue;
                noDpiNames.addAll((Collection)entry.getValue());
            }
            if (!noDpiNames.isEmpty()) {
                HashSet inBoth = new HashSet();
                ArrayList<File> arrayList = new ArrayList<File>();
                for (Map.Entry entry : folderToNames.entrySet()) {
                    File folder = (File)entry.getKey();
                    folderName = folder.getName();
                    if (IconDetector.isNoDpiFolder(folder)) continue;
                    assert (DENSITY_PATTERN.matcher((CharSequence)((Object)folderName)).matches());
                    Set<String> overlap = IconDetector.nameIntersection(noDpiNames, (Set)entry.getValue());
                    inBoth.addAll(overlap);
                    Iterator iterator = overlap.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        arrayList.add(new File(folder, string));
                    }
                }
                if (!inBoth.isEmpty()) {
                    ArrayList list2 = new ArrayList(inBoth);
                    Collections.sort(list2);
                    Location location2 = IconDetector.chainLocations(arrayList);
                    context2.report(ICON_NODPI, location2, String.format("The following images appear in both `-nodpi` and in a density folder: %1$s", Lint.formatList(list2, context2.getDriver().isAbbreviating() ? 10 : -1)));
                }
            }
        }
        if (context2.isEnabled(ICON_MIX_9PNG)) {
            IconDetector.checkMixedNinePatches(context2, folderToNames);
        }
        if (context2.isEnabled(ICON_XML_AND_PNG)) {
            Set<String> overlap;
            HashMap folderMap = Maps.newHashMap(folderToNames);
            folderMap.putAll(nonDpiFolderNames);
            HashSet xmlNames = Sets.newHashSetWithExpectedSize((int)100);
            HashSet hashSet = Sets.newHashSetWithExpectedSize((int)100);
            for (Map.Entry entry : folderMap.entrySet()) {
                Set names = (Set)entry.getValue();
                folderName = ((File)entry.getKey()).getName();
                for (Object name : names) {
                    if (Lint.endsWith((String)name, ".xml")) {
                        if (((String)((Object)folderName)).contains("-v")) continue;
                        xmlNames.add(name);
                        continue;
                    }
                    if (!IconDetector.isDrawableFile((String)name)) continue;
                    hashSet.add(name);
                }
            }
            if (!(xmlNames.isEmpty() || hashSet.isEmpty() || (overlap = IconDetector.nameIntersection(xmlNames, hashSet)).isEmpty())) {
                ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
                HashSet bases = Sets.newHashSetWithExpectedSize((int)overlap.size());
                for (String name : overlap) {
                    bases.add(Lint.getBaseName(name));
                }
                for (Object base : bases) {
                    for (Map.Entry entry : folderMap.entrySet()) {
                        File folder = (File)entry.getKey();
                        for (String n : (Set)entry.getValue()) {
                            if (!((String)base).equals(Lint.getBaseName(n))) continue;
                            arrayListMultimap.put(base, (Object)new File(folder, n));
                        }
                    }
                }
                ArrayList sorted = new ArrayList(arrayListMultimap.keySet());
                Collections.sort(sorted);
                for (Object name : sorted) {
                    ArrayList arrayList = Lists.newArrayList((Iterable)arrayListMultimap.get(name));
                    Location location3 = IconDetector.chainLocations(arrayList);
                    ArrayList fileNames = Lists.newArrayList();
                    boolean seenXml = false;
                    boolean seenNonXml = false;
                    for (File f : arrayList) {
                        boolean isXml = Lint.endsWith(f.getPath(), ".xml");
                        if (isXml && !seenXml) {
                            fileNames.add(context2.getProject().getDisplayPath(f));
                            seenXml = true;
                            continue;
                        }
                        if (isXml || seenNonXml) continue;
                        fileNames.add(context2.getProject().getDisplayPath(f));
                        seenNonXml = true;
                    }
                    Collections.sort(fileNames);
                    context2.report(ICON_XML_AND_PNG, location3, String.format("The following images appear both as density independent `.xml` files and as bitmap files: %1$s", Lint.formatList(fileNames, context2.getDriver().isAbbreviating() ? 10 : -1)));
                }
            }
        }
        if (context2.isEnabled(ICON_DENSITIES)) {
            HashSet<String> allNames = new HashSet<String>();
            for (Map.Entry<File, Set<String>> entry : folderToNames.entrySet()) {
                if (IconDetector.isNoDpiFolder(entry.getKey())) continue;
                Set<String> names = entry.getValue();
                allNames.addAll(names);
            }
            for (Map.Entry<File, Set<String>> entry : folderToNames.entrySet()) {
                ArrayList<String> delta;
                Set<String> set;
                File file = entry.getKey();
                if (IconDetector.isNoDpiFolder(file) || (set = entry.getValue()).size() == allNames.size() || (delta = new ArrayList<String>(IconDetector.nameDifferences(allNames, set))).isEmpty()) continue;
                Collections.sort(delta);
                String foundIn = "";
                if (delta.size() == 1) {
                    Object name;
                    ArrayList<String> defined = new ArrayList<String>();
                    name = (String)delta.get(0);
                    for (Map.Entry<File, Set<String>> e : folderToNames.entrySet()) {
                        if (!e.getValue().contains(name)) continue;
                        defined.add(e.getKey().getName());
                    }
                    if (!defined.isEmpty()) {
                        Collections.sort(defined);
                        foundIn = String.format(" (found in %1$s)", Lint.formatList(defined, context2.getDriver().isAbbreviating() ? 5 : -1));
                    }
                }
                String folder = file.getName();
                if (!this.getRequiredDensityFolders(context2).contains(folder)) continue;
                context2.report(ICON_DENSITIES, Location.create(file), String.format("Missing the following drawables in `%1$s`: %2$s%3$s", folder, Lint.formatList(delta, context2.getDriver().isAbbreviating() ? 5 : -1), foundIn));
            }
        }
    }

    private List<String> getRequiredDensityFolders(Context context2) {
        if (this.cachedRequiredDensities == null || context2.getProject() != this.cachedDensitiesForProject) {
            this.cachedDensitiesForProject = context2.getProject();
            this.cachedRequiredDensities = Lists.newArrayListWithExpectedSize((int)10);
            List<String> applicableDensities = context2.getProject().getApplicableDensities();
            if (applicableDensities != null) {
                this.cachedRequiredDensities.addAll(applicableDensities);
            } else {
                if (INCLUDE_LDPI) {
                    this.cachedRequiredDensities.add("drawable-ldpi");
                }
                this.cachedRequiredDensities.add("drawable-mdpi");
                this.cachedRequiredDensities.add("drawable-hdpi");
                this.cachedRequiredDensities.add("drawable-xhdpi");
                this.cachedRequiredDensities.add("drawable-xxhdpi");
            }
        }
        return this.cachedRequiredDensities;
    }

    private static Set<String> nameDifferences(Set<String> a, Set<String> b) {
        HashSet<String> names1 = new HashSet<String>(a.size());
        for (String string : a) {
            names1.add(Lint.getBaseName(string));
        }
        HashSet<String> names2 = new HashSet<String>(b.size());
        for (String s : b) {
            names2.add(Lint.getBaseName(s));
        }
        names1.removeAll(names2);
        if (!names1.isEmpty()) {
            HashSet<String> hashSet = new HashSet<String>(names1.size());
            for (String s : a) {
                if (!names1.contains(Lint.getBaseName(s))) continue;
                hashSet.add(s);
            }
            for (String s : b) {
                if (!names1.contains(Lint.getBaseName(s))) continue;
                hashSet.add(s);
            }
            return hashSet;
        }
        return Collections.emptySet();
    }

    private static Set<String> nameIntersection(Set<String> a, Set<String> b) {
        HashSet<String> names1 = new HashSet<String>(a.size());
        for (String string : a) {
            names1.add(Lint.getBaseName(string));
        }
        HashSet<String> names2 = new HashSet<String>(b.size());
        for (String s : b) {
            names2.add(Lint.getBaseName(s));
        }
        names1.retainAll(names2);
        if (!names1.isEmpty()) {
            HashSet<String> hashSet = new HashSet<String>(names1.size());
            for (String s : a) {
                if (!names1.contains(Lint.getBaseName(s))) continue;
                hashSet.add(s);
            }
            for (String s : b) {
                if (!names1.contains(Lint.getBaseName(s))) continue;
                hashSet.add(s);
            }
            return hashSet;
        }
        return Collections.emptySet();
    }

    private static boolean isNoDpiFolder(File file) {
        return file.getName().contains("-nodpi");
    }

    private BufferedImage getImage(File file) throws IOException {
        BufferedImage image;
        if (file == null) {
            return null;
        }
        if (this.imageCache == null) {
            this.imageCache = Maps.newHashMap();
        } else {
            image = this.imageCache.get(file);
            if (image != null) {
                return image;
            }
        }
        image = ImageIO.read(file);
        this.imageCache.put(file, image);
        return image;
    }

    private void checkDrawableDir(Context context2, File folder, File[] files, Map<File, Dimension> pixelSizes, Map<File, Long> fileSizes, Map<String, File> notificationIconsCompatibility) {
        String name;
        String folderName = folder.getName();
        if (folderName.equals("drawable")) {
            for (File file : files) {
                name = file.getName();
                if (name.endsWith(".xml") || !Lint.endsWith(name, ".png") && !Lint.endsWith(name, ".jpg") && !Lint.endsWith(name, ".jpeg") && !Lint.endsWith(name, ".webp") && !Lint.endsWith(name, ".gif")) continue;
                context2.report(ICON_LOCATION, Location.create(file), String.format("Found bitmap drawable `res/drawable/%1$s` in densityless folder", file.getName()));
            }
        }
        if (context2.isEnabled(GIF_USAGE)) {
            for (File file : files) {
                name = file.getName();
                if (!Lint.endsWith(name, ".gif")) continue;
                context2.report(GIF_USAGE, Location.create(file), "Using the `.gif` format for bitmaps is discouraged");
            }
        }
        if (context2.isEnabled(ICON_EXTENSION)) {
            for (File file : files) {
                String path2 = file.getPath();
                if (!IconDetector.isDrawableFile(path2) || Lint.endsWith(path2, ".xml")) continue;
                IconDetector.checkExtension(context2, file);
            }
        }
        if (context2.isEnabled(ICON_COLORS)) {
            for (File file : files) {
                Dimension size;
                String baseName;
                boolean isActionBarIcon;
                name = file.getName();
                if (!IconDetector.isDrawableFile(name) || Lint.endsWith(name, ".xml") || Lint.endsWith(name, ".9.png") || !(isActionBarIcon = this.isActionBarIcon(context2, folderName, baseName = IconDetector.getBaseName(name), file)) && !this.isNotificationIcon(baseName) || (size = this.checkColor(context2, file, isActionBarIcon)) == null || pixelSizes == null) continue;
                pixelSizes.put(file, size);
            }
        }
        if (context2.isEnabled(ICON_LAUNCHER_SHAPE)) {
            for (File file : files) {
                name = file.getName();
                if (!this.isLauncherIcon(folderName, IconDetector.getBaseName(name)) || Lint.endsWith(name, ".xml") || Lint.endsWith(name, ".9.png")) continue;
                this.checkLauncherShape(context2, folderName, file);
            }
        }
        if (context2.isEnabled(ICON_EXPECTED_SIZE)) {
            this.checkExpectedSizes(context2, folder, files);
        }
        if (pixelSizes != null || fileSizes != null) {
            for (File file : files) {
                String fileName = file.getName();
                if (!Lint.endsWith(fileName, ".png") && !Lint.endsWith(fileName, ".jpg") && !Lint.endsWith(fileName, ".jpeg") && !Lint.endsWith(fileName, ".webp")) continue;
                if (pixelSizes != null && !Lint.endsWith(fileName, ".9.png") && !pixelSizes.containsKey(file)) {
                    Dimension size = IconDetector.getSize(file);
                    pixelSizes.put(file, size);
                }
                if (fileSizes == null) continue;
                fileSizes.put(file, file.length());
            }
        }
        if (notificationIconsCompatibility != null) {
            this.checkNotificationIconsCompatibility(files, notificationIconsCompatibility);
        }
        if (context2.isEnabled(WEBP_UNSUPPORTED) && files.length > 0) {
            this.checkWebpSupported(context2, files);
        }
        this.imageCache = null;
    }

    private void checkNotificationIconsCompatibility(File[] files, Map<String, File> notificationIconsCompatibility) {
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            File mostCompatibleFile;
            String name = file.getName();
            String baseName = IconDetector.getBaseName(name);
            if (!this.isNotificationIcon(baseName) || (mostCompatibleFile = notificationIconsCompatibility.get(baseName)) != null && SdkUtils.isBitmapFile((File)mostCompatibleFile)) continue;
            notificationIconsCompatibility.put(baseName, file);
        }
    }

    private void checkWebpSupported(Context context2, File[] files) {
        int minSdk = Math.max(context2.getProject().getMinSdk(), context2.getDriver().getResourceFolderVersion(files[0]));
        if (minSdk >= 18) {
            return;
        }
        for (File file : files) {
            int required;
            String path2 = file.getPath();
            if (!SdkUtils.endsWithIgnoreCase((String)path2, (String)".webp")) continue;
            String name = file.getName();
            String baseName = IconDetector.getBaseName(name);
            if (IconDetector.isAdaptiveIconLayer(baseName)) {
                Location location2 = Location.create(file);
                String message2 = "Adaptive icon bitmaps must be in PNG format";
                Incident incident = new Incident(WEBP_UNSUPPORTED, location2, message2);
                context2.report(incident, Constraints.minSdkLessThan(18));
                continue;
            }
            WebpHeader header = WebpHeader.getWebpHeader(file);
            if (header == null || header.format == null) continue;
            boolean simpleFormat = "VP8".equals(header.format);
            int n = required = simpleFormat ? 15 : 18;
            if (required <= minSdk) continue;
            Location location3 = Location.create(file);
            String message3 = simpleFormat ? "WebP requires Android 4.0 (API 15)" : "WebP extended or lossless format requires Android 4.2.1 (API 18)";
            message3 = message3 + "; current minSdkVersion is %1$s";
            Incident incident = new Incident(WEBP_UNSUPPORTED, location3, message3);
            context2.report(incident, this.map().put(KEY_MIN_API, minSdk));
        }
    }

    @Override
    public boolean filterIncident(Context context2, Incident incident, LintMap map) {
        assert (incident.getIssue() == WEBP_UNSUPPORTED);
        int minSdk = context2.getMainProject().getMinSdk();
        if (minSdk < 18) {
            String message2 = incident.getMessage();
            assert (message2.contains("%"));
            int fileMin = map.getInt(KEY_MIN_API, 1);
            int actualMinSdk = Math.max(minSdk, fileMin);
            incident.setMessage(String.format(message2, actualMinSdk));
            return true;
        }
        return false;
    }

    private void checkLauncherShape(Context context2, String folderName, File file) {
        try {
            BufferedImage image = this.getImage(file);
            if (image != null) {
                if (this.isRoundIcon(folderName, IconDetector.getBaseName(file.getName())) && !IconDetector.isRound(image)) {
                    String message2 = "Launcher icon used as round icon did not have a circular shape";
                    context2.report(ICON_LAUNCHER_SHAPE, Location.create(file), message2);
                    return;
                }
                int height = image.getHeight();
                for (int y = 0; y < height; ++y) {
                    int width = image.getWidth();
                    for (int x = 0; x < width; ++x) {
                        int rgb = image.getRGB(x, y);
                        if ((rgb & 0xFF000000) != 0) continue;
                        return;
                    }
                }
                String message3 = "Launcher icons should not fill every pixel of their square region; see the design guide for details";
                context2.report(ICON_LAUNCHER_SHAPE, Location.create(file), message3);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isRound(BufferedImage image) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = 0;
        int maxY = 0;
        int imageHeight = image.getHeight();
        int imageWidth = image.getWidth();
        for (int y = 0; y < imageHeight; ++y) {
            for (int x = 0; x < imageWidth; ++x) {
                int rgb = image.getRGB(x, y);
                if ((rgb & 0xFF000000) == 0) continue;
                if (x > maxX) {
                    maxX = x;
                }
                if (y > maxY) {
                    maxY = y;
                }
                if (x < minX) {
                    minX = x;
                }
                if (y >= minY) continue;
                minY = y;
            }
        }
        int shapeWidth = maxX - minX + 1;
        int shapeHeight = maxY - minY + 1;
        if (Math.abs(shapeWidth - shapeHeight) > imageWidth / 10) {
            return false;
        }
        BufferedImage circle = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics graphics = circle.getGraphics();
        graphics.fillOval(minX, minY, shapeWidth, shapeHeight);
        graphics.dispose();
        int threshold = 64;
        int different = 0;
        for (int y = 0; y < imageHeight; ++y) {
            for (int x = 0; x < imageWidth; ++x) {
                boolean cir;
                int sourceAlpha = (image.getRGB(x, y) & 0xFF000000) >>> 24;
                int circleAlpha = (circle.getRGB(x, y) & 0xFF000000) >>> 24;
                if (sourceAlpha > 0 && sourceAlpha < 64) continue;
                boolean original = sourceAlpha < 64;
                boolean bl = cir = circleAlpha < 64;
                if (original == cir) continue;
                ++different;
            }
        }
        long total = (long)imageHeight * (long)imageWidth;
        double percentDifferent = (double)(100 * different) / (double)total;
        return percentDifferent < 4.0;
    }

    private Dimension checkColor(Context context2, File file, boolean isActionBarIcon) {
        block9: {
            try {
                BufferedImage image;
                block10: {
                    image = this.getImage(file);
                    if (image == null) break block9;
                    if (isActionBarIcon) {
                        int height = image.getHeight();
                        for (int y = 0; y < height; ++y) {
                            int width = image.getWidth();
                            for (int x = 0; x < width; ++x) {
                                int rgb = image.getRGB(x, y);
                                if ((rgb & 0xFF000000) == 0) continue;
                                int r = (rgb & 0xFF0000) >>> 16;
                                int g = (rgb & 0xFF00) >>> 8;
                                int b = rgb & 0xFF;
                                if (r == g && r == b) continue;
                                String message2 = "Action Bar icons should use a single gray color (`#333333` for light themes (with 60%/30% opacity for enabled/disabled), and `#FFFFFF` with opacity 80%/30% for dark themes";
                                context2.report(ICON_COLORS, Location.create(file), message2);
                                break block10;
                            }
                        }
                    } else {
                        int height = image.getHeight();
                        for (int y = 0; y < height; ++y) {
                            int width = image.getWidth();
                            for (int x = 0; x < width; ++x) {
                                UElement usage;
                                int rgb = image.getRGB(x, y);
                                if ((rgb & 0xFF000000) == 0 || (rgb & 0xFFFFFF) == 0xFFFFFF) continue;
                                int r = (rgb & 0xFF0000) >>> 16;
                                int g = (rgb & 0xFF00) >>> 8;
                                int b = rgb & 0xFF;
                                if (r == g && r == b && (x < width - 1 && rgb != image.getRGB(x + 1, y) || x > 0 && rgb != image.getRGB(x - 1, y) || y < height - 1 && rgb != image.getRGB(x, y + 1) || y > 0 && rgb != image.getRGB(x, y - 1))) continue;
                                String message3 = "Notification icons must be entirely white";
                                Location location2 = Location.create(file);
                                String name = IconDetector.getBaseName(file.getName());
                                UElement uElement = usage = this.notificationIcons != null ? this.notificationIcons.get(name) : null;
                                if (usage != null) {
                                    LintClient client = context2.getClient();
                                    Project project = context2.getProject();
                                    UastParser parser = client.getUastParser(project);
                                    Location secondary = parser.createLocation(usage);
                                    secondary.setMessage("Icon used in notification here");
                                    location2.setSecondary(secondary);
                                }
                                context2.report(ICON_COLORS, location2, message3);
                                break block10;
                            }
                        }
                    }
                }
                return new Dimension(image.getWidth(), image.getHeight());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkExtension(Context context2, File file) {
        block14: {
            try {
                ImageInputStream input = ImageIO.createImageInputStream(file);
                if (input == null) break block14;
                try {
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
                    if (!readers.hasNext() && !SdkUtils.endsWithIgnoreCase((String)file.getPath(), (String)".webp") && WebpHeader.getWebpHeader(file) != null) {
                        String extension = file.getName();
                        extension = extension.substring(extension.lastIndexOf(46) + 1);
                        String message2 = String.format("Misleading file extension; named `.%1$s` but the file format is `%2$s`", extension, "webp");
                        Location location2 = Location.create(file);
                        context2.report(ICON_EXTENSION, location2, message2);
                    }
                    while (readers.hasNext()) {
                        ImageReader reader = readers.next();
                        try {
                            int index;
                            reader.setInput(input);
                            String formatName = reader.getFormatName();
                            if (formatName == null || formatName.isEmpty()) continue;
                            String path2 = file.getPath();
                            String extension = path2.substring((index = path2.lastIndexOf(46)) + 1).toLowerCase(Locale.US);
                            if (!formatName.equalsIgnoreCase(extension)) {
                                if (Lint.endsWith(path2, ".jpg") && formatName.equals("JPEG")) {
                                    return;
                                }
                                String message3 = String.format("Misleading file extension; named `.%1$s` but the file format is `%2$s`", extension, formatName);
                                Location location3 = Location.create(file);
                                context2.report(ICON_EXTENSION, location3, message3);
                            }
                            break;
                        }
                        finally {
                            reader.dispose();
                        }
                    }
                }
                finally {
                    input.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String getBaseName(String name) {
        String baseName = name;
        int index = baseName.indexOf(46);
        if (index != -1) {
            baseName = baseName.substring(0, index);
        }
        return baseName;
    }

    private static void checkMixedNinePatches(Context context2, Map<File, Set<String>> folderToNames) {
        HashSet<String> conflictSet = null;
        for (Map.Entry<File, Set<String>> entry : folderToNames.entrySet()) {
            HashSet<String> hashSet = new HashSet<String>();
            Set<String> names = entry.getValue();
            for (String string : names) {
                assert (IconDetector.isDrawableFile(string)) : string;
                String base = IconDetector.getBaseName(string);
                if (hashSet.contains(base)) {
                    String ninepatch = base + ".9.png";
                    String png = base + ".png";
                    if (!names.contains(ninepatch) || !names.contains(png)) continue;
                    if (conflictSet == null) {
                        conflictSet = new HashSet<String>();
                    }
                    conflictSet.add(base);
                    continue;
                }
                hashSet.add(base);
            }
        }
        if (conflictSet == null || conflictSet.isEmpty()) {
            return;
        }
        Map conflicts = null;
        for (Map.Entry<File, Set<String>> entry : folderToNames.entrySet()) {
            File dir = entry.getKey();
            Set<String> names = entry.getValue();
            for (String name : names) {
                List files;
                assert (IconDetector.isDrawableFile(name)) : name;
                String base = IconDetector.getBaseName(name);
                if (!conflictSet.contains(base)) continue;
                if (conflicts == null) {
                    conflicts = Maps.newHashMap();
                }
                if ((files = (List)conflicts.get(base)) == null) {
                    files = Lists.newArrayList();
                    conflicts.put(base, files);
                }
                files.add(new File(dir, name));
            }
        }
        assert (conflicts != null && !conflicts.isEmpty()) : conflictSet;
        ArrayList arrayList = new ArrayList(conflicts.keySet());
        Collections.sort(arrayList);
        for (String name : arrayList) {
            List files = (List)conflicts.get(name);
            assert (files != null) : name;
            Location location2 = IconDetector.chainLocations(files);
            String message2 = String.format("The files `%1$s.png` and `%1$s.9.png` clash; both will map to `@drawable/%1$s`", name);
            context2.report(ICON_MIX_9PNG, location2, message2);
        }
    }

    private static Location chainLocations(List<File> files) {
        Collections.sort(files);
        Location location2 = null;
        for (File file : files) {
            Location linkedLocation = location2;
            location2 = Location.create(file);
            location2.setSecondary(linkedLocation);
        }
        return location2;
    }

    private void checkExpectedSizes(Context context2, File folder, File[] files) {
        if (files == null || files.length == 0) {
            return;
        }
        String folderName = folder.getName();
        int folderVersion = context2.getDriver().getResourceFolderVersion(files[0]);
        FolderConfiguration folderConfig = FolderConfiguration.getConfigForFolder((String)folderName);
        for (File file : files) {
            String name = file.getName();
            String baseName = IconDetector.getBaseName(name);
            if (this.isLauncherIcon(folderName, baseName)) {
                IconDetector.checkSize(context2, folderName, file, 48, 48, true, folderConfig);
                continue;
            }
            if (this.isActionBarIcon(folderName, baseName)) {
                IconDetector.checkSize(context2, folderName, file, 32, 32, true, folderConfig);
                continue;
            }
            if (name.startsWith("ic_dialog_")) {
                IconDetector.checkSize(context2, folderName, file, 32, 32, true, folderConfig);
                continue;
            }
            if (name.startsWith("ic_tab_")) {
                IconDetector.checkSize(context2, folderName, file, 32, 32, true, folderConfig);
                continue;
            }
            if (this.isNotificationIcon(baseName)) {
                IconDetector.checkSize(context2, folderName, file, 24, 24, true, folderConfig);
                continue;
            }
            if (IconDetector.isAdaptiveIconLayer(baseName)) {
                IconDetector.checkSize(context2, folderName, file, 108, 108, true, folderConfig);
                continue;
            }
            if (!name.startsWith("ic_menu_")) continue;
            IconDetector.checkSize(context2, folderName, file, 32, 32, true, folderConfig);
        }
    }

    private static float getMdpiScalingFactor(String folderName) {
        if (folderName.contains("-mdpi")) {
            return 1.0f;
        }
        if (folderName.contains("-hdpi")) {
            return 1.5f;
        }
        if (folderName.contains("-xhdpi")) {
            return 2.0f;
        }
        if (folderName.contains("-xxhdpi")) {
            return 3.0f;
        }
        if (folderName.contains("-xxxhdpi")) {
            return 4.0f;
        }
        if (folderName.contains("-ldpi")) {
            return 0.75f;
        }
        return 0.0f;
    }

    private static void checkSize(Context context2, String folderName, File file, int mdpiWidth, int mdpiHeight, boolean exactMatch, FolderConfiguration folderConfig) {
        int height;
        int width;
        String fileName = file.getName();
        if (!(Lint.endsWith(fileName, ".png") && !Lint.endsWith(fileName, ".9.png") || Lint.endsWith(fileName, ".webp") || Lint.endsWith(fileName, ".jpg") || Lint.endsWith(fileName, ".jpeg"))) {
            return;
        }
        if (folderName.startsWith("drawable-mdpi")) {
            width = mdpiWidth;
            height = mdpiHeight;
        } else if (folderName.startsWith("drawable-hdpi")) {
            width = Math.round((float)mdpiWidth * 3.0f / 2.0f);
            height = Math.round((float)mdpiHeight * 3.0f / 2.0f);
        } else if (folderName.startsWith("drawable-xhdpi")) {
            width = mdpiWidth * 2;
            height = mdpiHeight * 2;
        } else if (folderName.startsWith("drawable-xxhdpi")) {
            width = mdpiWidth * 3;
            height = mdpiWidth * 3;
        } else if (folderName.startsWith("drawable-ldpi")) {
            width = Math.round((float)mdpiWidth * 3.0f / 4.0f);
            height = Math.round((float)mdpiHeight * 3.0f / 4.0f);
        } else if (folderConfig != null && folderConfig.getDensityQualifier() != null && !folderConfig.getDensityQualifier().hasFakeValue()) {
            Density density = folderConfig.getDensityQualifier().getValue();
            if (density == null) {
                return;
            }
            width = mdpiWidth * density.getDpiValue() / Density.DEFAULT_DENSITY;
            height = mdpiHeight * density.getDpiValue() / Density.DEFAULT_DENSITY;
        } else {
            return;
        }
        Dimension size = IconDetector.getSize(file);
        if (size != null) {
            if (exactMatch && (size.width != width || size.height != height)) {
                context2.report(ICON_EXPECTED_SIZE, Location.create(file), "Incorrect icon size for `" + Lint.getFileNameWithParent(context2.getClient(), file) + "`: " + String.format("expected %1$dx%2$d, but was %3$dx%4$d", width, height, size.width, size.height));
            } else if (!(exactMatch || size.width <= width && size.height <= height)) {
                context2.report(ICON_EXPECTED_SIZE, Location.create(file), "Incorrect icon size for `" + Lint.getFileNameWithParent(context2.getClient(), file) + "`: " + String.format("icon size should be at most %1$dx%2$d, but was %3$dx%4$d", width, height, size.width, size.height));
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static Dimension getSize(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isLauncherIcon(String folderName, String name) {
        assert (name.indexOf(46) == -1) : name;
        if (name.startsWith("ic_launcher") && !IconDetector.isAdaptiveIconLayer(name)) {
            return true;
        }
        if (this.launcherIcons != null) {
            if (folderName.startsWith("mipmap")) {
                name = "@mipmap/" + name;
            }
            return this.launcherIcons.contains(name);
        }
        return false;
    }

    private boolean isRoundIcon(String folderName, String name) {
        assert (name.indexOf(46) == -1) : name;
        if (name.endsWith("_round")) {
            return true;
        }
        if (this.roundIcons != null) {
            if (folderName.startsWith("mipmap")) {
                name = "@mipmap/" + name;
            }
            return this.roundIcons.contains(name);
        }
        return false;
    }

    private boolean isNotificationIcon(String name) {
        assert (name.indexOf(46) == -1);
        if (name.startsWith("ic_stat_")) {
            return true;
        }
        return this.notificationIcons != null && this.notificationIcons.containsKey(name);
    }

    private boolean isActionBarIcon(String folderName, String name) {
        assert (name.indexOf(46) == -1);
        if (name.startsWith("ic_action_")) {
            return true;
        }
        if (this.actionBarIcons != null) {
            if (folderName.startsWith("mipmap")) {
                name = "@mipmap/" + name;
            }
            return this.actionBarIcons.contains(name);
        }
        return false;
    }

    private boolean isActionBarIcon(Context context2, String folderName, String name, File file) {
        if (this.isActionBarIcon(folderName, name)) {
            return true;
        }
        return file != null && name.startsWith("ic_menu_");
    }

    private static boolean isAdaptiveIconLayer(String name) {
        return name.startsWith("ic_launcher") && (name.endsWith("_foreground") || name.endsWith("_background"));
    }

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.MENU;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("application", "activity", "activity-alias", "service", "provider", "receiver", "item");
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        String icon = element.getAttributeNS("http://schemas.android.com/apk/res/android", "icon");
        this.addIcon(context2, element, icon);
        icon = element.getAttributeNS("http://schemas.android.com/apk/res/android", "roundIcon");
        String key = this.addIcon(context2, element, icon);
        if (key != null) {
            if (this.roundIcons == null) {
                this.roundIcons = Sets.newHashSet();
            }
            this.roundIcons.add(key);
        }
    }

    private String addIcon(XmlContext context2, Element element, String icon) {
        if (icon == null || icon.isEmpty()) {
            return null;
        }
        if (icon.startsWith("@drawable/")) {
            icon = icon.substring("@drawable/".length());
        } else if (!icon.startsWith("@mipmap/")) {
            return null;
        }
        String tagName = element.getTagName();
        if (tagName.equals("item")) {
            if (this.menuToIcons == null) {
                this.menuToIcons = ArrayListMultimap.create();
            }
            String menu = IconDetector.getBaseName(context2.file.getName());
            this.menuToIcons.put((Object)menu, (Object)icon);
        } else if (tagName.equals("activity") || tagName.equals("activity-alias") || tagName.equals("application")) {
            if (this.launcherIcons == null) {
                this.launcherIcons = Sets.newHashSet();
            }
            this.launcherIcons.add(icon);
        }
        return icon;
    }

    @Override
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        ArrayList<Class<? extends UElement>> types = new ArrayList<Class<? extends UElement>>(2);
        types.add(UCallExpression.class);
        types.add(UMethod.class);
        return types;
    }

    @Override
    public UElementHandler createUastHandler(JavaContext context2) {
        return new NotificationFinder(context2);
    }

    private boolean handleSelect(UElement select) {
        ResourceUrl url = ResourceEvaluator.getResourceConstant(select);
        if (url != null && url.type == ResourceType.DRAWABLE && !url.isFramework()) {
            if (this.notificationIcons == null) {
                this.notificationIcons = Maps.newHashMap();
            }
            this.notificationIcons.put(url.name, select);
            return true;
        }
        return false;
    }

    static {
        boolean includeLdpi = false;
        String value = System.getenv("ANDROID_LINT_INCLUDE_LDPI");
        if (value != null) {
            includeLdpi = Boolean.valueOf(value);
        }
        INCLUDE_LDPI = includeLdpi;
        DENSITY_PATTERN = Pattern.compile("^drawable-(nodpi|xxxhdpi|xxhdpi|xhdpi|hdpi|mdpi" + (INCLUDE_LDPI ? "|ldpi" : "") + ")$");
        DP_NAME_PATTERN = Pattern.compile(".+_(\\d+)dp\\.[a-zA-Z]+");
        DENSITY_QUALIFIERS = new String[]{"-ldpi", "-mdpi", "-hdpi", "-xhdpi", "-xxhdpi", "-xxxhdpi"};
        ICON_TYPE_SCOPE = EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.JAVA_FILE, Scope.MANIFEST);
        IMPLEMENTATION_JAVA = new Implementation(IconDetector.class, ICON_TYPE_SCOPE);
        IMPLEMENTATION_RES_ONLY = new Implementation(IconDetector.class, Scope.ALL_RESOURCES_SCOPE);
        ICON_EXPECTED_SIZE = Issue.create("IconExpectedSize", "Icon has incorrect size", "There are predefined sizes (for each density) for launcher icons. You should follow these conventions to make sure your icons fit in with the overall look of the platform.", Category.ICONS, 5, Severity.WARNING, IMPLEMENTATION_JAVA).setEnabledByDefault(false).addMoreInfo("https://material.io/design/iconography/");
        ICON_DIP_SIZE = Issue.create("IconDipSize", "Icon density-independent size validation", "Checks the all icons which are provided in multiple densities, all compute to roughly the same density-independent pixel (`dip`) size. This catches errors where images are either placed in the wrong folder, or icons are changed to new sizes but some folders are forgotten.", Category.ICONS, 5, Severity.WARNING, IMPLEMENTATION_RES_ONLY);
        ICON_LOCATION = Issue.create("IconLocation", "Image defined in density-independent drawable folder", "The res/drawable folder is intended for density-independent graphics such as shapes defined in XML. For bitmaps, move it to `drawable-mdpi` and consider providing higher and lower resolution versions in `drawable-ldpi`, `drawable-hdpi` and `drawable-xhdpi`. If the icon **really** is density independent (for example a solid color) you can place it in `drawable-nodpi`.", Category.ICONS, 5, Severity.WARNING, IMPLEMENTATION_RES_ONLY).addMoreInfo("https://developer.android.com/guide/practices/screens_support.html");
        ICON_DENSITIES = Issue.create("IconDensities", "Icon densities validation", "Icons will look best if a custom version is provided for each of the major screen density classes (low, medium, high, extra high). This lint check identifies icons which do not have complete coverage across the densities.\n\nLow density is not really used much anymore, so this check ignores the ldpi density. To force lint to include it, set the environment variable `ANDROID_LINT_INCLUDE_LDPI=true`. For more information on current density usage, see https://developer.android.com/about/dashboards", Category.ICONS, 4, Severity.WARNING, IMPLEMENTATION_RES_ONLY).addMoreInfo("https://developer.android.com/guide/practices/screens_support.html");
        ICON_MISSING_FOLDER = Issue.create("IconMissingDensityFolder", "Missing density folder", "Icons will look best if a custom version is provided for each of the major screen density classes (low, medium, high, extra-high, extra-extra-high). This lint check identifies folders which are missing, such as `drawable-hdpi`.\n\nLow density is not really used much anymore, so this check ignores the ldpi density. To force lint to include it, set the environment variable `ANDROID_LINT_INCLUDE_LDPI=true`. For more information on current density usage, see https://developer.android.com/about/dashboards", Category.ICONS, 3, Severity.WARNING, IMPLEMENTATION_RES_ONLY).addMoreInfo("https://developer.android.com/guide/practices/screens_support.html");
        GIF_USAGE = Issue.create("GifUsage", "Using `.gif` format for bitmaps is discouraged", "The `.gif` file format is discouraged. Consider using `.png` (preferred) or `.jpg` (acceptable) instead.", Category.ICONS, 5, Severity.WARNING, IMPLEMENTATION_RES_ONLY).addMoreInfo("https://developer.android.com/guide/topics/resources/drawable-resource.html#Bitmap");
        DUPLICATES_NAMES = Issue.create("IconDuplicates", "Duplicated icons under different names", "If an icon is repeated under different names, you can consolidate and just use one of the icons and delete the others to make your application smaller. However, duplicated icons usually are not intentional and can sometimes point to icons that were accidentally overwritten or accidentally not updated.", Category.ICONS, 3, Severity.WARNING, IMPLEMENTATION_RES_ONLY);
        DUPLICATES_CONFIGURATIONS = Issue.create("IconDuplicatesConfig", "Identical bitmaps across various configurations", "If an icon is provided under different configuration parameters such as `drawable-hdpi` or `-v11`, they should typically be different. This detector catches cases where the same icon is provided in different configuration folder which is usually not intentional.", Category.ICONS, 5, Severity.WARNING, IMPLEMENTATION_RES_ONLY);
        ICON_NODPI = Issue.create("IconNoDpi", "Icon appears in both `-nodpi` and dpi folders", "Bitmaps that appear in `drawable-nodpi` folders will not be scaled by the Android framework. If a drawable resource of the same name appears **both** in a `-nodpi` folder as well as a dpi folder such as `drawable-hdpi`, then the behavior is ambiguous and probably not intentional. Delete one or the other, or use different names for the icons.", Category.ICONS, 7, Severity.WARNING, IMPLEMENTATION_RES_ONLY);
        ICON_MIX_9PNG = Issue.create("IconMixedNinePatch", "Clashing PNG and 9-PNG files", "If you accidentally name two separate resources `file.png` and `file.9.png`, the image file and the nine patch file will both map to the same drawable resource, `@drawable/file`, which is probably not what was intended.", Category.ICONS, 5, Severity.WARNING, IMPLEMENTATION_RES_ONLY);
        ICON_XML_AND_PNG = Issue.create("IconXmlAndPng", "Icon is specified both as `.xml` file and as a bitmap", "If a drawable resource appears as an `.xml` file in the `drawable/` folder, it's usually not intentional for it to also appear as a bitmap using the same name; generally you expect the drawable XML file to define states and each state has a corresponding drawable bitmap.", Category.ICONS, 7, Severity.WARNING, IMPLEMENTATION_RES_ONLY);
        ICON_EXTENSION = Issue.create("IconExtension", "Icon format does not match the file extension", "Ensures that icons have the correct file extension (e.g. a `.png` file is really in the PNG format and not for example a GIF file named `.png`).", Category.ICONS, 3, Severity.WARNING, IMPLEMENTATION_RES_ONLY);
        ICON_COLORS = Issue.create("IconColors", "Icon colors do not follow the recommended visual style", "Notification icons and Action Bar icons should only white and shades of gray. See the Android Design Guide for more details. Note that the way Lint decides whether an icon is an action bar icon or a notification icon is based on the filename prefix: `ic_menu_` for action bar icons, `ic_stat_` for notification icons etc. These correspond to the naming conventions documented in https://material.io/design/iconography/", Category.ICONS, 6, Severity.WARNING, IMPLEMENTATION_JAVA);
        ICON_LAUNCHER_SHAPE = Issue.create("IconLauncherShape", "The launcher icon shape should use a distinct silhouette", "According to the Android Design Guide (https://material.io/design/iconography/) your launcher icons should \"use a distinct silhouette\", a \"three-dimensional, front view, with a slight perspective as if viewed from above, so that users perceive some depth.\"\n\nThe unique silhouette implies that your launcher icon should not be a filled square.", Category.ICONS, 6, Severity.WARNING, IMPLEMENTATION_JAVA);
        NOTIFICATION_ICON_COMPATIBILITY = Issue.create("NotificationIconCompatibility", "Notification Icon Compatibility", "Notification icons should define a raster image to support Android versions below 5.0 (API 21). Note that the way Lint decides whether an icon is a notification icon is based on the filename prefix `ic_stat_`. This corresponds to the naming convention documented in https://material.io/design/iconography/", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION_JAVA);
        WEBP_ELIGIBLE = Issue.create("ConvertToWebp", "Convert to WebP", "The WebP format is typically more compact than PNG and JPEG. As of Android 4.2.1 it supports transparency and lossless conversion as well. Note that there is a quickfix in the IDE which lets you perform conversion.\n\nPreviously, launcher icons were required to be in the PNG format but that restriction is no longer there, so lint now flags these.", Category.ICONS, 6, Severity.WARNING, IMPLEMENTATION_JAVA).setEnabledByDefault(false);
        WEBP_UNSUPPORTED = Issue.create("WebpUnsupported", "WebP Unsupported", "The WebP format requires Android 4.0 (API 15). Certain features, such as lossless encoding and transparency, requires Android 4.2.1 (API 18; API 17 is 4.2.0.)", Category.ICONS, 6, Severity.ERROR, IMPLEMENTATION_JAVA);
    }

    private final class MenuFinder
    extends AbstractUastVisitor {
        private MenuFinder() {
        }

        public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
            Collection icons;
            ResourceUrl url = ResourceEvaluator.getResourceConstant((UElement)node);
            if (url != null && url.type == ResourceType.MENU && !url.isFramework() && IconDetector.this.menuToIcons != null && (icons = IconDetector.this.menuToIcons.get((Object)url.name)) != null) {
                if (IconDetector.this.actionBarIcons == null) {
                    IconDetector.this.actionBarIcons = Sets.newHashSet();
                }
                IconDetector.this.actionBarIcons.addAll(icons);
            }
            return super.visitSimpleNameReferenceExpression(node);
        }

        public boolean visitClass(UClass node) {
            return node instanceof UAnonymousClass || super.visitClass(node);
        }
    }

    private final class SetIconFinder
    extends AbstractUastVisitor {
        private SetIconFinder() {
        }

        public boolean visitCallExpression(UCallExpression expression) {
            List arguments;
            if (UastExpressionUtils.isMethodCall((UElement)expression) && IconDetector.SET_SMALL_ICON.equals(Lint.getMethodName(expression)) && (arguments = expression.getValueArguments()).size() == 1 && arguments.get(0) instanceof UReferenceExpression) {
                IconDetector.this.handleSelect((UElement)arguments.get(0));
            }
            return super.visitCallExpression(expression);
        }

        public boolean visitClass(UClass node) {
            return node instanceof UAnonymousClass || super.visitClass(node);
        }
    }

    private final class NotificationFinder
    extends UElementHandler {
        private final JavaContext context;

        private NotificationFinder(JavaContext context2) {
            this.context = context2;
        }

        @Override
        public void visitMethod(UMethod method) {
            if (IconDetector.ON_CREATE_OPTIONS_MENU.equals(method.getName())) {
                method.accept((UastVisitor)new MenuFinder());
            }
        }

        @Override
        public void visitCallExpression(UCallExpression node) {
            if (UastExpressionUtils.isConstructorCall((UElement)node)) {
                this.visitConstructorCall(node);
            }
        }

        private void visitConstructorCall(UCallExpression node) {
            UMethod method;
            UReferenceExpression classReference = node.getClassReference();
            if (classReference == null) {
                return;
            }
            PsiElement resolved = classReference.resolve();
            if (!(resolved instanceof PsiClass)) {
                return;
            }
            String typeName = ((PsiClass)resolved).getQualifiedName();
            if (IconDetector.NOTIFICATION_CLASS.equals(typeName)) {
                List args = node.getValueArguments();
                if (args.size() == 3) {
                    if (args.get(0) instanceof UReferenceExpression && IconDetector.this.handleSelect((UElement)args.get(0))) {
                        return;
                    }
                    ResourceUrl url = ResourceEvaluator.getResource(this.context.getEvaluator(), (UElement)args.get(0));
                    if (url != null && (url.type == ResourceType.DRAWABLE || url.type == ResourceType.COLOR || url.type == ResourceType.MIPMAP)) {
                        if (IconDetector.this.notificationIcons == null) {
                            IconDetector.this.notificationIcons = Maps.newHashMap();
                        }
                        IconDetector.this.notificationIcons.put(url.name, node);
                    }
                }
            } else if ((IconDetector.NOTIFICATION_BUILDER_CLASS.equals(typeName) || IconDetector.NOTIFICATION_COMPAT_BUILDER_CLASS.equals(typeName)) && (method = (UMethod)UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)true)) != null) {
                SetIconFinder finder = new SetIconFinder();
                method.accept((UastVisitor)finder);
            }
        }
    }

    private static class WebpHeader {
        public String format;
        int width;
        int height;

        private WebpHeader() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static WebpHeader getWebpHeader(File file) {
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                if (((InputStream)is).read() != 82 || ((InputStream)is).read() != 73 || ((InputStream)is).read() != 70 || ((InputStream)is).read() != 70 || ((InputStream)is).read() == -1 || ((InputStream)is).read() == -1 || ((InputStream)is).read() == -1 || ((InputStream)is).read() == -1 || ((InputStream)is).read() != 87 || ((InputStream)is).read() != 69 || ((InputStream)is).read() != 66 || ((InputStream)is).read() != 80) {
                    WebpHeader webpHeader = null;
                    return webpHeader;
                }
                if (((InputStream)is).read() != 86 || ((InputStream)is).read() != 80 || ((InputStream)is).read() != 56) {
                    WebpHeader webpHeader = null;
                    return webpHeader;
                }
                int format = ((InputStream)is).read();
                WebpHeader data = new WebpHeader();
                if (format == 76) {
                    data.format = "VP8L";
                    for (int i = 0; i < 4; ++i) {
                        ((InputStream)is).read();
                    }
                    if (((InputStream)is).read() == 47) {
                        int byte1 = ((InputStream)is).read();
                        int byte2 = ((InputStream)is).read();
                        int byte3 = ((InputStream)is).read();
                        int byte4 = ((InputStream)is).read();
                        if (((InputStream)is).read() != -1) {
                            data.width = ((byte2 & 0x3F) << 8 | byte1) + 1;
                            data.height = ((byte4 & 0xF) << 10 | byte3 << 2 | (byte2 & 0xC0) >> 6) + 1;
                        }
                    }
                    WebpHeader byte1 = data;
                    return byte1;
                }
                if (format == 88) {
                    data.format = "VP8X";
                    for (int i = 0; i < 8; ++i) {
                        ((InputStream)is).read();
                    }
                    int byte1 = ((InputStream)is).read();
                    int byte2 = ((InputStream)is).read();
                    int byte3 = ((InputStream)is).read();
                    int byte4 = ((InputStream)is).read();
                    int byte5 = ((InputStream)is).read();
                    int byte6 = ((InputStream)is).read();
                    if (((InputStream)is).read() != -1) {
                        data.width = (byte1 | byte2 << 8 | byte3 << 16) + 1;
                        data.height = (byte4 | byte5 << 8 | byte6 << 16) + 1;
                    }
                    WebpHeader webpHeader = data;
                    return webpHeader;
                }
                if (format == 32) {
                    data.format = "VP8";
                    for (int i = 0; i < 7; ++i) {
                        ((InputStream)is).read();
                    }
                    if (((InputStream)is).read() == 157 && ((InputStream)is).read() == 1 && ((InputStream)is).read() == 42) {
                        int byte1 = ((InputStream)is).read();
                        int byte2 = ((InputStream)is).read();
                        int byte3 = ((InputStream)is).read();
                        int byte4 = ((InputStream)is).read();
                        if (((InputStream)is).read() != -1) {
                            data.width = byte1 | (byte2 & 0x3F) << 8;
                            data.height = byte3 | (byte4 & 0x3F) << 8;
                        }
                    }
                    WebpHeader webpHeader = data;
                    return webpHeader;
                }
                WebpHeader webpHeader = null;
                return webpHeader;
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }
}

