/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GridLayoutDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("GridLayout", "GridLayout validation", "Declaring a layout_row or layout_column that falls outside the declared size of a GridLayout's `rowCount` or `columnCount` is usually an unintentional error.", Category.CORRECTNESS, 4, Severity.FATAL, new Implementation(GridLayoutDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @Override
    public Collection<String> getApplicableElements() {
        return ImmutableSet.of((Object)"GridLayout", (Object)SdkConstants.FQCN_GRID_LAYOUT_V7.oldName(), (Object)SdkConstants.FQCN_GRID_LAYOUT_V7.newName());
    }

    private static int getInt(Element element, String attribute, int defaultValue) {
        String valueString = element.getAttributeNS("http://schemas.android.com/apk/res/android", attribute);
        if (valueString != null && !valueString.isEmpty()) {
            try {
                return Integer.decode(valueString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        int declaredRowCount = GridLayoutDetector.getInt(element, "rowCount", -1);
        int declaredColumnCount = GridLayoutDetector.getInt(element, "columnCount", -1);
        if (declaredColumnCount != -1 || declaredRowCount != -1) {
            for (Element child : XmlUtils.getSubTags((Node)element)) {
                int row;
                Attr node;
                int column;
                if (declaredColumnCount != -1 && (column = GridLayoutDetector.getInt(child, "layout_column", -1)) >= declaredColumnCount) {
                    node = child.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_column");
                    context2.report(ISSUE, node, context2.getLocation(node), String.format("Column attribute (%1$d) exceeds declared grid column count (%2$d)", column, declaredColumnCount));
                }
                if (declaredRowCount == -1 || (row = GridLayoutDetector.getInt(child, "layout_row", -1)) <= declaredRowCount) continue;
                node = child.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "layout_row");
                context2.report(ISSUE, node, context2.getLocation(node), String.format("Row attribute (%1$d) exceeds declared grid row count (%2$d)", row, declaredRowCount));
            }
        }
        if (SdkConstants.FQCN_GRID_LAYOUT_V7.isEquals(element.getTagName())) {
            this.ensureAppNamespace(context2, element, "columnCount");
            this.ensureAppNamespace(context2, element, "orientation");
            this.ensureAppNamespace(context2, element, "rowCount");
            this.ensureAppNamespace(context2, element, "useDefaultMargins");
            this.ensureAppNamespace(context2, element, "alignmentMode");
            this.ensureAppNamespace(context2, element, "columnOrderPreserved");
            this.ensureAppNamespace(context2, element, "rowOrderPreserved");
            for (Element child : XmlUtils.getSubTags((Node)element)) {
                this.ensureAppNamespace(context2, child, "layout_column");
                this.ensureAppNamespace(context2, child, "layout_columnSpan");
                this.ensureAppNamespace(context2, child, "layout_gravity");
                this.ensureAppNamespace(context2, child, "layout_row");
                this.ensureAppNamespace(context2, child, "layout_rowSpan");
                this.ensureAppNamespace(context2, child, "layout_rowWeight");
                this.ensureAppNamespace(context2, child, "layout_columnWeight");
            }
        }
    }

    private void ensureAppNamespace(XmlContext context2, Element element, String name) {
        Attr attribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", name);
        if (attribute != null) {
            boolean haveNamespace;
            String prefix = GridLayoutDetector.getNamespacePrefix(element.getOwnerDocument(), "http://schemas.android.com/apk/res-auto");
            boolean bl = haveNamespace = prefix != null;
            if (!haveNamespace) {
                prefix = "app";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Wrong namespace; with v7 `GridLayout` you should use ").append(prefix).append(":").append(name);
            if (!haveNamespace) {
                sb.append(" (and add `xmlns:app=\"").append("http://schemas.android.com/apk/res-auto").append("\"` to your root element)");
            }
            String message2 = sb.toString();
            LintFix fix = this.fix().name("Update to " + prefix + ":" + name).composite(this.fix().set("http://schemas.android.com/apk/res-auto", name, attribute.getValue()).build(), this.fix().unset("http://schemas.android.com/apk/res/android", name).build()).autoFix();
            context2.report(ISSUE, attribute, context2.getLocation(attribute), message2, fix);
        }
    }

    private static String getNamespacePrefix(Document document, String uri) {
        Element root = document.getDocumentElement();
        if (root == null) {
            return null;
        }
        NamedNodeMap attributes = root.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            Node attribute = attributes.item(i);
            if (!attribute.getNodeName().startsWith("xmlns:") || !attribute.getNodeValue().equals(uri)) continue;
            return attribute.getNodeName().substring("xmlns:".length());
        }
        return null;
    }
}

