/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/FragmentDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "visitClass", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "Companion", "android.sdktools.lint-checks"})
public final class FragmentDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    @NotNull
    public List<String> applicableSuperClasses() {
        Object[] objectArray = new String[2];
        objectArray[0] = "android.app.Fragment";
        String string = SdkConstants.CLASS_V4_FRAGMENT.oldName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CLASS_V4_FRAGMENT.oldName()");
        objectArray[1] = string;
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitClass(@NotNull JavaContext context2, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof UAnonymousClass) {
            context2.report(ISSUE, declaration, context2.getNameLocation(declaration), "Fragments should be static such that they can be re-instantiated by the system, and anonymous classes are not static");
            return;
        }
        JavaEvaluator evaluator = context2.getEvaluator();
        if (evaluator.isAbstract((PsiModifierListOwner)declaration)) {
            return;
        }
        if (!evaluator.isPublic((PsiModifierListOwner)declaration)) {
            context2.report(ISSUE, declaration, context2.getNameLocation(declaration), "This fragment class should be public (" + declaration.getQualifiedName() + ')');
            return;
        }
        if (declaration.getContainingClass() != null && !evaluator.isStatic((PsiModifierListOwner)declaration)) {
            context2.report(ISSUE, declaration, context2.getNameLocation(declaration), "This fragment inner class should be static (" + declaration.getQualifiedName() + ')');
            return;
        }
        boolean hasDefaultConstructor = false;
        boolean hasConstructor = false;
        PsiMethod[] psiMethodArray = declaration.getConstructors();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"declaration.constructors");
        for (PsiMethod constructor : psiMethodArray) {
            Location location2;
            hasConstructor = true;
            if (constructor.getParameterList().getParametersCount() == 0) {
                if (evaluator.isPublic((PsiModifierListOwner)constructor)) {
                    hasDefaultConstructor = true;
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)constructor, (String)"constructor");
                location2 = context2.getNameLocation((PsiElement)constructor);
                JavaContext.report$default(context2, ISSUE, (PsiElement)constructor, location2, "The default constructor must be public", null, 16, null);
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)constructor, (String)"constructor");
            location2 = context2.getNameLocation((PsiElement)constructor);
            String message2 = "Avoid non-default constructors in fragments: use a default constructor plus `Fragment#setArguments(Bundle)` instead";
            JavaContext.report$default(context2, ISSUE, (PsiElement)constructor, location2, message2, null, 16, null);
        }
        if (!hasDefaultConstructor && hasConstructor) {
            String message3 = "This fragment should provide a default constructor (a public constructor with no arguments) (`" + declaration.getQualifiedName() + "`)";
            context2.report(ISSUE, declaration, context2.getNameLocation(declaration), message3);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(FragmentDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default(companion, "ValidFragment", "Fragment not instantiatable", "\n                From the Fragment documentation:\n                **Every** fragment must have an empty constructor, so it can be instantiated \\\n                when restoring its activity's state. It is strongly recommended that subclasses \\\n                do not have other constructors with parameters, since these constructors will \\\n                not be called when the fragment is re-instantiated; instead, arguments can be \\\n                supplied by the caller with `setArguments(Bundle)` and later retrieved by the \\\n                Fragment with `getArguments()`.\n\n                Note that this is no longer true when you are using \\\n                `androidx.fragment.app.Fragment`; with the `FragmentFactory` you can supply \\\n                any arguments you want (as of version androidx version 1.1).\n                ", implementation, "https://developer.android.com/reference/android/app/Fragment.html#Fragment()", category, 6, severity, false, true, null, null, 3328, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/FragmentDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

