/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u00020\u0005H\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u001c\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/checks/ExportedFlagDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "createSetToFalseFix", "Lcom/android/tools/lint/detector/api/LintFix;", "createSetToTrueFix", "filterIncident", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getApplicableElements", "", "", "isNonExportedLaunchable", "exported", "Lorg/w3c/dom/Attr;", "intentFilterTag", "Lorg/w3c/dom/Element;", "visitElement", "", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Companion", "android.sdktools.lint-checks"})
public final class ExportedFlagDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String mainActivityAction = "android.intent.action.MAIN";
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("IntentFilterExportedReceiver", "Unspecified `android:exported` in manifest", "\n                Apps targeting Android 12 and higher are required to specify an explicit value \\\n                for `android:exported` when the corresponding component has an intent filter defined. \\\n                Otherwise, installation will fail. Set it to `true` to make this activity accessible \\\n                to other apps, and `false` to limit it to be used only by this app or the OS. For \\\n                launch activities, this should be set to true; otherwise, the app will fail to launch.\n\n                Previously, `android:exported` for components without any intent filters present \\\n                used to default to `false`, and when intent filters were present, the default was \\\n                `true`. Defaults which change value based on other values are confusing and lead to \\\n                apps accidentally exporting components as a side-effect of adding intent filters. \\\n                This is a security risk, and we have made this change to avoid introducing \\\n                accidental vulnerabilities.\n\n                While the default without intent filters remains unchanged, it is now required to \\\n                explicitly specify a value when intent filters are present. Any app failing to meet \\\n                this requirement will fail to install on any Android version after Android 11.\n\n                We recommend setting `android:exported` to false (even on previous versions of Android \\\n                prior to this requirement) unless you have a good reason to export a particular \\\n                component.\n            ", Category.SECURITY, 5, Severity.WARNING, new Implementation(ExportedFlagDetector.class, Scope.MANIFEST_SCOPE));

    @NotNull
    public List<String> getApplicableElements() {
        Object[] objectArray = new String[]{"activity", "activity-alias", "service", "receiver"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        LintFix[] intentFilter = DomExtensions.subtag((Element)element, (String)"intent-filter");
        Element navGraph = DomExtensions.subtag((Element)element, (String)"nav-graph");
        Attr exported = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "exported");
        if ((intentFilter != null || navGraph != null) && exported == null) {
            Incident incident;
            String string;
            Element element2;
            String message2 = "As of Android 12, `android:exported` must be set; use `true` to make the activity \\\navailable to other apps, and `false` otherwise.";
            LintFix[] lintFixArray = intentFilter;
            if (lintFixArray == null ? false : ((element2 = DomExtensions.subtag((Element)lintFixArray, (String)"action")) == null ? false : ((string = element2.getAttributeNS("http://schemas.android.com/apk/res/android", "name")) == null ? false : string.equals(mainActivityAction)))) {
                incident = new Incident(ISSUE, element, context2.getNameLocation(element), Intrinsics.stringPlus((String)message2, (Object)" For launcher activities, this should be set to `true`."), this.createSetToTrueFix());
            } else {
                lintFixArray = new LintFix[]{this.createSetToTrueFix(), this.createSetToFalseFix()};
                Incident incident2 = new Incident(ISSUE, element, context2.getNameLocation(element), message2, LintFix.Companion.create().alternatives(lintFixArray));
                incident = incident2;
            }
            Incident incident3 = incident;
            context2.report(incident3, this.map());
        } else if (this.isNonExportedLaunchable(exported, (Element)intentFilter)) {
            Intrinsics.checkNotNullExpressionValue((Object)exported, (String)"exported");
            Incident incident = new Incident(ISSUE, exported, context2.getLocation(exported), "A launchable activity must be exported as of Android 12, which also makes it available to other apps.", this.createSetToTrueFix()).overrideSeverity(Severity.ERROR);
            context2.report(incident, this.map());
        }
    }

    @Override
    public boolean filterIncident(@NotNull Context context2, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        if (context2.getMainProject().getTargetSdk() >= 31) {
            incident.overrideSeverity(Severity.ERROR);
        }
        return true;
    }

    private final boolean isNonExportedLaunchable(Attr exported, Element intentFilterTag) {
        String string;
        Element element;
        Node node = exported;
        return Intrinsics.areEqual((Object)(node == null ? null : node.getValue()), (Object)"false") && ((node = intentFilterTag) == null ? false : ((element = DomExtensions.subtag((Element)node, (String)"action")) == null ? false : ((string = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")) == null ? false : string.equals(mainActivityAction))));
    }

    private final LintFix createSetToTrueFix() {
        return this.fix().set().android().attribute("exported").value("true").build();
    }

    private final LintFix createSetToFalseFix() {
        return this.fix().set().android().attribute("exported").value("false").build();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/ExportedFlagDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "mainActivityAction", "", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

