/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULabeledExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPostfixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UYieldExpression;
import org.jetbrains.uast.UastSpecialExpressionKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.KotlinPostfixOperators;
import org.jetbrains.uast.kotlin.kinds.KotlinSpecialExpressionKinds;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u0000 J2\u00020\u0001:\u0001JB#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010/\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u000200H\u0016J\u0018\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u0004H\u0016J\u0010\u00104\u001a\u00020\u00172\u0006\u00104\u001a\u00020\u0004H\u0016J\u0018\u00105\u001a\u00020\u00172\u0006\u00106\u001a\u0002072\u0006\u0010\u0018\u001a\u00020\u001fH\u0002J\u0018\u00108\u001a\u0002092\u0006\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u0004H\u0016J\b\u0010:\u001a\u000209H\u0016J\u0012\u0010;\u001a\u0002092\b\u0010<\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010=\u001a\u0002092\u0006\u0010\u0018\u001a\u00020\u001fH\u0002J\u0010\u0010>\u001a\u0002092\u0006\u0010\u0018\u001a\u00020\u001fH\u0002J\u0010\u0010?\u001a\u0002092\u0006\u0010\u0018\u001a\u00020\u001fH\u0002J\u0010\u0010@\u001a\u0002092\u0006\u0010\u0018\u001a\u00020\u001fH\u0002J\u0010\u0010A\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u001fH\u0016J\u0010\u0010B\u001a\u00020\u00172\u0006\u0010C\u001a\u00020)H\u0016J\u0010\u0010D\u001a\u0002092\u0006\u00102\u001a\u00020\u001fH\u0016J\b\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u0002092\u0006\u0010\u0018\u001a\u00020\u001fH\u0016J\u0010\u0010H\u001a\u0002092\u0006\u0010\u0018\u001a\u00020%H\u0016J\n\u0010I\u001a\u00020F*\u00020\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\r\u00a8\u0006K"}, d2={"Lcom/android/tools/lint/checks/DataFlowAnalyzer;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "initial", "", "Lorg/jetbrains/uast/UElement;", "initialReferences", "Lcom/intellij/psi/PsiVariable;", "(Ljava/util/Collection;Ljava/util/Collection;)V", "getInitial", "()Ljava/util/Collection;", "instances", "", "getInstances", "()Ljava/util/Set;", "received", "getReceived", "references", "Lcom/intellij/psi/PsiElement;", "getReferences", "types", "Lcom/intellij/psi/PsiClass;", "getTypes", "addVariableReference", "", "node", "Lorg/jetbrains/uast/UVariable;", "afterVisitBinaryExpression", "Lorg/jetbrains/uast/UBinaryExpression;", "afterVisitBinaryExpressionWithType", "Lorg/jetbrains/uast/UBinaryExpressionWithType;", "afterVisitCallExpression", "Lorg/jetbrains/uast/UCallExpression;", "afterVisitIfExpression", "Lorg/jetbrains/uast/UIfExpression;", "afterVisitLabeledExpression", "Lorg/jetbrains/uast/ULabeledExpression;", "afterVisitParenthesizedExpression", "Lorg/jetbrains/uast/UParenthesizedExpression;", "afterVisitPostfixExpression", "Lorg/jetbrains/uast/UPostfixExpression;", "afterVisitReturnExpression", "Lorg/jetbrains/uast/UReturnExpression;", "afterVisitSwitchClauseExpression", "Lorg/jetbrains/uast/USwitchClauseExpression;", "afterVisitTryExpression", "Lorg/jetbrains/uast/UTryExpression;", "afterVisitVariable", "afterVisitYieldExpression", "Lorg/jetbrains/uast/UYieldExpression;", "argument", "call", "reference", "field", "handleLambdaSuffix", "lambda", "Lorg/jetbrains/uast/ULambdaExpression;", "ignoreArgument", "", "ignoreCopies", "isMatchingType", "containingClass", "isReturningContext", "isScopingFunction", "isScopingIt", "isScopingThis", "receiver", "returns", "expression", "returnsSelf", "toString", "", "visitCallExpression", "visitParenthesizedExpression", "id", "Companion", "android.sdktools.lint-checks"})
public abstract class DataFlowAnalyzer
extends AbstractUastVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<UElement> initial;
    @NotNull
    private final Set<PsiElement> references;
    @NotNull
    private final Set<UElement> instances;
    @NotNull
    private final Set<UElement> received;
    @NotNull
    private final Set<PsiClass> types;

    public DataFlowAnalyzer(@NotNull Collection<? extends UElement> initial, @NotNull Collection<? extends PsiVariable> initialReferences) {
        Intrinsics.checkNotNullParameter(initial, (String)"initial");
        Intrinsics.checkNotNullParameter(initialReferences, (String)"initialReferences");
        this.initial = initial;
        this.references = new LinkedHashSet();
        this.instances = new LinkedHashSet();
        this.received = new LinkedHashSet();
        this.types = new LinkedHashSet();
        if (this.references.isEmpty()) {
            this.references.addAll(initialReferences);
        }
        if (this.instances.isEmpty()) {
            this.instances.addAll(this.initial);
            for (UElement element : this.initial) {
                UElement parent;
                if (element instanceof UCallExpression && (parent = UastUtils.skipParenthesizedExprUp((UElement)element.getUastParent())) instanceof UQualifiedReferenceExpression && Intrinsics.areEqual((Object)((UQualifiedReferenceExpression)parent).getSelector(), (Object)element)) {
                    this.instances.add(parent);
                }
                UExpression uExpression = element instanceof UExpression ? (UExpression)element : null;
                PsiType psiType = uExpression == null ? null : uExpression.getExpressionType();
                PsiClassType type = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                if ((psiType = type) == null || (uExpression = psiType.resolve()) == null) continue;
                UExpression uExpression2 = uExpression;
                boolean bl = false;
                boolean bl2 = false;
                UExpression it = uExpression2;
                boolean bl3 = false;
                this.getTypes().add((PsiClass)it);
            }
        }
    }

    public /* synthetic */ DataFlowAnalyzer(Collection collection, Collection collection2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            collection2 = CollectionsKt.emptyList();
        }
        this(collection, collection2);
    }

    @NotNull
    public final Collection<UElement> getInitial() {
        return this.initial;
    }

    public void receiver(@NotNull UCallExpression call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
    }

    public void returns(@NotNull UReturnExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
    }

    public void field(@NotNull UElement field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
    }

    public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
    }

    public boolean ignoreArgument(@NotNull UCallExpression call, @NotNull UElement reference) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        String string = call.getMethodName();
        if (string == null) {
            return false;
        }
        String name = string;
        if (Intrinsics.areEqual((Object)name, (Object)"print") || Intrinsics.areEqual((Object)name, (Object)"println") || Intrinsics.areEqual((Object)name, (Object)"log")) {
            return true;
        }
        if (name.length() == 1) {
            UExpression receiver;
            UExpression uExpression = call.getReceiver();
            UExpression uExpression2 = receiver = uExpression == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression);
            if (receiver instanceof USimpleNameReferenceExpression && Intrinsics.areEqual((Object)((USimpleNameReferenceExpression)receiver).getIdentifier(), (Object)"Log")) {
                return true;
            }
        }
        return false;
    }

    public boolean returnsSelf(@NotNull UCallExpression call) {
        PsiClass returnTypeClass;
        PsiClass psiClass;
        Object object;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Object object2 = call.resolve();
        if (object2 == null) {
            return false;
        }
        PsiMethod resolvedCall = object2;
        if (call.getReturnType() instanceof PsiPrimitiveType) {
            return false;
        }
        if (this.ignoreCopies() && (object2 = Lint.getMethodName(call)) != null) {
            object = object2;
            boolean bl = false;
            boolean bl2 = false;
            Object name = object;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)name, (Object)"copy") || Intrinsics.areEqual((Object)name, (Object)"clone") || StringsKt.startsWith$default((String)name, (String)"to", (boolean)false, (int)2, null) && ((String)name).length() > 2 && Character.isUpperCase(((String)name).charAt(2))) {
                return false;
            }
        }
        if ((psiClass = resolvedCall.getContainingClass()) == null) {
            return false;
        }
        Object containingClass = object = psiClass;
        PsiType psiType = call.getReturnType();
        psiClass = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        PsiClass psiClass2 = returnTypeClass = psiClass == null ? null : psiClass.resolve();
        if (Intrinsics.areEqual((Object)returnTypeClass, (Object)containingClass)) {
            return true;
        }
        if (this.isReturningContext(call)) {
            return true;
        }
        if (returnTypeClass != null && !Intrinsics.areEqual((Object)containingClass.getName(), (Object)"Object") && returnTypeClass.isInheritor((PsiClass)containingClass, true)) {
            return true;
        }
        return Intrinsics.areEqual((Object)call.getReturnType(), (Object)Companion.getTypeOfExtensionMethod(resolvedCall));
    }

    public boolean ignoreCopies() {
        return true;
    }

    @NotNull
    protected final Set<PsiElement> getReferences() {
        return this.references;
    }

    @NotNull
    protected final Set<UElement> getInstances() {
        return this.instances;
    }

    @NotNull
    protected final Set<UElement> getReceived() {
        return this.received;
    }

    @NotNull
    protected final Set<PsiClass> getTypes() {
        return this.types;
    }

    public boolean visitCallExpression(@NotNull UCallExpression node) {
        UElement parentParent;
        UElement parent;
        Object valueParameters;
        UElement lambda;
        ULambdaExpression uLambdaExpression;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UExpression uExpression = node.getReceiver();
        UExpression receiver = uExpression == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression);
        boolean matched = false;
        if (receiver != null) {
            if (this.instances.contains(receiver)) {
                matched = true;
            } else {
                PsiElement resolved = UastUtils.tryResolve((UElement)((UElement)receiver));
                if (resolved == null && receiver instanceof USimpleNameReferenceExpression) {
                    if (Intrinsics.areEqual((Object)((USimpleNameReferenceExpression)receiver).getIdentifier(), (Object)"it")) {
                        UElement curr = (UElement)receiver;
                        while ((uLambdaExpression = (ULambdaExpression)UastUtils.getParentOfType((UElement)curr, ULambdaExpression.class, (boolean)true)) != null) {
                            boolean bl;
                            block30: {
                                lambda = uLambdaExpression;
                                valueParameters = lambda.getValueParameters();
                                Iterable $this$any$iv = (Iterable)valueParameters;
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        UParameter parameter = (UParameter)element$iv;
                                        boolean bl2 = false;
                                        PsiElement javaPsi = parameter.getJavaPsi();
                                        PsiElement sourcePsi = parameter.getSourcePsi();
                                        boolean bl3 = javaPsi != null && this.getReferences().contains(javaPsi) || sourcePsi != null && this.getReferences().contains(sourcePsi);
                                        if (!bl3) continue;
                                        bl = true;
                                        break block30;
                                    }
                                    bl = false;
                                }
                            }
                            if (bl) {
                                matched = true;
                                break;
                            }
                            curr = lambda;
                        }
                    }
                } else if (resolved != null && this.references.contains(resolved)) {
                    matched = true;
                }
            }
        } else if (this.received.contains(node)) {
            matched = true;
        } else {
            List args;
            UCallExpression lambdaCall;
            Object object;
            UElement uElement;
            ULambdaExpression $this$any$iv;
            parent = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
            lambda = parent;
            parentParent = UastUtils.skipParenthesizedExprUp((UElement)(lambda == null ? null : lambda.getUastParent()));
            ULambdaExpression uLambdaExpression2 = valueParameters = parent instanceof ULambdaExpression ? (ULambdaExpression)parent : null;
            if (valueParameters == null) {
                ULambdaExpression uLambdaExpression3 = $this$any$iv = parentParent instanceof ULambdaExpression ? (ULambdaExpression)parentParent : null;
                if ($this$any$iv == null) {
                    UElement uElement2 = UastUtils.skipParenthesizedExprUp((UElement)parentParent);
                    UElement uElement3 = uElement = uElement2 == null ? null : uElement2.getUastParent();
                    object = uElement instanceof ULambdaExpression ? (ULambdaExpression)uElement : null;
                } else {
                    object = $this$any$iv;
                }
            } else {
                object = valueParameters;
            }
            uElement = lambda = object;
            $this$any$iv = UastUtils.skipParenthesizedExprUp((UElement)(uElement == null ? null : uElement.getUastParent()));
            UCallExpression uCallExpression = lambdaCall = $this$any$iv instanceof UCallExpression ? (UCallExpression)$this$any$iv : null;
            if (lambdaCall != null && this.isReturningContext(lambdaCall)) {
                if (this.instances.contains(node)) {
                    matched = true;
                }
            } else if (this.isScopingThis(node) && (args = node.getValueArguments()).size() == 2 && CollectionsKt.contains((Iterable)this.instances, (Object)UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)args.get(0)))) && UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)args.get(1))) instanceof ULambdaExpression) {
                uElement = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)args.get(1)));
                if (uElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.uast.ULambdaExpression");
                }
                this.handleLambdaSuffix((ULambdaExpression)uElement, node);
            }
        }
        if (matched) {
            ULambdaExpression lambda2;
            UExpression uExpression2;
            if (!this.initial.contains(node)) {
                this.receiver(node);
            }
            if (this.returnsSelf(node)) {
                this.instances.add((UElement)node);
                parentParent = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
                UQualifiedReferenceExpression uQualifiedReferenceExpression = parent = parentParent instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)parentParent : null;
                if (parent != null) {
                    UExpression chained;
                    this.instances.add(parent);
                    lambda = UastUtils.skipParenthesizedExprUp((UElement)parent.getUastParent());
                    parentParent = lambda instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)lambda : null;
                    uLambdaExpression = parentParent;
                    UExpression uExpression3 = chained = uLambdaExpression == null ? null : uLambdaExpression.getSelector();
                    if (chained != null) {
                        this.instances.add((UElement)chained);
                    }
                }
            }
            UExpression uExpression4 = (uExpression2 = (UExpression)CollectionsKt.lastOrNull((List)node.getValueArguments())) == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression2);
            ULambdaExpression uLambdaExpression4 = lambda2 = uExpression4 instanceof ULambdaExpression ? (ULambdaExpression)uExpression4 : null;
            if (lambda2 != null) {
                this.handleLambdaSuffix(lambda2, node);
            }
        }
        return super.visitCallExpression(node);
    }

    public void afterVisitCallExpression(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        for (UExpression expression : node.getValueArguments()) {
            if (this.instances.contains(expression)) {
                if (this.ignoreArgument(node, (UElement)expression)) continue;
                this.argument(node, (UElement)expression);
                continue;
            }
            if (!(expression instanceof UReferenceExpression) || !CollectionsKt.contains((Iterable)this.references, (Object)((UReferenceExpression)expression).resolve())) continue;
            if (this.ignoreArgument(node, (UElement)expression)) break;
            this.argument(node, (UElement)expression);
            break;
        }
        super.afterVisitCallExpression(node);
    }

    private final void handleLambdaSuffix(ULambdaExpression lambda, UCallExpression node) {
        if (this.isScopingIt(node)) {
            if (lambda.getValueParameters().size() == 1) {
                UParameter lambdaVar = (UParameter)CollectionsKt.first((List)lambda.getValueParameters());
                this.instances.add((UElement)lambdaVar);
                this.addVariableReference((UVariable)lambdaVar);
            }
        } else if (this.isScopingThis(node)) {
            lambda.getBody().accept((UastVisitor)new AbstractUastVisitor(this, lambda){
                final /* synthetic */ DataFlowAnalyzer this$0;
                final /* synthetic */ ULambdaExpression $lambda;
                {
                    this.this$0 = $receiver;
                    this.$lambda = $lambda;
                }

                private final void checkBinding(UElement node, PsiElement resolved, Set<UElement> target2) {
                    PsiClass psiClass;
                    PsiClassType psiClassType;
                    PsiMember psiMember;
                    PsiMember psiMember2 = psiMember = resolved instanceof PsiMember ? (PsiMember)resolved : null;
                    if (psiMember == null) {
                        return;
                    }
                    PsiMember member = psiMember;
                    PsiClass containingClass = member.getContainingClass();
                    if (DataFlowAnalyzer.access$isMatchingType(this.this$0, containingClass)) {
                        target2.add(node);
                    }
                    if (member instanceof PsiMethod && (psiClassType = DataFlowAnalyzer.Companion.getTypeOfExtensionMethod((PsiMethod)member)) != null && (psiClass = psiClassType.resolve()) != null) {
                        PsiClass psiClass2 = psiClass;
                        DataFlowAnalyzer dataFlowAnalyzer = this.this$0;
                        boolean bl = false;
                        boolean bl2 = false;
                        PsiClass extensionClass = psiClass2;
                        boolean bl3 = false;
                        if (DataFlowAnalyzer.access$isMatchingType(dataFlowAnalyzer, extensionClass)) {
                            target2.add(node);
                        }
                    }
                }

                public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    this.checkBinding((UElement)node, node.resolve(), this.this$0.getReceived());
                    return super.visitSimpleNameReferenceExpression(node);
                }

                public boolean visitCallExpression(@NotNull UCallExpression node) {
                    UExpression callReceiver;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    UExpression uExpression = node.getReceiver();
                    UExpression uExpression2 = callReceiver = uExpression == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression);
                    if (callReceiver == null) {
                        this.checkBinding((UElement)node, (PsiElement)node.resolve(), this.this$0.getReceived());
                    } else if (callReceiver instanceof UThisExpression) {
                        this.checkBinding((UElement)callReceiver, (PsiElement)node.resolve(), this.this$0.getInstances());
                    }
                    return super.visitCallExpression(node);
                }

                public boolean visitLambdaExpression(@NotNull ULambdaExpression node) {
                    UCallExpression parent;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    UElement uElement = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
                    UCallExpression uCallExpression = parent = uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
                    PsiType psiType = uCallExpression == null ? null : uCallExpression.getExpressionType();
                    PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                    PsiClass typeClass = psiClassType == null ? null : psiClassType.resolve();
                    this.this$0.getInstances().contains(this.$lambda);
                    if (DataFlowAnalyzer.access$isMatchingType(this.this$0, typeClass) && parent != null && DataFlowAnalyzer.access$isScopingThis(this.this$0, parent)) {
                        return true;
                    }
                    return super.visitLambdaExpression(node);
                }
            });
        }
    }

    private final boolean isMatchingType(PsiClass containingClass) {
        PsiClass it;
        boolean bl;
        boolean $i$f$any;
        Iterable $this$any$iv;
        block10: {
            PsiClass psiClass = containingClass;
            if (psiClass == null) {
                return false;
            }
            $this$any$iv = this.types;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (PsiClass)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)containingClass, (Object)it)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)containingClass.getName(), (Object)"Object")) {
            boolean bl3;
            block11: {
                $this$any$iv = this.types;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (PsiClass)element$iv;
                        boolean bl4 = false;
                        if (!it.isInheritor(containingClass, true)) continue;
                        bl3 = true;
                        break block11;
                    }
                    bl3 = false;
                }
            }
            if (bl3) {
                return true;
            }
        }
        return false;
    }

    public boolean visitParenthesizedExpression(@NotNull UParenthesizedExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.instances.contains(node)) {
            this.instances.add((UElement)node.getExpression());
        }
        return super.visitParenthesizedExpression(node);
    }

    public void afterVisitParenthesizedExpression(@NotNull UParenthesizedExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.instances.contains(node.getExpression())) {
            this.instances.add((UElement)node);
        }
        super.afterVisitParenthesizedExpression(node);
    }

    public void afterVisitVariable(@NotNull UVariable node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof ULocalVariable) {
            UExpression initializer;
            UExpression uExpression = node.getUastInitializer();
            UExpression uExpression2 = initializer = uExpression == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression);
            if (initializer != null) {
                PsiElement resolved;
                if (this.instances.contains(initializer)) {
                    this.addVariableReference(node);
                } else if (initializer instanceof UReferenceExpression && (resolved = ((UReferenceExpression)initializer).resolve()) != null && this.references.contains(resolved)) {
                    this.addVariableReference(node);
                }
            }
        }
        super.afterVisitVariable(node);
    }

    public void afterVisitPostfixExpression(@NotNull UPostfixExpression node) {
        UExpression element;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getOperator(), (Object)KotlinPostfixOperators.EXCLEXCL) && this.instances.contains(element = node.getOperand())) {
            this.instances.add((UElement)node);
        }
        super.afterVisitPostfixExpression(node);
    }

    public void afterVisitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UExpression element = node.getOperand();
        if (this.instances.contains(element)) {
            this.instances.add((UElement)node);
        }
        super.afterVisitBinaryExpressionWithType(node);
    }

    protected final void addVariableReference(@NotNull UVariable node) {
        PsiElement it;
        boolean bl;
        boolean bl2;
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiElement psiElement2 = node.getSourcePsi();
        if (psiElement2 != null) {
            psiElement = psiElement2;
            bl2 = false;
            bl = false;
            it = psiElement;
            boolean bl3 = false;
            this.getReferences().add(it);
        }
        psiElement = node.getJavaPsi();
        PsiVariable psiVariable = psiElement2 = psiElement instanceof PsiVariable ? (PsiVariable)psiElement : null;
        if (psiElement2 != null) {
            psiElement = psiElement2;
            bl2 = false;
            bl = false;
            it = psiElement;
            boolean bl4 = false;
            this.getReferences().add(it);
        }
    }

    public void afterVisitSwitchClauseExpression(@NotNull USwitchClauseExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof USwitchClauseExpressionWithBody) {
            for (UExpression expression : ((USwitchClauseExpressionWithBody)node).getBody().getExpressions()) {
                if (!this.instances.contains(expression)) continue;
                UElement $this$getParentOfType$iv = (UElement)node;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                USwitchExpression uSwitchExpression = (USwitchExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, USwitchExpression.class, (boolean)strict$iv);
                if (uSwitchExpression == null) continue;
                this.instances.add((UElement)uSwitchExpression);
                break;
            }
        }
        super.afterVisitSwitchClauseExpression(node);
    }

    public void afterVisitYieldExpression(@NotNull UYieldExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UElement element = (UElement)node.getExpression();
        if (element != null && this.instances.contains(element)) {
            this.instances.add((UElement)node);
        }
        super.afterVisitYieldExpression(node);
    }

    public void afterVisitLabeledExpression(@NotNull ULabeledExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.instances.contains(node.getExpression())) {
            this.instances.add((UElement)node);
        }
        super.afterVisitLabeledExpression(node);
    }

    public void afterVisitIfExpression(@NotNull UIfExpression node) {
        UExpression elseExpression;
        UExpression then;
        UExpression uExpression;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!Lint.isJava(node.getSourcePsi())) {
            UElement parent = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
            if (parent instanceof UExpressionList && Intrinsics.areEqual((Object)((UExpressionList)parent).getKind(), (Object)KotlinSpecialExpressionKinds.ELVIS)) {
                PsiElement variable;
                uExpression = node.getThenExpression();
                UExpression uExpression2 = then = uExpression == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression);
                if (then instanceof USimpleNameReferenceExpression && (variable = ((USimpleNameReferenceExpression)then).resolve()) != null) {
                    if (this.references.contains(variable)) {
                        this.instances.add(parent);
                    } else if (variable instanceof UVariable) {
                        PsiElement psi = ((UVariable)variable).getJavaPsi();
                        PsiElement sourcePsi = ((UVariable)variable).getSourcePsi();
                        if (psi != null && this.references.contains(psi) || sourcePsi != null && this.references.contains(sourcePsi)) {
                            this.instances.add(parent);
                        }
                    }
                }
            }
        } else if (!node.isTernary()) {
            super.afterVisitIfExpression(node);
            return;
        }
        UExpression thenExpression = (then = node.getThenExpression()) == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)then);
        uExpression = node.getElseExpression();
        UExpression uExpression3 = elseExpression = uExpression == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression);
        if (thenExpression != null && this.instances.contains(thenExpression)) {
            this.instances.add((UElement)node);
        } else if (elseExpression != null && this.instances.contains(elseExpression)) {
            this.instances.add((UElement)node);
        } else {
            UExpression it;
            boolean bl;
            UExpression uExpression4;
            if (thenExpression instanceof UBlockExpression && (uExpression = (UExpression)CollectionsKt.lastOrNull((List)((UBlockExpression)thenExpression).getExpressions())) != null) {
                uExpression4 = uExpression;
                boolean bl2 = false;
                bl = false;
                it = uExpression4;
                boolean bl3 = false;
                if (this.getInstances().contains(it)) {
                    this.getInstances().add((UElement)node);
                }
            }
            if (elseExpression instanceof UBlockExpression && (uExpression = (UExpression)CollectionsKt.lastOrNull((List)((UBlockExpression)elseExpression).getExpressions())) != null) {
                uExpression4 = uExpression;
                boolean bl4 = false;
                bl = false;
                it = uExpression4;
                boolean bl5 = false;
                if (this.getInstances().contains(it)) {
                    this.getInstances().add((UElement)node);
                }
            }
        }
        super.afterVisitIfExpression(node);
    }

    public void afterVisitTryExpression(@NotNull UTryExpression node) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UExpression uExpression = node.getTryClause();
        Object object2 = object = uExpression instanceof UBlockExpression ? (UBlockExpression)uExpression : null;
        if (object == null) {
            return;
        }
        Object tryBlock = object;
        if ((object = (UExpression)CollectionsKt.lastOrNull((List)tryBlock.getExpressions())) != null) {
            uExpression = object;
            boolean bl = false;
            boolean bl2 = false;
            UExpression lastExpression = uExpression;
            boolean bl3 = false;
            if (this.getInstances().contains(lastExpression)) {
                this.getInstances().add((UElement)node);
            }
        }
        for (UCatchClause clause : node.getCatchClauses()) {
            UBlockExpression clauseBody;
            UExpression uExpression2 = clause.getBody();
            UBlockExpression uBlockExpression = uExpression2 instanceof UBlockExpression ? (UBlockExpression)uExpression2 : null;
            if (uBlockExpression == null || (uBlockExpression = (UExpression)CollectionsKt.lastOrNull((List)(clauseBody = uBlockExpression).getExpressions())) == null) continue;
            uExpression2 = uBlockExpression;
            boolean bl = false;
            boolean bl4 = false;
            UExpression lastExpression = uExpression2;
            boolean bl5 = false;
            if (!this.getInstances().contains(lastExpression)) continue;
            this.getInstances().add((UElement)node);
        }
        super.afterVisitTryExpression(node);
    }

    public void afterVisitBinaryExpression(@NotNull UBinaryExpression node) {
        UExpression lhs;
        PsiElement resolved;
        PsiElement lhs2;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!UastExpressionUtils.isAssignment((UElement)((UElement)node))) {
            super.afterVisitBinaryExpression(node);
            return;
        }
        boolean clearLhs = true;
        UExpression rhs = node.getRightOperand();
        if (this.instances.contains(rhs)) {
            lhs2 = UastUtils.tryResolve((UElement)((UElement)node.getLeftOperand()));
            if (lhs2 instanceof UVariable) {
                this.addVariableReference((UVariable)lhs2);
            } else if (lhs2 instanceof PsiLocalVariable) {
                this.references.add(lhs2);
            } else if (lhs2 instanceof PsiParameter) {
                this.references.add(lhs2);
            } else if (lhs2 instanceof PsiField) {
                this.field((UElement)rhs);
            } else if (lhs2 instanceof PsiMethod) {
                this.field((UElement)rhs);
            }
        } else if (rhs instanceof UReferenceExpression && (resolved = ((UReferenceExpression)rhs).resolve()) != null && this.references.contains(resolved)) {
            clearLhs = false;
            lhs = UastUtils.tryResolve((UElement)((UElement)node.getLeftOperand()));
            if (lhs instanceof UVariable) {
                this.addVariableReference((UVariable)lhs);
            } else if (lhs instanceof PsiParameter) {
                this.references.add((PsiElement)lhs);
            } else if (lhs instanceof PsiLocalVariable) {
                this.references.add((PsiElement)lhs);
            } else if (lhs instanceof PsiField) {
                this.field((UElement)rhs);
            } else if (lhs instanceof PsiMethod) {
                this.field((UElement)rhs);
            }
        }
        if (clearLhs) {
            UElement block;
            lhs = UastUtils.skipParenthesizedExprDown((UExpression)node.getLeftOperand());
            PsiElement psiElement = lhs2 = lhs == null ? null : UastUtils.tryResolve((UElement)((UElement)lhs));
            if (lhs2 != null && !Intrinsics.areEqual((Object)lhs2, this.initial) && this.references.contains(lhs2) && (block = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent())) instanceof UBlockExpression && this.initial.size() == 1) {
                UExpression uExpression;
                Class[] classArray = CollectionsKt.first((Iterable)this.initial);
                UExpression uExpression2 = classArray instanceof UExpression ? (UExpression)classArray : null;
                UExpression uExpression3 = uExpression = uExpression2 == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression2);
                if (uExpression == null) {
                    return;
                }
                UExpression element = uExpression;
                if (UastLintUtilsKt.isBelow$default((UElement)element, (UElement)node, false, 2, null)) {
                    return;
                }
                classArray = new Class[]{UIfExpression.class};
                uExpression2 = UastUtils.getParentOfType((UElement)((UElement)element), (boolean)false, UBlockExpression.class, (Class[])classArray);
                if (uExpression2 == null) {
                    return;
                }
                UExpression initialBlock = uExpression2;
                if (initialBlock == block) {
                    this.references.remove(lhs2);
                } else if (UastLintUtilsKt.isBelow$default((UElement)node, (UElement)initialBlock, false, 2, null)) {
                    Ref.BooleanRef referenced = new Ref.BooleanRef();
                    UElement uElement = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
                    if (uElement == null) {
                        return;
                    }
                    UElement target2 = uElement;
                    initialBlock.accept((UastVisitor)new AbstractUastVisitor(target2, lhs2, referenced){
                        private boolean reachedTarget;
                        final /* synthetic */ UElement $target;
                        final /* synthetic */ PsiElement $lhs;
                        final /* synthetic */ Ref.BooleanRef $referenced;
                        {
                            this.$target = $target;
                            this.$lhs = $lhs;
                            this.$referenced = $referenced;
                        }

                        public void afterVisitElement(@NotNull UElement node) {
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            if (Intrinsics.areEqual((Object)node, (Object)this.$target)) {
                                this.reachedTarget = true;
                            }
                            super.afterVisitElement(node);
                        }

                        public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                            PsiElement resolved;
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            if (this.reachedTarget && this.$lhs.isEquivalentTo(resolved = node.resolve())) {
                                this.$referenced.element = true;
                                return true;
                            }
                            return super.visitSimpleNameReferenceExpression(node);
                        }
                    });
                    if (!referenced.element) {
                        this.references.remove(lhs2);
                    }
                }
            }
        }
        super.afterVisitBinaryExpression(node);
    }

    public void afterVisitReturnExpression(@NotNull UReturnExpression node) {
        UExpression returnValue;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UExpression uExpression = node.getReturnExpression();
        UExpression uExpression2 = returnValue = uExpression == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression);
        if (returnValue != null) {
            PsiElement resolved;
            if (this.instances.contains(returnValue)) {
                this.returns(node);
            } else if (returnValue instanceof UReferenceExpression && (resolved = ((UReferenceExpression)returnValue).resolve()) != null && this.references.contains(resolved)) {
                this.returns(node);
            }
        }
        super.afterVisitReturnExpression(node);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Instances:\n");
        for (UElement instance : this.instances) {
            sb.append(this.id(instance));
            sb.append("\n");
        }
        Iterator<UElement> iterator = this.received;
        boolean instance = false;
        if (!iterator.isEmpty()) {
            sb.append("Receivers:\n");
            for (UElement receiver : this.received) {
                sb.append(this.id(receiver));
                sb.append("\n");
            }
        }
        iterator = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"sb.toString()");
        return iterator;
    }

    @NotNull
    public final String id(@NotNull UElement $this$id) {
        String string;
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)$this$id, (String)"<this>");
        StringBuilder stringBuilder = new StringBuilder().append(Integer.toHexString(System.identityHashCode($this$id))).append(':');
        PsiElement psiElement = $this$id.getSourcePsi();
        if (psiElement == null) {
            string3 = null;
        } else {
            string2 = psiElement.getText();
            if (string2 == null) {
                string3 = null;
            } else {
                CharSequence charSequence = string2;
                Regex regex = new Regex("\\s+");
                String string4 = " ";
                boolean bl = false;
                string3 = regex.replace(charSequence, string4);
            }
        }
        String s = stringBuilder.append((Object)string3).toString();
        int max = 100;
        if (s.length() > max) {
            StringBuilder stringBuilder2 = new StringBuilder();
            string2 = s;
            int n = 0;
            int n2 = max / 2;
            boolean bl = false;
            String string5 = string2;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            StringBuilder stringBuilder3 = stringBuilder2.append(string6).append("...");
            string2 = s;
            n = max / 2 + 3;
            n2 = 0;
            String string7 = string2;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
            string = stringBuilder3.append(string8).toString();
        } else {
            string = s;
        }
        return string;
    }

    private final boolean isScopingThis(UCallExpression node) {
        block11: {
            String name = Lint.getMethodName(node);
            if (name == null) break block11;
            int n = -1;
            switch (name.hashCode()) {
                case 3649734: {
                    if (name.equals("with")) {
                        n = 1;
                    }
                    break;
                }
                case 93029230: {
                    if (name.equals("apply")) {
                        n = 1;
                    }
                    break;
                }
                case 113291: {
                    if (name.equals("run")) {
                        n = 1;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    return this.isScopingFunction(node);
                }
            }
        }
        return false;
    }

    private final boolean isScopingIt(UCallExpression node) {
        String name = Lint.getMethodName(node);
        if (Intrinsics.areEqual((Object)name, (Object)"let") || Intrinsics.areEqual((Object)name, (Object)"also")) {
            return this.isScopingFunction(node);
        }
        return false;
    }

    private final boolean isReturningContext(UCallExpression node) {
        String name = Lint.getMethodName(node);
        if (Intrinsics.areEqual((Object)name, (Object)"apply") || Intrinsics.areEqual((Object)name, (Object)"also")) {
            return this.isScopingFunction(node);
        }
        return false;
    }

    private final boolean isScopingFunction(UCallExpression node) {
        PsiMethod psiMethod = node.resolve();
        if (psiMethod == null) {
            return true;
        }
        PsiMethod called = psiMethod;
        return Intrinsics.areEqual((Object)((psiMethod = called.getContainingClass()) == null ? null : psiMethod.getQualifiedName()), (Object)"kotlin.StandardKt__StandardKt");
    }

    public static final /* synthetic */ boolean access$isMatchingType(DataFlowAnalyzer $this, PsiClass containingClass) {
        return $this.isMatchingType(containingClass);
    }

    public static final /* synthetic */ boolean access$isScopingThis(DataFlowAnalyzer $this, UCallExpression node) {
        return $this.isScopingThis(node);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/DataFlowAnalyzer$Companion;", "", "()V", "getTypeOfExtensionMethod", "Lcom/intellij/psi/PsiClassType;", "method", "Lcom/intellij/psi/PsiMethod;", "getVariableElement", "Lcom/intellij/psi/PsiVariable;", "rhs", "Lorg/jetbrains/uast/UCallExpression;", "allowChainedCalls", "", "allowFields", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PsiClassType getTypeOfExtensionMethod(@NotNull PsiMethod method) {
            PsiParameter firstParameter;
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            PsiParameterList psiParameterList = method.getParameterList();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"method.parameterList");
            PsiParameterList parameterList = psiParameterList;
            if (parameterList.getParametersCount() > 0 && (firstParameter = parameterList.getParameter(0)) != null) {
                String string = firstParameter.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"firstParameter.name");
                if (StringsKt.startsWith$default((String)string, (String)"$this$", (boolean)false, (int)2, null)) {
                    string = firstParameter.getType();
                    return string instanceof PsiClassType ? (PsiClassType)string : null;
                }
            }
            return null;
        }

        @Nullable
        public final PsiVariable getVariableElement(@NotNull UCallExpression rhs, boolean allowChainedCalls, boolean allowFields) {
            Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
            UElement parent = UastUtils.skipParenthesizedExprUp((UElement)UastUtils.getQualifiedParentOrThis((UExpression)((UExpression)rhs)).getUastParent());
            if (allowChainedCalls) {
                while (parent instanceof UQualifiedReferenceExpression) {
                    UElement parentParent = UastUtils.skipParenthesizedExprUp((UElement)((UQualifiedReferenceExpression)parent).getUastParent());
                    if (parentParent instanceof UQualifiedReferenceExpression) {
                        parent = UastUtils.skipParenthesizedExprUp((UElement)((UQualifiedReferenceExpression)parentParent).getUastParent());
                        continue;
                    }
                    if (!(parentParent instanceof UVariable) && !(parentParent instanceof UPolyadicExpression)) break;
                    parent = parentParent;
                    break;
                }
            }
            if (parent != null && UastExpressionUtils.isAssignment((UElement)parent)) {
                PsiElement resolved;
                UElement uElement = parent;
                UBinaryExpression assignment = (UBinaryExpression)uElement;
                UExpression lhs = assignment.getLeftOperand();
                if (lhs instanceof UReferenceExpression && (resolved = ((UReferenceExpression)lhs).resolve()) instanceof PsiVariable && (allowFields || !(resolved instanceof PsiField))) {
                    return (PsiVariable)resolved;
                }
            } else if (parent instanceof UVariable && (allowFields || !(parent instanceof UField))) {
                UElement uElement;
                if (((UVariable)parent).getUastParent() instanceof UDeclarationsExpression) {
                    UElement uElement2 = ((UVariable)parent).getUastParent();
                    Intrinsics.checkNotNull((Object)uElement2);
                    if (uElement2.getUastParent() instanceof UExpressionList) {
                        UElement uElement3 = ((UVariable)parent).getUastParent();
                        Intrinsics.checkNotNull((Object)uElement3);
                        UElement lhs = uElement3.getUastParent();
                        if (lhs == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.uast.UExpressionList");
                        }
                        UExpressionList exp = (UExpressionList)lhs;
                        UastSpecialExpressionKind kind = exp.getKind();
                        if (Intrinsics.areEqual((Object)kind.getName(), (Object)"elvis") && exp.getUastParent() instanceof UVariable) {
                            parent = exp.getUastParent();
                        }
                    }
                }
                if ((uElement = parent) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.uast.UVariable");
                }
                return ((UVariable)uElement).getPsi();
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

