/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UInstanceExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULoopExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastOperator;
import org.jetbrains.uast.UastPostfixOperator;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0016\u0010\u0015\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00160\u0013H\u0016J0\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u000bH\u0002J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J \u0010%\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006*"}, d2={"Lcom/android/tools/lint/checks/AssertDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkKotlinAssertion", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "assertion", "Lorg/jetbrains/uast/UCallExpression;", "condition", "Lorg/jetbrains/uast/UExpression;", "checkSideEffect", "createKotlinAssertionStatusFix", "Lcom/android/tools/lint/detector/api/LintFix;", "assertCall", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "getApplicableMethodNames", "", "", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "getSideEffect", "Lkotlin/Pair;", "node", "depth", "", "callDepth", "isAssertionStatusCheck", "", "isExpensive", "argument", "isLocal", "lhs", "isWithinAssertionStatusCheck", "visitMethodCall", "method", "Lcom/intellij/psi/PsiMethod;", "warnAboutWork", "Issues", "android.sdktools.lint-checks"})
public final class AssertDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(AssertDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue SIDE_EFFECT = Issue.Companion.create("AssertionSideEffect", "Assertions with Side Effects", "\n                Assertion conditions can have side effects. This is risky because the behavior \\\n                depends on whether assertions are on or off. This is usually not intentional, \\\n                and can lead to bugs where the production version differs from the version tested \\\n                during development.\n\n                Generally, you'll want to perform the operation with the side effect before the \\\n                assertion, and then assert that the result was what you expected.\n                ", Category.PERFORMANCE, 4, Severity.WARNING, IMPLEMENTATION);
    @JvmField
    @NotNull
    public static final Issue EXPENSIVE;
    private static final int MAX_CALL_DEPTH;
    private static final int MAX_RECURSION_DEPTH;
    private static final int MAX_STATEMENT_COUNT;

    @Override
    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UCallExpression.class);
    }

    @Override
    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new UElementHandler(this, context2){
            final /* synthetic */ AssertDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node.getSourcePsi() instanceof PsiAssertStatement) {
                    Object object = node.getSourcePsi();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiAssertStatement");
                    }
                    PsiExpression psiExpression = ((PsiAssertStatement)object).getAssertCondition();
                    if (psiExpression == null) {
                        return;
                    }
                    PsiExpression psiExpression2 = psiExpression;
                    PsiExpression condition = psiExpression2;
                    psiExpression2 = UastFacade.INSTANCE.convertElement((PsiElement)condition, (UElement)node, UExpression.class);
                    if (psiExpression2 != null) {
                        psiExpression = psiExpression2;
                        object = this.this$0;
                        JavaContext javaContext = this.$context;
                        boolean bl = false;
                        boolean bl2 = false;
                        PsiExpression it = psiExpression;
                        boolean bl3 = false;
                        AssertDetector.access$checkSideEffect((AssertDetector)object, javaContext, (UExpression)it);
                    }
                }
            }
        };
    }

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"assert");
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!Lint.isKotlin(node.getSourcePsi())) {
            return;
        }
        PsiClass psiClass = method.getContainingClass();
        String string2 = string = psiClass == null ? null : psiClass.getQualifiedName();
        if (string == null) {
            return;
        }
        String string3 = string;
        String containingClass = string3;
        if (!Intrinsics.areEqual((Object)containingClass, (Object)"kotlin.PreconditionsKt") && !Intrinsics.areEqual((Object)containingClass, (Object)"kotlin.PreconditionsKt__AssertionsJVMKt")) {
            return;
        }
        List valueArguments = node.getValueArguments();
        UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)valueArguments);
        UExpression uExpression2 = psiClass = uExpression == null ? null : UastUtils.skipParenthesizedExprDown((UExpression)uExpression);
        if (psiClass == null) {
            return;
        }
        PsiClass first = psiClass;
        PsiClass condition = first instanceof ULambdaExpression ? (UExpression)CollectionsKt.last((List)valueArguments) : first;
        this.checkKotlinAssertion(context2, node, (UExpression)condition);
        this.checkSideEffect(context2, (UExpression)condition);
    }

    private final void checkKotlinAssertion(JavaContext context2, UCallExpression assertion, UExpression condition) {
        if (context2.isEnabled(EXPENSIVE) && this.warnAboutWork(assertion, condition)) {
            Location location2 = context2.getLocation((UElement)condition);
            String message2 = "Kotlin assertion arguments are always evaluated, even when assertions are off";
            LintFix fix = null;
            UClass cls = (UClass)UastUtils.getParentOfType((UElement)((UElement)assertion), UClass.class, (boolean)true);
            UClass uClass = cls;
            if ((uClass == null ? null : uClass.getSourcePsi()) != null) {
                fix = this.createKotlinAssertionStatusFix(context2, assertion);
                message2 = Intrinsics.stringPlus((String)message2, (Object)". Consider surrounding assertion with `if (javaClass.desiredAssertionStatus()) { assert(...) }`");
            } else {
                fix = null;
            }
            context2.report(EXPENSIVE, (UElement)assertion, location2, message2, fix);
        }
    }

    private final void checkSideEffect(JavaContext context2, UExpression condition) {
        Pair<UExpression, String> sideEffect = this.getSideEffect(condition, 0, 0);
        if (sideEffect != null) {
            JavaContext.report$default(context2, SIDE_EFFECT, (UElement)condition, context2.getLocation((UElement)sideEffect.getFirst()), Intrinsics.stringPlus((String)"Assertion condition has a side effect: ", (Object)sideEffect.getSecond()), null, 16, null);
        }
    }

    private final Pair<UExpression, String> getSideEffect(UExpression node, int depth, int callDepth) {
        block31: {
            UExpression uExpression;
            block33: {
                Pair<UExpression, String> sideEffect2222;
                PsiMethod called;
                block34: {
                    String string;
                    PsiElement sideEffect2222;
                    String name;
                    block35: {
                        block32: {
                            block30: {
                                uExpression = node;
                                if (uExpression == null) {
                                    return null;
                                }
                                if (depth == MAX_RECURSION_DEPTH) {
                                    return null;
                                }
                                uExpression = node;
                                if (!(uExpression instanceof UUnaryExpression)) break block30;
                                UastOperator operator = ((UUnaryExpression)node).getOperator();
                                if (Intrinsics.areEqual((Object)operator, (Object)UastPrefixOperator.INC) || Intrinsics.areEqual((Object)operator, (Object)UastPrefixOperator.DEC) || Intrinsics.areEqual((Object)operator, (Object)UastPostfixOperator.INC) || Intrinsics.areEqual((Object)operator, (Object)UastPostfixOperator.DEC)) {
                                    if (callDepth > 0 && this.isLocal(((UUnaryExpression)node).getOperand())) {
                                        return null;
                                    }
                                    PsiElement psiElement = ((UUnaryExpression)node).getSourcePsi();
                                    String string2 = psiElement == null ? null : psiElement.getText();
                                    return new Pair((Object)node, (Object)(string2 == null ? ((UUnaryExpression)node).getOperator().getText() : string2));
                                }
                                break block31;
                            }
                            if (!(uExpression instanceof UPolyadicExpression)) break block32;
                            if (node instanceof UBinaryExpression && ((UPolyadicExpression)node).getOperator() instanceof UastBinaryOperator.AssignOperator && (callDepth == 0 || !this.isLocal(((UBinaryExpression)node).getLeftOperand()))) {
                                PsiElement psiElement = ((UPolyadicExpression)node).getSourcePsi();
                                String operator = psiElement == null ? null : psiElement.getText();
                                return new Pair((Object)node, (Object)(operator == null ? ((UPolyadicExpression)node).getOperator().getText() : operator));
                            }
                            for (UExpression operand : ((UPolyadicExpression)node).getOperands()) {
                                Pair<UExpression, String> sideEffect2222 = this.getSideEffect(operand, depth + 1, callDepth);
                                if (sideEffect2222 == null) continue;
                                return sideEffect2222;
                            }
                            break block31;
                        }
                        if (uExpression instanceof UQualifiedReferenceExpression) {
                            return this.getSideEffect(((UQualifiedReferenceExpression)node).getSelector(), depth + 1, callDepth);
                        }
                        if (uExpression instanceof UParenthesizedExpression) {
                            return this.getSideEffect(((UParenthesizedExpression)node).getExpression(), depth + 1, callDepth);
                        }
                        if (!(uExpression instanceof UCallExpression)) break block33;
                        if (callDepth > MAX_CALL_DEPTH) {
                            return null;
                        }
                        PsiMethod operand = ((UCallExpression)node).resolve();
                        if (operand == null) {
                            return null;
                        }
                        called = operand;
                        if (!(called instanceof PsiCompiledElement)) break block34;
                        String sideEffect2222 = called.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)sideEffect2222, (String)"called.name");
                        name = sideEffect2222;
                        if (Intrinsics.areEqual((Object)name, (Object)"add") || Intrinsics.areEqual((Object)name, (Object)"remove") || Intrinsics.areEqual((Object)name, (Object)"put") || Intrinsics.areEqual((Object)name, (Object)"delete") || Intrinsics.areEqual((Object)name, (Object)"mkdir") || Intrinsics.areEqual((Object)name, (Object)"mkdirs")) break block35;
                        if (!StringsKt.startsWith$default((String)name, (String)"set", (boolean)false, (int)2, null) || name.length() <= 3) break block31;
                        char sideEffect2222 = name.charAt(3);
                        boolean bl = false;
                        if (!Character.isUpperCase(sideEffect2222)) break block31;
                    }
                    return new Pair((Object)node, (Object)((sideEffect2222 = ((UCallExpression)node).getSourcePsi()) == null ? name : ((string = sideEffect2222.getText()) == null ? name : string)));
                }
                UMethod uMethod = Lint.getUMethod(called);
                Pair<UExpression, String> pair2 = sideEffect2222 = uMethod == null ? null : uMethod.getUastBody();
                if (sideEffect2222 == null) {
                    return null;
                }
                Pair<UExpression, String> body = sideEffect2222;
                if ((sideEffect2222 = this.getSideEffect((UExpression)body, depth + 1, callDepth + 1)) != null) {
                    return new Pair((Object)node, sideEffect2222.getSecond());
                }
                break block31;
            }
            if (uExpression instanceof UReturnExpression) {
                return this.getSideEffect(((UReturnExpression)node).getReturnExpression(), depth + 1, callDepth);
            }
            if (uExpression instanceof UIfExpression) {
                Pair<UExpression, String> called = this.getSideEffect(((UIfExpression)node).getCondition(), depth + 1, callDepth);
                if (called != null) {
                    Pair<UExpression, String> pair3 = called;
                    boolean bl = false;
                    boolean bl2 = false;
                    Pair<UExpression, String> it = pair3;
                    boolean bl3 = false;
                    return it;
                }
                called = this.getSideEffect(((UIfExpression)node).getThenExpression(), depth + 1, callDepth);
                if (called != null) {
                    Pair<UExpression, String> pair4 = called;
                    boolean bl = false;
                    boolean bl4 = false;
                    Pair<UExpression, String> it = pair4;
                    boolean bl5 = false;
                    return it;
                }
                called = this.getSideEffect(((UIfExpression)node).getElseExpression(), depth + 1, callDepth);
                if (called != null) {
                    Pair<UExpression, String> pair5 = called;
                    boolean bl = false;
                    boolean bl6 = false;
                    Pair<UExpression, String> it = pair5;
                    boolean bl7 = false;
                    return it;
                }
            } else if (uExpression instanceof UTryExpression) {
                Pair<UExpression, String> called = this.getSideEffect(((UTryExpression)node).getTryClause(), depth + 1, callDepth);
                if (called != null) {
                    Pair<UExpression, String> pair6 = called;
                    boolean bl = false;
                    boolean bl8 = false;
                    Pair<UExpression, String> it = pair6;
                    boolean bl9 = false;
                    return it;
                }
                called = this.getSideEffect(((UTryExpression)node).getFinallyClause(), depth + 1, callDepth);
                if (called != null) {
                    Pair<UExpression, String> pair7 = called;
                    boolean bl = false;
                    boolean bl10 = false;
                    Pair<UExpression, String> it = pair7;
                    boolean bl11 = false;
                    return it;
                }
            } else if (uExpression instanceof UBlockExpression) {
                List expressions = ((UBlockExpression)node).getExpressions();
                int n = 0;
                int n2 = MAX_STATEMENT_COUNT;
                int it = expressions.size();
                boolean bl = false;
                int n3 = Math.min(n2, it);
                if (n < n3) {
                    do {
                        int i;
                        Pair<UExpression, String> sideEffect;
                        if ((sideEffect = this.getSideEffect((UExpression)expressions.get(i = n++), depth + 1, callDepth)) == null) continue;
                        return new Pair((Object)node, sideEffect.getSecond());
                    } while (n < n3);
                }
            } else if (uExpression instanceof ULoopExpression) {
                return this.getSideEffect(((ULoopExpression)node).getBody(), depth + 1, callDepth);
            }
        }
        return null;
    }

    private final boolean isLocal(UExpression lhs) {
        PsiElement resolved = UastUtils.tryResolve((UElement)((UElement)lhs));
        return resolved instanceof PsiLocalVariable;
    }

    private final LintFix createKotlinAssertionStatusFix(JavaContext context2, UCallExpression assertCall) {
        return this.fix().name("Surround with desiredAssertionStatus() check").replace().range(context2.getLocation((UElement)assertCall)).pattern("(.*)").with("if (javaClass.desiredAssertionStatus()) { \\k<1> }").reformat(true).build();
    }

    private final boolean warnAboutWork(UCallExpression assertCall, UExpression condition) {
        return this.isExpensive(condition, 0) && !this.isWithinAssertionStatusCheck((UExpression)assertCall);
    }

    private final boolean isExpensive(UExpression argument, int depth) {
        block30: {
            block28: {
                block29: {
                    if (depth == 4) {
                        return true;
                    }
                    if (argument instanceof ULiteralExpression || argument instanceof UInstanceExpression) {
                        return false;
                    }
                    if (argument instanceof UBinaryExpressionWithType) {
                        return argument.getSourcePsi() instanceof KtIsExpression ? false : this.isExpensive(((UBinaryExpressionWithType)argument).getOperand(), depth + 1);
                    }
                    if (argument instanceof UPolyadicExpression) {
                        for (UExpression value : ((UPolyadicExpression)argument).getOperands()) {
                            if (!this.isExpensive(value, depth + 1)) continue;
                            return true;
                        }
                        return false;
                    }
                    if (argument instanceof UParenthesizedExpression) {
                        return this.isExpensive(((UParenthesizedExpression)argument).getExpression(), depth);
                    }
                    if (argument instanceof UBinaryExpression) {
                        return this.isExpensive(((UBinaryExpression)argument).getLeftOperand(), depth + 1) || this.isExpensive(((UBinaryExpression)argument).getRightOperand(), depth + 1);
                    }
                    if (argument instanceof UUnaryExpression) {
                        return this.isExpensive(((UUnaryExpression)argument).getOperand(), depth + 1);
                    }
                    if (argument instanceof USimpleNameReferenceExpression) {
                        return false;
                    }
                    if (argument instanceof UQualifiedReferenceExpression) {
                        return false;
                    }
                    if (!(argument instanceof UCallExpression)) break block28;
                    PsiMethod method = ((UCallExpression)argument).resolve();
                    if (method == null || method instanceof PsiCompiledElement) break block29;
                    UElement uElement = UastUtils.skipParenthesizedExprUp((UElement)((UElement)UastFacade.INSTANCE.getMethodBody(method)));
                    if (uElement == null) {
                        return true;
                    }
                    UElement body = uElement;
                    if (body instanceof UBlockExpression) {
                        List expressions = ((UBlockExpression)body).getExpressions();
                        if (expressions.size() == 1 && expressions.get(0) instanceof UReturnExpression) {
                            UExpression retExp = ((UReturnExpression)expressions.get(0)).getReturnExpression();
                            return retExp == null || this.isExpensive(retExp, depth + 1);
                        }
                    } else if (body instanceof UExpression) {
                        return this.isExpensive((UExpression)body, depth + 1);
                    }
                    break block30;
                }
                String name = ((UCallExpression)argument).getMethodName();
                if (name == null) break block30;
                int n = -1;
                switch (name.hashCode()) {
                    case -567445985: {
                        if (name.equals("contains")) {
                            n = 1;
                        }
                        break;
                    }
                    case 2058039875: {
                        if (name.equals("isEmpty")) {
                            n = 1;
                        }
                        break;
                    }
                    case 759061892: {
                        if (name.equals("isNotEmpty")) {
                            n = 1;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        return false;
                    }
                }
                break block30;
            }
            if (argument instanceof UArrayAccessExpression) {
                for (UExpression value : ((UArrayAccessExpression)argument).getIndices()) {
                    if (!this.isExpensive(value, depth + 1)) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    private final boolean isWithinAssertionStatusCheck(UExpression node) {
        UElement uElement = node.getUastParent();
        if (uElement == null) {
            return false;
        }
        UElement curr = uElement;
        while (true) {
            block12: {
                block11: {
                    boolean bl;
                    block10: {
                        if (curr instanceof UIfExpression && this.isAssertionStatusCheck(((UIfExpression)curr).getCondition())) break block11;
                        if (!(curr instanceof USwitchClauseExpressionWithBody)) break block12;
                        Iterable $this$all$iv = ((USwitchClauseExpressionWithBody)curr).getCaseValues();
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                UExpression p0 = (UExpression)element$iv;
                                boolean bl2 = false;
                                if (this.isAssertionStatusCheck(p0)) continue;
                                bl = false;
                                break block10;
                            }
                            bl = true;
                        }
                    }
                    if (!bl) break block12;
                }
                return true;
            }
            if ((uElement = curr.getUastParent()) == null) {
                return false;
            }
            curr = uElement;
        }
    }

    private final boolean isAssertionStatusCheck(UExpression condition) {
        String string;
        PsiElement psiElement = condition.getSourcePsi();
        return psiElement == null ? false : ((string = psiElement.getText()) == null ? false : StringsKt.contains$default((CharSequence)string, (CharSequence)"desiredAssertionStatus", (boolean)false, (int)2, null));
    }

    public static final /* synthetic */ void access$checkSideEffect(AssertDetector $this, JavaContext context2, UExpression condition) {
        $this.checkSideEffect(context2, condition);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        EXPENSIVE = Issue.Companion.create$default(companion, "ExpensiveAssertion", "Expensive Assertions", "\n                In Kotlin, assertions are not handled the same way as from the Java programming \\\n                language. In particular, they're just implemented as a library call, and inside \\\n                the library call the error is only thrown if assertions are enabled.\n\n                This means that the arguments to the `assert` call will **always** \\\n                be evaluated. If you're doing any computation in the expression being \\\n                asserted, that computation will unconditionally be performed whether or not \\\n                assertions are turned on. This typically turns into wasted work in release \\\n                builds.\n\n                This check looks for cases where the assertion condition is nontrivial, e.g. \\\n                it is performing method calls or doing more work than simple comparisons \\\n                on local variables or fields.\n\n                You can work around this by writing your own inline assert method instead:\n\n                ```kotlin\n                @Suppress(\"INVISIBLE_REFERENCE\", \"INVISIBLE_MEMBER\")\n                inline fun assert(condition: () -> Boolean) {\n                    if (_Assertions.ENABLED && !condition()) {\n                        throw AssertionError()\n                    }\n                }\n                ```\n\n                In Android, because assertions are not enforced at runtime, instead use this:\n\n                ```kotlin\n                inline fun assert(condition: () -> Boolean) {\n                    if (BuildConfig.DEBUG && !condition()) {\n                        throw AssertionError()\n                    }\n                }\n                ```\n                ", implementation, null, category, 6, severity, false, null, null, null, 3600, null);
        MAX_CALL_DEPTH = LintClient.Companion.isStudio() ? 1 : 2;
        MAX_RECURSION_DEPTH = LintClient.Companion.isStudio() ? 5 : 10;
        MAX_STATEMENT_COUNT = LintClient.Companion.isStudio() ? 8 : 20;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/AssertDetector$Issues;", "", "()V", "EXPENSIVE", "Lcom/android/tools/lint/detector/api/Issue;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "MAX_CALL_DEPTH", "", "MAX_RECURSION_DEPTH", "MAX_STATEMENT_COUNT", "SIDE_EFFECT", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

