/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ArraySizeDetector
extends ResourceXmlDetector {
    public static final Issue INCONSISTENT = Issue.create("InconsistentArrays", "Inconsistencies in array element counts", "When an array is translated in a different locale, it should normally have the same number of elements as the original array. When adding or removing elements to an array, it is easy to forget to update all the locales, and this lint warning finds inconsistencies like these.\n\nNote however that there may be cases where you really want to declare a different number of array items in each configuration (for example where the array represents available options, and those options differ for different layout orientations and so on), so use your own judgment to decide if this is really an error.\n\nYou can suppress this error type if it finds false errors in your project.", Category.CORRECTNESS, 7, Severity.WARNING, new Implementation(ArraySizeDetector.class, Scope.RESOURCE_FILE_SCOPE));
    private Multimap<File, Pair<String, Integer>> mFileToArrayCount;
    private Map<String, Location> mLocations;
    private Map<String, String> mDescriptions;

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("array", "string-array", "integer-array");
    }

    @Override
    public void beforeCheckRootProject(Context context2) {
        if (context2.getPhase() == 1) {
            this.mFileToArrayCount = ArrayListMultimap.create((int)30, (int)5);
        }
    }

    @Override
    public void afterCheckRootProject(Context context2) {
        if (context2.getPhase() == 1) {
            boolean haveAllResources = context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES);
            if (!haveAllResources) {
                return;
            }
            LintClient client = context2.getClient();
            HashSet<String> alreadyReported = new HashSet<String>();
            HashMap<String, Integer> countMap = new HashMap<String, Integer>();
            HashMap<String, File> fileMap = new HashMap<String, File>();
            ArrayList keys = new ArrayList(this.mFileToArrayCount.keySet());
            Collections.sort(keys);
            for (File file : keys) {
                Collection pairs = this.mFileToArrayCount.get((Object)file);
                for (Pair pair2 : pairs) {
                    String name = (String)pair2.getFirst();
                    if (alreadyReported.contains(name)) continue;
                    Integer count = (Integer)pair2.getSecond();
                    Integer current = (Integer)countMap.get(name);
                    if (current == null) {
                        countMap.put(name, count);
                        fileMap.put(name, file);
                        continue;
                    }
                    if (count.equals(current)) continue;
                    alreadyReported.add(name);
                    if (this.mLocations == null) {
                        this.mLocations = new HashMap<String, Location>();
                        this.mDescriptions = new HashMap<String, String>();
                    }
                    this.mLocations.put(name, null);
                    String thisName = Lint.getFileNameWithParent(client, file);
                    File otherFile = (File)fileMap.get(name);
                    String otherName = Lint.getFileNameWithParent(client, otherFile);
                    String message2 = String.format("Array `%1$s` has an inconsistent number of items (%2$d in `%3$s`, %4$d in `%5$s`)", name, count, thisName, current, otherName);
                    this.mDescriptions.put(name, message2);
                }
            }
            if (this.mLocations != null) {
                context2.getDriver().requestRepeat(this, Scope.ALL_RESOURCES_SCOPE);
            }
            this.mFileToArrayCount = null;
        } else {
            if (this.mLocations != null) {
                ArrayList<String> names = new ArrayList<String>(this.mLocations.keySet());
                Collections.sort(names);
                for (String name : names) {
                    Location location2 = this.mLocations.get(name);
                    if (location2 == null) continue;
                    location2 = Location.reverse(location2);
                    int count = -1;
                    LintDriver driver = context2.getDriver();
                    boolean foundConflict = false;
                    for (Location curr = location2; curr != null; curr = curr.getSecondary()) {
                        Object clientData = curr.getClientData();
                        if (clientData instanceof Node) {
                            int newCount;
                            Node node = (Node)clientData;
                            if (driver.isSuppressed(null, INCONSISTENT, node) || (newCount = Lint.getChildCount(node)) == count) continue;
                            if (count == -1) {
                                count = newCount;
                                continue;
                            }
                            foundConflict = true;
                            break;
                        }
                        foundConflict = true;
                        break;
                    }
                    if (!foundConflict) continue;
                    String message3 = this.mDescriptions.get(name);
                    context2.report(INCONSISTENT, location2, message3);
                }
            }
            this.mLocations = null;
            this.mDescriptions = null;
        }
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        int phase = context2.getPhase();
        Attr attribute = element.getAttributeNode("name");
        if (attribute == null || attribute.getValue().isEmpty()) {
            if (phase != 1) {
                return;
            }
            context2.report(INCONSISTENT, element, context2.getLocation(element), String.format("Missing name attribute in `%1$s` declaration", element.getTagName()));
        } else {
            String name = attribute.getValue();
            if (phase == 1) {
                if (context2.getProject().getReportIssues()) {
                    int childCount = Lint.getChildCount(element);
                    if (!context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES)) {
                        ArraySizeDetector.incrementalCheckCount(context2, element, name, childCount);
                        return;
                    }
                    this.mFileToArrayCount.put((Object)context2.file, (Object)Pair.of((Object)name, (Object)childCount));
                }
            } else {
                assert (phase == 2);
                if (this.mLocations.containsKey(name)) {
                    if (context2.getDriver().isSuppressed(context2, INCONSISTENT, element)) {
                        return;
                    }
                    Location location2 = context2.getLocation(element);
                    location2.setData(element);
                    location2.setMessage(String.format("Declaration with array size (%1$d)", Lint.getChildCount(element)));
                    location2.setSecondary(this.mLocations.get(name));
                    this.mLocations.put(name, location2);
                }
            }
        }
    }

    private static void incrementalCheckCount(XmlContext context2, Element element, String name, int childCount) {
        LintClient client = context2.getClient();
        boolean full = context2.isGlobalAnalysis();
        Project project = full ? context2.getMainProject() : context2.getProject();
        ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
        List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.ARRAY, name);
        for (ResourceItem item : items) {
            ArrayResourceValue arv;
            ResourceValue rv;
            PathString source = item.getSource();
            if (source != null && Lint.isSameResourceFile(context2.file, source.toFile()) || !((rv = item.getResourceValue()) instanceof ArrayResourceValue) || childCount == (arv = (ArrayResourceValue)rv).getElementCount()) continue;
            String thisName = Lint.getFileNameWithParent(client, context2.file);
            assert (source != null);
            String otherName = Lint.getFileNameWithParent(client, source);
            String message2 = String.format("Array `%1$s` has an inconsistent number of items (%2$d in `%3$s`, %4$d in `%5$s`)", name, childCount, thisName, arv.getElementCount(), otherName);
            context2.report(INCONSISTENT, element, context2.getLocation(element), message2);
        }
    }
}

