/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AppBundleLocaleChangesDetector$visitMethodCall$lambda-1$;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.IncidentKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 .2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002JJ\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001eH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u001eH\u0016J\u0018\u0010 \u001a\u00020\u00062\u0006\u0010\f\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J \u0010)\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020!2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/tools/lint/checks/AppBundleLocaleChangesDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/GradleScanner;", "()V", "bundleLanguageSplittingDisabled", "", "localeChangeLocation", "Lcom/android/tools/lint/detector/api/Location;", "playCoreLanguageRequestFound", "afterCheckEachProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "checkConditionsAndReport", "checkDslPropertyAssignment", "Lcom/android/tools/lint/detector/api/GradleContext;", "property", "", "value", "parent", "parentParent", "propertyCookie", "", "valueCookie", "statementCookie", "checkPartialResults", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "getApplicableMethodNames", "", "getApplicableReferenceNames", "isLocationSuppressed", "Lcom/android/tools/lint/detector/api/JavaContext;", "expression", "Lorg/jetbrains/uast/UExpression;", "visitMethodCall", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "visitReference", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "Companion", "android.sdktools.lint-checks"})
public final class AppBundleLocaleChangesDetector
extends Detector
implements SourceCodeScanner,
GradleScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Location localeChangeLocation;
    private boolean playCoreLanguageRequestFound;
    private boolean bundleLanguageSplittingDisabled;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String REF_SETLOCALE = "setLocale";
    @NotNull
    private static final String REF_SETLOCALES = "setLocales";
    @NotNull
    private static final String REF_LOCALE = "locale";
    @NotNull
    private static final String REF_ADDLANGUAGE = "addLanguage";
    @NotNull
    private static final String REF_REQUESTINSTALL = "requestInstall";
    @NotNull
    private static final String CLASS_CONFIGURATION = "android.content.res.Configuration";
    @NotNull
    private static final String CLASS_SPLITINSTALLREQUEST_BUILDER = "com.google.android.play.core.splitinstall.SplitInstallRequest.Builder";
    @NotNull
    private static final String CLASS_SPLITINSTALLMANAGER = "com.google.android.play.core.splitinstall.SplitInstallManager";
    @NotNull
    private static final String KEY_LOCALE_CHANGE_LOCATION = "localeChangeLocation";
    @NotNull
    private static final String KEY_PLAYCORE_LANGUAGE_REQUEST_FOUND = "playCoreLanguageRequestFound";
    @NotNull
    private static final String KEY_BUNDLE_LANGUAGE_SPLITTING_DISABLED = "bundleLanguageSplittingDisabled";

    @Override
    @NotNull
    public List<String> getApplicableReferenceNames() {
        return CollectionsKt.listOf((Object)REF_LOCALE);
    }

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{REF_SETLOCALE, REF_SETLOCALES, REF_ADDLANGUAGE, REF_REQUESTINSTALL};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        switch (method.getName()) {
            case "setLocales": 
            case "setLocale": {
                if (this.localeChangeLocation != null) return;
                if (!context2.getEvaluator().isMemberInClass((PsiMember)method, CLASS_CONFIGURATION)) return;
                if (this.isLocationSuppressed(context2, (UExpression)node)) return;
                this.localeChangeLocation = context2.getLocation((UElement)node);
                return;
            }
            case "addLanguage": {
                if (this.playCoreLanguageRequestFound) return;
                if (!context2.getEvaluator().isMemberInClass((PsiMember)method, CLASS_SPLITINSTALLREQUEST_BUILDER)) return;
                this.playCoreLanguageRequestFound = true;
                return;
            }
            case "requestInstall": {
                JavaEvaluator evaluator = context2.getEvaluator();
                PsiParameterList psiParameterList = method.getParameterList();
                boolean bl = false;
                boolean bl2 = false;
                PsiParameterList $this$visitMethodCall_u24lambda_u2d1 = psiParameterList;
                boolean bl3 = false;
                if (this.playCoreLanguageRequestFound) return;
                if ($this$visitMethodCall_u24lambda_u2d1.getParameters().length != 4) return;
                if (!evaluator.typeMatches($this$visitMethodCall_u24lambda_u2d1.getParameters()[0].getType(), CLASS_SPLITINSTALLMANAGER)) return;
                if (!evaluator.isSuspend((PsiModifierListOwner)method)) return;
                if (node.getValueArgumentCount() != 2) {
                    KtValueArgumentName it;
                    void $this$any$iv;
                    void $this$forEachDescendantOfType$iv$iv$iv$iv;
                    void $this$collectDescendantsOfTypeTo$iv$iv$iv;
                    Iterable $this$collectDescendantsOfType_u24default$iv;
                    PsiElement psiElement = node.getSourcePsi();
                    if (psiElement == null) {
                        return;
                    }
                    PsiElement psiElement2 = psiElement;
                    Function1 predicate$iv = visitMethodCall$lambda-1$$inlined$collectDescendantsOfType$default$1.INSTANCE;
                    boolean $i$f$collectDescendantsOfType = false;
                    void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
                    boolean $i$f$collectDescendantsOfType2 = false;
                    void var17_20 = $this$collectDescendantsOfType$iv$iv;
                    Collection to$iv$iv$iv = new ArrayList();
                    boolean $i$f$collectDescendantsOfTypeTo = false;
                    void var20_24 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
                    Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtValueArgumentName, Unit>(predicate$iv, to$iv$iv$iv){
                        final /* synthetic */ Function1 $predicate;
                        final /* synthetic */ Collection $to;
                        {
                            this.$predicate = $predicate;
                            this.$to = $to;
                            super(1);
                        }

                        /*
                         * Ignored method signature, as it can't be verified against descriptor
                         */
                        public final void invoke(@NotNull PsiElement it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                                this.$to.add(it);
                            }
                        }
                    };
                    boolean $i$f$forEachDescendantOfType = false;
                    $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                        final /* synthetic */ Function1 $action;
                        {
                            this.$action = $action;
                        }

                        public void visitElement(@NotNull PsiElement element) {
                            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                            PsiElement it = element;
                            boolean bl = false;
                            super.visitElement(element);
                            if (element instanceof KtValueArgumentName) {
                                this.$action.invoke((Object)element);
                            }
                        }
                    });
                    List list2 = (List)to$iv$iv$iv;
                    $this$collectDescendantsOfType_u24default$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        return;
                    }
                    Iterator iterator = $this$any$iv.iterator();
                    do {
                        if (!iterator.hasNext()) return;
                        Object element$iv = iterator.next();
                        it = (KtValueArgumentName)element$iv;
                        boolean bl4 = false;
                    } while (!Intrinsics.areEqual((Object)it.getText(), (Object)"languages"));
                    boolean bl5 = true;
                    if (!bl5) return;
                    boolean bl6 = true;
                    if (!bl6) return;
                }
                this.playCoreLanguageRequestFound = true;
            }
        }
    }

    @Override
    public void visitReference(@NotNull JavaContext context2, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        UBinaryExpression binaryExpr;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)referenced, (String)"referenced");
        if (this.localeChangeLocation == null && referenced instanceof PsiField && context2.getEvaluator().isMemberInClass((PsiMember)referenced, CLASS_CONFIGURATION) && (binaryExpr = (UBinaryExpression)UastUtils.getParentOfType$default((UElement)((UElement)reference), UBinaryExpression.class, (boolean)false, (int)2, null)) != null && Intrinsics.areEqual((Object)binaryExpr.getOperator(), (Object)UastBinaryOperator.ASSIGN) && Intrinsics.areEqual((Object)UastUtils.tryResolve((UElement)((UElement)binaryExpr.getLeftOperand())), (Object)referenced) && !this.isLocationSuppressed(context2, (UExpression)reference)) {
            this.localeChangeLocation = context2.getLocation((UElement)reference);
        }
    }

    private final boolean isLocationSuppressed(JavaContext context2, UExpression expression) {
        if (context2.isSuppressedWithComment((UElement)expression, ISSUE)) {
            return true;
        }
        if (context2.isGlobalAnalysis()) {
            return false;
        }
        return context2.getDriver().isSuppressed(context2, ISSUE, (UAnnotated)expression);
    }

    @Override
    public void checkDslPropertyAssignment(@NotNull GradleContext context2, @NotNull String property, @NotNull String value, @NotNull String parent, @Nullable String parentParent, @NotNull Object propertyCookie, @NotNull Object valueCookie, @NotNull Object statementCookie) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)propertyCookie, (String)"propertyCookie");
        Intrinsics.checkNotNullParameter((Object)valueCookie, (String)"valueCookie");
        Intrinsics.checkNotNullParameter((Object)statementCookie, (String)"statementCookie");
        if (Intrinsics.areEqual((Object)property, (Object)"enableSplit") && Intrinsics.areEqual((Object)parent, (Object)"language") && Intrinsics.areEqual((Object)parentParent, (Object)"bundle") && Intrinsics.areEqual((Object)value, (Object)"false")) {
            this.bundleLanguageSplittingDisabled = true;
        }
    }

    @Override
    public void afterCheckEachProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.isGlobalAnalysis()) {
            if (context2.getProject() == context2.getMainProject()) {
                this.checkConditionsAndReport(context2, this.localeChangeLocation, this.playCoreLanguageRequestFound, this.bundleLanguageSplittingDisabled);
            }
        } else {
            LintMap partialResults = context2.getPartialResults(ISSUE).map();
            Location location2 = this.localeChangeLocation;
            if (location2 != null) {
                Location location3 = location2;
                boolean bl = false;
                boolean bl2 = false;
                Location location4 = location3;
                boolean bl3 = false;
                partialResults.put(KEY_LOCALE_CHANGE_LOCATION, location4);
            }
            if (this.playCoreLanguageRequestFound) {
                partialResults.put(KEY_PLAYCORE_LANGUAGE_REQUEST_FOUND, true);
            }
            if (this.bundleLanguageSplittingDisabled) {
                partialResults.put(KEY_BUNDLE_LANGUAGE_SPLITTING_DISABLED, true);
            }
        }
    }

    @Override
    public void checkPartialResults(@NotNull Context context2, @NotNull PartialResult partialResults) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
        if (context2.getProject() == context2.getMainProject()) {
            LintMap lintMap = partialResults.map();
            boolean bl = false;
            boolean bl2 = false;
            LintMap $this$checkPartialResults_u24lambda_u2d3 = lintMap;
            boolean bl3 = false;
            Boolean bl4 = LintMap.getBoolean$default($this$checkPartialResults_u24lambda_u2d3, KEY_PLAYCORE_LANGUAGE_REQUEST_FOUND, null, 2, null);
            boolean bl5 = bl4 == null ? false : bl4;
            bl4 = LintMap.getBoolean$default($this$checkPartialResults_u24lambda_u2d3, KEY_BUNDLE_LANGUAGE_SPLITTING_DISABLED, null, 2, null);
            this.checkConditionsAndReport(context2, $this$checkPartialResults_u24lambda_u2d3.getLocation(KEY_LOCALE_CHANGE_LOCATION), bl5, bl4 == null ? false : bl4);
        }
    }

    private final void checkConditionsAndReport(Context context2, Location localeChangeLocation, boolean playCoreLanguageRequestFound, boolean bundleLanguageSplittingDisabled) {
        if (localeChangeLocation != null && !playCoreLanguageRequestFound && !bundleLanguageSplittingDisabled) {
            IncidentKt.Incident(context2).issue(ISSUE).message("Found dynamic locale changes, but did not find corresponding Play Core library calls for downloading languages and splitting by language is not disabled in the `bundle` configuration").location(localeChangeLocation).report();
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(AppBundleLocaleChangesDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.GRADLE_FILE));
        ISSUE = Issue.Companion.create$default(companion, "AppBundleLocaleChanges", "App Bundle handling of runtime locale changes", "\n                When changing locales at runtime (e.g. to provide an in-app language switcher), \\\n                the Android App Bundle must be configured to not split by locale or the Play Core \\\n                library must be used to download additional locales at runtime.\n                ", implementation, "https://developer.android.com/guide/app-bundle/configure-base#handling_language_changes", category, 5, severity, false, true, null, null, 3328, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/AppBundleLocaleChangesDetector$Companion;", "", "()V", "CLASS_CONFIGURATION", "", "CLASS_SPLITINSTALLMANAGER", "CLASS_SPLITINSTALLREQUEST_BUILDER", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "KEY_BUNDLE_LANGUAGE_SPLITTING_DISABLED", "KEY_LOCALE_CHANGE_LOCATION", "KEY_PLAYCORE_LANGUAGE_REQUEST_FOUND", "REF_ADDLANGUAGE", "REF_LOCALE", "REF_REQUESTINSTALL", "REF_SETLOCALE", "REF_SETLOCALES", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

