/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.tasks;

import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.tasks.Canceller;
import com.android.tools.tracer.Trace;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class Task<T> {
    private final String name;
    private final Callable<T> callable;
    private final Task<?>[] inputs;
    final SettableFuture<T> future = SettableFuture.create();
    private DeployMetric metric;

    Task(String name, Callable<T> callable, Task<?> ... inputs) {
        this.inputs = inputs;
        this.name = name;
        this.callable = callable;
    }

    public T get() throws DeployerException {
        try {
            return (T)this.future.get();
        }
        catch (InterruptedException e) {
            throw DeployerException.interrupted(e.getMessage());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof DeployerException) {
                throw (DeployerException)e.getCause();
            }
            throw DeployerException.runtimeException(e);
        }
    }

    public void run(Executor executor, Canceller canceller) {
        Callable<Object> task = () -> {
            String status = "Not Started";
            this.metric = new DeployMetric(this.name);
            try {
                Trace ignored = Trace.begin(this.name);
                try {
                    T value;
                    if (canceller.cancelled()) {
                        status = "Cancelled";
                        throw DeployerException.interrupted("User cancelled deployment.");
                    }
                    try {
                        value = this.callable.call();
                    }
                    catch (ExecutionException e) {
                        status = "Dropped";
                        throw e;
                    }
                    catch (Throwable t) {
                        status = "Failed";
                        throw t;
                    }
                    status = "Success";
                    T t = value;
                    if (ignored != null) {
                        ignored.close();
                    }
                    return t;
                }
                catch (Throwable throwable) {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            finally {
                this.metric.finish(status);
            }
        };
        List futures = Arrays.stream(this.inputs).map(t -> t.future).collect(Collectors.toList());
        this.future.setFuture(Futures.whenAllComplete(futures).call(task, executor));
    }

    public DeployMetric getMetric() {
        return this.metric;
    }
}

