/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.tasks;

import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.Installer;
import com.android.tools.idea.protobuf.ByteString;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LiveUpdateDeployer {
    public List<UpdateLiveEditError> updateLiveLiteral(Installer installer, AdbClient adb, String packageName, Collection<UpdateLiveLiteralParam> params) {
        List<Integer> pids = adb.getPids(packageName);
        Deploy.Arch arch = adb.getArch(pids);
        Deploy.LiveLiteralUpdateRequest.Builder requestBuilder = Deploy.LiveLiteralUpdateRequest.newBuilder();
        for (UpdateLiveLiteralParam param : params) {
            requestBuilder.addUpdates(Deploy.LiveLiteral.newBuilder().setKey(param.key).setOffset(param.offset).setHelperClass(param.helper).setType(param.type).setValue(param.value));
        }
        requestBuilder.setPackageName(packageName);
        requestBuilder.addAllProcessIds(pids);
        requestBuilder.setArch(arch);
        Deploy.LiveLiteralUpdateRequest request = requestBuilder.build();
        LinkedList<UpdateLiveEditError> errors = new LinkedList<UpdateLiveEditError>();
        try {
            Deploy.LiveLiteralUpdateResponse response = installer.updateLiveLiterals(request);
            for (Deploy.AgentResponse failure : response.getFailedAgentsList()) {
                errors.add(new UpdateLiveEditError(failure.getLiveLiteralResponse().getExtra()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return errors;
    }

    public List<UpdateLiveEditError> updateLiveEdit(Installer installer, AdbClient adb, String packageName, UpdateLiveEditsParam param) {
        List<Integer> pids = adb.getPids(packageName);
        Deploy.Arch arch = adb.getArch(pids);
        Deploy.LiveEditRequest.Builder requestBuilder = Deploy.LiveEditRequest.newBuilder();
        requestBuilder.addAllProcessIds(pids);
        requestBuilder.setArch(arch);
        requestBuilder.setPackageName(packageName);
        requestBuilder.setTargetClass(Deploy.LiveEditClass.newBuilder().setClassName(param.className).setClassData(ByteString.copyFrom((byte[])param.classData)).setMethodName(param.methodName).setMethodDesc(param.methodDesc));
        for (String name : param.supportClasses.keySet()) {
            ByteString data = ByteString.copyFrom((byte[])param.supportClasses.get(name));
            requestBuilder.addSupportClasses(Deploy.LiveEditClass.newBuilder().setClassName(name).setClassData(data));
        }
        Deploy.LiveEditRequest request = requestBuilder.build();
        LinkedList<UpdateLiveEditError> errors = new LinkedList<UpdateLiveEditError>();
        System.out.println("Live Edit: Uploading " + param.className + "." + param.methodName + " of " + param.classData.length + " bytes.");
        try {
            Deploy.LiveEditResponse response = installer.liveEdit(request);
            for (Deploy.AgentResponse failure : response.getFailedAgentsList()) {
                errors.add(new UpdateLiveEditError(failure.getLiveLiteralResponse().getExtra()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return errors;
    }

    public static class UpdateLiveEditError {
        public final String msg;

        public UpdateLiveEditError(String msg) {
            this.msg = msg;
        }
    }

    public static class UpdateLiveEditsParam {
        final String className;
        final String methodName;
        final String methodDesc;
        final byte[] classData;
        final Map<String, byte[]> supportClasses;

        public UpdateLiveEditsParam(String className, String methodName, String methodDesc, byte[] classData, Map<String, byte[]> supportClasses) {
            this.className = className;
            this.methodName = methodName;
            this.methodDesc = methodDesc;
            this.classData = classData;
            this.supportClasses = supportClasses;
        }
    }

    public static class UpdateLiveLiteralParam {
        final String key;
        final String type;
        final String value;
        final int offset;
        final String helper;

        public UpdateLiveLiteralParam(String key, int offset, String helper, String type, String value) {
            this.key = key;
            this.offset = offset;
            this.helper = helper;
            this.type = type;
            this.value = value;
        }
    }
}

