/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.model.component;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.component.AppComponent;
import com.android.tools.manifest.parser.components.ManifestServiceInfo;
import com.android.utils.ILogger;

public class WatchFace
extends AppComponent {
    static final String DEBUG_COMMAND = "am set-debug-app -w";
    private final ILogger logger;

    public WatchFace(ManifestServiceInfo info, String appId, IDevice device, ILogger logger) {
        super(device, appId, info);
        this.logger = logger;
    }

    @Override
    public void activate(String extraFlags, AppComponent.Mode activationMode, IShellOutputReceiver receiver) throws DeployerException {
        this.validate(extraFlags);
        this.logger.info("Activating WatchFace '%s' %s", new Object[]{this.info.getQualifiedName(), activationMode.equals((Object)AppComponent.Mode.DEBUG) ? "for debug" : ""});
        if (activationMode.equals((Object)AppComponent.Mode.DEBUG)) {
            String debug_command = "am set-debug-app -w '" + this.appId + "'";
            this.logger.info("$ adb shell " + debug_command, new Object[0]);
            this.runShellCommand(debug_command, receiver);
        }
        String command = this.getStartWatchFaceCommand();
        this.logger.info("$ adb shell " + command, new Object[0]);
        this.runShellCommand(command, receiver);
    }

    private void validate(String extraFlags) throws DeployerException {
        if (!extraFlags.isEmpty()) {
            throw DeployerException.componentActivationException(String.format("Extra flags are not supported by Watch Face. Detected flags `%s`", extraFlags));
        }
    }

    private String getStartWatchFaceCommand() {
        return "am broadcast -a com.google.android.wearable.app.DEBUG_SURFACE --es operation set-watchface --ecn component " + this.getFQEscapedName();
    }

    public static class ShellCommand {
        public static final String SHOW_WATCH_FACE = "am broadcast -a com.google.android.wearable.app.DEBUG_SYSUI --es operation show-watchface";
        public static final String SET_WATCH_FACE = "am broadcast -a com.google.android.wearable.app.DEBUG_SURFACE --es operation set-watchface --ecn component ";
        public static final String UNSET_WATCH_FACE = "am broadcast -a com.google.android.wearable.app.DEBUG_SURFACE --es operation unset-watchface";
    }
}

