/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.model.component;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.component.AppComponent;
import com.android.tools.manifest.parser.components.ManifestServiceInfo;
import com.android.utils.ILogger;

public class Tile
extends AppComponent {
    static final String DEBUG_COMMAND = "am set-debug-app -w";
    private final ILogger logger;

    public Tile(ManifestServiceInfo info, String appId, IDevice device, ILogger logger) {
        super(device, appId, info);
        this.logger = logger;
    }

    @Override
    public void activate(String extraFlags, AppComponent.Mode activationMode, IShellOutputReceiver receiver) throws DeployerException {
        this.validate(extraFlags);
        this.logger.info("Activating Tile '%s' %s", new Object[]{this.info.getQualifiedName(), activationMode.equals((Object)AppComponent.Mode.DEBUG) ? "for debug" : ""});
        if (activationMode.equals((Object)AppComponent.Mode.DEBUG)) {
            String debugCommand = String.format("%s '%s'", DEBUG_COMMAND, this.appId);
            this.logger.info("$ adb shell " + debugCommand, new Object[0]);
            this.runShellCommand(debugCommand, receiver);
        }
        String command = this.getStartTileCommand();
        this.logger.info("$ adb shell " + command, new Object[0]);
        this.runShellCommand(command, receiver);
    }

    private void validate(String extraFlags) throws DeployerException {
        if (!extraFlags.isEmpty()) {
            throw DeployerException.componentActivationException(String.format("Extra flags are not supported by Tile. Detected flags `%s`", extraFlags));
        }
    }

    private String getStartTileCommand() {
        return ShellCommand.SET_TILE + this.getFQEscapedName();
    }

    public static class ShellCommand {
        public static String SET_TILE = "am broadcast -a com.google.android.wearable.app.DEBUG_SURFACE --es operation 'add-tile' --ecn component ";
        public static String UNSET_TILE = "am broadcast -a com.google.android.wearable.app.DEBUG_SURFACE --es operation remove-tile --ecn component ";
        public static String SHOW_TILE_COMMAND = "am broadcast -a com.google.android.wearable.app.DEBUG_SYSUI --es operation show-tile --ei index ";
    }
}

